/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.WeakIdentityHashMap;

public class JavaSupport {
    private final Ruby runtime;
    private final Map exceptionHandlers = new HashMap();
    private final JRubyClassLoader javaClassLoader;
    private final Map instanceCache = Collections.synchronizedMap(new WeakIdentityHashMap(100));
    private final ConcurrentHashMap<Class, JavaClass> javaClassCache = new ConcurrentHashMap(128);
    private final Map matchCache = Collections.synchronizedMap(new HashMap(128));
    private Callback concreteProxyCallback;
    private RubyModule javaModule;
    private RubyModule javaUtilitiesModule;
    private RubyClass javaObjectClass;
    private RubyClass javaClassClass;
    private RubyClass javaArrayClass;
    private RubyClass javaProxyClass;
    private RubyModule javaInterfaceTemplate;
    private RubyModule packageModuleTemplate;
    private RubyClass arrayProxyClass;
    private RubyClass concreteProxyClass;

    public JavaSupport(Ruby ruby) {
        this.runtime = ruby;
        this.javaClassLoader = ruby.getJRubyClassLoader();
    }

    final synchronized void setConcreteProxyCallback(Callback concreteProxyCallback) {
        if (this.concreteProxyCallback == null) {
            this.concreteProxyCallback = concreteProxyCallback;
        }
    }

    final Callback getConcreteProxyCallback() {
        return this.concreteProxyCallback;
    }

    final Map getMatchCache() {
        return this.matchCache;
    }

    public Class loadJavaClass(String className) {
        try {
            Class result = JavaSupport.primitiveClass(className);
            if (result == null) {
                return Ruby.isSecurityRestricted() ? Class.forName(className) : Class.forName(className, true, this.javaClassLoader);
            }
            return result;
        }
        catch (ClassNotFoundException cnfExcptn) {
            throw this.runtime.newNameError("cannot load Java class " + className, className);
        }
    }

    public JavaClass getJavaClassFromCache(Class clazz) {
        return this.javaClassCache.get(clazz);
    }

    public void putJavaClassIntoCache(JavaClass clazz) {
        this.javaClassCache.put(clazz.javaClass(), clazz);
    }

    public void addToClasspath(URL url) {
        this.javaClassLoader.addURL(url);
    }

    public void defineExceptionHandler(String exceptionClass, RubyProc handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void handleNativeException(Throwable exception) {
        Class<?> excptnClass;
        if (exception instanceof RaiseException) {
            throw (RaiseException)exception;
        }
        RubyProc handler = (RubyProc)this.exceptionHandlers.get(excptnClass.getName());
        for (excptnClass = exception.getClass(); handler == null && excptnClass != Throwable.class; excptnClass = excptnClass.getSuperclass()) {
        }
        if (handler == null) {
            throw this.createRaiseException(exception);
        }
        handler.call(new IRubyObject[]{JavaUtil.convertJavaToRuby(this.runtime, exception)});
    }

    private RaiseException createRaiseException(Throwable exception) {
        RaiseException re = RaiseException.createNativeRaiseException(this.runtime, exception);
        return re;
    }

    private static Class primitiveClass(String name) {
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        return null;
    }

    public ClassLoader getJavaClassLoader() {
        return this.javaClassLoader;
    }

    public JavaObject getJavaObjectFromCache(Object object) {
        WeakReference ref = (WeakReference)this.instanceCache.get(object);
        if (ref == null) {
            return null;
        }
        JavaObject javaObject = (JavaObject)ref.get();
        if (javaObject != null && javaObject.getValue() == object) {
            return javaObject;
        }
        return null;
    }

    public void putJavaObjectIntoCache(JavaObject object) {
        this.instanceCache.put(object.getValue(), new WeakReference<JavaObject>(object));
    }

    public RubyModule getJavaModule() {
        if (this.javaModule == null) {
            this.javaModule = this.runtime.fastGetModule("Java");
        }
        return this.javaModule;
    }

    public RubyModule getJavaUtilitiesModule() {
        if (this.javaUtilitiesModule == null) {
            this.javaUtilitiesModule = this.runtime.fastGetModule("JavaUtilities");
        }
        return this.javaUtilitiesModule;
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = this.getJavaModule().fastGetClass("JavaObject");
        }
        return this.javaObjectClass;
    }

    public RubyClass getJavaArrayClass() {
        if (this.javaArrayClass == null) {
            this.javaArrayClass = this.getJavaModule().fastGetClass("JavaArray");
        }
        return this.javaArrayClass;
    }

    public RubyClass getJavaClassClass() {
        if (this.javaClassClass == null) {
            this.javaClassClass = this.getJavaModule().fastGetClass("JavaClass");
        }
        return this.javaClassClass;
    }

    public RubyModule getJavaInterfaceTemplate() {
        if (this.javaInterfaceTemplate == null) {
            this.javaInterfaceTemplate = this.runtime.fastGetModule("JavaInterfaceTemplate");
        }
        return this.javaInterfaceTemplate;
    }

    public RubyModule getPackageModuleTemplate() {
        if (this.packageModuleTemplate == null) {
            this.packageModuleTemplate = this.runtime.fastGetModule("JavaPackageModuleTemplate");
        }
        return this.packageModuleTemplate;
    }

    public RubyClass getJavaProxyClass() {
        if (this.javaProxyClass == null) {
            this.javaProxyClass = this.runtime.fastGetClass("JavaProxy");
        }
        return this.javaProxyClass;
    }

    public RubyClass getConcreteProxyClass() {
        if (this.concreteProxyClass == null) {
            this.concreteProxyClass = this.runtime.fastGetClass("ConcreteJavaProxy");
        }
        return this.concreteProxyClass;
    }

    public RubyClass getArrayProxyClass() {
        if (this.arrayProxyClass == null) {
            this.arrayProxyClass = this.runtime.fastGetClass("ArrayJavaProxy");
        }
        return this.arrayProxyClass;
    }
}

