/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class InvocationMethodFactory
extends MethodFactory
implements Opcodes {
    public static final CodegenUtils cg = CodegenUtils.cg;
    private static final String COMPILED_SUPER_CLASS = CompiledMethod.class.getName().replace('.', '/');
    private static final String COMPILED_CALL_SIG = cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject[].class, Block.class));
    private static final String COMPILED_SUPER_SIG = cg.sig(Void.TYPE, cg.params(RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class));
    private static final String JAVA_SUPER_SIG = cg.sig(Void.TYPE, cg.params(RubyModule.class, Visibility.class));
    private JRubyClassLoader classLoader;
    public static final int SCRIPT_INDEX = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int RECEIVER_INDEX = 2;
    public static final int CLASS_INDEX = 3;
    public static final int NAME_INDEX = 4;
    public static final int ARGS_INDEX = 5;
    public static final int BLOCK_INDEX = 6;

    public InvocationMethodFactory() {
    }

    public InvocationMethodFactory(ClassLoader classLoader) {
        this.classLoader = classLoader instanceof JRubyClassLoader ? (JRubyClassLoader)classLoader : new JRubyClassLoader(classLoader);
    }

    private static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    private ClassWriter createCompiledCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", COMPILED_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitVarInsn(25, 5);
        mv.visitMethodInsn(183, sup, "<init>", COMPILED_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private ClassWriter createJavaMethodCtor(String namePath, String sup) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(48, 33, namePath, null, sup, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", JAVA_SUPER_SIG, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, sup, "<init>", JAVA_SUPER_SIG);
        Label line = new Label();
        mv.visitLineNumber(0, line);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        return cw;
    }

    private Class tryClass(Ruby runtime, String name) {
        try {
            if (this.classLoader == null) {
                return Class.forName(name, true, runtime.getJRubyClassLoader());
            }
            return this.classLoader.loadClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class endCall(Ruby runtime, ClassWriter cw, MethodVisitor mv, String name) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] code = cw.toByteArray();
        if (this.classLoader == null) {
            this.classLoader = runtime.getJRubyClassLoader();
        }
        return this.classLoader.defineClass(name, code);
    }

    private void loadArguments(MethodVisitor mv, int argsIndex, int count) {
        for (int i = 0; i < count; ++i) {
            this.loadArgument(mv, argsIndex, i);
        }
    }

    private void loadArgument(MethodVisitor mv, int argsIndex, int argIndex) {
        mv.visitVarInsn(25, argsIndex);
        mv.visitLdcInsn(new Integer(argIndex));
        mv.visitInsn(50);
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, Method method) {
        Class<?> type = method.getDeclaringClass();
        JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
        String typePath = InvocationMethodFactory.p(type);
        String javaMethodName = method.getName();
        String generatedClassName = type.getName() + "Invoker$" + javaMethodName + "_method_" + jrubyMethod.required() + "_" + jrubyMethod.optional();
        String generatedClassPath = typePath + "Invoker$" + javaMethodName + "_method_" + jrubyMethod.required() + "_" + jrubyMethod.optional();
        Class c = this.tryClass(implementationClass.getRuntime(), generatedClassName);
        try {
            if (c == null) {
                Class[] signature = method.getParameterTypes();
                Class<?> ret = method.getReturnType();
                ClassWriter cw = this.createJavaMethodCtor(generatedClassPath, cg.p(JavaMethod.class));
                SkinnyMethodAdapter mv = null;
                mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG, null, null));
                mv.visitCode();
                Label line = new Label();
                mv.visitLineNumber(0, line);
                Label arityError = new Label();
                Label noArityError = new Label();
                if (jrubyMethod.rest()) {
                    if (jrubyMethod.required() > 0) {
                        mv.aload(5);
                        mv.arraylength();
                        mv.ldc(jrubyMethod.required());
                        mv.if_icmplt(arityError);
                    }
                } else if (jrubyMethod.optional() > 0) {
                    if (jrubyMethod.required() > 0) {
                        mv.aload(5);
                        mv.arraylength();
                        mv.ldc(jrubyMethod.required());
                        mv.if_icmplt(arityError);
                    }
                    mv.aload(5);
                    mv.arraylength();
                    mv.ldc(jrubyMethod.required() + jrubyMethod.optional());
                    mv.if_icmpgt(arityError);
                } else {
                    mv.aload(5);
                    mv.arraylength();
                    mv.ldc(jrubyMethod.required());
                    mv.if_icmpne(arityError);
                }
                mv.go_to(noArityError);
                mv.label(arityError);
                mv.aload(1);
                mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                mv.aload(5);
                mv.ldc(jrubyMethod.required());
                mv.ldc(jrubyMethod.required() + jrubyMethod.optional());
                mv.invokestatic(cg.p(Arity.class), "checkArgumentCount", cg.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                mv.pop();
                mv.label(noArityError);
                mv.aload(0);
                mv.getfield(cg.p(DynamicMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.aload(2);
                mv.aload(0);
                mv.invokevirtual(cg.p(DynamicMethod.class), "getImplementationClass", cg.sig(RubyModule.class));
                mv.aload(0);
                mv.getfield(cg.p(JavaMethod.class), "arity", cg.ci(Arity.class));
                mv.aload(4);
                mv.aload(5);
                mv.aload(6);
                mv.aconst_null();
                mv.aload(0);
                mv.invokevirtual(cg.p(CallConfiguration.class), "pre", cg.sig(Void.TYPE, cg.params(ThreadContext.class, IRubyObject.class, RubyModule.class, Arity.class, String.class, IRubyObject[].class, Block.class, StaticScope.class, JumpTarget.class)));
                boolean getsBlock = signature.length > 0 && signature[signature.length - 1] == Block.class;
                Label tryBegin = new Label();
                Label tryEnd = new Label();
                Label tryFinally = new Label();
                Label tryReturnJump = new Label();
                Label tryRedoJump = new Label();
                Label normalExit = new Label();
                mv.trycatch(tryBegin, tryEnd, tryReturnJump, cg.p(JumpException.ReturnJump.class));
                mv.trycatch(tryBegin, tryEnd, tryRedoJump, cg.p(JumpException.RedoJump.class));
                mv.trycatch(tryBegin, tryEnd, tryFinally, null);
                mv.label(tryBegin);
                if (Modifier.isStatic(method.getModifiers())) {
                    mv.aload(2);
                } else {
                    mv.aload(2);
                    mv.checkcast(typePath);
                }
                if (jrubyMethod.optional() == 0 && !jrubyMethod.rest()) {
                    this.loadArguments(mv, 5, jrubyMethod.required());
                } else {
                    mv.visitVarInsn(25, 5);
                }
                if (getsBlock) {
                    mv.visitVarInsn(25, 6);
                }
                if (Modifier.isStatic(method.getModifiers())) {
                    mv.visitMethodInsn(184, typePath, javaMethodName, cg.sig(ret, signature));
                } else {
                    mv.visitMethodInsn(182, typePath, javaMethodName, cg.sig(ret, signature));
                }
                mv.label(tryEnd);
                mv.label(normalExit);
                mv.aload(0);
                mv.getfield(cg.p(JavaMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.invokevirtual(cg.p(CallConfiguration.class), "post", cg.sig(Void.TYPE, cg.params(ThreadContext.class)));
                mv.visitInsn(176);
                mv.label(tryReturnJump);
                mv.dup();
                mv.invokevirtual(cg.p(JumpException.FlowControlException.class), "getTarget", cg.sig(Object.class));
                mv.aload(0);
                Label rethrow = new Label();
                mv.if_acmpne(rethrow);
                mv.invokevirtual(cg.p(JumpException.FlowControlException.class), "getValue", cg.sig(Object.class));
                mv.areturn();
                mv.label(rethrow);
                mv.go_to(tryFinally);
                mv.label(tryRedoJump);
                mv.pop();
                mv.aload(1);
                mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                mv.dup();
                mv.invokevirtual(cg.p(Ruby.class), "getNil", cg.sig(IRubyObject.class));
                mv.ldc("redo");
                mv.swap();
                mv.ldc("unexpected redo");
                mv.invokevirtual(cg.p(Ruby.class), "newLocalJumpError", cg.sig(RaiseException.class, cg.params(String.class, IRubyObject.class, String.class)));
                mv.go_to(tryFinally);
                mv.label(tryFinally);
                mv.aload(0);
                mv.getfield(cg.p(JavaMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.invokevirtual(cg.p(CallConfiguration.class), "post", cg.sig(Void.TYPE, cg.params(ThreadContext.class)));
                mv.athrow();
                c = this.endCall(implementationClass.getRuntime(), cw, mv, generatedClassName);
            }
            JavaMethod ic = (JavaMethod)c.getConstructor(RubyModule.class, Visibility.class).newInstance(new Object[]{implementationClass, jrubyMethod.visibility()});
            boolean fast = !jrubyMethod.frame() && !jrubyMethod.scope();
            ic.setArity(Arity.fromAnnotation(jrubyMethod));
            ic.setJavaName(javaMethodName);
            ic.setArgumentTypes(method.getParameterTypes());
            ic.setSingleton(Modifier.isStatic(method.getModifiers()));
            if (fast) {
                ic.setCallConfig(CallConfiguration.JAVA_FAST);
            } else {
                ic.setCallConfig(CallConfiguration.JAVA_FULL);
            }
            return ic;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    private DynamicMethod getCompleteMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, String sup, Object scriptObject) {
        Class<?> scriptClass = scriptObject.getClass();
        String typePath = InvocationMethodFactory.p(scriptClass);
        String mname = scriptClass.getName() + "Invoker" + method + arity;
        String mnamePath = typePath + "Invoker" + method + arity;
        Class c = this.tryClass(implementationClass.getRuntime(), mname);
        try {
            if (c == null) {
                ClassWriter cw = this.createCompiledCtor(mnamePath, sup);
                SkinnyMethodAdapter mv = null;
                mv = new SkinnyMethodAdapter(cw.visitMethod(1, "call", COMPILED_CALL_SIG, null, null));
                mv.visitCode();
                Label line = new Label();
                mv.visitLineNumber(0, line);
                mv.aload(0);
                mv.getfield(cg.p(CompiledMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.aload(2);
                mv.aload(0);
                mv.invokevirtual(cg.p(CompiledMethod.class), "getImplementationClass", cg.sig(RubyModule.class));
                mv.aload(0);
                mv.getfield(cg.p(CompiledMethod.class), "arity", cg.ci(Arity.class));
                mv.aload(4);
                mv.aload(5);
                mv.aload(6);
                mv.aload(0);
                mv.getfield(cg.p(CompiledMethod.class), "staticScope", cg.ci(StaticScope.class));
                mv.aload(0);
                mv.invokevirtual(cg.p(CallConfiguration.class), "pre", cg.sig(Void.TYPE, cg.params(ThreadContext.class, IRubyObject.class, RubyModule.class, Arity.class, String.class, IRubyObject[].class, Block.class, StaticScope.class, JumpTarget.class)));
                mv.aconst_null();
                mv.astore(8);
                Label tryBegin = new Label();
                Label tryEnd = new Label();
                Label tryFinally = new Label();
                Label tryReturnJump = new Label();
                Label tryRedoJump = new Label();
                Label normalExit = new Label();
                mv.trycatch(tryBegin, tryEnd, tryReturnJump, cg.p(JumpException.ReturnJump.class));
                mv.trycatch(tryBegin, tryEnd, tryRedoJump, cg.p(JumpException.RedoJump.class));
                mv.trycatch(tryBegin, tryEnd, tryFinally, null);
                mv.label(tryBegin);
                mv.aload(0);
                mv.getfield(mnamePath, "$scriptObject", cg.ci(Object.class));
                mv.checkcast(typePath);
                mv.aload(1);
                mv.aload(2);
                mv.aload(5);
                mv.aload(6);
                mv.invokevirtual(typePath, method, cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class)));
                mv.astore(8);
                mv.label(tryEnd);
                mv.label(normalExit);
                mv.aload(0);
                mv.getfield(cg.p(DynamicMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.invokevirtual(cg.p(CallConfiguration.class), "post", cg.sig(Void.TYPE, cg.params(ThreadContext.class)));
                mv.aload(8);
                mv.visitInsn(176);
                mv.label(tryReturnJump);
                mv.dup();
                mv.invokevirtual(cg.p(JumpException.FlowControlException.class), "getTarget", cg.sig(Object.class));
                mv.aload(0);
                Label rethrow = new Label();
                mv.if_acmpne(rethrow);
                mv.invokevirtual(cg.p(JumpException.FlowControlException.class), "getValue", cg.sig(Object.class));
                mv.astore(8);
                mv.go_to(normalExit);
                mv.label(rethrow);
                mv.go_to(tryFinally);
                mv.label(tryRedoJump);
                mv.pop();
                mv.aload(1);
                mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                mv.dup();
                mv.invokevirtual(cg.p(Ruby.class), "getNil", cg.sig(IRubyObject.class));
                mv.ldc("redo");
                mv.swap();
                mv.ldc("unexpected redo");
                mv.invokevirtual(cg.p(Ruby.class), "newLocalJumpError", cg.sig(RaiseException.class, cg.params(String.class, IRubyObject.class, String.class)));
                mv.go_to(tryFinally);
                mv.label(tryFinally);
                mv.aload(0);
                mv.getfield(cg.p(DynamicMethod.class), "callConfig", cg.ci(CallConfiguration.class));
                mv.aload(1);
                mv.invokevirtual(cg.p(CallConfiguration.class), "post", cg.sig(Void.TYPE, cg.params(ThreadContext.class)));
                mv.athrow();
                c = this.endCall(implementationClass.getRuntime(), cw, mv, mname);
            }
            return (DynamicMethod)c.getConstructor(RubyModule.class, Arity.class, Visibility.class, StaticScope.class, Object.class).newInstance(new Object[]{implementationClass, arity, visibility, scope, scriptObject});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw implementationClass.getRuntime().newLoadError(e.getMessage());
        }
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String method, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject) {
        return this.getCompleteMethod(implementationClass, method, arity, visibility, scope, COMPILED_SUPER_CLASS, scriptObject);
    }
}

