/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.AliasNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.regexp.PatternSyntaxException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.SharedScopeBlock;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ASTInterpreter {
    public static IRubyObject eval(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        assert (self != null) : "self during eval must never be null";
        try {
            return ASTInterpreter.evalInternal(runtime, context, node, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
    }

    private static IRubyObject evalInternal(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        block94: while (true) {
            if (node == null) {
                return ASTInterpreter.nilNode(runtime, context);
            }
            switch (node.nodeId) {
                case ALIASNODE: {
                    return ASTInterpreter.aliasNode(runtime, context, node);
                }
                case ANDNODE: {
                    Object iVisited = (BinaryOperatorNode)((Object)node);
                    IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
                    if (!result.isTrue()) {
                        return result;
                    }
                    node = iVisited.getSecondNode();
                    continue block94;
                }
                case ARGSCATNODE: {
                    return ASTInterpreter.argsCatNode(runtime, context, node, self, aBlock);
                }
                case ARGSPUSHNODE: {
                    return ASTInterpreter.argsPushNode(runtime, context, node, self, aBlock);
                }
                case ARRAYNODE: {
                    return ASTInterpreter.arrayNode(runtime, context, node, self, aBlock);
                }
                case ATTRASSIGNNODE: {
                    return ASTInterpreter.attrAssignNode(runtime, context, node, self, aBlock);
                }
                case BACKREFNODE: {
                    return ASTInterpreter.backRefNode(context, node);
                }
                case BEGINNODE: {
                    node = ((BeginNode)node).getBodyNode();
                    continue block94;
                }
                case BIGNUMNODE: {
                    return ASTInterpreter.bignumNode(runtime, node);
                }
                case BLOCKNODE: {
                    return ASTInterpreter.blockNode(runtime, context, node, self, aBlock);
                }
                case BLOCKPASSNODE: {
                    assert (false) : "Call nodes and friends deal with this";
                }
                case BREAKNODE: {
                    return ASTInterpreter.breakNode(runtime, context, node, self, aBlock);
                }
                case CALLNODE: {
                    return ASTInterpreter.callNode(runtime, context, node, self, aBlock);
                }
                case CASENODE: {
                    return ASTInterpreter.caseNode(runtime, context, node, self, aBlock);
                }
                case CLASSNODE: {
                    return ASTInterpreter.classNode(runtime, context, node, self, aBlock);
                }
                case CLASSVARASGNNODE: {
                    return ASTInterpreter.classVarAsgnNode(runtime, context, node, self, aBlock);
                }
                case CLASSVARDECLNODE: {
                    return ASTInterpreter.classVarDeclNode(runtime, context, node, self, aBlock);
                }
                case CLASSVARNODE: {
                    return ASTInterpreter.classVarNode(runtime, context, node, self);
                }
                case COLON2NODE: {
                    return ASTInterpreter.colon2Node(runtime, context, node, self, aBlock);
                }
                case COLON3NODE: {
                    return ASTInterpreter.colon3Node(runtime, node);
                }
                case CONSTDECLNODE: {
                    return ASTInterpreter.constDeclNode(runtime, context, node, self, aBlock);
                }
                case CONSTNODE: {
                    return ASTInterpreter.constNode(context, node);
                }
                case DASGNNODE: {
                    return ASTInterpreter.dAsgnNode(runtime, context, node, self, aBlock);
                }
                case DEFINEDNODE: {
                    return ASTInterpreter.definedNode(runtime, context, node, self, aBlock);
                }
                case DEFNNODE: {
                    return ASTInterpreter.defnNode(runtime, context, node);
                }
                case DEFSNODE: {
                    return ASTInterpreter.defsNode(runtime, context, node, self, aBlock);
                }
                case DOTNODE: {
                    return ASTInterpreter.dotNode(runtime, context, node, self, aBlock);
                }
                case DREGEXPNODE: {
                    return ASTInterpreter.dregexpNode(runtime, context, node, self, aBlock);
                }
                case DSTRNODE: {
                    return ASTInterpreter.dStrNode(runtime, context, node, self, aBlock);
                }
                case DSYMBOLNODE: {
                    return ASTInterpreter.dSymbolNode(runtime, context, node, self, aBlock);
                }
                case DVARNODE: {
                    return ASTInterpreter.dVarNode(runtime, context, node);
                }
                case DXSTRNODE: {
                    return ASTInterpreter.dXStrNode(runtime, context, node, self, aBlock);
                }
                case ENSURENODE: {
                    return ASTInterpreter.ensureNode(runtime, context, node, self, aBlock);
                }
                case EVSTRNODE: {
                    return ASTInterpreter.evStrNode(runtime, context, node, self, aBlock);
                }
                case FALSENODE: {
                    return ASTInterpreter.falseNode(runtime, context);
                }
                case FCALLNODE: {
                    return ASTInterpreter.fCallNode(runtime, context, node, self, aBlock);
                }
                case FIXNUMNODE: {
                    return ASTInterpreter.fixnumNode(runtime, node);
                }
                case FLIPNODE: {
                    return ASTInterpreter.flipNode(runtime, context, node, self, aBlock);
                }
                case FLOATNODE: {
                    return ASTInterpreter.floatNode(runtime, node);
                }
                case FORNODE: {
                    return ASTInterpreter.forNode(runtime, context, node, self, aBlock);
                }
                case GLOBALASGNNODE: {
                    return ASTInterpreter.globalAsgnNode(runtime, context, node, self, aBlock);
                }
                case GLOBALVARNODE: {
                    return ASTInterpreter.globalVarNode(runtime, context, node);
                }
                case HASHNODE: {
                    return ASTInterpreter.hashNode(runtime, context, node, self, aBlock);
                }
                case IFNODE: {
                    Object iVisited = (IfNode)node;
                    IRubyObject result = ASTInterpreter.evalInternal(runtime, context, ((IfNode)iVisited).getCondition(), self, aBlock);
                    if (result.isTrue()) {
                        node = ((IfNode)iVisited).getThenBody();
                        continue block94;
                    }
                    node = ((IfNode)iVisited).getElseBody();
                    continue block94;
                }
                case INSTASGNNODE: {
                    return ASTInterpreter.instAsgnNode(runtime, context, node, self, aBlock);
                }
                case INSTVARNODE: {
                    return ASTInterpreter.instVarNode(runtime, node, self);
                }
                case ITERNODE: {
                    assert (false) : "Call nodes deal with these directly";
                }
                case LOCALASGNNODE: {
                    return ASTInterpreter.localAsgnNode(runtime, context, node, self, aBlock);
                }
                case LOCALVARNODE: {
                    return ASTInterpreter.localVarNode(runtime, context, node);
                }
                case MATCH2NODE: {
                    return ASTInterpreter.match2Node(runtime, context, node, self, aBlock);
                }
                case MATCH3NODE: {
                    return ASTInterpreter.match3Node(runtime, context, node, self, aBlock);
                }
                case MATCHNODE: {
                    return ASTInterpreter.matchNode(runtime, context, node, self, aBlock);
                }
                case MODULENODE: {
                    return ASTInterpreter.moduleNode(runtime, context, node, self, aBlock);
                }
                case MULTIPLEASGNNODE: {
                    return ASTInterpreter.multipleAsgnNode(runtime, context, node, self, aBlock);
                }
                case NEWLINENODE: {
                    Object iVisited = (NewlineNode)node;
                    context.setPosition(((Node)iVisited).getPosition());
                    if (ASTInterpreter.isTrace(runtime)) {
                        ASTInterpreter.callTraceFunction(runtime, context, 0);
                    }
                    node = ((NewlineNode)iVisited).getNextNode();
                    continue block94;
                }
                case NEXTNODE: {
                    return ASTInterpreter.nextNode(runtime, context, node, self, aBlock);
                }
                case NILNODE: {
                    return ASTInterpreter.nilNode(runtime, context);
                }
                case NOTNODE: {
                    return ASTInterpreter.notNode(runtime, context, node, self, aBlock);
                }
                case NTHREFNODE: {
                    return ASTInterpreter.nthRefNode(context, node);
                }
                case OPASGNANDNODE: {
                    Object iVisited = (BinaryOperatorNode)((Object)node);
                    IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
                    if (!result.isTrue()) {
                        return ASTInterpreter.pollAndReturn(context, result);
                    }
                    node = iVisited.getSecondNode();
                    continue block94;
                }
                case OPASGNNODE: {
                    return ASTInterpreter.opAsgnNode(runtime, context, node, self, aBlock);
                }
                case OPASGNORNODE: {
                    return ASTInterpreter.opAsgnOrNode(runtime, context, node, self, aBlock);
                }
                case OPELEMENTASGNNODE: {
                    return ASTInterpreter.opElementAsgnNode(runtime, context, node, self, aBlock);
                }
                case ORNODE: {
                    return ASTInterpreter.orNode(runtime, context, node, self, aBlock);
                }
                case PREEXENODE: {
                    return ASTInterpreter.preExeNode(runtime, context, node, self, aBlock);
                }
                case POSTEXENODE: {
                    return ASTInterpreter.postExeNode(runtime, context, node, self, aBlock);
                }
                case REDONODE: {
                    return ASTInterpreter.redoNode(context, node);
                }
                case REGEXPNODE: {
                    return ASTInterpreter.regexpNode(runtime, node);
                }
                case RESCUEBODYNODE: {
                    node = ((RescueBodyNode)node).getBodyNode();
                    continue block94;
                }
                case RESCUENODE: {
                    return ASTInterpreter.rescueNode(runtime, context, node, self, aBlock);
                }
                case RETRYNODE: {
                    return ASTInterpreter.retryNode(context);
                }
                case RETURNNODE: {
                    return ASTInterpreter.returnNode(runtime, context, node, self, aBlock);
                }
                case ROOTNODE: {
                    return ASTInterpreter.rootNode(runtime, context, node, self, aBlock);
                }
                case SCLASSNODE: {
                    return ASTInterpreter.sClassNode(runtime, context, node, self, aBlock);
                }
                case SELFNODE: {
                    return ASTInterpreter.pollAndReturn(context, self);
                }
                case SPLATNODE: {
                    return ASTInterpreter.splatNode(runtime, context, node, self, aBlock);
                }
                case STRNODE: {
                    return ASTInterpreter.strNode(runtime, node);
                }
                case SUPERNODE: {
                    return ASTInterpreter.superNode(runtime, context, node, self, aBlock);
                }
                case SVALUENODE: {
                    return ASTInterpreter.sValueNode(runtime, context, node, self, aBlock);
                }
                case SYMBOLNODE: {
                    return ASTInterpreter.symbolNode(runtime, node);
                }
                case TOARYNODE: {
                    return ASTInterpreter.toAryNode(runtime, context, node, self, aBlock);
                }
                case TRUENODE: {
                    return ASTInterpreter.trueNode(runtime, context);
                }
                case UNDEFNODE: {
                    return ASTInterpreter.undefNode(runtime, context, node);
                }
                case UNTILNODE: {
                    return ASTInterpreter.untilNode(runtime, context, node, self, aBlock);
                }
                case VALIASNODE: {
                    return ASTInterpreter.valiasNode(runtime, node);
                }
                case VCALLNODE: {
                    return ASTInterpreter.vcallNode(runtime, context, node, self);
                }
                case WHENNODE: {
                    assert (false);
                    return null;
                }
                case WHILENODE: {
                    return ASTInterpreter.whileNode(runtime, context, node, self, aBlock);
                }
                case XSTRNODE: {
                    return ASTInterpreter.xStrNode(runtime, context, node, self);
                }
                case YIELDNODE: {
                    return ASTInterpreter.yieldNode(runtime, context, node, self, aBlock);
                }
                case ZARRAYNODE: {
                    return ASTInterpreter.zArrayNode(runtime);
                }
                case ZSUPERNODE: {
                    return ASTInterpreter.zsuperNode(runtime, context, node, self, aBlock);
                }
            }
            break;
        }
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + node.getClass().getName() + "\", please report this at www.jruby.org");
    }

    private static IRubyObject aliasNode(Ruby runtime, ThreadContext context, Node node) {
        AliasNode iVisited = (AliasNode)node;
        RuntimeHelpers.defineAlias(context, iVisited.getNewName(), iVisited.getOldName());
        RubyModule module = context.getRubyClass();
        if (module == null) {
            throw runtime.newTypeError("no class to make alias");
        }
        module.defineAlias(iVisited.getNewName(), iVisited.getOldName());
        module.callMethod(context, "method_added", runtime.fastNewSymbol(iVisited.getNewName()));
        return runtime.getNil();
    }

    private static IRubyObject argsCatNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArgsCatNode iVisited = (ArgsCatNode)node;
        IRubyObject args = ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        RubyArray secondArgs = ASTInterpreter.splatValue(runtime, ASTInterpreter.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock));
        RubyArray list = args instanceof RubyArray ? (RubyArray)args : runtime.newArray(args);
        return list.concat(secondArgs);
    }

    private static IRubyObject argsPushNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArgsPushNode iVisited = (ArgsPushNode)node;
        RubyArray args = (RubyArray)ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock).dup();
        return args.append(ASTInterpreter.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock));
    }

    private static IRubyObject arrayNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ArrayNode iVisited = (ArrayNode)node;
        IRubyObject[] array = new IRubyObject[iVisited.size()];
        for (int i = 0; i < iVisited.size(); ++i) {
            Node next = iVisited.get(i);
            array[i] = ASTInterpreter.evalInternal(runtime, context, next, self, aBlock);
        }
        if (iVisited.isLightweight()) {
            return runtime.newArrayNoCopyLight(array);
        }
        return runtime.newArrayNoCopy(array);
    }

    public static RubyArray arrayValue(Ruby runtime, IRubyObject value) {
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            if (value.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                if (!((value = value.callMethod(runtime.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)value;
            }
            return runtime.newArray(value);
        }
        return (RubyArray)tmp;
    }

    public static IRubyObject aryToAry(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return value.convertToType(runtime.getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return runtime.newArray(value);
    }

    private static IRubyObject attrAssignNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        String name;
        AttrAssignNode iVisited = (AttrAssignNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, iVisited.getArgsNode(), self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        CallType callType = receiver == self ? CallType.VARIABLE : CallType.NORMAL;
        RubyClass module = receiver.getMetaClass();
        DynamicMethod method = module.searchMethod(name = iVisited.getName());
        if (method.isUndefined() || !method.isCallableFrom(self, callType)) {
            return RuntimeHelpers.callMethodMissing(context, receiver, method, name, args, self, callType, Block.NULL_BLOCK);
        }
        method.call(context, receiver, module, name, args, Block.NULL_BLOCK);
        return args[args.length - 1];
    }

    private static IRubyObject backRefNode(ThreadContext context, Node node) {
        BackRefNode iVisited = (BackRefNode)node;
        IRubyObject backref = context.getCurrentFrame().getBackRef();
        switch (iVisited.getType()) {
            case '~': {
                if (backref instanceof RubyMatchData) {
                    ((RubyMatchData)backref).use();
                }
                return backref;
            }
            case '&': {
                return RubyRegexp.last_match(backref);
            }
            case '`': {
                return RubyRegexp.match_pre(backref);
            }
            case '\'': {
                return RubyRegexp.match_post(backref);
            }
            case '+': {
                return RubyRegexp.match_last(backref);
            }
        }
        assert (false) : "backref with invalid type";
        return null;
    }

    private static IRubyObject bignumNode(Ruby runtime, Node node) {
        return RubyBignum.newBignum(runtime, ((BignumNode)node).getValue());
    }

    private static IRubyObject blockNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        BlockNode iVisited = (BlockNode)node;
        IRubyObject result = runtime.getNil();
        for (int i = 0; i < iVisited.size(); ++i) {
            result = ASTInterpreter.evalInternal(runtime, context, iVisited.get(i), self, aBlock);
        }
        return result;
    }

    private static IRubyObject breakNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        BreakNode iVisited = (BreakNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        throw new JumpException.BreakJump(null, result);
    }

    /*
     * Loose catch block
     */
    private static IRubyObject callNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        CallNode iVisited = (CallNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, iVisited.getArgsNode(), self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        if (!block.isGiven()) {
            return iVisited.callAdapter.call(context, receiver, args);
        }
        while (true) {
            try {
                return iVisited.callAdapter.call(context, receiver, args, block);
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }

    private static IRubyObject caseNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        CaseNode iVisited = (CaseNode)node;
        IRubyObject expression = null;
        if (iVisited.getCaseNode() != null) {
            expression = ASTInterpreter.evalInternal(runtime, context, iVisited.getCaseNode(), self, aBlock);
        }
        context.pollThreadEvents();
        IRubyObject result = runtime.getNil();
        Node firstWhenNode = iVisited.getFirstWhenNode();
        while (firstWhenNode != null) {
            if (!(firstWhenNode instanceof WhenNode)) {
                node = firstWhenNode;
                return ASTInterpreter.evalInternal(runtime, context, node, self, aBlock);
            }
            WhenNode whenNode = (WhenNode)firstWhenNode;
            if (whenNode.getExpressionNodes() instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)whenNode.getExpressionNodes();
                for (int i = 0; i < arrayNode.size(); ++i) {
                    Node tag = arrayNode.get(i);
                    context.setPosition(tag.getPosition());
                    if (ASTInterpreter.isTrace(runtime)) {
                        ASTInterpreter.callTraceFunction(runtime, context, 0);
                    }
                    if (tag instanceof WhenNode) {
                        IRubyObject expressionsObject = ASTInterpreter.evalInternal(runtime, context, ((WhenNode)tag).getExpressionNodes(), self, aBlock);
                        RubyArray expressions = ASTInterpreter.splatValue(runtime, expressionsObject);
                        int k = expressions.getLength();
                        for (int j = 0; j < k; ++j) {
                            IRubyObject condition = expressions.eltInternal(j);
                            if ((expression == null || !condition.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue()) && (expression != null || !condition.isTrue())) continue;
                            node = ((WhenNode)firstWhenNode).getBodyNode();
                            return ASTInterpreter.evalInternal(runtime, context, node, self, aBlock);
                        }
                        continue;
                    }
                    result = ASTInterpreter.evalInternal(runtime, context, tag, self, aBlock);
                    if ((expression == null || !result.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue()) && (expression != null || !result.isTrue())) continue;
                    node = whenNode.getBodyNode();
                    return ASTInterpreter.evalInternal(runtime, context, node, self, aBlock);
                }
            } else {
                result = ASTInterpreter.evalInternal(runtime, context, whenNode.getExpressionNodes(), self, aBlock);
                if (expression != null && result.callMethod(context, MethodIndex.OP_EQQ, "===", expression).isTrue() || expression == null && result.isTrue()) {
                    node = ((WhenNode)firstWhenNode).getBodyNode();
                    return ASTInterpreter.evalInternal(runtime, context, node, self, aBlock);
                }
            }
            context.pollThreadEvents();
            firstWhenNode = whenNode.getNextCase();
        }
        return runtime.getNil();
    }

    private static IRubyObject classNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassNode iVisited = (ClassNode)node;
        Colon3Node classNameNode = iVisited.getCPath();
        RubyModule enclosingClass = ASTInterpreter.getEnclosingModule(runtime, context, classNameNode, self, aBlock);
        if (enclosingClass == null) {
            throw runtime.newTypeError("no outer class/module");
        }
        Node superNode = iVisited.getSuperNode();
        RubyClass superClass = null;
        if (superNode != null) {
            IRubyObject superObj = ASTInterpreter.evalInternal(runtime, context, superNode, self, aBlock);
            RubyClass.checkInheritable(superObj);
            superClass = (RubyClass)superObj;
        }
        String name = ((INameNode)classNameNode).getName();
        RubyClass clazz = enclosingClass.defineOrGetClassUnder(name, superClass);
        StaticScope scope = iVisited.getScope();
        scope.setModule(clazz);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, scope, iVisited.getBodyNode(), clazz, self, aBlock);
    }

    private static IRubyObject classVarAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassVarAsgnNode iVisited = (ClassVarAsgnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        rubyClass.fastSetClassVar(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject classVarDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ClassVarDeclNode iVisited = (ClassVarDeclNode)node;
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            throw runtime.newTypeError("no class/module to define class variable");
        }
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        rubyClass.fastSetClassVar(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject classVarNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        ClassVarNode iVisited = (ClassVarNode)node;
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(iVisited.getName());
    }

    private static IRubyObject colon2Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Colon2Node iVisited = (Colon2Node)node;
        Node leftNode = iVisited.getLeftNode();
        if (leftNode == null) {
            return runtime.getObject().fastGetConstantFrom(iVisited.getName());
        }
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getLeftNode(), self, aBlock);
        if (result instanceof RubyModule) {
            return ((RubyModule)result).fastGetConstantFrom(iVisited.getName());
        }
        return result.callMethod(context, iVisited.getName(), aBlock);
    }

    private static IRubyObject colon3Node(Ruby runtime, Node node) {
        return runtime.getObject().fastGetConstantFrom(((Colon3Node)node).getName());
    }

    private static IRubyObject constDeclNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ConstDeclNode iVisited = (ConstDeclNode)node;
        Node constNode = iVisited.getConstNode();
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (constNode == null) {
            return context.setConstantInCurrent(iVisited.getName(), result);
        }
        if (constNode.nodeId == NodeType.COLON2NODE) {
            RubyModule module = (RubyModule)ASTInterpreter.evalInternal(runtime, context, ((Colon2Node)iVisited.getConstNode()).getLeftNode(), self, aBlock);
            return context.setConstantInModule(iVisited.getName(), module, result);
        }
        return context.setConstantInObject(iVisited.getName(), result);
    }

    private static IRubyObject constNode(ThreadContext context, Node node) {
        return context.getConstant(((ConstNode)node).getName());
    }

    private static IRubyObject dAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DAsgnNode iVisited = (DAsgnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
        return result;
    }

    private static IRubyObject definedNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DefinedNode iVisited = (DefinedNode)node;
        String definition = ASTInterpreter.getDefinition(runtime, context, iVisited.getExpressionNode(), self, aBlock);
        if (definition != null) {
            return runtime.newString(definition);
        }
        return runtime.getNil();
    }

    private static IRubyObject defnNode(Ruby runtime, ThreadContext context, Node node) {
        DefnNode iVisited = (DefnNode)node;
        RubyModule containingClass = context.getRubyClass();
        if (containingClass == null) {
            throw runtime.newTypeError("No class to add method.");
        }
        String name = iVisited.getName();
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn("redefining Object#initialize may cause infinite loop");
        }
        if (name == "__id__" || name == "__send__") {
            runtime.getWarnings().warn("redefining `" + name + "' may cause serious problem");
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        StaticScope scope = iVisited.getScope();
        scope.determineModule();
        DefaultMethod newMethod = new DefaultMethod(containingClass, scope, iVisited.getBodyNode(), iVisited.getArgsNode(), visibility);
        containingClass.addMethod(name, newMethod);
        if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), newMethod, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        }
        if (containingClass.isSingleton()) {
            ((MetaClass)containingClass).getAttached().callMethod(context, "singleton_method_added", runtime.fastNewSymbol(iVisited.getName()));
        } else {
            containingClass.callMethod(context, "method_added", runtime.fastNewSymbol(name));
        }
        return runtime.getNil();
    }

    private static IRubyObject defsNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DefsNode iVisited = (DefsNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        String name = iVisited.getName();
        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw runtime.newSecurityError("Insecure; can't define singleton method.");
        }
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("can't define singleton method \"" + name + "\" for " + receiver.getMetaClass().getBaseName());
        }
        if (receiver.isFrozen()) {
            throw runtime.newFrozenError("object");
        }
        RubyClass rubyClass = receiver.getSingletonClass();
        if (runtime.getSafeLevel() >= 4 && rubyClass.getMethods().get(name) != null) {
            throw runtime.newSecurityError("redefining method prohibited.");
        }
        StaticScope scope = iVisited.getScope();
        scope.determineModule();
        DefaultMethod newMethod = new DefaultMethod(rubyClass, scope, iVisited.getBodyNode(), iVisited.getArgsNode(), Visibility.PUBLIC);
        rubyClass.addMethod(name, newMethod);
        receiver.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        return runtime.getNil();
    }

    private static IRubyObject dotNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DotNode iVisited = (DotNode)node;
        return RubyRange.newRange(runtime, ASTInterpreter.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock), ASTInterpreter.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock), iVisited.isExclusive());
    }

    private static IRubyObject dregexpNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        String lang;
        DRegexpNode iVisited = (DRegexpNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(ASTInterpreter.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        int opts = iVisited.getOptions();
        String string2 = lang = (opts & 0x10) != 0 ? "n" : null;
        if ((opts & 0x30) == 48) {
            lang = "s";
        } else if ((opts & 0x20) == 32) {
            lang = "e";
        } else if ((opts & 0x40) != 0) {
            lang = "u";
        }
        try {
            return RubyRegexp.newRegexp(runtime, string.toString(), iVisited.getOptions(), lang);
        }
        catch (jregex.PatternSyntaxException e) {
            throw runtime.newRegexpError(e.getMessage());
        }
    }

    private static IRubyObject dStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DStrNode iVisited = (DStrNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(ASTInterpreter.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return string;
    }

    private static IRubyObject dSymbolNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DSymbolNode iVisited = (DSymbolNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(ASTInterpreter.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return runtime.newSymbol(string.toString());
    }

    private static IRubyObject dVarNode(Ruby runtime, ThreadContext context, Node node) {
        DVarNode iVisited = (DVarNode)node;
        IRubyObject obj = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
        return obj == null ? runtime.getNil() : obj;
    }

    private static IRubyObject dXStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        DXStrNode iVisited = (DXStrNode)node;
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < iVisited.size(); ++i) {
            Node iterNode = iVisited.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(ASTInterpreter.evalInternal(runtime, context, iterNode, self, aBlock));
        }
        return self.callMethod(context, "`", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject ensureNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        EnsureNode iVisited = (EnsureNode)node;
        if (iVisited.getEnsureNode() != null) {
            IRubyObject result = runtime.getNil();
            try {
                result = ASTInterpreter.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
            }
            finally {
                ASTInterpreter.evalInternal(runtime, context, iVisited.getEnsureNode(), self, aBlock);
            }
            return result;
        }
        node = iVisited.getBodyNode();
        return ASTInterpreter.evalInternal(runtime, context, node, self, aBlock);
    }

    private static IRubyObject evStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ASTInterpreter.evalInternal(runtime, context, ((EvStrNode)node).getBody(), self, aBlock).asString();
    }

    private static IRubyObject falseNode(Ruby runtime, ThreadContext context) {
        return ASTInterpreter.pollAndReturn(context, runtime.getFalse());
    }

    private static IRubyObject fCallNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        FCallNode iVisited = (FCallNode)node;
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, iVisited.getArgsNode(), self, aBlock);
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        if (!block.isGiven()) {
            return iVisited.callAdapter.call(context, self, args);
        }
        while (true) {
            try {
                return iVisited.callAdapter.call(context, self, args, block);
            }
            catch (JumpException.RetryJump retryJump) {
                continue;
            }
            break;
        }
    }

    private static IRubyObject fixnumNode(Ruby runtime, Node node) {
        return ((FixnumNode)node).getFixnum(runtime);
    }

    private static IRubyObject flipNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        FlipNode iVisited = (FlipNode)node;
        DynamicScope scope = context.getCurrentScope();
        IRubyObject result = scope.getValue(iVisited.getIndex(), iVisited.getDepth());
        if (iVisited.isExclusive()) {
            if (result == null || !result.isTrue()) {
                result = ASTInterpreter.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock).isTrue() ? runtime.getTrue() : runtime.getFalse();
                scope.setValue(iVisited.getIndex(), result, iVisited.getDepth());
                return result;
            }
            if (ASTInterpreter.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue()) {
                scope.setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
            }
            return runtime.getTrue();
        }
        if (result == null || !result.isTrue()) {
            if (ASTInterpreter.evalInternal(runtime, context, iVisited.getBeginNode(), self, aBlock).isTrue()) {
                scope.setValue(iVisited.getIndex(), ASTInterpreter.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue() ? runtime.getFalse() : runtime.getTrue(), iVisited.getDepth());
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (ASTInterpreter.evalInternal(runtime, context, iVisited.getEndNode(), self, aBlock).isTrue()) {
            scope.setValue(iVisited.getIndex(), runtime.getFalse(), iVisited.getDepth());
        }
        return runtime.getTrue();
    }

    private static IRubyObject floatNode(Ruby runtime, Node node) {
        return RubyFloat.newFloat(runtime, ((FloatNode)node).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject forNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ForNode iVisited = (ForNode)node;
        Block block = SharedScopeBlock.createSharedScopeBlock(context, iVisited, context.getCurrentScope(), self);
        try {
            while (true) {
                try {
                    ISourcePosition position = context.getPosition();
                    IRubyObject recv = null;
                    try {
                        recv = ASTInterpreter.evalInternal(runtime, context, iVisited.getIterNode(), self, aBlock);
                    }
                    finally {
                        context.setPosition(position);
                    }
                    return ForNode.callAdapter.call(context, recv, block);
                }
                catch (JumpException.RetryJump position) {
                    continue;
                }
                break;
            }
        }
        catch (JumpException.BreakJump bj) {
            return (IRubyObject)bj.getValue();
        }
    }

    private static IRubyObject globalAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        GlobalAsgnNode iVisited = (GlobalAsgnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        runtime.getGlobalVariables().set(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject globalVarNode(Ruby runtime, ThreadContext context, Node node) {
        GlobalVarNode iVisited = (GlobalVarNode)node;
        return runtime.getGlobalVariables().get(iVisited.getName());
    }

    private static IRubyObject hashNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        HashNode iVisited = (HashNode)node;
        RubyHash hash = null;
        if (iVisited.getListNode() != null) {
            hash = RubyHash.newHash(runtime);
            int i = 0;
            while (i < iVisited.getListNode().size()) {
                IRubyObject key = ASTInterpreter.evalInternal(runtime, context, iVisited.getListNode().get(i++), self, aBlock);
                IRubyObject value = ASTInterpreter.evalInternal(runtime, context, iVisited.getListNode().get(i++), self, aBlock);
                hash.fastASet(key, value);
            }
        }
        if (hash == null) {
            return RubyHash.newHash(runtime);
        }
        return hash;
    }

    private static IRubyObject instAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        InstAsgnNode iVisited = (InstAsgnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        self.fastSetInstanceVariable(iVisited.getName(), result);
        return result;
    }

    private static IRubyObject instVarNode(Ruby runtime, Node node, IRubyObject self) {
        InstVarNode iVisited = (InstVarNode)node;
        IRubyObject variable = self.fastGetInstanceVariable(iVisited.getName());
        if (variable != null) {
            return variable;
        }
        runtime.getWarnings().warning(iVisited.getPosition(), "instance variable " + iVisited.getName() + " not initialized");
        return runtime.getNil();
    }

    private static IRubyObject localAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        LocalAsgnNode iVisited = (LocalAsgnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        context.getCurrentScope().setValue(iVisited.getIndex(), result, iVisited.getDepth());
        return result;
    }

    private static IRubyObject localVarNode(Ruby runtime, ThreadContext context, Node node) {
        LocalVarNode iVisited = (LocalVarNode)node;
        IRubyObject result = context.getCurrentScope().getValue(iVisited.getIndex(), iVisited.getDepth());
        return result == null ? runtime.getNil() : result;
    }

    private static IRubyObject match2Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Match2Node iVisited = (Match2Node)node;
        IRubyObject recv = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        return ((RubyRegexp)recv).op_match(value);
    }

    private static IRubyObject match3Node(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Match3Node iVisited = (Match3Node)node;
        IRubyObject recv = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (value instanceof RubyString) {
            return ((RubyRegexp)recv).op_match(value);
        }
        return Match3Node.callAdapter.call(context, value, recv);
    }

    private static IRubyObject matchNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ((RubyRegexp)ASTInterpreter.evalInternal(runtime, context, ((MatchNode)node).getRegexpNode(), self, aBlock)).op_match2();
    }

    private static IRubyObject moduleNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ModuleNode iVisited = (ModuleNode)node;
        Colon3Node classNameNode = iVisited.getCPath();
        RubyModule enclosingModule = ASTInterpreter.getEnclosingModule(runtime, context, classNameNode, self, aBlock);
        if (enclosingModule == null) {
            throw runtime.newTypeError("no outer class/module");
        }
        String name = ((INameNode)classNameNode).getName();
        RubyModule module = enclosingModule.defineOrGetModuleUnder(name);
        StaticScope scope = iVisited.getScope();
        scope.setModule(module);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, scope, iVisited.getBodyNode(), module, self, aBlock);
    }

    private static IRubyObject multipleAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        MultipleAsgnNode iVisited = (MultipleAsgnNode)node;
        switch (iVisited.getValueNode().nodeId) {
            case ARRAYNODE: {
                ArrayNode iVisited2 = (ArrayNode)iVisited.getValueNode();
                return ASTInterpreter.multipleAsgnArrayNode(runtime, context, iVisited, iVisited2, self, aBlock);
            }
            case SPLATNODE: {
                SplatNode splatNode = (SplatNode)iVisited.getValueNode();
                RubyArray rubyArray = ASTInterpreter.splatValue(runtime, ASTInterpreter.evalInternal(runtime, context, splatNode.getValue(), self, aBlock));
                return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, rubyArray, false);
            }
        }
        IRubyObject value = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(runtime, value);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, (RubyArray)value, false);
    }

    private static IRubyObject multipleAsgnArrayNode(Ruby runtime, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            Node next = node.get(i);
            array[i] = ASTInterpreter.evalInternal(runtime, context, next, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime, array), false);
    }

    private static IRubyObject nextNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        NextNode iVisited = (NextNode)node;
        context.pollThreadEvents();
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        throw new JumpException.NextJump(result);
    }

    private static IRubyObject nilNode(Ruby runtime, ThreadContext context) {
        return ASTInterpreter.pollAndReturn(context, runtime.getNil());
    }

    private static IRubyObject notNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        NotNode iVisited = (NotNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getConditionNode(), self, aBlock);
        return result.isTrue() ? runtime.getFalse() : runtime.getTrue();
    }

    private static IRubyObject nthRefNode(ThreadContext context, Node node) {
        return RubyRegexp.nth_match(((NthRefNode)node).getMatchNumber(), context.getCurrentFrame().getBackRef());
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    private static IRubyObject opAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpAsgnNode iVisited = (OpAsgnNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject value = receiver.callMethod(context, iVisited.getVariableName());
        if (iVisited.getOperatorName() == "||") {
            if (value.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value);
            }
            value = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else if (iVisited.getOperatorName() == "&&") {
            if (!value.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value);
            }
            value = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else {
            value = iVisited.operatorCallAdapter.call(context, value, ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock));
        }
        receiver.callMethod(context, iVisited.getVariableNameAsgn(), value);
        return ASTInterpreter.pollAndReturn(context, value);
    }

    private static IRubyObject opAsgnOrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpAsgnOrNode iVisited = (OpAsgnOrNode)node;
        String def = ASTInterpreter.getDefinition(runtime, context, iVisited.getFirstNode(), self, aBlock);
        IRubyObject result = runtime.getNil();
        if (def != null) {
            result = ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        }
        if (!result.isTrue()) {
            result = ASTInterpreter.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock);
        }
        return ASTInterpreter.pollAndReturn(context, result);
    }

    private static IRubyObject opElementAsgnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OpElementAsgnNode iVisited = (OpElementAsgnNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, iVisited.getArgsNode(), self, aBlock);
        IRubyObject firstValue = receiver.callMethod(context, MethodIndex.AREF, "[]", args);
        if (iVisited.getOperatorName() == "||") {
            if (firstValue.isTrue()) {
                return firstValue;
            }
            firstValue = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else if (iVisited.getOperatorName() == "&&") {
            if (!firstValue.isTrue()) {
                return firstValue;
            }
            firstValue = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        } else {
            firstValue = iVisited.callAdapter.call(context, firstValue, ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock));
        }
        IRubyObject[] expandedArgs = new IRubyObject[args.length + 1];
        System.arraycopy(args, 0, expandedArgs, 0, args.length);
        expandedArgs[expandedArgs.length - 1] = firstValue;
        return receiver.callMethod(context, MethodIndex.ASET, "[]=", expandedArgs);
    }

    private static IRubyObject orNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        OrNode iVisited = (OrNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getFirstNode(), self, aBlock);
        if (!result.isTrue()) {
            result = ASTInterpreter.evalInternal(runtime, context, iVisited.getSecondNode(), self, aBlock);
        }
        return result;
    }

    private static IRubyObject postExeNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        PostExeNode iVisited = (PostExeNode)node;
        Block block = SharedScopeBlock.createSharedScopeBlock(context, iVisited, context.getCurrentScope(), self);
        runtime.pushExitBlock(runtime.newProc(Block.Type.LAMBDA, block));
        return runtime.getNil();
    }

    private static IRubyObject preExeNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        PreExeNode iVisited = (PreExeNode)node;
        DynamicScope scope = new DynamicScope(iVisited.getScope());
        context.preScopedBody(scope);
        Block block = Block.createBlock(context, iVisited, context.getCurrentScope(), self);
        block.yield(context, null);
        context.postScopedBody();
        return runtime.getNil();
    }

    private static IRubyObject redoNode(ThreadContext context, Node node) {
        context.pollThreadEvents();
        throw JumpException.REDO_JUMP;
    }

    private static IRubyObject regexpNode(Ruby runtime, Node node) {
        RegexpNode iVisited = (RegexpNode)node;
        if (iVisited.literal == null) {
            String lang;
            int opts = iVisited.getOptions();
            String string = lang = (opts & 0x10) == 16 ? "n" : null;
            if ((opts & 0x30) == 48) {
                lang = "s";
            } else if ((opts & 0x20) == 32) {
                lang = "e";
            } else if ((opts & 0x40) != 0) {
                lang = "u";
            }
            IRubyObject noCaseGlobal = runtime.getGlobalVariables().get("$=");
            int extraOptions = noCaseGlobal.isTrue() ? 1 : 0;
            try {
                iVisited.literal = RubyRegexp.newRegexp(runtime, iVisited.getPattern(runtime, extraOptions), lang);
            }
            catch (PatternSyntaxException e) {
                throw runtime.newRegexpError(e.getMessage());
            }
        }
        return iVisited.literal;
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject rescueNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject retryNode(ThreadContext context) {
        context.pollThreadEvents();
        throw JumpException.RETRY_JUMP;
    }

    private static IRubyObject returnNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        ReturnNode iVisited = (ReturnNode)node;
        IRubyObject result = ASTInterpreter.evalInternal(runtime, context, iVisited.getValueNode(), self, aBlock);
        throw new JumpException.ReturnJump(context.getFrameJumpTarget(), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject rootNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        RootNode iVisited = (RootNode)node;
        DynamicScope scope = iVisited.getScope();
        if (scope == null) {
            scope = new DynamicScope(iVisited.getStaticScope());
        }
        StaticScope staticScope = scope.getStaticScope();
        context.preScopedBody(scope);
        if (staticScope.getModule() == null) {
            staticScope.setModule(runtime.getObject());
        }
        try {
            IRubyObject iRubyObject = ASTInterpreter.evalInternal(runtime, context, iVisited.getBodyNode(), self, aBlock);
            return iRubyObject;
        }
        finally {
            context.postScopedBody();
        }
    }

    private static IRubyObject sClassNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        SClassNode iVisited = (SClassNode)node;
        IRubyObject receiver = ASTInterpreter.evalInternal(runtime, context, iVisited.getReceiverNode(), self, aBlock);
        if (receiver instanceof RubyFixnum || receiver instanceof RubySymbol) {
            throw runtime.newTypeError("no virtual class for " + receiver.getMetaClass().getBaseName());
        }
        if (runtime.getSafeLevel() >= 4 && !receiver.isTaint()) {
            throw runtime.newSecurityError("Insecure: can't extend object.");
        }
        RubyClass singletonClass = receiver.getSingletonClass();
        StaticScope scope = iVisited.getScope();
        scope.setModule(singletonClass);
        return ASTInterpreter.evalClassDefinitionBody(runtime, context, scope, iVisited.getBodyNode(), singletonClass, self, aBlock);
    }

    private static IRubyObject splatNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ASTInterpreter.splatValue(runtime, ASTInterpreter.evalInternal(runtime, context, ((SplatNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject strNode(Ruby runtime, Node node) {
        return runtime.newStringShared(((StrNode)node).getValue());
    }

    private static IRubyObject superNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        SuperNode iVisited = (SuperNode)node;
        RubyModule klazz = context.getFrameKlazz();
        if (klazz == null) {
            String name = context.getFrameName();
            throw runtime.newNameError("Superclass method '" + name + "' disabled.", name);
        }
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, iVisited.getArgsNode(), self, aBlock);
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, iVisited.getIterNode());
        if (iVisited.getIterNode() == null && !block.isGiven()) {
            block = aBlock;
        }
        return self.callSuper(context, args, block);
    }

    private static IRubyObject sValueNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ASTInterpreter.aValueSplat(runtime, ASTInterpreter.evalInternal(runtime, context, ((SValueNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject symbolNode(Ruby runtime, Node node) {
        return ((SymbolNode)node).getSymbol(runtime);
    }

    private static IRubyObject toAryNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        return ASTInterpreter.aryToAry(runtime, ASTInterpreter.evalInternal(runtime, context, ((ToAryNode)node).getValue(), self, aBlock));
    }

    private static IRubyObject trueNode(Ruby runtime, ThreadContext context) {
        return ASTInterpreter.pollAndReturn(context, runtime.getTrue());
    }

    private static IRubyObject undefNode(Ruby runtime, ThreadContext context, Node node) {
        UndefNode iVisited = (UndefNode)node;
        RubyModule module = context.getRubyClass();
        if (module == null) {
            throw runtime.newTypeError("No class to undef method '" + iVisited.getName() + "'.");
        }
        module.undef(iVisited.getName());
        return runtime.getNil();
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject untilNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 3[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject valiasNode(Ruby runtime, Node node) {
        VAliasNode iVisited = (VAliasNode)node;
        runtime.getGlobalVariables().alias(iVisited.getNewName(), iVisited.getOldName());
        return runtime.getNil();
    }

    private static IRubyObject vcallNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        VCallNode iVisited = (VCallNode)node;
        return iVisited.callAdapter.call(context, self);
    }

    /*
     * Exception decompiling
     */
    private static IRubyObject whileNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 4[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IRubyObject xStrNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self) {
        return self.callMethod(context, "`", runtime.newStringShared(((XStrNode)node).getValue()));
    }

    private static IRubyObject yieldNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        YieldNode iVisited = (YieldNode)node;
        IRubyObject result = null;
        if (iVisited.getArgsNode() != null) {
            result = ASTInterpreter.evalInternal(runtime, context, iVisited.getArgsNode(), self, aBlock);
        }
        Block block = context.getCurrentFrame().getBlock();
        return block.yield(context, result, null, null, iVisited.getCheckState());
    }

    private static IRubyObject zArrayNode(Ruby runtime) {
        return runtime.newArray();
    }

    private static IRubyObject zsuperNode(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, ((ZSuperNode)node).getIterNode());
        return RuntimeHelpers.callZSuper(runtime, context, block, self);
    }

    public static IRubyObject aValueSplat(Ruby runtime, IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    private static void callTraceFunction(Ruby runtime, ThreadContext context, int event) {
        String name = context.getFrameName();
        RubyModule type = context.getFrameKlazz();
        runtime.callEventHooks(context, event, context.getPosition().getFile(), context.getPosition().getStartLine(), name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self, Block block) {
        context.preClassEval(scope, type);
        try {
            if (ASTInterpreter.isTrace(runtime)) {
                ASTInterpreter.callTraceFunction(runtime, context, 1);
            }
            IRubyObject iRubyObject = ASTInterpreter.evalInternal(runtime, context, bodyNode, type, block);
            return iRubyObject;
        }
        finally {
            if (ASTInterpreter.isTrace(runtime)) {
                ASTInterpreter.callTraceFunction(runtime, context, 2);
            }
            context.postClassEval();
        }
    }

    private static String getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, String type, IRubyObject self, Block block) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                if (ASTInterpreter.getDefinitionInner(runtime, context, iterNode, self, block) != null) continue;
                return null;
            }
        } else if (ASTInterpreter.getDefinitionInner(runtime, context, node, self, block) == null) {
            return null;
        }
        return type;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            IterNode iterNode = (IterNode)blockNode;
            StaticScope scope = iterNode.getScope();
            scope.determineModule();
            return Block.createBlock(context, iterNode, new DynamicScope(scope, context.getCurrentScope()), self);
        }
        if (blockNode instanceof BlockPassNode) {
            BlockPassNode blockPassNode = (BlockPassNode)blockNode;
            IRubyObject proc = ASTInterpreter.evalInternal(runtime, context, blockPassNode.getBodyNode(), self, currentBlock);
            return RuntimeHelpers.getBlockFromBlockPassBody(proc, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        if (rubyClass.isSingleton()) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() == null) {
                runtime.getWarnings().warn("class variable access from toplevel singleton method");
            }
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefinition(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string = ASTInterpreter.getDefinitionInner(runtime, context, node, self, aBlock);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    private static String getDefinitionInner(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return "expression";
        }
        switch (node.nodeId) {
            case ATTRASSIGNNODE: {
                AttrAssignNode iVisited = (AttrAssignNode)node;
                if (ASTInterpreter.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "assignment", self, aBlock);
                        }
                    }
                    catch (JumpException receiver) {
                        // empty catch block
                    }
                }
                return null;
            }
            case BACKREFNODE: {
                IRubyObject backref = context.getCurrentFrame().getBackRef();
                if (backref instanceof RubyMatchData) {
                    return "$" + ((BackRefNode)node).getType();
                }
                return null;
            }
            case CALLNODE: {
                CallNode iVisited = (CallNode)node;
                if (ASTInterpreter.getDefinitionInner(runtime, context, iVisited.getReceiverNode(), self, aBlock) != null) {
                    try {
                        IRubyObject receiver = ASTInterpreter.eval(runtime, context, iVisited.getReceiverNode(), self, aBlock);
                        RubyClass metaClass = receiver.getMetaClass();
                        DynamicMethod method = metaClass.searchMethod(iVisited.getName());
                        Visibility visibility = method.getVisibility();
                        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || self.isKindOf(metaClass.getRealClass())) && metaClass.isMethodBound(iVisited.getName(), false)) {
                            return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                        }
                    }
                    catch (JumpException receiver) {
                        // empty catch block
                    }
                }
                return null;
            }
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: {
                return "assignment";
            }
            case CLASSVARNODE: {
                ClassVarNode iVisited = (ClassVarNode)node;
                RubyModule module = context.getCurrentScope().getStaticScope().getModule();
                if (module == null && self.getMetaClass().fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                if (module.fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                IRubyObject attached = null;
                if (module.isSingleton()) {
                    attached = ((MetaClass)module).getAttached();
                }
                if (attached instanceof RubyModule && (module = (RubyModule)attached).fastIsClassVarDefined(iVisited.getName())) {
                    return "class variable";
                }
                return null;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                Colon3Node iVisited = (Colon3Node)node;
                try {
                    IRubyObject left = runtime.getObject();
                    if (iVisited instanceof Colon2Node) {
                        left = ASTInterpreter.eval(runtime, context, ((Colon2Node)iVisited).getLeftNode(), self, aBlock);
                    }
                    if (left instanceof RubyModule && ((RubyModule)left).fastGetConstantAt(iVisited.getName()) != null) {
                        return "constant";
                    }
                    if (left.getMetaClass().isMethodBound(iVisited.getName(), true)) {
                        return "method";
                    }
                }
                catch (JumpException left) {
                    // empty catch block
                }
                return null;
            }
            case CONSTNODE: {
                if (context.getConstantDefined(((ConstNode)node).getName())) {
                    return "constant";
                }
                return null;
            }
            case DVARNODE: {
                return "local-variable(in-block)";
            }
            case FALSENODE: {
                return "false";
            }
            case FCALLNODE: {
                FCallNode iVisited = (FCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "method", self, aBlock);
                }
                return null;
            }
            case GLOBALVARNODE: {
                if (runtime.getGlobalVariables().isDefined(((GlobalVarNode)node).getName())) {
                    return "global-variable";
                }
                return null;
            }
            case INSTVARNODE: {
                if (self.fastHasInstanceVariable(((InstVarNode)node).getName())) {
                    return "instance-variable";
                }
                return null;
            }
            case LOCALVARNODE: {
                return "local-variable";
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return "method";
            }
            case NILNODE: {
                return "nil";
            }
            case NTHREFNODE: {
                IRubyObject backref = context.getCurrentFrame().getBackRef();
                if (backref instanceof RubyMatchData) {
                    ((RubyMatchData)backref).use();
                    if (!((RubyMatchData)backref).group(((NthRefNode)node).getMatchNumber()).isNil()) {
                        return "$" + ((NthRefNode)node).getMatchNumber();
                    }
                }
                return null;
            }
            case SELFNODE: {
                return "self";
            }
            case SUPERNODE: {
                SuperNode iVisited = (SuperNode)node;
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, iVisited.getArgsNode(), "super", self, aBlock);
                }
                return null;
            }
            case TRUENODE: {
                return "true";
            }
            case VCALLNODE: {
                VCallNode iVisited = (VCallNode)node;
                if (self.getMetaClass().isMethodBound(iVisited.getName(), false)) {
                    return "method";
                }
                return null;
            }
            case YIELDNODE: {
                return aBlock.isGiven() ? "yield" : null;
            }
            case ZSUPERNODE: {
                String name = context.getFrameName();
                RubyModule klazz = context.getFrameKlazz();
                if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
                    return "super";
                }
                return null;
            }
        }
        try {
            ASTInterpreter.eval(runtime, context, node, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpException) {
            return null;
        }
    }

    private static RubyModule getEnclosingModule(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        RubyModule enclosingModule = null;
        if (node instanceof Colon2Node) {
            IRubyObject result = ASTInterpreter.evalInternal(runtime, context, ((Colon2Node)node).getLeftNode(), self, block);
            if (result != null && !result.isNil()) {
                enclosingModule = (RubyModule)result;
            }
        } else if (node instanceof Colon3Node) {
            enclosingModule = runtime.getObject();
        }
        if (enclosingModule == null) {
            enclosingModule = context.getCurrentScope().getStaticScope().getModule();
        }
        return enclosingModule;
    }

    private static boolean isTrace(Ruby runtime) {
        return runtime.hasEventHooks();
    }

    private static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            ISourcePosition position = context.getPosition();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            for (int i = 0; i < size; ++i) {
                argsArray[i] = ASTInterpreter.evalInternal(runtime, context, argsArrayNode.get(i), self, aBlock);
            }
            context.setPosition(position);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(ASTInterpreter.evalInternal(runtime, context, node, self, aBlock));
    }

    public static RubyArray splatValue(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.newArray(value);
        }
        return ASTInterpreter.arrayValue(runtime, value);
    }

    public static RubyArray splatValue(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.splatValue(runtime, value);
    }

    public static IRubyObject aValueSplat(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aValueSplat(runtime, value);
    }

    public static IRubyObject aryToAry(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aryToAry(runtime, value);
    }
}

