/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.regexp.RegexpPattern;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallAdapter;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledSharedScopeBlock;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;

public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    private static final CodegenUtils cg = CodegenUtils.cg;
    private static final String THREADCONTEXT = cg.p(ThreadContext.class);
    private static final String RUBY = cg.p(Ruby.class);
    private static final String IRUBYOBJECT = cg.p(IRubyObject.class);
    private static final String METHOD_SIGNATURE = cg.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    private static final String CLOSURE_SIGNATURE = cg.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class);
    private static final int THIS = 0;
    private static final int THREADCONTEXT_INDEX = 1;
    private static final int SELF_INDEX = 2;
    private static final int ARGS_INDEX = 3;
    private static final int CLOSURE_INDEX = 4;
    private static final int DYNAMIC_SCOPE_INDEX = 5;
    private static final int RUNTIME_INDEX = 6;
    private static final int VARS_ARRAY_INDEX = 7;
    private static final int NIL_INDEX = 8;
    private static final int EXCEPTION_INDEX = 9;
    private static final int PREVIOUS_EXCEPTION_INDEX = 10;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    int methodIndex = -1;
    int innerIndex = -1;
    int fieldIndex = 0;
    int rescueNumber = 1;
    int ensureNumber = 1;
    StaticScope topLevelScope;
    Map<String, String> sourcePositions = new HashMap<String, String>();
    Map<String, String> byteLists = new HashMap<String, String>();
    Map<String, String> symbols = new HashMap<String, String>();
    private int constants = 0;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(cg.c(this.classname), this.classWriter.toByteArray());
        return classLoader.loadClass(cg.c(this.classname));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        byte[] bytecode = writer.toByteArray();
        CheckClassAdapter.verify(new ClassReader(bytecode), false, new PrintWriter(System.err));
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(bytecode);
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope scope) {
        this.classWriter = new ClassWriter(1);
        this.classWriter.visit(48, 33, this.classname, null, cg.p(Object.class), new String[]{cg.p(Script.class)});
        this.classWriter.visitSource(this.sourcename, null);
        this.topLevelScope = scope;
        this.beginInit();
        this.beginClassInit();
    }

    @Override
    public void endScript() {
        String methodName = "__file__";
        SkinnyMethodAdapter method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null));
        method.start();
        method.aload(0);
        method.aload(1);
        method.aload(2);
        method.aload(3);
        method.aload(4);
        method.invokevirtual(this.classname, methodName, METHOD_SIGNATURE);
        method.areturn();
        method.end();
        method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURE, null, null));
        method.start();
        Label tryBegin = new Label();
        Label tryFinally = new Label();
        method.label(tryBegin);
        method.aload(1);
        this.buildStaticScopeNames(method, this.topLevelScope);
        method.invokestatic(cg.p(RuntimeHelpers.class), "preLoad", cg.sig(Void.TYPE, ThreadContext.class, String[].class));
        method.aload(0);
        method.aload(1);
        method.aload(2);
        method.aload(3);
        method.aload(4);
        method.invokevirtual(this.classname, methodName, METHOD_SIGNATURE);
        method.aload(1);
        method.invokestatic(cg.p(RuntimeHelpers.class), "postLoad", cg.sig(Void.TYPE, ThreadContext.class));
        method.areturn();
        method.label(tryFinally);
        method.aload(1);
        method.invokestatic(cg.p(RuntimeHelpers.class), "postLoad", cg.sig(Void.TYPE, ThreadContext.class));
        method.athrow();
        method.trycatch(tryBegin, tryFinally, tryFinally, null);
        method.end();
        method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", cg.sig(Void.TYPE, cg.params(String[].class)), null, null));
        method.start();
        method.newobj(this.classname);
        method.dup();
        method.invokespecial(this.classname, "<init>", cg.sig(Void.TYPE));
        method.newobj(cg.p(RubyInstanceConfig.class));
        method.dup();
        method.invokespecial(cg.p(RubyInstanceConfig.class), "<init>", "()V");
        method.dup();
        method.aload(0);
        method.invokevirtual(cg.p(RubyInstanceConfig.class), "setArgv", cg.sig(Void.TYPE, String[].class));
        method.invokestatic(cg.p(Ruby.class), "newInstance", cg.sig(Ruby.class, RubyInstanceConfig.class));
        method.dup();
        method.invokevirtual(RUBY, "getCurrentContext", cg.sig(ThreadContext.class));
        method.swap();
        method.invokevirtual(RUBY, "getTopSelf", cg.sig(IRubyObject.class));
        method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
        method.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
        method.invokevirtual(this.classname, "load", METHOD_SIGNATURE);
        method.voidreturn();
        method.end();
        this.endInit();
        this.endClassInit();
    }

    public void buildStaticScopeNames(SkinnyMethodAdapter method, StaticScope scope) {
        method.ldc(new Integer(scope.getNumberOfVariables()));
        method.anewarray(cg.p(String.class));
        for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
            method.dup();
            method.ldc(new Integer(i));
            method.ldc(scope.getVariables()[i]);
            method.arraystore();
        }
    }

    private void beginInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", cg.sig(Void.TYPE), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        this.initMethod.invokespecial(cg.p(Object.class), "<init>", cg.sig(Void.TYPE));
        cv.visitField(18, "$class", cg.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(cg.c(this.classname));
        this.initMethod.invokestatic(cg.p(Class.class), "forName", cg.sig(Class.class, cg.params(String.class)));
        this.initMethod.putfield(this.classname, "$class", cg.ci(Class.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(cv.visitMethod(9, "<clinit>", cg.sig(Void.TYPE), null, null));
        this.clinitMethod.start();
    }

    private void endClassInit() {
        this.clinitMethod.voidreturn();
        this.clinitMethod.end();
    }

    @Override
    public MethodCompiler startMethod(String friendlyName, ClosureCallback args, StaticScope scope, ASTInspector inspector) {
        ASMMethodCompiler methodCompiler = new ASMMethodCompiler(friendlyName, inspector);
        methodCompiler.beginMethod(args, scope);
        return methodCompiler;
    }

    public String getNewConstant(String type, String name_prefix) {
        return this.getNewConstant(type, name_prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewConstant(String type, String name_prefix, Object init) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "_" + this.constants++;
        }
        cv.visitField(2, realName, type, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.classname, realName, type);
        }
        return realName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String type, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "__" + this.constants++;
        }
        cv.visitField(10, realName, type, null, null).visitEnd();
        return realName;
    }

    public String cacheCallAdapter(String name, CallType callType) {
        String fieldName = this.getNewConstant(cg.ci(CallAdapter.class), cg.cleanJavaIdentifier(name));
        this.initMethod.aload(0);
        this.initMethod.ldc(name);
        if (callType.equals(CallType.NORMAL)) {
            this.initMethod.invokestatic(cg.p(MethodIndex.class), "getCallAdapter", cg.sig(CallAdapter.class, cg.params(String.class)));
        } else if (callType.equals(CallType.FUNCTIONAL)) {
            this.initMethod.invokestatic(cg.p(MethodIndex.class), "getFunctionAdapter", cg.sig(CallAdapter.class, cg.params(String.class)));
        } else if (callType.equals(CallType.VARIABLE)) {
            this.initMethod.invokestatic(cg.p(MethodIndex.class), "getVariableAdapter", cg.sig(CallAdapter.class, cg.params(String.class)));
        }
        this.initMethod.putfield(this.classname, fieldName, cg.ci(CallAdapter.class));
        return fieldName;
    }

    public String cachePosition(String file, int line) {
        String cleanName = cg.cleanJavaIdentifier(file + "$" + line);
        String fieldName = this.sourcePositions.get(cleanName);
        if (fieldName == null) {
            fieldName = this.getNewStaticConstant(cg.ci(ISourcePosition.class), cleanName);
            this.sourcePositions.put(cg.cleanJavaIdentifier(file + "$" + line), fieldName);
            this.clinitMethod.ldc(file);
            this.clinitMethod.ldc(line);
            this.clinitMethod.invokestatic(cg.p(RuntimeHelpers.class), "constructPosition", cg.sig(ISourcePosition.class, String.class, Integer.TYPE));
            this.clinitMethod.putstatic(this.classname, fieldName, cg.ci(ISourcePosition.class));
        }
        return fieldName;
    }

    public String cacheByteList(String contents) {
        String fieldName = this.byteLists.get(contents);
        if (fieldName == null) {
            fieldName = this.getNewStaticConstant(cg.ci(ByteList.class), "byteList");
            this.byteLists.put(contents, fieldName);
            this.clinitMethod.ldc(contents);
            this.clinitMethod.invokestatic(cg.p(ByteList.class), "create", cg.sig(ByteList.class, CharSequence.class));
            this.clinitMethod.putstatic(this.classname, fieldName, cg.ci(ByteList.class));
        }
        return fieldName;
    }

    public String cacheSymbol(String symbol) {
        String methodName = this.symbols.get(symbol);
        if (methodName == null) {
            String fieldName = this.getNewConstant(cg.ci(RubySymbol.class), "symbol");
            methodName = "getSymbol" + fieldName;
            this.symbols.put(symbol, methodName);
            ClassVisitor cv = this.getClassVisitor();
            SkinnyMethodAdapter symMethod = new SkinnyMethodAdapter(cv.visitMethod(4098, methodName, cg.sig(RubySymbol.class, Ruby.class), null, null));
            symMethod.start();
            symMethod.aload(0);
            symMethod.getfield(this.classname, fieldName, cg.ci(RubySymbol.class));
            symMethod.dup();
            symMethod.astore(2);
            Label ifNullEnd = new Label();
            symMethod.ifnull(ifNullEnd);
            symMethod.aload(2);
            symMethod.areturn();
            symMethod.label(ifNullEnd);
            symMethod.aload(0);
            symMethod.aload(1);
            symMethod.ldc(symbol);
            symMethod.invokevirtual(cg.p(Ruby.class), "fastNewSymbol", cg.sig(RubySymbol.class, String.class));
            symMethod.dup_x1();
            symMethod.putfield(this.classname, fieldName, cg.ci(RubySymbol.class));
            symMethod.areturn();
            symMethod.end();
        }
        return methodName;
    }

    public class ASMMethodCompiler
    extends AbstractMethodCompiler {
        private String friendlyName;

        public ASMMethodCompiler(String friendlyName, ASTInspector inspector) {
            this.friendlyName = friendlyName;
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, friendlyName, METHOD_SIGNATURE, null, null));
            this.variableCompiler = inspector == null || inspector.hasClosure() || inspector.hasScopeAwareMethods() ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4);
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        public void beginChainedMethod() {
            this.method.aload(1);
            this.method.dup();
            this.method.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.method.invokevirtual(cg.p(Ruby.class), "getNil", cg.sig(IRubyObject.class));
            this.method.astore(8);
            this.method.invokevirtual(cg.p(ThreadContext.class), "getCurrentScope", cg.sig(DynamicScope.class));
            this.method.dup();
            this.method.astore(5);
            this.method.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
            this.method.astore(7);
        }

        @Override
        public void beginMethod(ClosureCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", cg.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", cg.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginMethod(args, scope);
            Label start = new Label();
            this.method.label(start);
            this.scopeStart = start;
        }

        public void beginClass(ClosureCallback bodyPrep, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", cg.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", cg.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClass(bodyPrep, scope);
            Label start = new Label();
            this.method.label(start);
            this.scopeStart = start;
        }

        @Override
        public void endMethod() {
            this.method.areturn();
            Label end = new Label();
            this.method.label(end);
            this.method.end();
        }

        @Override
        public void performReturn() {
            if (this.withinProtection) {
                this.loadThreadContext();
                this.invokeUtilityMethod("returnJump", cg.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
            } else {
                this.method.areturn();
            }
        }

        @Override
        public void issueBreakEvent(ClosureCallback value) {
            if (this.withinProtection) {
                value.compile(this);
                this.invokeUtilityMethod("breakJump", cg.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                value.compile(this);
                this.issueLoopBreak();
            } else {
                this.loadRuntime();
                value.compile(this);
                this.invokeUtilityMethod("breakLocalJumpError", cg.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        @Override
        public void issueNextEvent(ClosureCallback value) {
            if (this.withinProtection) {
                value.compile(this);
                this.invokeUtilityMethod("nextJump", cg.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                value.compile(this);
                this.issueLoopNext();
            } else {
                this.loadRuntime();
                value.compile(this);
                this.invokeUtilityMethod("nextLocalJumpError", cg.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        @Override
        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", cg.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.loadRuntime();
                this.invokeUtilityMethod("redoLocalJumpError", cg.sig(IRubyObject.class, Ruby.class));
            }
        }
    }

    public class ASMClosureCompiler
    extends AbstractMethodCompiler {
        private String closureMethodName;

        public ASMClosureCompiler(String closureMethodName, String closureFieldName, ASTInspector inspector) {
            this.closureMethodName = closureMethodName;
            StandardASMCompiler.this.getClassVisitor().visitField(2, closureFieldName, cg.ci(CompiledBlockCallback.class), null, null);
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, closureMethodName, CLOSURE_SIGNATURE, null, null));
            this.variableCompiler = inspector == null || inspector.hasClosure() || inspector.hasScopeAwareMethods() ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4);
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        @Override
        public void beginMethod(ClosureCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", cg.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", cg.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClosure(args, scope);
            this.scopeStart = new Label();
            this.scopeEnd = new Label();
            this.redoJump = new Label();
            this.method.label(this.scopeStart);
        }

        public void beginClass(ClosureCallback bodyPrep, StaticScope scope) {
            throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
        }

        @Override
        public void endMethod() {
            this.scopeEnd = new Label();
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, cg.p(JumpException.RedoJump.class));
            this.method.end();
        }

        @Override
        public void loadBlock() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameBlock", cg.sig(Block.class));
        }

        @Override
        protected String getNewRescueName() {
            return this.closureMethodName + "_" + super.getNewRescueName();
        }

        @Override
        protected String getNewEnsureName() {
            return this.closureMethodName + "_" + super.getNewEnsureName();
        }

        @Override
        public void performReturn() {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", cg.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void processRequiredArgs(Arity arity, int requiredArgs, int optArgs, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void assignOptionalArgs(Object object, int expectedArgsCount, int size, ArrayCallback optEval) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processRestArg(int startIndex, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processBlockArgument(int index) {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadBlock();
            this.method.ldc(new Integer(index));
            this.invokeUtilityMethod("processBlockArgument", cg.sig(Void.TYPE, cg.params(Ruby.class, ThreadContext.class, Block.class, Integer.TYPE)));
        }

        @Override
        public void issueBreakEvent(ClosureCallback value) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                value.compile(this);
                this.invokeUtilityMethod("breakJump", cg.sig(IRubyObject.class, IRubyObject.class));
            } else {
                value.compile(this);
                this.issueLoopBreak();
            }
        }

        @Override
        public void issueNextEvent(ClosureCallback value) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                value.compile(this);
                this.invokeUtilityMethod("nextJump", cg.sig(IRubyObject.class, IRubyObject.class));
            } else {
                value.compile(this);
                this.issueLoopNext();
            }
        }

        @Override
        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", cg.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.method.go_to(this.scopeStart);
            }
        }
    }

    public abstract class AbstractMethodCompiler
    implements MethodCompiler {
        protected SkinnyMethodAdapter method;
        protected VariableCompiler variableCompiler;
        protected InvocationCompiler invocationCompiler;
        protected Label[] currentLoopLabels;
        protected Label scopeStart;
        protected Label scopeEnd;
        protected Label redoJump;
        protected boolean withinProtection = false;
        protected int localVariable = 11;

        public abstract void beginMethod(ClosureCallback var1, StaticScope var2);

        @Override
        public abstract void endMethod();

        @Override
        public MethodCompiler chainToMethod(String methodName, ASTInspector inspector) {
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, cg.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
            this.endMethod();
            ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, inspector);
            methodCompiler.beginChainedMethod();
            return methodCompiler;
        }

        public StandardASMCompiler getScriptCompiler() {
            return StandardASMCompiler.this;
        }

        @Override
        public void lineNumber(ISourcePosition position) {
            Label line = new Label();
            this.method.label(line);
            this.method.visitLineNumber(position.getStartLine() + 1, line);
        }

        public void loadThreadContext() {
            this.method.aload(1);
        }

        @Override
        public void loadSelf() {
            this.method.aload(2);
        }

        public void loadRuntime() {
            this.method.aload(6);
        }

        public void loadBlock() {
            this.method.aload(4);
        }

        @Override
        public void loadNil() {
            this.method.aload(8);
        }

        @Override
        public void loadNull() {
            this.method.aconst_null();
        }

        @Override
        public void loadSymbol(String symbol) {
            this.loadRuntime();
            this.method.ldc(symbol);
            this.invokeIRuby("newSymbol", cg.sig(RubySymbol.class, cg.params(String.class)));
        }

        @Override
        public void loadObject() {
            this.loadRuntime();
            this.invokeIRuby("getObject", cg.sig(RubyClass.class, cg.params(new Class[0])));
        }

        public void invokeUtilityMethod(String methodName, String signature) {
            this.method.invokestatic(cg.p(RuntimeHelpers.class), methodName, signature);
        }

        public void invokeThreadContext(String methodName, String signature) {
            this.method.invokevirtual(THREADCONTEXT, methodName, signature);
        }

        public void invokeIRuby(String methodName, String signature) {
            this.method.invokevirtual(RUBY, methodName, signature);
        }

        public void invokeIRubyObject(String methodName, String signature) {
            this.method.invokeinterface(IRUBYOBJECT, methodName, signature);
        }

        @Override
        public void consumeCurrentValue() {
            this.method.pop();
        }

        @Override
        public void duplicateCurrentValue() {
            this.method.dup();
        }

        @Override
        public void swapValues() {
            this.method.swap();
        }

        @Override
        public void retrieveSelf() {
            this.loadSelf();
        }

        @Override
        public void retrieveSelfClass() {
            this.loadSelf();
            this.metaclass();
        }

        @Override
        public VariableCompiler getVariableCompiler() {
            return this.variableCompiler;
        }

        @Override
        public InvocationCompiler getInvocationCompiler() {
            return this.invocationCompiler;
        }

        @Override
        public void assignConstantInCurrent(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.method.dup2_x1();
            this.method.pop2();
            this.invokeThreadContext("setConstantInCurrent", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
        }

        @Override
        public void assignConstantInModule(String name) {
            this.method.ldc(name);
            this.loadThreadContext();
            this.invokeUtilityMethod("setConstantInModule", cg.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
        }

        @Override
        public void assignConstantInObject(String name) {
            this.loadRuntime();
            this.invokeIRuby("getObject", cg.sig(RubyClass.class, cg.params(new Class[0])));
            this.method.swap();
            this.assignConstantInModule(name);
        }

        @Override
        public void retrieveConstant(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstant", cg.sig(IRubyObject.class, cg.params(String.class)));
        }

        @Override
        public void retrieveConstantFromModule(String name) {
            this.method.visitTypeInsn(192, cg.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(RubyModule.class), "fastGetConstantFrom", cg.sig(IRubyObject.class, cg.params(String.class)));
        }

        @Override
        public void retrieveClassVariable(String name) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastFetchClassVariable", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
        }

        @Override
        public void assignClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastSetClassVariable", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void declareClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastDeclareClassVariable", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        @Override
        public void createNewFloat(double value) {
            this.loadRuntime();
            this.method.ldc(new Double(value));
            this.invokeIRuby("newFloat", cg.sig(RubyFloat.class, cg.params(Double.TYPE)));
        }

        @Override
        public void createNewFixnum(long value) {
            this.loadRuntime();
            this.method.ldc(new Long(value));
            this.invokeIRuby("newFixnum", cg.sig(RubyFixnum.class, cg.params(Long.TYPE)));
        }

        @Override
        public void createNewBignum(BigInteger value) {
            this.loadRuntime();
            this.method.ldc(value.toString());
            this.method.invokestatic(cg.p(RubyBignum.class), "newBignum", cg.sig(RubyBignum.class, cg.params(Ruby.class, String.class)));
        }

        @Override
        public void createNewString(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.invokeIRuby("newString", cg.sig(RubyString.class, cg.params(new Class[0])));
            for (int i = 0; i < count; ++i) {
                callback.nextValue(this, null, i);
                this.method.invokevirtual(cg.p(RubyString.class), "append", cg.sig(RubyString.class, cg.params(IRubyObject.class)));
            }
        }

        @Override
        public void createNewSymbol(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.invokeIRuby("newString", cg.sig(RubyString.class, cg.params(new Class[0])));
            for (int i = 0; i < count; ++i) {
                callback.nextValue(this, null, i);
                this.method.invokevirtual(cg.p(RubyString.class), "append", cg.sig(RubyString.class, cg.params(IRubyObject.class)));
            }
            this.toJavaString();
            this.loadRuntime();
            this.method.swap();
            this.invokeIRuby("newSymbol", cg.sig(RubySymbol.class, cg.params(String.class)));
        }

        @Override
        public void createNewString(ByteList value) {
            String fieldName = StandardASMCompiler.this.cacheByteList(value.toString());
            this.loadRuntime();
            this.method.getstatic(StandardASMCompiler.this.classname, fieldName, cg.ci(ByteList.class));
            this.invokeIRuby("newStringShared", cg.sig(RubyString.class, cg.params(ByteList.class)));
        }

        @Override
        public void createNewSymbol(String name) {
            this.method.aload(0);
            this.loadRuntime();
            String methodName = StandardASMCompiler.this.cacheSymbol(name);
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, cg.sig(RubySymbol.class, cg.params(Ruby.class)));
        }

        @Override
        public void createNewArray(boolean lightweight) {
            this.loadRuntime();
            this.method.swap();
            if (lightweight) {
                this.invokeIRuby("newArrayNoCopyLight", cg.sig(RubyArray.class, cg.params(IRubyObject[].class)));
            } else {
                this.invokeIRuby("newArrayNoCopy", cg.sig(RubyArray.class, cg.params(IRubyObject[].class)));
            }
        }

        @Override
        public void createEmptyArray() {
            this.loadRuntime();
            this.invokeIRuby("newArray", cg.sig(RubyArray.class, cg.params(new Class[0])));
        }

        @Override
        public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
            this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
        }

        @Override
        public void createObjectArray(int elementCount) {
            if (elementCount >= 6) {
                throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
            }
            Object[] params = new Class[elementCount];
            Arrays.fill(params, IRubyObject.class);
            this.invokeUtilityMethod("constructObjectArray", cg.sig(IRubyObject[].class, (Class[])params));
        }

        private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
            if (sourceArray.length == 0) {
                this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
            } else if (sourceArray.length < 5) {
                for (int i = 0; i < sourceArray.length; ++i) {
                    callback.nextValue(this, sourceArray, i);
                }
                this.invokeUtilityMethod("constructObjectArray", cg.sig(IRubyObject[].class, cg.params(IRubyObject.class, sourceArray.length)));
            } else {
                this.method.ldc(new Integer(sourceArray.length));
                this.method.anewarray(type);
                for (int i = 0; i < sourceArray.length; ++i) {
                    this.method.dup();
                    this.method.ldc(new Integer(i));
                    callback.nextValue(this, sourceArray, i);
                    this.method.arraystore();
                }
            }
        }

        @Override
        public void createEmptyHash() {
            this.loadRuntime();
            this.method.invokestatic(cg.p(RubyHash.class), "newHash", cg.sig(RubyHash.class, cg.params(Ruby.class)));
        }

        @Override
        public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
            this.loadRuntime();
            if (keyCount < 3) {
                for (int i = 0; i < keyCount; ++i) {
                    callback.nextValue(this, elements, i);
                }
                this.invokeUtilityMethod("constructHash", cg.sig(RubyHash.class, cg.params(Ruby.class, IRubyObject.class, keyCount * 2)));
            } else {
                this.method.newobj(cg.p(HashMap.class));
                this.method.dup();
                this.method.invokespecial(cg.p(HashMap.class), "<init>", cg.sig(Void.TYPE));
                for (int i = 0; i < keyCount; ++i) {
                    this.method.dup();
                    callback.nextValue(this, elements, i);
                    this.method.invokevirtual(cg.p(HashMap.class), "put", cg.sig(Object.class, cg.params(Object.class, Object.class)));
                    this.method.pop();
                }
                this.loadNil();
                this.method.invokestatic(cg.p(RubyHash.class), "newHash", cg.sig(RubyHash.class, cg.params(Ruby.class, Map.class, IRubyObject.class)));
            }
        }

        @Override
        public void createNewRange(boolean isExclusive) {
            this.loadRuntime();
            this.method.dup_x2();
            this.method.pop();
            this.method.ldc(new Boolean(isExclusive));
            this.method.invokestatic(cg.p(RubyRange.class), "newRange", cg.sig(RubyRange.class, cg.params(Ruby.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE)));
        }

        private void isTrue() {
            this.invokeIRubyObject("isTrue", cg.sig(Boolean.TYPE));
        }

        @Override
        public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label afterJmp = new Label();
            Label falseJmp = new Label();
            this.isTrue();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        @Override
        public void performLogicalAnd(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifeq(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        @Override
        public void performLogicalOr(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifne(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        @Override
        public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
            Label tryBegin = new Label();
            Label tryEnd = new Label();
            Label catchRedo = new Label();
            Label catchNext = new Label();
            Label catchBreak = new Label();
            Label catchRaised = new Label();
            Label endOfBody = new Label();
            Label conditionCheck = new Label();
            Label topOfBody = new Label();
            Label done = new Label();
            Label normalLoopEnd = new Label();
            this.method.trycatch(tryBegin, tryEnd, catchRedo, cg.p(JumpException.RedoJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchNext, cg.p(JumpException.NextJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchBreak, cg.p(JumpException.BreakJump.class));
            if (checkFirst) {
                this.method.trycatch(tryBegin, tryEnd, catchRaised, cg.p(RaiseException.class));
            }
            this.method.label(tryBegin);
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
            if (checkFirst) {
                this.method.go_to(conditionCheck);
            }
            this.method.label(topOfBody);
            body.branch(this);
            this.method.label(endOfBody);
            this.method.pop();
            this.method.label(conditionCheck);
            condition.branch(this);
            this.isTrue();
            this.method.ifne(topOfBody);
            this.currentLoopLabels = oldLoopLabels;
            this.method.label(tryEnd);
            this.method.go_to(normalLoopEnd);
            this.method.label(catchRedo);
            this.method.pop();
            this.method.go_to(topOfBody);
            this.method.label(catchNext);
            this.method.pop();
            this.method.go_to(conditionCheck);
            this.method.label(catchBreak);
            this.loadBlock();
            this.invokeUtilityMethod("breakJumpInWhile", cg.sig(IRubyObject.class, JumpException.BreakJump.class, Block.class));
            this.method.go_to(done);
            if (checkFirst) {
                this.method.label(catchRaised);
                Label raiseNext = new Label();
                Label raiseRedo = new Label();
                Label raiseRethrow = new Label();
                this.method.dup();
                this.invokeUtilityMethod("getLocalJumpTypeOrRethrow", cg.sig(String.class, cg.params(RaiseException.class)));
                this.method.dup();
                this.method.ldc("break");
                this.method.invokevirtual(cg.p(String.class), "equals", cg.sig(Boolean.TYPE, cg.params(Object.class)));
                this.method.ifeq(raiseNext);
                this.method.pop();
                this.invokeUtilityMethod("unwrapLocalJumpErrorValue", cg.sig(IRubyObject.class, cg.params(RaiseException.class)));
                this.method.go_to(done);
                this.method.label(raiseNext);
                this.method.dup();
                this.method.ldc("next");
                this.method.invokevirtual(cg.p(String.class), "equals", cg.sig(Boolean.TYPE, cg.params(Object.class)));
                this.method.ifeq(raiseRedo);
                this.method.pop2();
                this.method.go_to(conditionCheck);
                this.method.label(raiseRedo);
                this.method.dup();
                this.method.ldc("redo");
                this.method.invokevirtual(cg.p(String.class), "equals", cg.sig(Boolean.TYPE, cg.params(Object.class)));
                this.method.ifeq(raiseRethrow);
                this.method.pop2();
                this.method.go_to(topOfBody);
                this.method.label(raiseRethrow);
                this.method.pop();
                this.method.athrow();
            }
            this.method.label(normalLoopEnd);
            this.loadNil();
            this.method.label(done);
        }

        @Override
        public void createNewClosure(StaticScope scope, int arity, ClosureCallback body, ClosureCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
            String closureMethodName = "closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, inspector);
            closureCompiler.beginMethod(args, scope);
            body.compile(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(cg.p(CallbackFactory.class), "getBlockCallback", cg.sig(CompiledBlockCallback.class, cg.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(arity));
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.ldc(hasMultipleArgsHead);
            this.method.ldc(Block.asArgumentType(argsNodeId));
            this.method.ldc(!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
            this.invokeUtilityMethod("createBlock", cg.sig(CompiledBlock.class, cg.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, String[].class, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE)));
        }

        @Override
        public void runBeginBlock(StaticScope scope, ClosureCallback body) {
            String closureMethodName = "closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(null, scope);
            body.compile(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(cg.p(CallbackFactory.class), "getBlockCallback", cg.sig(CompiledBlockCallback.class, cg.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.invokeUtilityMethod("runBeginBlock", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
        }

        @Override
        public void createNewForLoop(int arity, ClosureCallback body, ClosureCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId) {
            String closureMethodName = "closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(args, null);
            body.compile(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(cg.p(CallbackFactory.class), "getBlockCallback", cg.sig(CompiledBlockCallback.class, cg.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(arity));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.ldc(hasMultipleArgsHead);
            this.method.ldc(Block.asArgumentType(argsNodeId));
            this.invokeUtilityMethod("createSharedScopeBlock", cg.sig(CompiledSharedScopeBlock.class, cg.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        }

        @Override
        public void createNewEndBlock(ClosureCallback body) {
            String closureMethodName = "END_closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(null, null);
            body.compile(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(cg.p(CallbackFactory.class), "getBlockCallback", cg.sig(CompiledBlockCallback.class, cg.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(0));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, cg.ci(CompiledBlockCallback.class));
            this.method.ldc(false);
            this.method.ldc(0);
            this.invokeUtilityMethod("createSharedScopeBlock", cg.sig(CompiledSharedScopeBlock.class, cg.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
            this.loadRuntime();
            this.invokeUtilityMethod("registerEndBlock", cg.sig(Void.TYPE, CompiledSharedScopeBlock.class, Ruby.class));
            this.loadNil();
        }

        private void getCallbackFactory() {
            this.loadRuntime();
            this.getCompiledClass();
            this.method.dup();
            this.method.invokevirtual(cg.p(Class.class), "getClassLoader", cg.sig(ClassLoader.class));
            this.method.invokestatic(cg.p(CallbackFactory.class), "createFactory", cg.sig(CallbackFactory.class, cg.params(Ruby.class, Class.class, ClassLoader.class)));
        }

        public void getCompiledClass() {
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, "$class", cg.ci(Class.class));
        }

        private void getRubyClass() {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", cg.sig(RubyModule.class));
        }

        public void println() {
            this.method.dup();
            this.method.getstatic(cg.p(System.class), "out", cg.ci(PrintStream.class));
            this.method.swap();
            this.method.invokevirtual(cg.p(PrintStream.class), "println", cg.sig(Void.TYPE, cg.params(Object.class)));
        }

        @Override
        public void defineAlias(String newName, String oldName) {
            this.loadThreadContext();
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.invokeUtilityMethod("defineAlias", cg.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
        }

        @Override
        public void loadFalse() {
            this.loadRuntime();
            this.invokeIRuby("getFalse", cg.sig(RubyBoolean.class));
        }

        @Override
        public void loadTrue() {
            this.loadRuntime();
            this.invokeIRuby("getTrue", cg.sig(RubyBoolean.class));
        }

        @Override
        public void loadCurrentModule() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentScope", cg.sig(DynamicScope.class));
            this.method.invokevirtual(cg.p(DynamicScope.class), "getStaticScope", cg.sig(StaticScope.class));
            this.method.invokevirtual(cg.p(StaticScope.class), "getModule", cg.sig(RubyModule.class));
        }

        @Override
        public void retrieveInstanceVariable(String name) {
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastGetInstanceVariable", cg.sig(IRubyObject.class, Ruby.class, IRubyObject.class, String.class));
        }

        @Override
        public void assignInstanceVariable(String name) {
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeIRubyObject("fastSetInstanceVariable", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
        }

        @Override
        public void retrieveGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(GlobalVariables.class), "get", cg.sig(IRubyObject.class, cg.params(String.class)));
        }

        @Override
        public void assignGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.method.invokevirtual(cg.p(GlobalVariables.class), "set", cg.sig(IRubyObject.class, cg.params(String.class, IRubyObject.class)));
        }

        @Override
        public void negateCurrentValue() {
            this.loadRuntime();
            this.invokeUtilityMethod("negate", cg.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
        }

        @Override
        public void splatCurrentValue() {
            this.loadRuntime();
            this.method.invokestatic(cg.p(ASTInterpreter.class), "splatValue", cg.sig(RubyArray.class, cg.params(IRubyObject.class, Ruby.class)));
        }

        @Override
        public void singlifySplattedValue() {
            this.loadRuntime();
            this.method.invokestatic(cg.p(ASTInterpreter.class), "aValueSplat", cg.sig(IRubyObject.class, cg.params(IRubyObject.class, Ruby.class)));
        }

        @Override
        public void aryToAry() {
            this.loadRuntime();
            this.method.invokestatic(cg.p(ASTInterpreter.class), "aryToAry", cg.sig(IRubyObject.class, cg.params(IRubyObject.class, Ruby.class)));
        }

        @Override
        public void ensureRubyArray() {
            this.invokeUtilityMethod("ensureRubyArray", cg.sig(RubyArray.class, cg.params(IRubyObject.class)));
        }

        @Override
        public void ensureMultipleAssignableRubyArray(boolean masgnHasHead) {
            this.loadRuntime();
            this.method.swap();
            this.method.ldc(new Boolean(masgnHasHead));
            this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", cg.sig(RubyArray.class, cg.params(Ruby.class, IRubyObject.class, Boolean.TYPE)));
        }

        @Override
        public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback, ArrayCallback nilCallback, ClosureCallback argsCallback) {
            while (start < count) {
                Label noMoreArrayElements = new Label();
                Label doneWithElement = new Label();
                this.method.dup();
                this.method.invokevirtual(cg.p(RubyArray.class), "getLength", cg.sig(Integer.TYPE));
                this.method.ldc(new Integer(start));
                this.method.if_icmple(noMoreArrayElements);
                this.method.dup();
                this.method.ldc(new Integer(start));
                this.method.invokevirtual(cg.p(RubyArray.class), "entry", cg.sig(IRubyObject.class, cg.params(Integer.TYPE)));
                callback.nextValue(this, source, start);
                this.method.go_to(doneWithElement);
                this.method.label(noMoreArrayElements);
                nilCallback.nextValue(this, source, start);
                this.method.label(doneWithElement);
                this.method.pop();
                ++start;
            }
            if (argsCallback != null) {
                Label emptyArray = new Label();
                Label readyForArgs = new Label();
                this.method.dup();
                this.method.invokevirtual(cg.p(RubyArray.class), "getLength", cg.sig(Integer.TYPE));
                this.method.ldc(new Integer(start));
                this.method.if_icmple(emptyArray);
                this.method.dup();
                this.method.ldc(start);
                this.invokeUtilityMethod("createSubarray", cg.sig(RubyArray.class, RubyArray.class, Integer.TYPE));
                this.method.go_to(readyForArgs);
                this.method.label(emptyArray);
                this.createEmptyArray();
                this.method.label(readyForArgs);
                argsCallback.compile(this);
                this.method.pop();
            }
        }

        @Override
        public void asString() {
            this.method.invokeinterface(cg.p(IRubyObject.class), "asString", cg.sig(RubyString.class, cg.params(new Class[0])));
        }

        @Override
        public void toJavaString() {
            this.method.invokevirtual(cg.p(Object.class), "toString", cg.sig(String.class));
        }

        @Override
        public void nthRef(int match) {
            this.method.ldc(new Integer(match));
            this.backref();
            this.method.invokestatic(cg.p(RubyRegexp.class), "nth_match", cg.sig(IRubyObject.class, cg.params(Integer.TYPE, IRubyObject.class)));
        }

        @Override
        public void match() {
            this.method.invokevirtual(cg.p(RubyRegexp.class), "op_match2", cg.sig(IRubyObject.class, cg.params(new Class[0])));
        }

        @Override
        public void match2() {
            this.method.invokevirtual(cg.p(RubyRegexp.class), "op_match", cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
        }

        @Override
        public void match3() {
            this.loadThreadContext();
            this.invokeUtilityMethod("match3", cg.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
        }

        @Override
        public void createNewRegexp(ByteList value, int options, String lang) {
            String regexpField = StandardASMCompiler.this.getNewConstant(cg.ci(RubyRegexp.class), "lit_reg_");
            String patternField = StandardASMCompiler.this.getNewConstant(cg.ci(RegexpPattern.class), "lit_pat_");
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, cg.ci(RubyRegexp.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.loadRuntime();
            String regexpString = null;
            regexpString = (options & 0x40) > 0 ? value.toUtf8String() : value.toString();
            this.loadRuntime();
            this.method.ldc(regexpString);
            this.method.ldc(new Integer(options));
            this.invokeUtilityMethod("regexpLiteral", cg.sig(RegexpPattern.class, cg.params(Ruby.class, String.class, Integer.TYPE)));
            this.method.dup();
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, patternField, cg.ci(RegexpPattern.class));
            if (null == lang) {
                this.method.aconst_null();
            } else {
                this.method.ldc(lang);
            }
            this.method.invokestatic(cg.p(RubyRegexp.class), "newRegexp", cg.sig(RubyRegexp.class, cg.params(Ruby.class, RegexpPattern.class, String.class)));
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, regexpField, cg.ci(RubyRegexp.class));
            this.method.label(alreadyCreated);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, cg.ci(RubyRegexp.class));
        }

        @Override
        public void createNewRegexp(ClosureCallback createStringCallback, int options, String lang) {
            this.loadRuntime();
            this.loadRuntime();
            createStringCallback.compile(this);
            this.method.ldc(new Integer(options));
            this.invokeUtilityMethod("regexpLiteral", cg.sig(RegexpPattern.class, cg.params(Ruby.class, String.class, Integer.TYPE)));
            if (null == lang) {
                this.method.aconst_null();
            } else {
                this.method.ldc(lang);
            }
            this.method.invokestatic(cg.p(RubyRegexp.class), "newRegexp", cg.sig(RubyRegexp.class, cg.params(Ruby.class, RegexpPattern.class, String.class)));
        }

        @Override
        public void pollThreadEvents() {
            this.loadThreadContext();
            this.invokeThreadContext("pollThreadEvents", cg.sig(Void.TYPE));
        }

        @Override
        public void nullToNil() {
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.method.aload(8);
            this.method.label(notNull);
        }

        @Override
        public void isInstanceOf(Class clazz, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.instance_of(cg.p(clazz));
            Label falseJmp = new Label();
            Label afterJmp = new Label();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        @Override
        public void isCaptured(final int number, final BranchCallback trueBranch, final BranchCallback falseBranch) {
            this.backref();
            this.method.dup();
            this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, cg.p(RubyMatchData.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.invokevirtual(cg.p(RubyMatchData.class), "use", cg.sig(Void.TYPE));
                    AbstractMethodCompiler.this.method.ldc(new Long(number));
                    AbstractMethodCompiler.this.method.invokevirtual(cg.p(RubyMatchData.class), "group", cg.sig(IRubyObject.class, cg.params(Long.TYPE)));
                    AbstractMethodCompiler.this.method.invokeinterface(cg.p(IRubyObject.class), "isNil", cg.sig(Boolean.TYPE));
                    Label isNil = new Label();
                    Label after = new Label();
                    AbstractMethodCompiler.this.method.ifne(isNil);
                    trueBranch.branch(context);
                    AbstractMethodCompiler.this.method.go_to(after);
                    AbstractMethodCompiler.this.method.label(isNil);
                    falseBranch.branch(context);
                    AbstractMethodCompiler.this.method.label(after);
                }
            }, new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.pop();
                    falseBranch.branch(context);
                }
            });
        }

        @Override
        public void branchIfModule(ClosureCallback receiverCallback, BranchCallback moduleCallback, BranchCallback notModuleCallback) {
            receiverCallback.compile(this);
            this.isInstanceOf(RubyModule.class, moduleCallback, notModuleCallback);
        }

        @Override
        public void backref() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentFrame", cg.sig(Frame.class));
            this.method.invokevirtual(cg.p(Frame.class), "getBackRef", cg.sig(IRubyObject.class));
        }

        @Override
        public void backrefMethod(String methodName) {
            this.backref();
            this.method.invokestatic(cg.p(RubyRegexp.class), methodName, cg.sig(IRubyObject.class, cg.params(IRubyObject.class)));
        }

        public void issueLoopBreak() {
            this.method.go_to(this.currentLoopLabels[2]);
        }

        public void issueLoopNext() {
            this.method.go_to(this.currentLoopLabels[0]);
        }

        public void issueLoopRedo() {
            this.method.go_to(this.currentLoopLabels[1]);
        }

        protected String getNewEnsureName() {
            return "__ensure_" + StandardASMCompiler.this.ensureNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void protect(BranchCallback regularCode, BranchCallback protectedCode, Class ret) {
            String mname = this.getNewEnsureName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, cg.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                mv.dup();
                mv.astore(6);
                mv.invokevirtual(cg.p(Ruby.class), "getNil", cg.sig(IRubyObject.class));
                mv.astore(8);
                mv.invokevirtual(cg.p(ThreadContext.class), "getCurrentScope", cg.sig(DynamicScope.class));
                mv.dup();
                mv.astore(5);
                mv.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
                mv.astore(7);
                Label codeBegin = new Label();
                Label codeEnd = new Label();
                Label ensureBegin = new Label();
                Label ensureEnd = new Label();
                this.method.label(codeBegin);
                regularCode.branch(this);
                this.method.label(codeEnd);
                protectedCode.branch(this);
                mv.areturn();
                this.method.label(ensureBegin);
                this.method.astore(9);
                this.method.label(ensureEnd);
                protectedCode.branch(this);
                this.method.aload(9);
                this.method.athrow();
                this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
                this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.withinProtection = oldWithinProtection;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, cg.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        protected String getNewRescueName() {
            return "__rescue_" + StandardASMCompiler.this.rescueNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rescue(BranchCallback regularCode, Class exception, BranchCallback catchCode, Class ret) {
            String mname = this.getNewRescueName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, cg.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            Label afterMethodBody = new Label();
            Label catchRetry = new Label();
            Label catchRaised = new Label();
            Label catchJumps = new Label();
            Label exitRescue = new Label();
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(cg.p(ThreadContext.class), "getRuntime", cg.sig(Ruby.class));
                mv.dup();
                mv.astore(6);
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", cg.sig(IRubyObject.class, Ruby.class));
                mv.astore(10);
                mv.invokevirtual(cg.p(Ruby.class), "getNil", cg.sig(IRubyObject.class));
                mv.astore(8);
                mv.invokevirtual(cg.p(ThreadContext.class), "getCurrentScope", cg.sig(DynamicScope.class));
                mv.dup();
                mv.astore(5);
                mv.invokevirtual(cg.p(DynamicScope.class), "getValues", cg.sig(IRubyObject[].class));
                mv.astore(7);
                Label beforeBody = new Label();
                Label afterBody = new Label();
                Label catchBlock = new Label();
                mv.visitTryCatchBlock(beforeBody, afterBody, catchBlock, cg.p(exception));
                mv.visitLabel(beforeBody);
                regularCode.branch(this);
                mv.label(afterBody);
                mv.go_to(exitRescue);
                mv.label(catchBlock);
                mv.astore(9);
                catchCode.branch(this);
                mv.label(afterMethodBody);
                mv.go_to(exitRescue);
                mv.trycatch(beforeBody, afterMethodBody, catchRetry, cg.p(JumpException.RetryJump.class));
                mv.label(catchRetry);
                mv.pop();
                mv.go_to(beforeBody);
                mv.trycatch(beforeBody, afterMethodBody, catchRaised, cg.p(RaiseException.class));
                mv.label(catchRaised);
                mv.athrow();
                mv.trycatch(beforeBody, afterMethodBody, catchJumps, cg.p(JumpException.class));
                mv.label(catchJumps);
                this.loadRuntime();
                mv.aload(10);
                this.invokeUtilityMethod("setErrorInfo", cg.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(exitRescue);
                this.loadRuntime();
                mv.aload(10);
                this.invokeUtilityMethod("setErrorInfo", cg.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.areturn();
                mv.visitMaxs(1, 1);
                mv.visitEnd();
            }
            finally {
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, cg.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        @Override
        public void inDefined() {
            this.method.aload(1);
            this.method.iconst_1();
            this.invokeThreadContext("setWithinDefined", cg.sig(Void.TYPE, cg.params(Boolean.TYPE)));
        }

        @Override
        public void outDefined() {
            this.method.aload(1);
            this.method.iconst_0();
            this.invokeThreadContext("setWithinDefined", cg.sig(Void.TYPE, cg.params(Boolean.TYPE)));
        }

        @Override
        public void stringOrNil() {
            this.loadRuntime();
            this.loadNil();
            this.invokeUtilityMethod("stringOrNil", cg.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
        }

        @Override
        public void pushNull() {
            this.method.aconst_null();
        }

        @Override
        public void pushString(String str) {
            this.method.ldc(str);
        }

        @Override
        public void isMethodBound(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.metaclass();
            this.method.ldc(name);
            this.method.iconst_0();
            this.method.invokevirtual(cg.p(RubyClass.class), "isMethodBound", cg.sig(Boolean.TYPE, cg.params(String.class, Boolean.TYPE)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void hasBlock(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadBlock();
            this.method.invokevirtual(cg.p(Block.class), "isGiven", cg.sig(Boolean.TYPE));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isGlobalDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(GlobalVariables.class), "isDefined", cg.sig(Boolean.TYPE, cg.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isConstantDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstantDefined", cg.sig(Boolean.TYPE, cg.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isInstanceVariableDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadSelf();
            this.method.ldc(name);
            this.method.invokeinterface(cg.p(IRubyObject.class), "fastHasInstanceVariable", cg.sig(Boolean.TYPE, cg.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isClassVarDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(RubyModule.class), "fastIsClassVarDefined", cg.sig(Boolean.TYPE, cg.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public Object getNewEnding() {
            return new Label();
        }

        @Override
        public void isNil(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.invokeinterface(cg.p(IRubyObject.class), "isNil", cg.sig(Boolean.TYPE));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void isNull(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifnonnull(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        @Override
        public void ifNull(Object gotoToken) {
            this.method.ifnull((Label)gotoToken);
        }

        @Override
        public void ifNotNull(Object gotoToken) {
            this.method.ifnonnull((Label)gotoToken);
        }

        @Override
        public void setEnding(Object endingToken) {
            this.method.label((Label)endingToken);
        }

        @Override
        public void go(Object gotoToken) {
            this.method.go_to((Label)gotoToken);
        }

        @Override
        public void isConstantBranch(final BranchCallback setup, final BranchCallback isConstant, final BranchCallback isMethod, final BranchCallback none, final String name) {
            this.rescue(new BranchCallback(){

                @Override
                public void branch(MethodCompiler context) {
                    setup.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.instance_of(cg.p(RubyModule.class));
                    Label falseJmp = new Label();
                    Label afterJmp = new Label();
                    Label nextJmp = new Label();
                    Label nextJmpPop = new Label();
                    AbstractMethodCompiler.this.method.ifeq(nextJmp);
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, cg.p(RubyModule.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.invokevirtual(cg.p(RubyModule.class), "fastGetConstantAt", cg.sig(IRubyObject.class, cg.params(String.class)));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ifnull(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.pop();
                    isConstant.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.label(nextJmp);
                    AbstractMethodCompiler.this.metaclass();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.iconst_1();
                    AbstractMethodCompiler.this.method.invokevirtual(cg.p(RubyClass.class), "isMethodBound", cg.sig(Boolean.TYPE, cg.params(String.class, Boolean.TYPE)));
                    AbstractMethodCompiler.this.method.ifeq(falseJmp);
                    isMethod.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(falseJmp);
                    none.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.label(afterJmp);
                }
            }, JumpException.class, none, String.class);
        }

        @Override
        public void metaclass() {
            this.invokeIRubyObject("getMetaClass", cg.sig(RubyClass.class));
        }

        @Override
        public void getVisibilityFor(String name) {
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(RubyClass.class), "searchMethod", cg.sig(DynamicMethod.class, cg.params(String.class)));
            this.method.invokevirtual(cg.p(DynamicMethod.class), "getVisibility", cg.sig(Visibility.class));
        }

        @Override
        public void isPrivate(Object gotoToken, int toConsume) {
            this.method.invokevirtual(cg.p(Visibility.class), "isPrivate", cg.sig(Boolean.TYPE));
            Label temp = new Label();
            this.method.ifeq(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        @Override
        public void isNotProtected(Object gotoToken, int toConsume) {
            this.method.invokevirtual(cg.p(Visibility.class), "isProtected", cg.sig(Boolean.TYPE));
            Label temp = new Label();
            this.method.ifne(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        @Override
        public void selfIsKindOf(Object gotoToken) {
            this.loadSelf();
            this.method.swap();
            this.method.invokevirtual(cg.p(RubyClass.class), "getRealClass", cg.sig(RubyClass.class));
            this.method.invokeinterface(cg.p(IRubyObject.class), "isKindOf", cg.sig(Boolean.TYPE, cg.params(RubyModule.class)));
            this.method.ifne((Label)gotoToken);
        }

        @Override
        public void notIsModuleAndClassVarDefined(String name, Object gotoToken) {
            this.method.dup();
            this.method.instance_of(cg.p(RubyModule.class));
            Label falsePopJmp = new Label();
            Label successJmp = new Label();
            this.method.ifeq(falsePopJmp);
            this.method.visitTypeInsn(192, cg.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(RubyModule.class), "fastIsClassVarDefined", cg.sig(Boolean.TYPE, cg.params(String.class)));
            this.method.ifeq((Label)gotoToken);
            this.method.go_to(successJmp);
            this.method.label(falsePopJmp);
            this.method.pop();
            this.method.go_to((Label)gotoToken);
            this.method.label(successJmp);
        }

        @Override
        public void ifSingleton(Object gotoToken) {
            this.method.invokevirtual(cg.p(RubyModule.class), "isSingleton", cg.sig(Boolean.TYPE));
            this.method.ifne((Label)gotoToken);
        }

        @Override
        public void getInstanceVariable(String name) {
            this.method.ldc(name);
            this.method.invokeinterface(cg.p(IRubyObject.class), "fastGetInstanceVariable", cg.sig(IRubyObject.class, cg.params(String.class)));
        }

        @Override
        public void getFrameName() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameName", cg.sig(String.class));
        }

        @Override
        public void getFrameKlazz() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameKlazz", cg.sig(RubyModule.class));
        }

        @Override
        public void superClass() {
            this.method.invokevirtual(cg.p(RubyModule.class), "getSuperClass", cg.sig(RubyClass.class));
        }

        @Override
        public void attached() {
            this.method.visitTypeInsn(192, cg.p(MetaClass.class));
            this.method.invokevirtual(cg.p(MetaClass.class), "getAttached", cg.sig(IRubyObject.class));
        }

        @Override
        public void ifNotSuperMethodBound(Object token) {
            this.method.swap();
            this.method.iconst_0();
            this.method.invokevirtual(cg.p(RubyModule.class), "isMethodBound", cg.sig(Boolean.TYPE, cg.params(String.class, Boolean.TYPE)));
            this.method.ifeq((Label)token);
        }

        @Override
        public void concatArrays() {
            this.method.invokevirtual(cg.p(RubyArray.class), "concat", cg.sig(RubyArray.class, cg.params(IRubyObject.class)));
        }

        public void concatObjectArrays() {
            this.invokeUtilityMethod("concatObjectArrays", cg.sig(IRubyObject[].class, cg.params(IRubyObject[].class, IRubyObject[].class)));
        }

        @Override
        public void appendToArray() {
            this.method.invokevirtual(cg.p(RubyArray.class), "append", cg.sig(RubyArray.class, cg.params(IRubyObject.class)));
        }

        @Override
        public void appendToObjectArray() {
            this.invokeUtilityMethod("appendToObjectArray", cg.sig(IRubyObject[].class, cg.params(IRubyObject[].class, IRubyObject.class)));
        }

        @Override
        public void convertToJavaArray() {
            this.method.invokestatic(cg.p(ArgsUtil.class), "convertToJavaArray", cg.sig(IRubyObject[].class, cg.params(IRubyObject.class)));
        }

        @Override
        public void aliasGlobal(String newName, String oldName) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", cg.sig(GlobalVariables.class));
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.method.invokevirtual(cg.p(GlobalVariables.class), "alias", cg.sig(Void.TYPE, cg.params(String.class, String.class)));
            this.loadNil();
        }

        @Override
        public void undefMethod(String name) {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", cg.sig(RubyModule.class));
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.loadRuntime();
            this.method.ldc("No class to undef method '" + name + "'.");
            this.invokeIRuby("newTypeError", cg.sig(RaiseException.class, cg.params(String.class)));
            this.method.athrow();
            this.method.label(notNull);
            this.method.ldc(name);
            this.method.invokevirtual(cg.p(RubyModule.class), "undef", cg.sig(Void.TYPE, cg.params(String.class)));
            this.loadNil();
        }

        @Override
        public void defineClass(final String name, final StaticScope staticScope, final ClosureCallback superCallback, final ClosureCallback pathCallback, ClosureCallback bodyCallback, final ClosureCallback receiverCallback) {
            String methodName = "rubyclass__" + cg.cleanJavaIdentifier(name) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null);
            ClosureCallback bodyPrep = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    if (receiverCallback == null) {
                        if (superCallback != null) {
                            methodCompiler.loadRuntime();
                            superCallback.compile(methodCompiler);
                            methodCompiler.invokeUtilityMethod("prepareSuperClass", cg.sig(RubyClass.class, cg.params(Ruby.class, IRubyObject.class)));
                        } else {
                            methodCompiler.method.aconst_null();
                        }
                        methodCompiler.loadThreadContext();
                        pathCallback.compile(methodCompiler);
                        methodCompiler.invokeUtilityMethod("prepareClassNamespace", cg.sig(RubyModule.class, cg.params(ThreadContext.class, IRubyObject.class)));
                        methodCompiler.method.swap();
                        methodCompiler.method.ldc(name);
                        methodCompiler.method.swap();
                        methodCompiler.method.invokevirtual(cg.p(RubyModule.class), "defineOrGetClassUnder", cg.sig(RubyClass.class, cg.params(String.class, RubyClass.class)));
                    } else {
                        methodCompiler.loadRuntime();
                        receiverCallback.compile(methodCompiler);
                        methodCompiler.invokeUtilityMethod("getSingletonClass", cg.sig(RubyClass.class, cg.params(Ruby.class, IRubyObject.class)));
                    }
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", cg.sig(Void.TYPE, cg.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.compile(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params(new Class[0])));
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
            this.method.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURE);
        }

        @Override
        public void defineModule(final String name, final StaticScope staticScope, final ClosureCallback pathCallback, ClosureCallback bodyCallback) {
            String methodName = "rubyclass__" + cg.cleanJavaIdentifier(name) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null);
            ClosureCallback bodyPrep = new ClosureCallback(){

                @Override
                public void compile(MethodCompiler context) {
                    methodCompiler.loadThreadContext();
                    pathCallback.compile(methodCompiler);
                    methodCompiler.invokeUtilityMethod("prepareClassNamespace", cg.sig(RubyModule.class, cg.params(ThreadContext.class, IRubyObject.class)));
                    methodCompiler.method.ldc(name);
                    methodCompiler.method.invokevirtual(cg.p(RubyModule.class), "defineOrGetModuleUnder", cg.sig(RubyModule.class, cg.params(String.class)));
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", cg.sig(Void.TYPE, cg.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.compile(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", cg.sig(Void.TYPE, cg.params(new Class[0])));
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(cg.p(IRubyObject.class), "NULL_ARRAY", cg.ci(IRubyObject[].class));
            this.method.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURE);
        }

        @Override
        public void unwrapPassedBlock() {
            this.loadBlock();
            this.invokeUtilityMethod("getBlockFromBlockPassBody", cg.sig(Block.class, cg.params(IRubyObject.class, Block.class)));
        }

        @Override
        public void performBackref(char type) {
            this.loadThreadContext();
            switch (type) {
                case '~': {
                    this.invokeUtilityMethod("backref", cg.sig(IRubyObject.class, cg.params(ThreadContext.class)));
                    break;
                }
                case '&': {
                    this.invokeUtilityMethod("backrefLastMatch", cg.sig(IRubyObject.class, cg.params(ThreadContext.class)));
                    break;
                }
                case '`': {
                    this.invokeUtilityMethod("backrefMatchPre", cg.sig(IRubyObject.class, cg.params(ThreadContext.class)));
                    break;
                }
                case '\'': {
                    this.invokeUtilityMethod("backrefMatchPost", cg.sig(IRubyObject.class, cg.params(ThreadContext.class)));
                    break;
                }
                case '+': {
                    this.invokeUtilityMethod("backrefMatchLast", cg.sig(IRubyObject.class, cg.params(ThreadContext.class)));
                    break;
                }
                default: {
                    throw new NotCompilableException("ERROR: backref with invalid type");
                }
            }
        }

        @Override
        public void callZSuper(ClosureCallback closure) {
            this.loadRuntime();
            this.loadThreadContext();
            if (closure != null) {
                closure.compile(this);
            } else {
                this.method.getstatic(cg.p(Block.class), "NULL_BLOCK", cg.ci(Block.class));
            }
            this.loadSelf();
            this.invokeUtilityMethod("callZSuper", cg.sig(IRubyObject.class, cg.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
        }

        @Override
        public void checkIsExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isExceptionHandled", cg.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        @Override
        public void rethrowException() {
            this.loadException();
            this.method.athrow();
        }

        @Override
        public void loadClass(String name) {
            this.loadRuntime();
            this.method.ldc(name);
            this.invokeIRuby("getClass", cg.sig(RubyClass.class, String.class));
        }

        @Override
        public void unwrapRaiseException() {
            this.method.invokevirtual(cg.p(RaiseException.class), "getException", cg.sig(RubyException.class));
        }

        @Override
        public void loadException() {
            this.method.aload(9);
        }

        @Override
        public void setPosition(ISourcePosition position) {
            this.loadThreadContext();
            this.method.getstatic(StandardASMCompiler.this.classname, StandardASMCompiler.this.cachePosition(position.getFile(), position.getEndLine()), cg.ci(ISourcePosition.class));
            this.invokeThreadContext("setPosition", cg.sig(Void.TYPE, ISourcePosition.class));
        }

        @Override
        public void checkWhenWithSplat() {
            this.loadThreadContext();
            this.invokeUtilityMethod("isWhenTriggered", cg.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        @Override
        public void issueRetryEvent() {
            this.invokeUtilityMethod("retryJump", cg.sig(IRubyObject.class));
        }

        @Override
        public void defineNewMethod(String name, StaticScope scope, ClosureCallback body, ClosureCallback args, ClosureCallback receiver, ASTInspector inspector) {
            ++StandardASMCompiler.this.methodIndex;
            String methodName = cg.cleanJavaIdentifier(name) + "__" + StandardASMCompiler.this.methodIndex;
            MethodCompiler methodCompiler = StandardASMCompiler.this.startMethod(methodName, args, scope, inspector);
            body.compile(methodCompiler);
            methodCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            if (receiver != null) {
                receiver.compile(this);
            }
            this.method.aload(0);
            this.method.ldc(name);
            this.method.ldc(methodName);
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.ldc(scope.getArity().getValue());
            this.method.ldc(scope.getRequiredArgs());
            this.method.ldc(scope.getOptionalArgs());
            this.method.ldc(scope.getRestArg());
            if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                this.method.getstatic(cg.p(CallConfiguration.class), "RUBY_FULL", cg.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(cg.p(CallConfiguration.class), "JAVA_FULL", cg.ci(CallConfiguration.class));
            }
            if (receiver != null) {
                this.invokeUtilityMethod("defs", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            } else {
                this.invokeUtilityMethod("def", cg.sig(IRubyObject.class, cg.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            }
        }

        @Override
        public void rethrowIfSystemExit() {
            this.loadRuntime();
            this.method.ldc("SystemExit");
            this.method.invokevirtual(cg.p(Ruby.class), "fastGetClass", cg.sig(RubyClass.class, String.class));
            this.method.invokevirtual(cg.p(RubyException.class), "isKindOf", cg.sig(Boolean.TYPE, cg.params(RubyModule.class)));
            this.method.iconst_0();
            Label ifEnd = new Label();
            this.method.if_icmpeq(ifEnd);
            this.loadException();
            this.method.athrow();
            this.method.label(ifEnd);
        }
    }
}

