/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public abstract class AbstractVariableCompiler
implements VariableCompiler {
    protected static final CodegenUtils cg = CodegenUtils.cg;
    protected SkinnyMethodAdapter method;
    protected StandardASMCompiler.AbstractMethodCompiler methodCompiler;
    protected int argsIndex;
    protected int closureIndex;
    protected Arity arity;

    public AbstractVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, int argsIndex, int closureIndex) {
        this.methodCompiler = methodCompiler;
        this.method = method;
        this.argsIndex = argsIndex;
        this.closureIndex = closureIndex;
    }

    @Override
    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    @Override
    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    @Override
    public void assignLastLine() {
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentFrame", cg.sig(Frame.class));
        this.method.swap();
        this.method.invokevirtual(cg.p(Frame.class), "setLastLine", cg.sig(Void.TYPE, cg.params(IRubyObject.class)));
    }

    @Override
    public void retrieveLastLine() {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentFrame", cg.sig(Frame.class));
        this.method.invokevirtual(cg.p(Frame.class), "getLastLine", cg.sig(IRubyObject.class));
    }

    @Override
    public void retrieveBackRef() {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentFrame", cg.sig(Frame.class));
        this.method.invokevirtual(cg.p(Frame.class), "getBackRef", cg.sig(IRubyObject.class));
    }

    @Override
    public void checkMethodArity(int requiredArgs, int optArgs, int restArg) {
        Label arityError = new Label();
        Label noArityError = new Label();
        if (restArg != -1) {
            if (requiredArgs > 0) {
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.ldc(requiredArgs);
                this.method.if_icmplt(arityError);
            }
        } else if (optArgs > 0) {
            if (requiredArgs > 0) {
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.ldc(requiredArgs);
                this.method.if_icmplt(arityError);
            }
            this.method.aload(this.argsIndex);
            this.method.arraylength();
            this.method.ldc(requiredArgs + optArgs);
            this.method.if_icmpgt(arityError);
        } else {
            this.method.aload(this.argsIndex);
            this.method.arraylength();
            this.method.ldc(requiredArgs);
            this.method.if_icmpne(arityError);
        }
        this.method.go_to(noArityError);
        this.method.label(arityError);
        this.methodCompiler.loadRuntime();
        this.method.aload(this.argsIndex);
        this.method.ldc(requiredArgs);
        this.method.ldc(requiredArgs + optArgs);
        this.method.invokestatic(cg.p(Arity.class), "checkArgumentCount", cg.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
        this.method.pop();
        this.method.label(noArityError);
    }

    @Override
    public void assignMethodArguments(Object requiredArgs, int requiredArgsCount, Object optArgs, int optArgsCount, ArrayCallback requiredAssignment, ArrayCallback optGivenAssignment, ArrayCallback optNotGivenAssignment, ClosureCallback restAssignment, ClosureCallback blockAssignment) {
        int currentArgElement;
        this.method.aload(this.argsIndex);
        for (currentArgElement = 0; currentArgElement < requiredArgsCount; ++currentArgElement) {
            this.method.dup();
            this.method.ldc(new Integer(currentArgElement));
            this.method.arrayload();
            requiredAssignment.nextValue(this.methodCompiler, requiredArgs, currentArgElement);
            this.method.pop();
        }
        for (int optArgElement = 0; optArgElement < optArgsCount; ++optArgElement) {
            Label noMoreArrayElements = new Label();
            Label doneWithElement = new Label();
            this.method.dup();
            this.method.arraylength();
            this.method.ldc(new Integer(currentArgElement));
            this.method.if_icmple(noMoreArrayElements);
            this.method.dup();
            this.method.ldc(new Integer(currentArgElement));
            this.method.arrayload();
            optGivenAssignment.nextValue(this.methodCompiler, optArgs, optArgElement);
            this.method.go_to(doneWithElement);
            this.method.label(noMoreArrayElements);
            optNotGivenAssignment.nextValue(this.methodCompiler, optArgs, optArgElement);
            this.method.label(doneWithElement);
            this.method.pop();
            ++currentArgElement;
        }
        if (restAssignment != null) {
            Label emptyArray = new Label();
            Label readyForArgs = new Label();
            this.method.dup();
            this.method.arraylength();
            this.method.ldc(new Integer(currentArgElement));
            this.method.if_icmple(emptyArray);
            this.method.dup();
            this.methodCompiler.loadRuntime();
            this.method.ldc(currentArgElement);
            this.methodCompiler.invokeUtilityMethod("createSubarray", cg.sig(RubyArray.class, IRubyObject[].class, Ruby.class, Integer.TYPE));
            this.method.go_to(readyForArgs);
            this.method.label(emptyArray);
            this.methodCompiler.createEmptyArray();
            this.method.label(readyForArgs);
            restAssignment.compile(this.methodCompiler);
            this.method.pop();
        }
        this.method.pop();
        if (blockAssignment != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.closureIndex);
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", cg.sig(IRubyObject.class, cg.params(Ruby.class, Block.class)));
            blockAssignment.compile(this.methodCompiler);
            this.method.pop();
        }
    }
}

