/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.executable;

import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.executable.RubiniusCMethod;
import org.jruby.ast.executable.RubiniusInstructions;
import org.jruby.internal.runtime.methods.RubiniusMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.parser.LocalStaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubiniusMachine {
    public static final RubiniusMachine INSTANCE = new RubiniusMachine();

    public static final int getInt(char[] bytecodes, int ix) {
        int val = 0;
        val += bytecodes[ix + 0] << 24;
        val += bytecodes[ix + 1] << 16;
        val += bytecodes[ix + 2] << 8;
        return val += bytecodes[ix + 3];
    }

    public IRubyObject exec(ThreadContext context, IRubyObject self, char[] bytecodes, IRubyObject[] literals, IRubyObject[] args) {
        IRubyObject[] stack = new IRubyObject[20];
        int stackTop = 0;
        stack[stackTop] = context.getRuntime().getNil();
        for (int i = 0; i < args.length; ++i) {
            stack[++stackTop] = args[i];
        }
        int ip = 0;
        int call_flags = -1;
        int cache_index = -1;
        Ruby runtime = context.getRuntime();
        block34: while (ip < bytecodes.length) {
            int ix = ip;
            char code = bytecodes[ip++];
            switch (code) {
                case '\u0000': {
                    continue block34;
                }
                case '\u001d': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    String name = literals[val].toString();
                    RubyModule clzz = (RubyModule)stack[stackTop--];
                    RubyArray method = (RubyArray)stack[stackTop--];
                    Visibility visibility = context.getCurrentVisibility();
                    if (name == "initialize" || visibility == Visibility.MODULE_FUNCTION) {
                        visibility = Visibility.PRIVATE;
                    }
                    RubiniusCMethod cmethod = new RubiniusCMethod(method);
                    LocalStaticScope staticScope = new LocalStaticScope(context.getCurrentScope().getStaticScope());
                    staticScope.setVariables(new String[cmethod.locals]);
                    staticScope.determineModule();
                    RubiniusMethod newMethod = new RubiniusMethod(clzz, cmethod, staticScope, visibility);
                    clzz.addMethod(name, newMethod);
                    if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
                        clzz.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)clzz.getSingletonClass(), newMethod, Visibility.PUBLIC));
                        clzz.callMethod(context, "singleton_method_added", literals[val]);
                    }
                    if (clzz.isSingleton()) {
                        ((MetaClass)clzz).getAttached().callMethod(context, "singleton_method_added", literals[val]);
                    } else {
                        clzz.callMethod(context, "method_added", literals[val]);
                    }
                    stack[++stackTop] = method;
                    continue block34;
                }
                case 'F': {
                    stack[++stackTop] = RubyFixnum.minus_one(runtime);
                    continue block34;
                }
                case '7': {
                    int min = RubiniusMachine.getInt(bytecodes, ip);
                    int max = RubiniusMachine.getInt(bytecodes, ip += 4);
                    ip += 4;
                    if (args.length < min) {
                        throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + min + ")");
                    }
                    if (max <= 0 || args.length <= max) continue block34;
                    throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + max + ")");
                }
                case 'G': {
                    stack[++stackTop] = RubyFixnum.zero(runtime);
                    continue block34;
                }
                case 'H': {
                    stack[++stackTop] = RubyFixnum.one(runtime);
                    continue block34;
                }
                case 'I': {
                    stack[++stackTop] = runtime.newFixnum(2L);
                    continue block34;
                }
                case '\u0011': {
                    int local = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    context.getCurrentScope().setValue(local, stack[stackTop], 0);
                    continue block34;
                }
                case '\u0012': {
                    int local = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = context.getCurrentScope().getValue(local, 0);
                    continue block34;
                }
                case '\u0001': {
                    stack[++stackTop] = runtime.getNil();
                    continue block34;
                }
                case '\u0002': {
                    stack[++stackTop] = runtime.getTrue();
                    continue block34;
                }
                case '\u0003': {
                    stack[++stackTop] = runtime.getFalse();
                    continue block34;
                }
                case '\f': {
                    stack[++stackTop] = self;
                    continue block34;
                }
                case ':': {
                    stack[stackTop] = ((RubyString)stack[stackTop]).strDup();
                    continue block34;
                }
                case '\u000b': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = literals[val];
                    continue block34;
                }
                case 'Q': {
                    IRubyObject t1 = stack[stackTop--];
                    IRubyObject t2 = stack[stackTop--];
                    if (t1 instanceof RubyFixnum && t1 instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)t1).getLongValue() < ((RubyFixnum)t2).getLongValue() ? runtime.getTrue() : runtime.getFalse();
                        continue block34;
                    }
                    stack[++stackTop] = t1.callMethod(context, MethodIndex.OP_LT, "<", t2);
                    continue block34;
                }
                case 'R': {
                    IRubyObject t1 = stack[stackTop--];
                    IRubyObject t2 = stack[stackTop--];
                    if (t1 instanceof RubyFixnum && t1 instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)t1).getLongValue() > ((RubyFixnum)t1).getLongValue() ? runtime.getTrue() : runtime.getFalse();
                        continue block34;
                    }
                    stack[++stackTop] = t1.callMethod(context, MethodIndex.OP_GT, ">", t2);
                    continue block34;
                }
                case 'N': {
                    IRubyObject t1 = stack[stackTop--];
                    IRubyObject t2 = stack[stackTop--];
                    if (t1 instanceof RubyFixnum && t2 instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)t1).op_plus(t2);
                        continue block34;
                    }
                    stack[++stackTop] = t1.callMethod(context, MethodIndex.OP_PLUS, "+", t2);
                    continue block34;
                }
                case 'O': {
                    IRubyObject t1 = stack[stackTop--];
                    IRubyObject t2 = stack[stackTop--];
                    if (t1 instanceof RubyFixnum && t2 instanceof RubyFixnum) {
                        stack[++stackTop] = ((RubyFixnum)t1).op_minus(t2);
                        continue block34;
                    }
                    stack[++stackTop] = t1.callMethod(context, MethodIndex.OP_MINUS, "-", t2);
                    continue block34;
                }
                case '&': {
                    --stackTop;
                    continue block34;
                }
                case '\\': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    call_flags = val;
                    continue block34;
                }
                case 'C': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    cache_index = val;
                    continue block34;
                }
                case ')': {
                    int index = RubiniusMachine.getInt(bytecodes, ip);
                    int num_args = RubiniusMachine.getInt(bytecodes, ip += 4);
                    ip += 4;
                    String name = literals[index].toString();
                    int ixi = MethodIndex.getIndex(name);
                    IRubyObject recv = stack[stackTop--];
                    IRubyObject[] argu = new IRubyObject[num_args];
                    for (int i = 0; i < num_args; ++i) {
                        argu[i] = stack[stackTop--];
                    }
                    if ((call_flags & 1) == 1) {
                        stack[++stackTop] = recv.callMethod(context, recv.getMetaClass(), ixi, name, argu, CallType.FUNCTIONAL, Block.NULL_BLOCK);
                        continue block34;
                    }
                    stack[++stackTop] = recv.callMethod(context, recv.getMetaClass(), ixi, name, argu, CallType.NORMAL, Block.NULL_BLOCK);
                    continue block34;
                }
                case '\u000e': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    if (stack[stackTop--].isTrue()) continue block34;
                    ip = val;
                    continue block34;
                }
                case '\u000f': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    if (!stack[stackTop--].isTrue()) continue block34;
                    ip = val;
                    continue block34;
                }
                case '\u0010': {
                    IRubyObject swap = stack[stackTop];
                    stack[stackTop] = stack[stackTop - 1];
                    stack[stackTop - 1] = swap;
                    continue block34;
                }
                case '%': {
                    stack[stackTop + 1] = stack[stackTop];
                    ++stackTop;
                    continue block34;
                }
                case '\r': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    ip = val;
                    continue block34;
                }
                case '\'': {
                    return stack[stackTop];
                }
                case '\u0007': {
                    int val = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    stack[++stackTop] = runtime.newFixnum(val);
                    continue block34;
                }
                case '\u0018': {
                    int index = RubiniusMachine.getInt(bytecodes, ip);
                    ip += 4;
                    String name = literals[index].toString();
                    stack[++stackTop] = context.getConstant(name);
                    continue block34;
                }
            }
            System.err.println("--COULDN'T");
            if (RubiniusInstructions.ONE_INT[code]) {
                ip += 4;
                continue;
            }
            if (!RubiniusInstructions.TWO_INT[code]) continue;
            ip += 8;
        }
        return null;
    }
}

