/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.regexp.PatternSyntaxException;
import org.jruby.regexp.RegexpFactory;
import org.jruby.regexp.RegexpPattern;
import org.jruby.util.ByteList;

public class RegexpNode
extends Node
implements ILiteralNode {
    private RegexpPattern pattern;
    private final ByteList value;
    private final int options;
    public RubyRegexp literal;

    public RegexpNode(ISourcePosition position, ByteList value, int options) {
        super(position, NodeType.REGEXPNODE);
        this.value = value;
        this.options = options;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRegexpNode(this);
    }

    public int getOptions() {
        return this.options;
    }

    public ByteList getValue() {
        return this.value;
    }

    public RegexpPattern getPattern(Ruby runtime, int extra_options) throws PatternSyntaxException {
        if (this.pattern == null) {
            this.pattern = (this.options & 0x100) == 256 ? RegexpFactory.getFactory("java").createPattern(this.value, this.options & 0xFFFFFEFF | extra_options, 0) : runtime.getRegexpFactory().createPattern(this.value, this.options | extra_options, 0);
        }
        return this.pattern;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

