/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.CallAdapter;
import org.jruby.runtime.CallType;

public class FCallNode
extends Node
implements INameNode,
IArgumentNode,
BlockAcceptingNode {
    private Node argsNode;
    private Node iterNode;
    public final CallAdapter callAdapter;

    public FCallNode(ISourcePosition position, String name, Node argsNode) {
        this(position, name, argsNode, null);
    }

    public FCallNode(ISourcePosition position, String name, Node argsNode, Node iterNode) {
        super(position, NodeType.FCALLNODE);
        this.setArgsNode(argsNode);
        this.iterNode = iterNode;
        this.callAdapter = new CallAdapter.DefaultCallAdapter(name, CallType.FUNCTIONAL);
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitFCallNode(this);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public void setIterNode(Node iterNode) {
        this.iterNode = iterNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public void setArgsNode(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public String getName() {
        return this.callAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return FCallNode.createList(this.argsNode, this.iterNode);
    }

    @Override
    public String toString() {
        return "FCallNode: " + this.getName();
    }
}

