/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyStringIO
extends RubyObject {
    private static ObjectAllocator STRINGIO_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyStringIO(runtime, klass);
        }
    };
    private long pos = 0L;
    private int lineno = 0;
    private boolean eof = false;
    private RubyString internal;
    private boolean closedRead = false;
    private boolean closedWrite = false;
    private boolean append = false;
    private static final ByteList NEWLINE_BL = new ByteList(new byte[]{10}, false);

    public static RubyClass createStringIOClass(Ruby runtime) {
        RubyClass stringIOClass = runtime.defineClass("StringIO", runtime.getObject(), STRINGIO_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyStringIO.class);
        stringIOClass.defineAnnotatedMethods(RubyStringIO.class);
        return stringIOClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, optional=2, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyStringIO strio;
        IRubyObject val = strio = (RubyStringIO)((RubyClass)recv).newInstance(args, Block.NULL_BLOCK);
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (block.isGiven()) {
            try {
                val = block.yield(tc, strio);
            }
            finally {
                strio.close();
            }
        }
        return val;
    }

    protected RubyStringIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length > 0) {
            this.internal = args[0].convertToString();
            if (args.length > 1) {
                if (args[1] instanceof RubyFixnum) {
                    int n = RubyNumeric.fix2int(args[1]);
                }
                String modes = args[1].convertToString().toString();
                this.setupModes(modes);
            }
        } else {
            this.internal = this.getRuntime().newString("");
        }
        return this;
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(IRubyObject obj) {
        this.checkWritable();
        this.checkFrozen();
        RubyString val = (RubyString)obj.callMethod(obj.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s");
        this.internal.modify();
        if (this.append) {
            this.internal.getByteList().append(val.getByteList());
        } else {
            int left = this.internal.getByteList().length() - (int)this.pos;
            this.internal.getByteList().replace((int)this.pos, Math.min(val.getByteList().length(), left), val.getByteList());
            this.pos += (long)val.getByteList().length();
        }
        return this;
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        this.closedRead = true;
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        return this.getRuntime().newBoolean(this.closedRead && this.closedWrite);
    }

    @JRubyMethod(name={"close_read"})
    public IRubyObject close_read() {
        this.closedRead = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_read?"})
    public IRubyObject closed_read_p() {
        return this.getRuntime().newBoolean(this.closedRead);
    }

    @JRubyMethod(name={"close_write"})
    public IRubyObject close_write() {
        this.closedWrite = true;
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"closed_write?"})
    public IRubyObject closed_write_p() {
        return this.getRuntime().newBoolean(this.closedWrite);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true)
    public IRubyObject each(IRubyObject[] args, Block block) {
        IRubyObject line = this.gets(args);
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!line.isNil()) {
            block.yield(context, line);
            line = this.gets(args);
        }
        return this;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(Block block) {
        this.checkReadable();
        RubyString.newString(this.getRuntime(), new ByteList(this.internal.getByteList(), (int)this.pos, this.internal.getByteList().length())).each_byte(block);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"each_line"}, frame=true)
    public IRubyObject each_line(Block block) {
        return this.each(new RubyObject[0], block);
    }

    @JRubyMethod(name={"eof"})
    public IRubyObject eof() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"eof?"})
    public IRubyObject eof_p() {
        return this.pos >= (long)this.internal.getByteList().length() || this.eof ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"fcntl"})
    public IRubyObject fcntl() {
        throw this.getRuntime().newNotImplementedError("fcntl not implemented");
    }

    @JRubyMethod(name={"fileno"})
    public IRubyObject fileno() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush() {
        return this;
    }

    @JRubyMethod(name={"fsync"})
    public IRubyObject fsync() {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        if (this.pos >= (long)this.internal.getByteList().length()) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.internal.getByteList().get((int)this.pos++) & 0xFF);
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.pos < (long)this.internal.getByteList().length() && !this.eof) {
            String sep = ((RubyString)this.getRuntime().getGlobalVariables().get("$/")).getValue().toString();
            if (args.length > 0) {
                if (args[0].isNil()) {
                    ByteList buf = new ByteList(this.internal.getByteList(), (int)this.pos, this.internal.getByteList().length() - (int)this.pos);
                    this.pos += (long)buf.length();
                    return RubyString.newString(this.getRuntime(), buf);
                }
                sep = args[0].toString();
            }
            String ss = this.internal.toString();
            int ix = ss.indexOf(sep, (int)this.pos);
            String add = sep;
            if (-1 == ix) {
                ix = this.internal.getByteList().length();
                add = "";
            }
            ByteList line = new ByteList(this.internal.getByteList(), (int)this.pos, ix - (int)this.pos);
            line.append(RubyString.stringToBytes(add));
            this.pos = ix + add.length();
            ++this.lineno;
            return RubyString.newString(this.getRuntime(), line);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public IRubyObject gets(IRubyObject[] args) {
        this.checkReadable();
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"isatty"})
    public IRubyObject isatty() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"tty?"})
    public IRubyObject tty_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"length"})
    public IRubyObject length() {
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.lineno);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject arg) {
        this.lineno = RubyNumeric.fix2int(arg);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"path"})
    public IRubyObject path() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pid"})
    public IRubyObject pid() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"pos"})
    public IRubyObject pos() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"tell"})
    public IRubyObject tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject arg) {
        this.pos = RubyNumeric.fix2int(arg);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true)
    public IRubyObject print(IRubyObject[] args) {
        IRubyObject sep;
        if (args.length != 0) {
            int j = args.length;
            for (int i = 0; i < j; ++i) {
                this.append(args[i]);
            }
        }
        if (!(sep = this.getRuntime().getGlobalVariables().get("$\\")).isNil()) {
            this.append(sep);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, required=1, rest=true)
    public IRubyObject printf(IRubyObject[] args) {
        this.append(RubyKernel.sprintf(this, args));
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1)
    public IRubyObject putc(IRubyObject obj) {
        this.checkWritable();
        byte c = RubyNumeric.num2chr(obj);
        this.checkFrozen();
        this.internal.modify();
        if (this.append) {
            this.pos = this.internal.getByteList().length();
            this.internal.getByteList().append(c);
        } else {
            if (this.pos >= (long)this.internal.getByteList().length()) {
                this.internal.getByteList().append(c);
            } else {
                this.internal.getByteList().set((int)this.pos, c);
            }
            ++this.pos;
        }
        return obj;
    }

    @JRubyMethod(name={"puts"}, rest=true)
    public IRubyObject puts(IRubyObject[] obj) {
        this.checkWritable();
        if (obj.length == 0) {
            this.append(RubyString.newString(this.getRuntime(), NEWLINE_BL));
        }
        int j = obj.length;
        for (int i = 0; i < j; ++i) {
            this.append(obj[i]);
            int lastPossibleNewlineIndex = (int)(this.pos - (long)NEWLINE_BL.length());
            if (lastPossibleNewlineIndex != -1 && this.internal.getByteList().subSequence(lastPossibleNewlineIndex, (int)this.pos).equals(NEWLINE_BL)) continue;
            this.internal.getByteList().unsafeReplace((int)this.pos++, (long)this.internal.getByteList().length() > this.pos ? 1 : 0, NEWLINE_BL);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] args) {
        this.checkReadable();
        ByteList buf = null;
        int length = 0;
        int oldLength = 0;
        RubyString originalString = null;
        switch (args.length) {
            case 2: {
                originalString = args[1].convertToString();
                buf = originalString.getByteList();
            }
            case 1: {
                if (!args[0].isNil()) {
                    oldLength = length = RubyNumeric.fix2int(args[0]);
                    if (length < 0) {
                        throw this.getRuntime().newArgumentError("negative length " + length + " given");
                    }
                    if (length > 0 && this.pos >= (long)this.internal.getByteList().length()) {
                        this.eof = true;
                        if (buf != null) {
                            buf.realSize = 0;
                        }
                        return this.getRuntime().getNil();
                    }
                    if (!this.eof) break;
                    if (buf != null) {
                        buf.realSize = 0;
                    }
                    return this.getRuntime().getNil();
                }
            }
            case 0: {
                oldLength = -1;
                length = this.internal.getByteList().length();
                if ((long)length <= this.pos) {
                    this.eof = true;
                    if (buf == null) {
                        buf = new ByteList();
                    } else {
                        buf.realSize = 0;
                    }
                    return this.getRuntime().newString(buf);
                }
                length = (int)((long)length - this.pos);
                break;
            }
            default: {
                this.getRuntime().newArgumentError(args.length, 0);
            }
        }
        if (buf == null) {
            int internalLength = this.internal.getByteList().length();
            if (internalLength > 0) {
                if ((long)internalLength >= this.pos + (long)length) {
                    buf = new ByteList(this.internal.getByteList(), (int)this.pos, length);
                } else {
                    int rest = (int)((long)this.internal.getByteList().length() - this.pos);
                    if (length > rest) {
                        length = rest;
                    }
                    buf = new ByteList(this.internal.getByteList(), (int)this.pos, length);
                }
            }
        } else {
            int rest = (int)((long)this.internal.getByteList().length() - this.pos);
            if (length > rest) {
                length = rest;
            }
            buf.realSize = length;
            buf.replace(0, length, this.internal.getByteList().bytes, (int)this.pos, length);
        }
        if (buf == null) {
            if (!this.eof) {
                buf = new ByteList();
            }
            length = 0;
        } else {
            length = buf.length();
            this.pos += (long)length;
        }
        if (oldLength < 0 || oldLength > length) {
            this.eof = true;
        }
        return originalString != null ? originalString : this.getRuntime().newString(buf);
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1)
    public IRubyObject readlines(IRubyObject[] arg) {
        this.checkReadable();
        ArrayList<IRubyObject> lns = new ArrayList<IRubyObject>();
        while (this.pos < (long)this.internal.getByteList().length() && !this.eof) {
            lns.add(this.gets(arg));
        }
        return this.getRuntime().newArray(lns);
    }

    @JRubyMethod(name={"reopen"}, required=1, optional=1)
    public IRubyObject reopen(IRubyObject[] args) {
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        IRubyObject str = args[0];
        if (str instanceof RubyStringIO) {
            this.pos = ((RubyStringIO)str).pos;
            this.lineno = ((RubyStringIO)str).lineno;
            this.eof = ((RubyStringIO)str).eof;
            this.closedRead = ((RubyStringIO)str).closedRead;
            this.closedWrite = ((RubyStringIO)str).closedWrite;
            this.internal = ((RubyStringIO)str).internal;
        } else {
            this.pos = 0L;
            this.lineno = 0;
            this.eof = false;
            this.closedRead = false;
            this.closedWrite = false;
            this.internal = str.convertToString();
        }
        if (args.length == 2) {
            this.setupModes(args[1].convertToString().toString());
        }
        return this;
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        this.pos = 0L;
        this.lineno = 0;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public IRubyObject seek(IRubyObject[] args) {
        long amount = RubyNumeric.fix2long(args[0]);
        int whence = 0;
        long newPosition = this.pos;
        if (args.length > 1 && !args[0].isNil()) {
            whence = RubyNumeric.fix2int(args[1]);
        }
        newPosition = whence == 1 ? (newPosition += amount) : (whence == 2 ? (long)this.internal.getByteList().length() + amount : amount);
        if (newPosition < 0L) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        this.pos = newPosition;
        this.eof = false;
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"string="}, required=1)
    public IRubyObject set_string(IRubyObject arg) {
        return this.reopen(new IRubyObject[]{arg});
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject args) {
        return args;
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.internal.getByteList().length());
    }

    @JRubyMethod(name={"string"})
    public IRubyObject string() {
        return this.internal;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"sysread"}, required=1, optional=1)
    public IRubyObject sysread(IRubyObject[] args) {
        IRubyObject obj = this.read(args);
        if (obj.isNil() || ((RubyString)obj).getByteList().length() == 0) {
            throw this.getRuntime().newEOFError();
        }
        return obj;
    }

    @JRubyMethod(name={"syswrite"}, required=1)
    public IRubyObject syswrite(IRubyObject args) {
        return this.write(args);
    }

    @JRubyMethod(name={"truncate"}, required=1)
    public IRubyObject truncate(IRubyObject arg) {
        this.checkWritable();
        int len = RubyFixnum.fix2int(arg);
        this.internal.modify();
        this.internal.getByteList().length(len);
        return this.getRuntime().newFixnum(len);
    }

    @JRubyMethod(name={"ungetc"}, required=1)
    public IRubyObject ungetc(IRubyObject arg) {
        this.checkReadable();
        int c = RubyNumeric.num2int(arg);
        if (this.pos == 0L) {
            return this.getRuntime().getNil();
        }
        this.internal.modify();
        --this.pos;
        this.internal.getByteList().set((int)this.pos, c);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"write"}, required=1)
    public IRubyObject write(IRubyObject arg) {
        this.checkWritable();
        String obj = arg.toString();
        this.append(arg);
        return this.getRuntime().newFixnum(obj.length());
    }

    @Override
    protected void checkFrozen() {
        if (this.internal.isFrozen()) {
            throw this.getRuntime().newIOError("not modifiable string");
        }
    }

    private void checkReadable() {
        if (this.closedRead) {
            throw this.getRuntime().newIOError("not opened for reading");
        }
    }

    private void checkWritable() {
        if (this.closedWrite) {
            throw this.getRuntime().newIOError("not opened for writing");
        }
    }

    private void setupModes(String modes) {
        this.closedWrite = false;
        this.closedRead = false;
        this.append = false;
        if (modes.contains("r")) {
            this.closedWrite = true;
        }
        if (modes.contains("w")) {
            this.closedRead = true;
        }
        if (modes.contains("a")) {
            this.append = true;
        }
    }
}

