/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigInteger;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Convert;

public class RubyNumeric
extends RubyObject {
    protected static ObjectAllocator NUMERIC_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNumeric(runtime, klass);
        }
    };
    public static double DBL_EPSILON = 2.220446049250313E-16;

    public static RubyClass createNumericClass(Ruby runtime) {
        RubyClass numeric = runtime.defineClass("Numeric", runtime.getObject(), NUMERIC_ALLOCATOR);
        runtime.setNumeric(numeric);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNumeric.class);
        numeric.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyNumeric;
            }
        };
        numeric.includeModule(runtime.getComparable());
        numeric.defineAnnotatedMethods(RubyNumeric.class);
        numeric.dispatcher = callbackFactory.createDispatcher(numeric);
        return numeric;
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public RubyNumeric(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        super(runtime, metaClass, useObjectSpace);
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public long getLongValue() {
        return 0L;
    }

    public static RubyNumeric newNumeric(Ruby runtime) {
        return new RubyNumeric(runtime, runtime.getNumeric());
    }

    public static int num2int(IRubyObject arg) {
        long num = RubyNumeric.num2long(arg);
        RubyNumeric.checkInt(arg, num);
        return (int)num;
    }

    public static void checkInt(IRubyObject arg, long num) {
        String s;
        if (num < Integer.MIN_VALUE) {
            s = "small";
        } else if (num > Integer.MAX_VALUE) {
            s = "big";
        } else {
            return;
        }
        throw arg.getRuntime().newRangeError("integer " + num + " too " + s + " to convert to `int'");
    }

    public static byte num2chr(IRubyObject arg) {
        String value;
        if (arg instanceof RubyString && (value = ((RubyString)arg).toString()) != null && value.length() > 0) {
            return (byte)value.charAt(0);
        }
        return (byte)RubyNumeric.num2int(arg);
    }

    public static long num2long(IRubyObject arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).getLongValue();
        }
        if (arg.isNil()) {
            throw arg.getRuntime().newTypeError("no implicit conversion from nil to integer");
        }
        if (arg instanceof RubyFloat) {
            double aFloat = ((RubyFloat)arg).getDoubleValue();
            if (aFloat <= 9.223372036854776E18 && aFloat >= -9.223372036854776E18) {
                return (long)aFloat;
            }
            throw arg.getRuntime().newTypeError("float " + aFloat + "out of range of integer");
        }
        if (arg instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)arg);
        }
        return arg.convertToInteger().getLongValue();
    }

    public static IRubyObject dbl2num(Ruby runtime, double val) {
        if (Double.isInfinite(val)) {
            throw runtime.newFloatDomainError(val < 0.0 ? "-Infinity" : "Infinity");
        }
        if (Double.isNaN(val)) {
            throw runtime.newFloatDomainError("NaN");
        }
        if (val > 9.223372036854776E18 || val < -9.223372036854776E18) {
            return RubyBignum.newBignum(runtime, val);
        }
        return RubyFixnum.newFixnum(runtime, (long)val);
    }

    public static double num2dbl(IRubyObject arg) {
        if (arg instanceof RubyFloat) {
            return ((RubyFloat)arg).getDoubleValue();
        }
        if (arg instanceof RubyString) {
            throw arg.getRuntime().newTypeError("no implicit conversion to float from string");
        }
        if (arg == arg.getRuntime().getNil()) {
            throw arg.getRuntime().newTypeError("no implicit conversion to float from nil");
        }
        return arg.convertToFloat().getDoubleValue();
    }

    public static IRubyObject dbl_cmp(Ruby runtime, double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return runtime.getNil();
        }
        if (a > b) {
            return RubyFixnum.one(runtime);
        }
        if (a < b) {
            return RubyFixnum.minus_one(runtime);
        }
        return RubyFixnum.zero(runtime);
    }

    public static long fix2long(IRubyObject arg) {
        return ((RubyFixnum)arg).getLongValue();
    }

    public static int fix2int(IRubyObject arg) {
        long num = arg instanceof RubyFixnum ? RubyNumeric.fix2long(arg) : RubyNumeric.num2long(arg);
        RubyNumeric.checkInt(arg, num);
        return (int)num;
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base) {
        return RubyNumeric.str2inum(runtime, str, base, false);
    }

    public static RubyNumeric int2fix(Ruby runtime, long val) {
        return RubyFixnum.newFixnum(runtime, val);
    }

    public static IRubyObject num2fix(IRubyObject val) {
        if (val instanceof RubyFixnum) {
            return val;
        }
        if (val instanceof RubyBignum) {
            throw val.getRuntime().newRangeError("integer " + val + " out of range of fixnum");
        }
        return RubyFixnum.newFixnum(val.getRuntime(), RubyNumeric.num2long(val));
    }

    public static RubyInteger str2inum(Ruby runtime, RubyString str, int base, boolean strict) {
        if (base != 0 && (base < 2 || base > 36)) {
            throw runtime.newArgumentError("illegal radix " + base);
        }
        ByteList bytes = str.getByteList();
        try {
            return runtime.newFixnum(Convert.byteListToLong(bytes, base, strict));
        }
        catch (InvalidIntegerException e) {
            if (strict) {
                throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return RubyFixnum.zero(runtime);
        }
        catch (NumberTooLargeException e) {
            try {
                BigInteger bi = Convert.byteListToBigInteger(bytes, base, strict);
                return new RubyBignum(runtime, bi);
            }
            catch (InvalidIntegerException e2) {
                if (strict) {
                    throw runtime.newArgumentError("invalid value for Integer: " + str.callMethod(runtime.getCurrentContext(), "inspect").toString());
                }
                return RubyFixnum.zero(runtime);
            }
        }
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg) {
        return RubyNumeric.str2fnum(runtime, arg, false);
    }

    public static RubyFloat str2fnum(Ruby runtime, RubyString arg, boolean strict) {
        double ZERO = 0.0;
        try {
            return new RubyFloat(runtime, Convert.byteListToDouble(arg.getByteList(), strict));
        }
        catch (NumberFormatException e) {
            if (strict) {
                throw runtime.newArgumentError("invalid value for Float(): " + arg.callMethod(runtime.getCurrentContext(), "inspect").toString());
            }
            return new RubyFloat(runtime, 0.0);
        }
    }

    protected IRubyObject[] getCoerced(IRubyObject other, boolean error) {
        IRubyObject result;
        try {
            result = other.callMethod(this.getRuntime().getCurrentContext(), "coerce", this);
        }
        catch (RaiseException e) {
            if (error) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return ((RubyArray)result).toJavaArray();
    }

    protected IRubyObject callCoerced(String method, IRubyObject other, boolean err) {
        IRubyObject[] args = this.getCoerced(other, err);
        if (args == null) {
            return this.getRuntime().getNil();
        }
        return args[0].callMethod(this.getRuntime().getCurrentContext(), method, args[1]);
    }

    protected IRubyObject callCoerced(String method, IRubyObject other) {
        IRubyObject[] args = this.getCoerced(other, false);
        if (args == null) {
            return this.getRuntime().getNil();
        }
        return args[0].callMethod(this.getRuntime().getCurrentContext(), method, args[1]);
    }

    protected final IRubyObject coerceBody(IRubyObject other) {
        return other.callMethod(this.getRuntime().getCurrentContext(), "coerce", this);
    }

    protected final RubyArray doCoerce(IRubyObject other, boolean err) {
        IRubyObject result;
        try {
            result = this.coerceBody(other);
        }
        catch (RaiseException e) {
            if (err) {
                throw this.getRuntime().newTypeError(other.getMetaClass().getName() + " can't be coerced into " + this.getMetaClass().getName());
            }
            return null;
        }
        if (!(result instanceof RubyArray) || ((RubyArray)result).getLength() != 2) {
            throw this.getRuntime().newTypeError("coerce must return [x, y]");
        }
        return (RubyArray)result;
    }

    protected final IRubyObject coerceBin(String method, IRubyObject other) {
        RubyArray ary = this.doCoerce(other, true);
        return ary.eltInternal(0).callMethod(this.getRuntime().getCurrentContext(), method, ary.eltInternal(1));
    }

    protected final IRubyObject coerceCmp(String method, IRubyObject other) {
        RubyArray ary = this.doCoerce(other, false);
        if (ary == null) {
            return this.getRuntime().getNil();
        }
        return ary.eltInternal(0).callMethod(this.getRuntime().getCurrentContext(), method, ary.eltInternal(1));
    }

    protected final IRubyObject coerceRelOp(String method, IRubyObject other) {
        IRubyObject result;
        RubyArray ary = this.doCoerce(other, false);
        if (ary != null && !(result = ary.eltInternal(0).callMethod(this.getRuntime().getCurrentContext(), method, ary.eltInternal(1))).isNil()) {
            return result;
        }
        RubyComparable.cmperr(this, other);
        return null;
    }

    public RubyNumeric asNumeric() {
        return this;
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1)
    public IRubyObject sadded(IRubyObject name) {
        throw this.getRuntime().newTypeError("can't define singleton method " + name + " for " + this.getType().getName());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject arg) {
        throw this.getRuntime().newTypeError("can't copy " + this.getType().getName());
    }

    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        if (this.getMetaClass() == other.getMetaClass()) {
            return this.getRuntime().newArray(other, this);
        }
        return this.getRuntime().newArray(RubyKernel.new_float(this, other), RubyKernel.new_float(this, this));
    }

    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        RubyArray ary = zero.doCoerce(this, true);
        return ary.eltInternal(0).callMethod(this.getRuntime().getCurrentContext(), MethodIndex.OP_MINUS, "-", ary.eltInternal(1));
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject other) {
        if (this == other) {
            return RubyFixnum.zero(this.getRuntime());
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject other) {
        if (this.getMetaClass() != other.getMetaClass()) {
            return this.getRuntime().getFalse();
        }
        return this.op_equal(other);
    }

    @JRubyMethod(name={"quo"}, required=1)
    public IRubyObject quo(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "/", other);
    }

    @JRubyMethod(name={"div"}, required=1)
    public IRubyObject div(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "/", other).convertToFloat().floor();
    }

    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(IRubyObject other) {
        return RubyArray.newArray(this.getRuntime(), this.div(other), this.modulo(other));
    }

    @JRubyMethod(name={"modulo"}, required=1)
    public IRubyObject modulo(IRubyObject other) {
        return this.callMethod(this.getRuntime().getCurrentContext(), "%", other);
    }

    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(IRubyObject dividend) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject z = this.callMethod(context, "%", dividend);
        RubyNumeric x = this;
        RubyFixnum zero = RubyFixnum.zero(this.getRuntime());
        if (z.op_equal(zero).isTrue()) {
            return z;
        }
        if (x.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() || x.callMethod(context, MethodIndex.OP_GT, ">", zero).isTrue() && dividend.callMethod(context, MethodIndex.OP_LT, "<", zero).isTrue()) {
            return z.callMethod(context, MethodIndex.OP_MINUS, "-", dividend);
        }
        return z;
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.callMethod(context, MethodIndex.OP_LT, "<", RubyFixnum.zero(this.getRuntime())).isTrue()) {
            return (RubyNumeric)this.callMethod(context, "-@");
        }
        return this;
    }

    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int() {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_I, "to_i", IRubyObject.NULL_ARRAY);
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.op_equal(RubyFixnum.zero(this.getRuntime())).isTrue() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        if (this.callMethod(this.getRuntime().getCurrentContext(), "zero?").isTrue()) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject floor() {
        return this.convertToFloat().floor();
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject ceil() {
        return this.convertToFloat().ceil();
    }

    @JRubyMethod(name={"round"})
    public IRubyObject round() {
        return this.convertToFloat().round();
    }

    @JRubyMethod(name={"truncate"})
    public IRubyObject truncate() {
        return this.convertToFloat().truncate();
    }

    @JRubyMethod(name={"step"}, required=1, optional=1, frame=true)
    public IRubyObject step(IRubyObject[] args, Block block) {
        IRubyObject step;
        IRubyObject to;
        if (args.length == 1) {
            to = args[0];
            step = RubyFixnum.one(this.getRuntime());
        } else if (args.length == 2) {
            to = args[0];
            step = args[1];
        } else {
            throw this.getRuntime().newTypeError("wrong number of arguments");
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum && step instanceof RubyFixnum) {
            long value = this.getLongValue();
            long end = ((RubyFixnum)to).getLongValue();
            long diff = ((RubyFixnum)step).getLongValue();
            if (diff == 0L) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            if (diff > 0L) {
                for (long i = value; i <= end; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            } else {
                for (long i = value; i >= end; i += diff) {
                    block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
                }
            }
        } else if (this instanceof RubyFloat || to instanceof RubyFloat || step instanceof RubyFloat) {
            double beg = RubyNumeric.num2dbl(this);
            double end = RubyNumeric.num2dbl(to);
            double unit = RubyNumeric.num2dbl(step);
            if (unit == 0.0) {
                throw this.getRuntime().newArgumentError("step cannot be 0");
            }
            double n = (end - beg) / unit;
            double err = (Math.abs(beg) + Math.abs(end) + Math.abs(end - beg)) / Math.abs(unit) * DBL_EPSILON;
            if (err > 0.5) {
                err = 0.5;
            }
            n = Math.floor(n + err) + 1.0;
            for (double i = 0.0; i < n; i += 1.0) {
                block.yield(context, RubyFloat.newFloat(this.getRuntime(), i * unit + beg));
            }
        } else {
            RubyNumeric i = this;
            int cmp = ((RubyBoolean)step.callMethod(context, MethodIndex.OP_GT, ">", RubyFixnum.zero(this.getRuntime()))).isTrue() ? MethodIndex.OP_GT : MethodIndex.OP_LT;
            String cmpString = MethodIndex.NAMES.get(cmp);
            while (!i.callMethod(context, cmp, cmpString, to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", step);
            }
        }
        return this;
    }

    @Override
    public IRubyObject op_equal(IRubyObject other) {
        if (this == other) {
            return this.getRuntime().getTrue();
        }
        return other.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.EQUALEQUAL, "==", this);
    }

    public static class NumberTooLargeException
    extends NumberFormatException {
        private static final long serialVersionUID = -1835120694982699449L;

        public NumberTooLargeException() {
        }

        public NumberTooLargeException(String message) {
            super(message);
        }
    }

    public static class InvalidIntegerException
    extends NumberFormatException {
        private static final long serialVersionUID = 55019452543252148L;

        public InvalidIntegerException() {
        }

        public InvalidIntegerException(String message) {
            super(message);
        }
    }
}

