/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.UnsupportedEncodingException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.regexp.RegexpMatcher;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyMatchData
extends RubyObject {
    public RegexpMatcher matcher;
    public static final int MATCH_BUSY = 64;

    public static RubyClass createMatchDataClass(Ruby runtime) {
        RubyClass matchDataClass = runtime.defineClass("MatchData", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setMatchData(matchDataClass);
        runtime.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyMatchData;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMatchData.class);
        matchDataClass.getMetaClass().undefineMethod("new");
        matchDataClass.defineAnnotatedMethods(RubyMatchData.class);
        matchDataClass.dispatcher = callbackFactory.createDispatcher(matchDataClass);
        return matchDataClass;
    }

    public RubyMatchData(Ruby runtime, RegexpMatcher matcher) {
        super(runtime, runtime.getMatchData());
        this.matcher = matcher;
    }

    public void use() {
        this.flags |= 0x40;
    }

    public final boolean used() {
        return (this.flags & 0x40) == 64;
    }

    @JRubyMethod(name={"captures"})
    public abstract IRubyObject captures();

    public IRubyObject subseq(long beg, long len) {
        if (beg < 0L || beg > this.getSize() || len < 0L) {
            this.getRuntime().getNil();
        }
        if (beg + len > this.getSize()) {
            len = this.getSize() - beg;
        }
        if (len < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return this.getRuntime().newArray();
        }
        RubyArray arr = RubyArray.newArray(this.getRuntime(), len);
        long j = beg + len;
        for (long i = beg; i < j; ++i) {
            arr.append(this.group(i));
        }
        return arr;
    }

    public long getSize() {
        return this.matcher.groupCount();
    }

    public boolean proceed() {
        boolean b = this.matcher.proceed();
        this.invalidateRegs();
        return b;
    }

    public boolean find() {
        boolean b = this.matcher.find();
        this.invalidateRegs();
        return b;
    }

    public void invalidateRegs() {
    }

    public abstract IRubyObject group(long var1);

    public int matchStartPosition() {
        return this.matcher.start();
    }

    public int matchEndPosition() {
        return this.matcher.end();
    }

    private boolean outOfBounds(long n) {
        return n < 0L || n >= this.getSize();
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        if (this.getMetaClass() != original.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyMatchData origMatchData = (RubyMatchData)original;
        this.matcher = origMatchData.matcher;
        return this;
    }

    @JRubyMethod(name={"[]"}, required=1, optional=1)
    public IRubyObject op_aref(IRubyObject[] args) {
        int argc = Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        if (argc == 2) {
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (beg < 0) {
                beg = (int)((long)beg + this.getSize());
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx = (int)((long)idx + this.getSize());
            }
            return this.group(idx);
        }
        if (args[0] instanceof RubyBignum) {
            throw this.getRuntime().newIndexError("index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getSize(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.group(RubyNumeric.num2long(args[0]));
    }

    @JRubyMethod(name={"begin"}, required=1)
    public IRubyObject begin(IRubyObject index) {
        int idx = RubyNumeric.num2int(index);
        if (idx < 0 || (long)idx >= this.getSize()) {
            throw this.getRuntime().newIndexError("index " + idx + " out of matches");
        }
        int answer = this.begin(idx);
        return answer == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public int begin(int index) {
        return this.outOfBounds(index) || !this.matcher.isCaptured(index) ? -1 : this.matcher.start(index);
    }

    @JRubyMethod(name={"end"}, required=1)
    public IRubyObject end(IRubyObject index) {
        int idx = RubyNumeric.num2int(index);
        if (idx < 0 || (long)idx >= this.getSize()) {
            throw this.getRuntime().newIndexError("index " + idx + " out of matches");
        }
        int answer = this.end(idx);
        return answer == -1 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(answer);
    }

    public int end(int index) {
        return this.outOfBounds(index) || !this.matcher.isCaptured(index) ? -1 : this.matcher.end(index);
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.anyToString();
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getSize());
    }

    @JRubyMethod(name={"values_at"}, required=1, rest=true)
    public IRubyObject values_at(IRubyObject[] args) {
        return this.to_a().values_at(args);
    }

    @JRubyMethod(name={"select"}, frame=true)
    public IRubyObject select(Block block) {
        return block.yield(this.getRuntime().getCurrentContext(), this.to_a());
    }

    @JRubyMethod(name={"offset"}, required=1)
    public IRubyObject offset(IRubyObject index) {
        int idx = RubyNumeric.num2int(index);
        if (idx < 0 || (long)idx >= this.getSize()) {
            throw this.getRuntime().newIndexError("index " + idx + " out of matches");
        }
        int beg = this.begin(idx);
        if (beg < 0) {
            return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().getNil(), this.getRuntime().getNil()});
        }
        return this.getRuntime().newArrayNoCopy(new IRubyObject[]{this.getRuntime().newFixnum(beg), this.getRuntime().newFixnum(this.end(idx))});
    }

    @JRubyMethod(name={"pre_match"})
    public abstract RubyString pre_match();

    @JRubyMethod(name={"post_match"})
    public abstract RubyString post_match();

    @JRubyMethod(name={"string"})
    public abstract RubyString string();

    @Override
    @JRubyMethod(name={"to_a"})
    public abstract RubyArray to_a();

    @Override
    @JRubyMethod(name={"to_s"})
    public abstract IRubyObject to_s();

    public abstract IRubyObject doClone();

    public static final class RString
    extends RubyMatchData {
        public RubyString original;
        private int len;
        private int[] start;
        private int[] end;

        public RString(Ruby runtime, RubyString original, RegexpMatcher matcher) {
            super(runtime, matcher);
            this.original = original;
            this.set();
        }

        public final void set() {
            this.original = (RubyString)this.original.strDup().freeze();
            this.invalidateRegs();
        }

        @Override
        public void invalidateRegs() {
            this.len = this.matcher.groupCount();
            if (this.start == null || this.start.length != this.len) {
                this.start = new int[this.len];
                this.end = new int[this.len];
            }
            for (int i = 0; i < this.len; ++i) {
                if (this.matcher.isCaptured(i)) {
                    this.start[i] = this.matcher.start(i);
                    this.end[i] = this.matcher.end(i);
                    continue;
                }
                this.start[i] = -1;
            }
        }

        @Override
        public long getSize() {
            return this.len;
        }

        private RubyArray match_array(int st) {
            RubyArray ary = RubyArray.newArray(this.getRuntime(), this.len);
            RubyString target = this.original;
            boolean taint = this.isTaint();
            for (int i = st; i < this.len; ++i) {
                if (this.start[i] == -1) {
                    ary.append(this.getRuntime().getNil());
                    continue;
                }
                RubyString str = target.makeShared(this.start[i], this.end[i] - this.start[i]);
                if (taint) {
                    str.setTaint(true);
                }
                ary.append(str);
            }
            return ary;
        }

        @Override
        public IRubyObject captures() {
            return this.match_array(1);
        }

        public IRubyObject nth_match(int nth) {
            if (nth >= this.len) {
                return this.getRuntime().getNil();
            }
            if (nth < 0 && (nth += this.len) <= 0) {
                return this.getRuntime().getNil();
            }
            if (this.start[nth] == -1) {
                return this.getRuntime().getNil();
            }
            int st = this.start[nth];
            int llen = this.end[nth] - st;
            RubyString str = this.original.makeShared(st, llen);
            str.infectBy(this);
            return str;
        }

        @Override
        public IRubyObject group(long _n) {
            int n = (int)_n;
            if (n < 0 || n >= this.len || this.start[n] == -1) {
                return this.getRuntime().getNil();
            }
            int st = this.start[n];
            int llen = this.end[n] - st;
            return this.original.makeShared(st, llen);
        }

        @Override
        public RubyString pre_match() {
            RubyString str = this.original.makeShared(0, this.start[0]);
            if (this.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public RubyString post_match() {
            RubyString str = this.original;
            int pos = this.end[0];
            str = str.makeShared(pos, str.getByteList().length() - pos);
            if (this.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public RubyString string() {
            return this.original;
        }

        @Override
        public RubyArray to_a() {
            return this.match_array(0);
        }

        private IRubyObject last_match() {
            return this.nth_match(0);
        }

        @Override
        public IRubyObject to_s() {
            IRubyObject str = this.last_match();
            if (str.isNil()) {
                str = this.getRuntime().newString();
            }
            if (this.isTaint()) {
                str.setTaint(true);
            }
            if (this.original.isTaint()) {
                str.setTaint(true);
            }
            return str;
        }

        @Override
        public IRubyObject doClone() {
            return new RString(this.getRuntime(), this.original, this.matcher);
        }

        @Override
        public int matchStartPosition() {
            return this.start[0];
        }

        @Override
        public int matchEndPosition() {
            return this.end[0];
        }
    }

    public static final class JavaString
    extends RubyMatchData {
        public String original;

        public JavaString(Ruby runtime, String original, RegexpMatcher matcher) {
            super(runtime, matcher);
            this.original = original;
        }

        @Override
        public IRubyObject captures() {
            RubyArray arr = this.getRuntime().newArray(this.matcher.groupCount());
            for (int i = 1; i < this.matcher.groupCount(); ++i) {
                if (this.matcher.group(i) == null) {
                    arr.append(this.getRuntime().getNil());
                    continue;
                }
                arr.append(RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(i)));
            }
            return arr;
        }

        @Override
        public IRubyObject group(long n) {
            if (n < 0L || n >= this.getSize() || this.matcher.group((int)n) == null) {
                return this.getRuntime().getNil();
            }
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.group((int)n));
        }

        @Override
        public RubyString pre_match() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.prefix());
        }

        @Override
        public RubyString post_match() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.suffix());
        }

        @Override
        public RubyString string() {
            RubyString frozenString = RubyString.newUnicodeString(this.getRuntime(), this.original);
            System.out.println(frozenString);
            frozenString.freeze();
            return frozenString;
        }

        @Override
        public RubyArray to_a() {
            RubyArray arr = this.getRuntime().newArray(this.matcher.groupCount());
            for (int i = 0; i < this.matcher.groupCount(); ++i) {
                if (this.matcher.group(i) == null) {
                    arr.append(this.getRuntime().getNil());
                    continue;
                }
                arr.append(RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(i)));
            }
            return arr;
        }

        @Override
        public IRubyObject to_s() {
            return RubyString.newUnicodeString(this.getRuntime(), this.matcher.group(0));
        }

        @Override
        public IRubyObject doClone() {
            return new JavaString(this.getRuntime(), this.original, this.matcher);
        }

        @Override
        public int matchStartPosition() {
            int position = 0;
            try {
                position = this.matcher.prefix().getBytes("UTF8").length;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return position;
        }
    }
}

