/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyIO;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyArgsFile
extends RubyObject {
    private IRubyObject currentFile;
    private int currentLineNumber;
    private boolean startedProcessing = false;
    private boolean finishedProcessing = false;

    public RubyArgsFile(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    public void setCurrentLineNumber(int newLineNumber) {
        this.currentLineNumber = newLineNumber;
    }

    public void initArgsFile() {
        this.getRuntime().getEnumerable().extend_object(this);
        this.getRuntime().defineReadonlyVariable("$<", this);
        this.getRuntime().defineGlobalConstant("ARGF", this);
        RubyClass argfClass = this.getMetaClass();
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        this.getRuntime().defineReadonlyVariable("$FILENAME", this.getRuntime().newString("-"));
    }

    protected boolean nextArgsFile() {
        if (this.finishedProcessing) {
            return false;
        }
        RubyArray args = (RubyArray)this.getRuntime().getGlobalVariables().get("$*");
        if (args.getLength() == 0) {
            if (!this.startedProcessing) {
                this.currentFile = this.getRuntime().getGlobalVariables().get("$stdin");
                ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer("-"));
                this.currentLineNumber = 0;
                this.startedProcessing = true;
                return true;
            }
            this.finishedProcessing = true;
            return false;
        }
        String filename = args.shift().toString();
        ((RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME")).setValue(new StringBuffer(filename));
        this.currentFile = filename.equals("-") ? this.getRuntime().getGlobalVariables().get("$stdin") : new RubyFile(this.getRuntime(), filename);
        this.startedProcessing = true;
        return true;
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public IRubyObject fileno() {
        if (!this.startedProcessing && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)this.currentFile).fileno();
    }

    @JRubyMethod(name={"to_io"})
    public IRubyObject to_io() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return this.currentFile;
    }

    public IRubyObject internalGets(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject line = this.currentFile.callMethod(context, "gets", args);
        while (line instanceof RubyNil) {
            this.currentFile.callMethod(context, "close");
            if (!this.nextArgsFile()) {
                this.currentFile = null;
                return line;
            }
            line = this.currentFile.callMethod(context, "gets", args);
        }
        ++this.currentLineNumber;
        this.getRuntime().getGlobalVariables().set("$.", this.getRuntime().newFixnum(this.currentLineNumber));
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1, frame=true)
    public IRubyObject gets(IRubyObject[] args) {
        IRubyObject result = this.internalGets(args);
        if (!result.isNil()) {
            this.getRuntime().getCurrentContext().getCurrentFrame().setLastLine(result);
        }
        return result;
    }

    @JRubyMethod(name={"readline"}, optional=1, frame=true)
    public IRubyObject readline(IRubyObject[] args) {
        IRubyObject line = this.gets(args);
        if (line.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject line;
        IRubyObject[] separatorArgument;
        if (args.length > 0) {
            if (!args[0].isKindOf(this.getRuntime().getNilClass()) && !args[0].isKindOf(this.getRuntime().getString())) {
                throw this.getRuntime().newTypeError(args[0], this.getRuntime().getString());
            }
            separatorArgument = new IRubyObject[]{args[0]};
        } else {
            separatorArgument = IRubyObject.NULL_ARRAY;
        }
        RubyArray result = this.getRuntime().newArray();
        while (!(line = this.internalGets(separatorArgument)).isNil()) {
            result.append(line);
        }
        return result;
    }

    @JRubyMethod(name={"each_byte"}, frame=true)
    public IRubyObject each_byte(Block block) {
        IRubyObject bt;
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        while (!(bt = this.getc()).isNil()) {
            block.yield(ctx, bt);
        }
        return this;
    }

    @JRubyMethod(name={"each_line"}, alias={"each"}, optional=1, frame=true)
    public IRubyObject each_line(IRubyObject[] args, Block block) {
        IRubyObject nextLine = this.internalGets(args);
        while (!nextLine.isNil()) {
            block.yield(this.getRuntime().getCurrentContext(), nextLine);
            nextLine = this.internalGets(args);
        }
        return this;
    }

    @JRubyMethod(name={"file"})
    public IRubyObject file() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this.getRuntime().getNil();
        }
        return this.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip() {
        this.currentFile = null;
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this;
        }
        this.currentFile = null;
        this.currentLineNumber = 0;
        return this;
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            return this;
        }
        return ((RubyIO)this.currentFile).closed_p();
    }

    @JRubyMethod(name={"binmode"})
    public IRubyObject binmode() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream");
        }
        return ((RubyIO)this.currentFile).binmode();
    }

    @JRubyMethod(name={"lineno"})
    public IRubyObject lineno() {
        return this.getRuntime().newFixnum(this.currentLineNumber);
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public IRubyObject tell() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)this.currentFile).pos();
    }

    @JRubyMethod(name={"rewind"})
    public IRubyObject rewind() {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to rewind");
        }
        return ((RubyIO)this.currentFile).rewind();
    }

    @JRubyMethod(name={"eof", "eof?"})
    public IRubyObject eof() {
        if (this.currentFile != null && !this.nextArgsFile()) {
            return this.getRuntime().getTrue();
        }
        return ((RubyIO)this.currentFile).eof_p();
    }

    @JRubyMethod(name={"pos="}, required=1)
    public IRubyObject set_pos(IRubyObject offset) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to set position");
        }
        return ((RubyIO)this.currentFile).pos_set(offset);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public IRubyObject seek(IRubyObject[] args) {
        if (this.currentFile == null && !this.nextArgsFile()) {
            throw this.getRuntime().newArgumentError("no stream to seek");
        }
        return ((RubyIO)this.currentFile).seek(args);
    }

    @JRubyMethod(name={"lineno="}, required=1)
    public IRubyObject set_lineno(IRubyObject line) {
        this.currentLineNumber = RubyNumeric.fix2int(line);
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"readchar"})
    public IRubyObject readchar() {
        IRubyObject c = this.getc();
        if (c.isNil()) {
            throw this.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public IRubyObject getc() {
        IRubyObject bt;
        while (true) {
            if (this.currentFile == null && !this.nextArgsFile()) {
                return this.getRuntime().getNil();
            }
            bt = !(this.currentFile instanceof RubyFile) ? this.currentFile.callMethod(this.getRuntime().getCurrentContext(), "getc") : ((RubyIO)this.currentFile).getc();
            if (!bt.isNil()) break;
            this.currentFile = null;
        }
        return bt;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public IRubyObject read(IRubyObject[] args) {
        IRubyObject str;
        IRubyObject length;
        long len = 0L;
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 2);
        if (args.length > 0) {
            length = args[0];
            str = args.length > 1 ? args[1] : this.getRuntime().getNil();
        } else {
            length = this.getRuntime().getNil();
            str = this.getRuntime().getNil();
        }
        if (!length.isNil()) {
            len = RubyNumeric.num2long(length);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args[1] = this.getRuntime().getNil();
        }
        while (true) {
            if (this.currentFile == null && !this.nextArgsFile()) {
                return str;
            }
            IRubyObject tmp = !(this.currentFile instanceof RubyIO) ? this.currentFile.callMethod(this.getRuntime().getCurrentContext(), "read", args) : ((RubyIO)this.currentFile).read(args);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length.isNil()) {
                this.currentFile = null;
                continue;
            }
            if (args.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args[0] = this.getRuntime().newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public RubyString filename() {
        return (RubyString)this.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.getRuntime().newString("ARGF");
    }
}

