/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jregex.Bitset;
import jregex.PatternSyntaxException;
import jregex.Term;
import jregex.UnicodeConstants;

class CharacterClass
extends Term
implements UnicodeConstants {
    static final Bitset DIGIT = new Bitset();
    static final Bitset WORDCHAR = new Bitset();
    static final Bitset SPACE = new Bitset();
    static final Bitset UDIGIT = new Bitset();
    static final Bitset UWORDCHAR = new Bitset();
    static final Bitset USPACE = new Bitset();
    static final Bitset NONDIGIT = new Bitset();
    static final Bitset NONWORDCHAR = new Bitset();
    static final Bitset NONSPACE = new Bitset();
    static final Bitset UNONDIGIT = new Bitset();
    static final Bitset UNONWORDCHAR = new Bitset();
    static final Bitset UNONSPACE = new Bitset();
    private static boolean namesInitialized = false;
    static final Hashtable namedClasses = new Hashtable();
    static final Vector unicodeBlocks = new Vector();
    static final Vector posixClasses = new Vector();
    static final Vector unicodeCategories = new Vector();
    private static final int ADD = 1;
    private static final int SUBTRACT = 2;
    private static final int INTERSECT = 3;
    private static final String blockData = "0000..007F:InBasicLatin;0080..00FF:InLatin-1Supplement;0100..017F:InLatinExtended-A;0180..024F:InLatinExtended-B;0250..02AF:InIPAExtensions;02B0..02FF:InSpacingModifierLetters;0300..036F:InCombiningDiacriticalMarks;0370..03FF:InGreek;0400..04FF:InCyrillic;0530..058F:InArmenian;0590..05FF:InHebrew;0600..06FF:InArabic;0700..074F:InSyriac;0780..07BF:InThaana;0900..097F:InDevanagari;0980..09FF:InBengali;0A00..0A7F:InGurmukhi;0A80..0AFF:InGujarati;0B00..0B7F:InOriya;0B80..0BFF:InTamil;0C00..0C7F:InTelugu;0C80..0CFF:InKannada;0D00..0D7F:InMalayalam;0D80..0DFF:InSinhala;0E00..0E7F:InThai;0E80..0EFF:InLao;0F00..0FFF:InTibetan;1000..109F:InMyanmar;10A0..10FF:InGeorgian;1100..11FF:InHangulJamo;1200..137F:InEthiopic;13A0..13FF:InCherokee;1400..167F:InUnifiedCanadianAboriginalSyllabics;1680..169F:InOgham;16A0..16FF:InRunic;1780..17FF:InKhmer;1800..18AF:InMongolian;1E00..1EFF:InLatinExtendedAdditional;1F00..1FFF:InGreekExtended;2000..206F:InGeneralPunctuation;2070..209F:InSuperscriptsAndSubscripts;20A0..20CF:InCurrencySymbols;20D0..20FF:InCombiningMarksForSymbols;2100..214F:InLetterLikeSymbols;2150..218F:InNumberForms;2190..21FF:InArrows;2200..22FF:InMathematicalOperators;2300..23FF:InMiscellaneousTechnical;2400..243F:InControlPictures;2440..245F:InOpticalCharacterRecognition;2460..24FF:InEnclosedAlphanumerics;2500..257F:InBoxDrawing;2580..259F:InBlockElements;25A0..25FF:InGeometricShapes;2600..26FF:InMiscellaneousSymbols;2700..27BF:InDingbats;2800..28FF:InBraillePatterns;2E80..2EFF:InCJKRadicalsSupplement;2F00..2FDF:InKangxiRadicals;2FF0..2FFF:InIdeographicDescriptionCharacters;3000..303F:InCJKSymbolsAndPunctuation;3040..309F:InHiragana;30A0..30FF:InKatakana;3100..312F:InBopomofo;3130..318F:InHangulCompatibilityJamo;3190..319F:InKanbun;31A0..31BF:InBopomofoExtended;3200..32FF:InEnclosedCJKLettersAndMonths;3300..33FF:InCJKCompatibility;3400..4DB5:InCJKUnifiedIdeographsExtensionA;4E00..9FFF:InCJKUnifiedIdeographs;A000..A48F:InYiSyllables;A490..A4CF:InYiRadicals;AC00..D7A3:InHangulSyllables;D800..DB7F:InHighSurrogates;DB80..DBFF:InHighPrivateUseSurrogates;DC00..DFFF:InLowSurrogates;E000..F8FF:InPrivateUse;F900..FAFF:InCJKCompatibilityIdeographs;FB00..FB4F:InAlphabeticPresentationForms;FB50..FDFF:InArabicPresentationForms-A;FE20..FE2F:InCombiningHalfMarks;FE30..FE4F:InCJKCompatibilityForms;FE50..FE6F:InSmallFormVariants;FE70..FEFE:InArabicPresentationForms-B;FEFF..FEFF:InSpecials;FF00..FFEF:InHalfWidthAndFullWidthForms;FFF0..FFFD:InSpecials";

    CharacterClass() {
    }

    private static void registerClass(String name, Bitset cls, Vector realm) {
        namedClasses.put(name, cls);
        if (!realm.contains(name)) {
            realm.addElement(name);
        }
    }

    private static void initPosixClasses() {
        Bitset lower = new Bitset();
        lower.setRange('a', 'z');
        CharacterClass.registerClass("Lower", lower, posixClasses);
        Bitset upper = new Bitset();
        upper.setRange('A', 'Z');
        CharacterClass.registerClass("Upper", upper, posixClasses);
        Bitset ascii = new Bitset();
        ascii.setRange('\u0000', '\u007f');
        CharacterClass.registerClass("ASCII", ascii, posixClasses);
        Bitset alpha = new Bitset();
        alpha.add(lower);
        alpha.add(upper);
        CharacterClass.registerClass("Alpha", alpha, posixClasses);
        Bitset digit = new Bitset();
        digit.setRange('0', '9');
        CharacterClass.registerClass("Digit", digit, posixClasses);
        Bitset alnum = new Bitset();
        alnum.add(alpha);
        alnum.add(digit);
        CharacterClass.registerClass("Alnum", alnum, posixClasses);
        Bitset punct = new Bitset();
        punct.setChars("!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~");
        CharacterClass.registerClass("Punct", punct, posixClasses);
        Bitset graph = new Bitset();
        graph.add(alnum);
        graph.add(punct);
        CharacterClass.registerClass("Graph", graph, posixClasses);
        CharacterClass.registerClass("Print", graph, posixClasses);
        Bitset blank = new Bitset();
        blank.setChars(" \t");
        CharacterClass.registerClass("Blank", blank, posixClasses);
        Bitset cntrl = new Bitset();
        cntrl.setRange('\u0000', '\u001f');
        cntrl.setChar('\u007f');
        CharacterClass.registerClass("Cntrl", cntrl, posixClasses);
        Bitset xdigit = new Bitset();
        xdigit.setRange('0', '9');
        xdigit.setRange('a', 'f');
        xdigit.setRange('A', 'F');
        CharacterClass.registerClass("XDigit", xdigit, posixClasses);
        Bitset space = new Bitset();
        space.setChars(" \t\n\r\f\u000b");
        CharacterClass.registerClass("Space", space, posixClasses);
    }

    private static void initNames() {
        CharacterClass.initNamedCategory("C", new int[]{0, 15, 16, 18, 19});
        CharacterClass.initNamedCategory("Cn", 0);
        CharacterClass.initNamedCategory("Cc", 15);
        CharacterClass.initNamedCategory("Cf", 16);
        CharacterClass.initNamedCategory("Co", 18);
        CharacterClass.initNamedCategory("Cs", 19);
        CharacterClass.initNamedCategory("L", new int[]{1, 2, 3, 4, 5});
        CharacterClass.initNamedCategory("Lu", 1);
        CharacterClass.initNamedCategory("Ll", 2);
        CharacterClass.initNamedCategory("Lt", 3);
        CharacterClass.initNamedCategory("Lm", 4);
        CharacterClass.initNamedCategory("Lo", 5);
        CharacterClass.initNamedCategory("M", new int[]{6, 7, 8});
        CharacterClass.initNamedCategory("Mn", 6);
        CharacterClass.initNamedCategory("Me", 7);
        CharacterClass.initNamedCategory("Mc", 8);
        CharacterClass.initNamedCategory("N", new int[]{9, 10, 11});
        CharacterClass.initNamedCategory("Nd", 9);
        CharacterClass.initNamedCategory("Nl", 10);
        CharacterClass.initNamedCategory("No", 11);
        CharacterClass.initNamedCategory("Z", new int[]{12, 13, 14});
        CharacterClass.initNamedCategory("Zs", 12);
        CharacterClass.initNamedCategory("Zl", 13);
        CharacterClass.initNamedCategory("Zp", 14);
        CharacterClass.initNamedCategory("P", new int[]{20, 21, 21, 22, 22, 23, 24});
        CharacterClass.initNamedCategory("Pd", 20);
        CharacterClass.initNamedCategory("Ps", 21);
        CharacterClass.initNamedCategory("Pi", 21);
        CharacterClass.initNamedCategory("Pe", 22);
        CharacterClass.initNamedCategory("Pf", 22);
        CharacterClass.initNamedCategory("Pc", 23);
        CharacterClass.initNamedCategory("Po", 24);
        CharacterClass.initNamedCategory("S", new int[]{25, 26, 27, 28});
        CharacterClass.initNamedCategory("Sm", 25);
        CharacterClass.initNamedCategory("Sc", 26);
        CharacterClass.initNamedCategory("Sk", 27);
        CharacterClass.initNamedCategory("So", 28);
        Bitset bs = new Bitset();
        bs.setCategory(0);
        CharacterClass.registerClass("UNASSIGNED", bs, unicodeCategories);
        bs = new Bitset();
        bs.setCategory(0);
        bs.setPositive(false);
        CharacterClass.registerClass("ASSIGNED", bs, unicodeCategories);
        StringTokenizer st = new StringTokenizer(blockData, ".,:;");
        while (st.hasMoreTokens()) {
            try {
                int first = Integer.parseInt(st.nextToken(), 16);
                int last = Integer.parseInt(st.nextToken(), 16);
                String name = st.nextToken();
                CharacterClass.initNamedBlock(name, first, last);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CharacterClass.initNamedBlock("ALL", 0, 65535);
        namesInitialized = true;
    }

    private static void initNamedBlock(String name, int first, int last) {
        if (first < 0 || first > 65535) {
            throw new IllegalArgumentException("wrong start code (" + first + ") in block " + name);
        }
        if (last < 0 || last > 65535) {
            throw new IllegalArgumentException("wrong end code (" + last + ") in block " + name);
        }
        if (last < first) {
            throw new IllegalArgumentException("end code < start code in block " + name);
        }
        Bitset bs = (Bitset)namedClasses.get(name);
        if (bs == null) {
            bs = new Bitset();
            CharacterClass.registerClass(name, bs, unicodeBlocks);
        }
        bs.setRange((char)first, (char)last);
    }

    private static void initNamedCategory(String name, int cat) {
        Bitset bs = new Bitset();
        bs.setCategory(cat);
        CharacterClass.registerClass(name, bs, unicodeCategories);
    }

    private static void initNamedCategory(String name, int[] cats) {
        Bitset bs = new Bitset();
        for (int i = 0; i < cats.length; ++i) {
            bs.setCategory(cats[i]);
        }
        namedClasses.put(name, bs);
    }

    private static Bitset getNamedClass(String name) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        return (Bitset)namedClasses.get(name);
    }

    static void makeICase(Term term, char c) {
        Bitset bs = new Bitset();
        bs.setChar(Character.toLowerCase(c));
        bs.setChar(Character.toUpperCase(c));
        bs.setChar(Character.toTitleCase(c));
        Bitset.unify(bs, term);
    }

    static void makeDigit(Term term, boolean inverse, boolean unicode) {
        Bitset digit = unicode ? (inverse ? UNONDIGIT : UDIGIT) : (inverse ? NONDIGIT : DIGIT);
        Bitset.unify(digit, term);
    }

    static void makeSpace(Term term, boolean inverse, boolean unicode) {
        Bitset space = unicode ? (inverse ? UNONSPACE : USPACE) : (inverse ? NONSPACE : SPACE);
        Bitset.unify(space, term);
    }

    static void makeWordChar(Term term, boolean inverse, boolean unicode) {
        Bitset wordChar = unicode ? (inverse ? UNONWORDCHAR : UWORDCHAR) : (inverse ? NONWORDCHAR : WORDCHAR);
        Bitset.unify(wordChar, term);
    }

    static void makeWordBoundary(Term term, boolean inverse, boolean unicode) {
        CharacterClass.makeWordChar(term, inverse, unicode);
        term.type = unicode ? 13 : 11;
    }

    static void makeWordStart(Term term, boolean unicode) {
        CharacterClass.makeWordChar(term, false, unicode);
        term.type = unicode ? 14 : 12;
    }

    static void makeWordEnd(Term term, boolean unicode) {
        CharacterClass.makeWordChar(term, true, unicode);
        term.type = unicode ? 14 : 12;
    }

    static final void parseGroup(char[] data, int i, int out, Term term, boolean icase, boolean skipspaces, boolean unicode, boolean xml) throws PatternSyntaxException {
        Bitset sum = new Bitset();
        Bitset bs = new Bitset();
        int mode = 1;
        block12: while (i < out) {
            char c = data[i++];
            switch (c) {
                case '+': {
                    mode = 1;
                    continue block12;
                }
                case '-': {
                    mode = 2;
                    continue block12;
                }
                case '&': {
                    mode = 3;
                    continue block12;
                }
                case '[': {
                    bs.reset();
                    i = CharacterClass.parseClass(data, i, out, bs, icase, skipspaces, unicode, xml);
                    switch (mode) {
                        case 1: {
                            sum.add(bs);
                            break;
                        }
                        case 2: {
                            sum.subtract(bs);
                            break;
                        }
                        case 3: {
                            sum.intersect(bs);
                        }
                    }
                    continue block12;
                }
                case ')': {
                    throw new PatternSyntaxException("unbalanced class group");
                }
            }
        }
        Bitset.unify(sum, term);
    }

    static final int parseClass(char[] data, int i, int out, Term term, boolean icase, boolean skipspaces, boolean unicode, boolean xml) throws PatternSyntaxException {
        Bitset bs = new Bitset();
        i = CharacterClass.parseClass(data, i, out, bs, icase, skipspaces, unicode, xml);
        Bitset.unify(bs, term);
        return i;
    }

    static final int parseName(char[] data, int i, int out, Term term, boolean inverse, boolean skipspaces) throws PatternSyntaxException {
        StringBuffer sb = new StringBuffer();
        i = CharacterClass.parseName(data, i, out, sb, skipspaces);
        Bitset bs = CharacterClass.getNamedClass(sb.toString());
        if (bs == null) {
            throw new PatternSyntaxException("unknown class: {" + sb + "}");
        }
        Bitset.unify(bs, term);
        term.inverse = inverse;
        return i;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final int parseClass(char[] data, int i, int out, Bitset bs, boolean icase, boolean skipspaces, boolean unicode, boolean xml) throws PatternSyntaxException {
        prev = '\uffffffff';
        isFirst = true;
        setFirst = false;
        inRange = false;
        bs1 = null;
        sb = null;
        while (i < out) {
            c = data[i++];
            block0 : switch (c) {
                case ']': {
                    if (!isFirst) {
                        if (inRange) {
                            bs.setChar('-');
                        }
                        if (prev >= '\u0000') {
                            c1 = prev;
                            if (icase) {
                                bs.setChar(Character.toLowerCase(c1));
                                bs.setChar(Character.toUpperCase(c1));
                                bs.setChar(Character.toTitleCase(c1));
                            } else {
                                bs.setChar(c1);
                            }
                        }
                        return i;
                    }
                    ** GOTO lbl163
                }
                case '-': {
                    if (!isFirst && !inRange) {
                        inRange = true;
                        break;
                    }
                    ** GOTO lbl163
                }
                case '[': {
                    if (inRange && xml) {
                        if (prev >= '\u0000') {
                            bs.setChar(prev);
                        }
                        if (bs1 == null) {
                            bs1 = new Bitset();
                        } else {
                            bs1.reset();
                        }
                        i = CharacterClass.parseClass(data, i, out, bs1, icase, skipspaces, unicode, xml);
                        bs.subtract(bs1);
                        inRange = false;
                        prev = '\uffffffff';
                        break;
                    }
                    ** GOTO lbl163
                }
                case '^': {
                    if (isFirst) {
                        bs.setPositive(false);
                        setFirst = true;
                        break;
                    }
                    ** GOTO lbl163
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (skipspaces) {
                        break;
                    }
                    ** GOTO lbl163
                }
                case '\\': {
                    negatigeClass = null;
                    inv = false;
                    c = data[i++];
                    switch (c) {
                        case 'r': {
                            c = '\r';
                            ** GOTO lbl163
                        }
                        case 'n': {
                            c = '\n';
                            ** GOTO lbl163
                        }
                        case 'e': {
                            c = '\u001b';
                            ** GOTO lbl163
                        }
                        case 't': {
                            c = '\t';
                            ** GOTO lbl163
                        }
                        case 'f': {
                            c = '\f';
                            ** GOTO lbl163
                        }
                        case 'u': {
                            if (i >= out - 4) {
                                throw new PatternSyntaxException("incomplete escape sequence \\uXXXX");
                            }
                            c = (char)((CharacterClass.toHexDigit(c) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                            ** GOTO lbl163
                        }
                        case 'v': {
                            c = (char)((CharacterClass.toHexDigit(c) << 24) + (CharacterClass.toHexDigit(data[i++]) << 16) + (CharacterClass.toHexDigit(data[i++]) << 12) + (CharacterClass.toHexDigit(data[i++]) << 8) + (CharacterClass.toHexDigit(data[i++]) << 4) + CharacterClass.toHexDigit(data[i++]));
                            ** GOTO lbl163
                        }
                        case 'b': {
                            c = '\b';
                            ** GOTO lbl163
                        }
                        case 'x': {
                            hex = 0;
                            d = data[i++];
                            if (d == '{') {
                                while ((d = data[i++]) != '}') {
                                    hex = (hex << 4) + CharacterClass.toHexDigit(d);
                                }
                                if (hex > 65535) {
                                    throw new PatternSyntaxException("\\x{<out of range>}");
                                }
                            } else {
                                hex = (CharacterClass.toHexDigit(d) << 4) + CharacterClass.toHexDigit(data[i++]);
                            }
                            c = (char)hex;
                            ** GOTO lbl163
                        }
                        case '0': 
                        case 'o': {
                            oct = 0;
                            while ((d = data[i++]) >= '0' && d <= '7') {
                                oct *= 8;
                                if ((oct += d - 48) <= 65535) continue;
                                ** GOTO lbl104
                            }
                            --i;
lbl104:
                            // 2 sources

                            c = (char)oct;
                            ** GOTO lbl163
                        }
                        case 'm': {
                            dec = 0;
                            while ((d = data[i++]) >= '0' && d <= '9') {
                                dec *= 10;
                                if ((dec += d - 48) <= 65535) continue;
                                ** GOTO lbl113
                            }
                            --i;
lbl113:
                            // 2 sources

                            c = (char)dec;
                            ** GOTO lbl163
                        }
                        case 'c': {
                            c = (char)(data[i++] & 31);
                            ** GOTO lbl163
                        }
                        case 'D': {
                            negatigeClass = unicode != false ? CharacterClass.UNONDIGIT : CharacterClass.NONDIGIT;
                            break;
                        }
                        case 'S': {
                            negatigeClass = unicode != false ? CharacterClass.UNONSPACE : CharacterClass.NONSPACE;
                            break;
                        }
                        case 'W': {
                            negatigeClass = unicode != false ? CharacterClass.UNONWORDCHAR : CharacterClass.NONWORDCHAR;
                            break;
                        }
                        case 'd': {
                            if (inRange) {
                                throw new PatternSyntaxException("illegal range: [..." + prev + "-\\d...]");
                            }
                            bs.setDigit(unicode);
                            break block0;
                        }
                        case 's': {
                            if (inRange) {
                                throw new PatternSyntaxException("illegal range: [..." + prev + "-\\s...]");
                            }
                            bs.setSpace(unicode);
                            break block0;
                        }
                        case 'w': {
                            if (inRange) {
                                throw new PatternSyntaxException("illegal range: [..." + prev + "-\\w...]");
                            }
                            bs.setWordChar(unicode);
                            break block0;
                        }
                        case 'P': {
                            inv = true;
                        }
                        case 'p': {
                            if (inRange) {
                                throw new PatternSyntaxException("illegal range: [..." + prev + "-\\w...]");
                            }
                            if (sb == null) {
                                sb = new StringBuffer();
                            } else {
                                sb.setLength(0);
                            }
                            i = CharacterClass.parseName(data, i, out, sb, skipspaces);
                            nc = CharacterClass.getNamedClass(sb.toString());
                            if (nc == null) {
                                throw new PatternSyntaxException("unknown named class: {" + sb + "}");
                            }
                            bs.add(nc, inv);
                            break block0;
                        }
                        default: {
                            ** GOTO lbl163
                        }
                    }
                    if (inRange) {
                        throw new PatternSyntaxException("illegal range: [..." + prev + "-\\" + c + "...]");
                    }
                    bs.add(negatigeClass);
                    break;
                }
lbl163:
                // 19 sources

                default: {
                    if (prev < '\u0000') {
                        prev = c;
                        inRange = false;
                        break;
                    }
                    if (!inRange) {
                        c1 = prev;
                        if (icase) {
                            bs.setChar(Character.toLowerCase(c1));
                            bs.setChar(Character.toUpperCase(c1));
                            bs.setChar(Character.toTitleCase(c1));
                        } else {
                            bs.setChar(c1);
                        }
                        prev = c;
                        break;
                    }
                    if (prev > c) {
                        throw new PatternSyntaxException("illegal range: " + prev + ">" + c);
                    }
                    c0 = prev;
                    inRange = false;
                    prev = '\uffffffff';
                    if (icase) {
                        bs.setRange(Character.toLowerCase(c0), Character.toLowerCase(c));
                        bs.setRange(Character.toUpperCase(c0), Character.toUpperCase(c));
                        bs.setRange(Character.toTitleCase(c0), Character.toTitleCase(c));
                        break;
                    }
                    bs.setRange(c0, c);
                }
            }
            isFirst = setFirst;
            setFirst = false;
        }
        throw new PatternSyntaxException("unbalanced brackets in a class def");
    }

    static final int parseName(char[] data, int i, int out, StringBuffer sb, boolean skipspaces) throws PatternSyntaxException {
        int start = -1;
        block5: while (i < out) {
            char c = data[i++];
            switch (c) {
                case '{': {
                    start = i;
                    continue block5;
                }
                case '}': {
                    return i;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!skipspaces) break;
                    continue block5;
                }
            }
            if (start < 0) {
                throw new PatternSyntaxException("named class doesn't start with '{'");
            }
            sb.append(c);
        }
        throw new PatternSyntaxException("wrong class name: " + new String(data, i, out - i));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String stringValue0(boolean[] arr) {
        StringBuffer b = new StringBuffer();
        int c = 0;
        while (true) {
            if (!arr[c]) {
                if (++c < 255) continue;
                return b.toString();
            }
            int first = c;
            while (arr[c] && ++c <= 255) {
            }
            int last = c - 1;
            if (last == first) {
                b.append(CharacterClass.stringValue(last));
            } else {
                b.append(CharacterClass.stringValue(first));
                b.append('-');
                b.append(CharacterClass.stringValue(last));
            }
            if (c > 255) return b.toString();
        }
    }

    static String stringValue2(boolean[][] arr) {
        StringBuffer b;
        block4: {
            b = new StringBuffer();
            int c = 0;
            do {
                boolean[] marks;
                boolean[] marks2;
                boolean marked = false;
                while ((marks2 = arr[c >> 8]) == null || !marks2[c & 0xFF]) {
                    if (++c <= 65535) continue;
                    break block4;
                }
                int first = c;
                while (c <= 65535 && (marks = arr[c >> 8]) != null && marks[c & 0xFF]) {
                    ++c;
                }
                int last = c - 1;
                if (last == first) {
                    b.append(CharacterClass.stringValue(last));
                    continue;
                }
                b.append(CharacterClass.stringValue(first));
                b.append('-');
                b.append(CharacterClass.stringValue(last));
            } while (c <= 65535);
        }
        return b.toString();
    }

    static String stringValue(int c) {
        StringBuffer b = new StringBuffer(5);
        if (c < 32) {
            switch (c) {
                case 13: {
                    b.append("\\r");
                    break;
                }
                case 10: {
                    b.append("\\n");
                    break;
                }
                case 9: {
                    b.append("\\t");
                    break;
                }
                case 12: {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append('(');
                    b.append(c);
                    b.append(')');
                    break;
                }
            }
        } else if (c < 256) {
            b.append((char)c);
        } else {
            b.append('\\');
            b.append('x');
            b.append(Integer.toHexString(c));
        }
        return b.toString();
    }

    static int toHexDigit(char d) throws PatternSyntaxException {
        int val = 0;
        if (d >= '0' && d <= '9') {
            val = d - 48;
        } else if (d >= 'a' && d <= 'f') {
            val = 10 + d - 97;
        } else if (d >= 'A' && d <= 'F') {
            val = 10 + d - 65;
        } else {
            throw new PatternSyntaxException("hexadecimal digit expected: " + d);
        }
        return val;
    }

    public static void main(String[] args) {
        if (!namesInitialized) {
            CharacterClass.initNames();
        }
        if (args.length == 0) {
            System.out.println("Class usage: \\p{Class},\\P{Class}");
            CharacterClass.printRealm(posixClasses, "Posix classes");
            CharacterClass.printRealm(unicodeCategories, "Unicode categories");
            CharacterClass.printRealm(unicodeBlocks, "Unicode blocks");
        } else {
            for (int i = 0; i < args.length; ++i) {
                System.out.print(args[i]);
                System.out.print(": ");
                System.out.println(namedClasses.containsKey(args[i]) ? "supported" : "not supported");
            }
        }
    }

    private static void printRealm(Vector realm, String name) {
        System.out.println(name + ":");
        Enumeration e = realm.elements();
        while (e.hasMoreElements()) {
            System.out.println("  " + e.nextElement());
        }
    }

    static {
        DIGIT.setDigit(false);
        WORDCHAR.setWordChar(false);
        SPACE.setSpace(false);
        UDIGIT.setDigit(true);
        UWORDCHAR.setWordChar(true);
        USPACE.setSpace(true);
        NONDIGIT.setDigit(false);
        NONDIGIT.setPositive(false);
        NONWORDCHAR.setWordChar(false);
        NONWORDCHAR.setPositive(false);
        NONSPACE.setSpace(false);
        NONSPACE.setPositive(false);
        UNONDIGIT.setDigit(true);
        UNONDIGIT.setPositive(false);
        UNONWORDCHAR.setWordChar(true);
        UNONWORDCHAR.setPositive(false);
        UNONSPACE.setSpace(true);
        UNONSPACE.setPositive(false);
        CharacterClass.initPosixClasses();
    }
}

