/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.Reader;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOReader
extends Reader {
    private IRubyObject io;

    public IOReader(IRubyObject io) {
        if (!io.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = io;
    }

    @Override
    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.io.callMethod(this.io.getRuntime().getCurrentContext(), "close");
        }
    }

    @Override
    public int read(char[] arr, int off, int len) {
        IRubyObject read = this.io.callMethod(this.io.getRuntime().getCurrentContext(), "read", this.io.getRuntime().newFixnum(len));
        if (read.isNil() || ((RubyString)read).getByteList().realSize == 0) {
            return -1;
        }
        RubyString str = (RubyString)read;
        ByteList val = str.getByteList();
        System.arraycopy(ByteList.plain(val.bytes, val.begin, val.realSize), 0, arr, off, val.realSize);
        return val.realSize;
    }
}

