/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private IRubyObject io;
    private CallSite writeAdapter;
    private CallSite closeAdapter = new CallSite.InlineCachingCallSite("close", CallType.FUNCTIONAL);

    public IOOutputStream(IRubyObject io) {
        if (io.respondsTo("write")) {
            this.writeAdapter = new CallSite.InlineCachingCallSite("write", CallType.FUNCTIONAL);
        } else if (io.respondsTo("<<")) {
            this.writeAdapter = new CallSite.InlineCachingCallSite("<<", CallType.FUNCTIONAL);
        } else {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    @Override
    public void write(int bite) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    @Override
    public void close() throws IOException {
        this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io);
    }
}

