/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class TwoVarDynamicScope
extends DynamicScope {
    private IRubyObject variableValueZero;
    private IRubyObject variableValueOne;

    public TwoVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public TwoVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 2) {
            throw new RuntimeException("TwoVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    @Override
    public DynamicScope cloneScope() {
        return new TwoVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueZero == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return this.variableValueZero;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueOne == null) {
            this.variableValueOne = nil;
            return this.variableValueOne;
        }
        return this.variableValueOne;
    }

    @Override
    public void setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
        } else {
            assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
            switch (offset) {
                case 0: {
                    this.variableValueZero = value;
                }
                case 1: {
                    this.variableValueOne = value;
                }
            }
            throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
        }
        this.parent.setValue(offset, value, depth - 1);
    }

    @Override
    public void setValueDepthZero(IRubyObject value, int offset) {
        assert (offset < 2) : "TwoVarDynamicScope only supports scopes with two variables";
        switch (offset) {
            case 0: {
                this.variableValueZero = value;
            }
            case 1: {
                this.variableValueOne = value;
            }
        }
        throw new RuntimeException("TwoVarDynamicScope only supports scopes with two variables");
    }

    @Override
    public void setValueZeroDepthZero(IRubyObject value) {
        this.variableValueZero = value;
    }

    @Override
    public void setValueOneDepthZero(IRubyObject value) {
        this.variableValueOne = value;
    }

    @Override
    public void setArgValues(IRubyObject[] values, int size) {
        assert (values.length == 2) : "TwoVarDynamicScope only supports scopes with two variables";
        this.variableValueZero = values[0];
        this.variableValueZero = values[1];
    }

    @Override
    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 2) : "TwoVarDynamicScope only supports scopes with two variables";
        if (this.staticScope.getRestArg() < 0) {
            if (totalArgs == 1) {
                return new IRubyObject[]{this.variableValueZero, this.variableValueOne};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = ASTInterpreter.splatValue(restArg.getRuntime(), restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        return argValues;
    }

    @Override
    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names = this.staticScope.getVariables();
        buf.append(names[0]).append("=");
        if (this.variableValueZero == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueZero);
        }
        buf.append(",");
        if (this.variableValueOne == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValueOne);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

