/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaCallable
extends JavaAccessibleObject
implements ParameterTypes {
    public JavaCallable(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaCallable.class);
        result.defineFastMethod("public?", callbackFactory.getFastMethod("public_p"));
        result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
        result.defineFastMethod("parameter_types", callbackFactory.getFastMethod("parameter_types"));
        result.defineFastMethod("exception_types", callbackFactory.getFastMethod("exception_types"));
        result.defineFastMethod("generic_parameter_types", callbackFactory.getFastMethod("generic_parameter_types"));
        result.defineFastMethod("generic_exception_types", callbackFactory.getFastMethod("generic_exception_types"));
        result.defineFastMethod("parameter_annotations", callbackFactory.getFastMethod("parameter_annotations"));
        result.defineFastMethod("varargs?", callbackFactory.getFastMethod("varargs_p"));
        result.defineFastMethod("to_generic_string", callbackFactory.getFastMethod("to_generic_string"));
        result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
    }

    public abstract int getArity();

    public abstract int getModifiers();

    @Override
    public abstract Class<?>[] getParameterTypes();

    @Override
    public abstract Class<?>[] getExceptionTypes();

    public abstract Type[] getGenericExceptionTypes();

    public abstract Type[] getGenericParameterTypes();

    public abstract Annotation[][] getParameterAnnotations();

    @Override
    public abstract boolean isVarArgs();

    public abstract String toGenericString();

    protected abstract String nameOnInspection();

    public final RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getArity());
    }

    public final RubyArray argument_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    public IRubyObject parameter_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getParameterTypes());
    }

    public IRubyObject exception_types() {
        return JavaClass.getRubyArray(this.getRuntime(), this.getExceptionTypes());
    }

    public IRubyObject generic_parameter_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericParameterTypes());
    }

    public IRubyObject generic_exception_types() {
        return Java.getInstance(this.getRuntime(), this.getGenericExceptionTypes());
    }

    public IRubyObject parameter_annotations() {
        return Java.getInstance(this.getRuntime(), this.getParameterAnnotations());
    }

    public RubyBoolean varargs_p() {
        return this.getRuntime().newBoolean(this.isVarArgs());
    }

    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.toGenericString());
    }

    @Override
    public IRubyObject inspect() {
        StringBuffer result = new StringBuffer();
        result.append(this.nameOnInspection());
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(parameterTypes[i].getName());
            if (i >= parameterTypes.length - 1) continue;
            result.append(',');
        }
        result.append(")>");
        return this.getRuntime().newString(result.toString());
    }

    public RubyBoolean public_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), Modifier.isPublic(this.getModifiers()));
    }
}

