/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.IANA;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.RubyTCPServer;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.RubyUNIXServer;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySocket(runtime, klass);
        }
    };
    public static final int NI_DGRAM = 16;
    public static final int NI_MAXHOST = 1025;
    public static final int NI_MAXSERV = 32;
    public static final int NI_NAMEREQD = 4;
    public static final int NI_NOFQDN = 1;
    public static final int NI_NUMERICHOST = 2;
    public static final int NI_NUMERICSERV = 8;
    public static final int SOL_IP = 0;
    public static final int SOL_SOCKET = 65535;
    public static final int SOL_TCP = 6;
    public static final int SOL_UDP = 17;
    public static final int SO_BROADCAST = 32;
    public static final int SO_DEBUG = 1;
    public static final int SO_DONTROUTE = 16;
    public static final int SO_ERROR = 4103;
    public static final int SO_KEEPALIVE = 8;
    public static final int SO_LINGER = 128;
    public static final int SO_OOBINLINE = 256;
    public static final int SO_RCVBUF = 4098;
    public static final int SO_RCVLOWAT = 4100;
    public static final int SO_RCVTIMEO = 4102;
    public static final int SO_REUSEADDR = 4;
    public static final int SO_SNDBUF = 4097;
    public static final int SO_SNDLOWAT = 4099;
    public static final int SO_SNDTIMEO = 4101;
    public static final int SO_TIMESTAMP = 1024;
    public static final int SO_TYPE = 4104;
    public static final int SOCK_STREAM = 1;
    public static final int SOCK_DGRAM = 2;
    public static final int SOCK_RAW = 3;
    public static final int AF_UNSPEC = 0;
    public static final int PF_UNSPEC = 0;
    public static final int AF_UNIX = 1;
    public static final int PF_UNIX = 1;
    public static final int AF_INET = 2;
    public static final int PF_INET = 2;
    public static final int IPPROTO_IP = 0;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_TCP = 6;
    public static final int IPPROTO_UDP = 17;
    private int soDomain;
    private int soType;
    private int soProtocol;
    private static final Pattern STRING_ADDRESS_PATTERN = Pattern.compile("((.*)\\/)?([\\.0-9]+)(:([0-9]+))?");
    private static final int HOST_GROUP = 3;
    private static final int PORT_GROUP = 5;

    static void createSocket(Ruby runtime) {
        RubyClass rb_cSocket = runtime.defineClass("Socket", runtime.fastGetClass("BasicSocket"), SOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubySocket.class);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        rb_mConstants.fastSetConstant("SOCK_STREAM", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SOCK_DGRAM", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("SOCK_RAW", runtime.newFixnum(3L));
        rb_mConstants.fastSetConstant("PF_UNSPEC", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("AF_UNSPEC", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("PF_INET", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("AF_INET", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("MSG_OOB", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SOL_SOCKET", runtime.newFixnum(65535L));
        rb_mConstants.fastSetConstant("SOL_IP", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("SOL_TCP", runtime.newFixnum(6L));
        rb_mConstants.fastSetConstant("SOL_UDP", runtime.newFixnum(17L));
        rb_mConstants.fastSetConstant("IPPROTO_IP", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("IPPROTO_ICMP", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("IPPROTO_TCP", runtime.newFixnum(6L));
        rb_mConstants.fastSetConstant("IPPROTO_UDP", runtime.newFixnum(17L));
        rb_mConstants.fastSetConstant("INADDR_ANY", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("INADDR_BROADCAST", runtime.newFixnum(-1L));
        rb_mConstants.fastSetConstant("INADDR_LOOPBACK", runtime.newFixnum(2130706433L));
        rb_mConstants.fastSetConstant("INADDR_UNSPEC_GROUP", runtime.newFixnum(-536870912L));
        rb_mConstants.fastSetConstant("INADDR_ALLHOSTS_GROUP", runtime.newFixnum(-536870911L));
        rb_mConstants.fastSetConstant("INADDR_MAX_LOCAL_GROUP", runtime.newFixnum(-536870657L));
        rb_mConstants.fastSetConstant("INADDR_NONE", runtime.newFixnum(-1L));
        rb_mConstants.fastSetConstant("SHUT_RD", runtime.newFixnum(0L));
        rb_mConstants.fastSetConstant("SHUT_WR", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SHUT_RDWR", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("AI_PASSIVE", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SO_BROADCAST", runtime.newFixnum(32L));
        rb_mConstants.fastSetConstant("SO_DEBUG", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("SO_DONTROUTE", runtime.newFixnum(16L));
        rb_mConstants.fastSetConstant("SO_ERROR", runtime.newFixnum(4103L));
        rb_mConstants.fastSetConstant("SO_KEEPALIVE", runtime.newFixnum(8L));
        rb_mConstants.fastSetConstant("SO_LINGER", runtime.newFixnum(128L));
        rb_mConstants.fastSetConstant("SO_OOBINLINE", runtime.newFixnum(256L));
        rb_mConstants.fastSetConstant("SO_RCVBUF", runtime.newFixnum(4098L));
        rb_mConstants.fastSetConstant("SO_RCVLOWAT", runtime.newFixnum(4100L));
        rb_mConstants.fastSetConstant("SO_RCVTIMEO", runtime.newFixnum(4102L));
        rb_mConstants.fastSetConstant("SO_REUSEADDR", runtime.newFixnum(4L));
        rb_mConstants.fastSetConstant("SO_SNDBUF", runtime.newFixnum(4097L));
        rb_mConstants.fastSetConstant("SO_SNDLOWAT", runtime.newFixnum(4099L));
        rb_mConstants.fastSetConstant("SO_SNDTIMEO", runtime.newFixnum(4101L));
        rb_mConstants.fastSetConstant("SO_TIMESTAMP", runtime.newFixnum(1024L));
        rb_mConstants.fastSetConstant("SO_TYPE", runtime.newFixnum(4104L));
        rb_mConstants.fastSetConstant("TCP_NODELAY", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("NI_DGRAM", runtime.newFixnum(16L));
        rb_mConstants.fastSetConstant("NI_MAXHOST", runtime.newFixnum(1025L));
        rb_mConstants.fastSetConstant("NI_MAXSERV", runtime.newFixnum(32L));
        rb_mConstants.fastSetConstant("NI_NAMEREQD", runtime.newFixnum(4L));
        rb_mConstants.fastSetConstant("NI_NOFQDN", runtime.newFixnum(1L));
        rb_mConstants.fastSetConstant("NI_NUMERICHOST", runtime.newFixnum(2L));
        rb_mConstants.fastSetConstant("NI_NUMERICSERV", runtime.newFixnum(8L));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineFastMethod("initialize", cfact.getFastMethod("initialize", IRubyObject.class, IRubyObject.class, IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("gethostname", cfact.getFastSingletonMethod("gethostname"));
        rb_cSocket.getMetaClass().defineFastMethod("gethostbyaddr", cfact.getFastOptSingletonMethod("gethostbyaddr"));
        rb_cSocket.getMetaClass().defineFastMethod("gethostbyname", cfact.getFastSingletonMethod("gethostbyname", IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("getaddrinfo", cfact.getFastOptSingletonMethod("getaddrinfo"));
        rb_cSocket.getMetaClass().defineFastMethod("getnameinfo", cfact.getFastOptSingletonMethod("getnameinfo"));
        rb_cSocket.getMetaClass().defineFastMethod("getservbyname", cfact.getFastOptSingletonMethod("getservbyname"));
        rb_cSocket.getMetaClass().defineFastMethod("sockaddr_in", cfact.getFastSingletonMethod("pack_sockaddr_in", IRubyObject.class, IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("pack_sockaddr_in", cfact.getFastSingletonMethod("pack_sockaddr_in", IRubyObject.class, IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("sockaddr_un", cfact.getFastSingletonMethod("pack_sockaddr_un", IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("pack_sockaddr_un", cfact.getFastSingletonMethod("pack_sockaddr_un", IRubyObject.class));
        rb_cSocket.getMetaClass().defineFastMethod("unpack_sockaddr_in", cfact.getFastSingletonMethod("unpack_sockaddr_in", IRubyObject.class));
    }

    public RubySocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    protected int getSoTypeDefault() {
        return this.soType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject initialize(IRubyObject domain, IRubyObject type, IRubyObject protocol) {
        try {
            if (domain instanceof RubyString) {
                String string = domain.toString();
                if (string.equals("AF_INET")) {
                    this.soDomain = 2;
                } else {
                    if (!string.equals("PF_INET")) throw RubySocket.sockerr(this, "unknown socket domain " + string);
                    this.soDomain = 2;
                }
            } else {
                this.soDomain = RubyNumeric.fix2int(domain);
            }
            if (type instanceof RubyString) {
                String string = type.toString();
                if (string.equals("SOCK_STREAM")) {
                    this.soType = 1;
                } else {
                    if (!string.equals("SOCK_DGRAM")) throw RubySocket.sockerr(this, "unknown socket type " + string);
                    this.soType = 2;
                }
            } else {
                this.soType = RubyNumeric.fix2int(type);
            }
            this.soProtocol = RubyNumeric.fix2int(protocol);
            if (this.soType == 1) {
                SocketChannel socketChannel = SocketChannel.open();
                this.initSocket(new ChannelDescriptor(socketChannel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
                return this;
            } else {
                if (this.soType != 2) return this;
                DatagramChannel datagramChannel = DatagramChannel.open();
                this.initSocket(new ChannelDescriptor(datagramChannel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            return this;
        }
        catch (InvalidValueException invalidValueException) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            throw RubySocket.sockerr(this, "initialize: " + iOException.toString());
        }
    }

    private static RuntimeException sockerr(IRubyObject recv, String msg) {
        return new RaiseException(recv.getRuntime(), recv.getRuntime().fastGetClass("SocketError"), msg, true);
    }

    public static IRubyObject gethostname(IRubyObject recv) {
        try {
            return recv.getRuntime().newString(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            try {
                return recv.getRuntime().newString(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}).getHostName());
            }
            catch (UnknownHostException e2) {
                throw RubySocket.sockerr(recv, "gethostname: name or service not known");
            }
        }
    }

    private static InetAddress intoAddress(IRubyObject recv, String s) {
        try {
            byte[] bs = ByteList.plain(s);
            return InetAddress.getByAddress(bs);
        }
        catch (Exception e) {
            throw RubySocket.sockerr(recv, "strtoaddr: " + e.toString());
        }
    }

    private static String intoString(IRubyObject recv, InetAddress as) {
        try {
            return new String(ByteList.plain(as.getAddress()));
        }
        catch (Exception e) {
            throw RubySocket.sockerr(recv, "addrtostr: " + e.toString());
        }
    }

    public static IRubyObject gethostbyaddr(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        IRubyObject[] ret = new IRubyObject[]{runtime.newString(RubySocket.intoAddress(recv, args[0].convertToString().toString()).getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2L), args[0]};
        return runtime.newArrayNoCopy(ret);
    }

    public static IRubyObject getservbyname(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args, 1, 2);
        String name = args[0].convertToString().toString();
        String service = argc == 1 ? "tcp" : args[1].convertToString().toString();
        Integer port = IANA.serviceToPort.get(name + "/" + service);
        if (port == null) {
            throw RubySocket.sockerr(recv, "no such service " + name + "/" + service);
        }
        return runtime.newFixnum(port.intValue());
    }

    public static IRubyObject pack_sockaddr_un(IRubyObject recv, IRubyObject filename) {
        StringBuffer sb = new StringBuffer();
        sb.append('\u0000');
        sb.append('\u0001');
        String str = filename.convertToString().toString();
        sb.append(str);
        for (int i = str.length(); i < 104; ++i) {
            sb.append('\u0000');
        }
        return recv.getRuntime().newString(sb.toString());
    }

    public static IRubyObject pack_sockaddr_in(IRubyObject recv, IRubyObject port, IRubyObject host) {
        StringBuffer sb = new StringBuffer();
        sb.append('\u0010');
        sb.append('\u0002');
        int iport = RubyNumeric.fix2int(port);
        sb.append((char)(iport >> 8 & 0xFF));
        sb.append((char)(iport & 0xFF));
        try {
            String str;
            String string = str = host.isNil() ? null : host.convertToString().toString();
            if (str != null && "".equals(str)) {
                sb.append('\u0000');
                sb.append('\u0000');
                sb.append('\u0000');
                sb.append('\u0000');
            } else {
                InetAddress[] addrs = InetAddress.getAllByName(str);
                byte[] addr = addrs[0].getAddress();
                sb.append((char)addr[0]);
                sb.append((char)addr[1]);
                sb.append((char)addr[2]);
                sb.append((char)addr[3]);
            }
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "getaddrinfo: No address associated with nodename");
        }
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        sb.append('\u0000');
        return recv.getRuntime().newString(sb.toString());
    }

    public static IRubyObject unpack_sockaddr_in(IRubyObject recv, IRubyObject addr) {
        String val = addr.convertToString().toString();
        if (val.charAt(0) != '\u0010' || val.charAt(1) != '\u0002') {
            throw recv.getRuntime().newArgumentError("can't resolve socket address of wrong type");
        }
        int port = (val.charAt(2) << 8) + val.charAt(3);
        StringBuffer sb = new StringBuffer();
        sb.append((int)val.charAt(4));
        sb.append(".");
        sb.append((int)val.charAt(5));
        sb.append(".");
        sb.append((int)val.charAt(6));
        sb.append(".");
        sb.append((int)val.charAt(7));
        IRubyObject[] result = new IRubyObject[]{recv.getRuntime().newFixnum(port), recv.getRuntime().newString(sb.toString())};
        return recv.getRuntime().newArrayNoCopy(result);
    }

    public static IRubyObject gethostbyname(IRubyObject recv, IRubyObject hostname) {
        try {
            InetAddress addr = InetAddress.getByName(hostname.convertToString().toString());
            Ruby runtime = recv.getRuntime();
            IRubyObject[] ret = new IRubyObject[]{runtime.newString(addr.getCanonicalHostName()), runtime.newArray(), runtime.newFixnum(2L), runtime.newString(RubySocket.intoString(recv, addr))};
            return runtime.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "gethostbyname: name or service not known");
        }
    }

    public static IRubyObject getaddrinfo(IRubyObject recv, IRubyObject[] args) {
        args = Arity.scanArgs(recv.getRuntime(), args, 2, 4);
        try {
            Ruby r = recv.getRuntime();
            IRubyObject host = args[0];
            IRubyObject port = args[1];
            if (port instanceof RubyString) {
                port = RubySocket.getservbyname(recv, new IRubyObject[]{port});
            }
            IRubyObject socktype = args[3];
            boolean sock_stream = true;
            boolean sock_dgram = true;
            if (!socktype.isNil()) {
                int val = RubyNumeric.fix2int(socktype);
                if (val == 1) {
                    sock_dgram = false;
                } else if (val == 2) {
                    sock_stream = false;
                }
            }
            InetAddress[] addrs = InetAddress.getAllByName(host.isNil() ? null : host.convertToString().toString());
            ArrayList<IRubyObject> l = new ArrayList<IRubyObject>();
            for (int i = 0; i < addrs.length; ++i) {
                IRubyObject[] c;
                if (sock_dgram) {
                    c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2L), r.newFixnum(2L), r.newFixnum(17L)};
                    l.add(r.newArrayNoCopy(c));
                }
                if (!sock_stream) continue;
                c = new IRubyObject[]{r.newString("AF_INET"), port, r.newString(addrs[i].getCanonicalHostName()), r.newString(addrs[i].getHostAddress()), r.newFixnum(2L), r.newFixnum(1L), r.newFixnum(6L)};
                l.add(r.newArrayNoCopy(c));
            }
            return r.newArray(l);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "getaddrinfo: name or service not known");
        }
    }

    public static IRubyObject getnameinfo(IRubyObject recv, IRubyObject[] args) {
        InetAddress addr;
        String port;
        String host;
        Ruby runtime = recv.getRuntime();
        int argc = Arity.checkArgumentCount(runtime, args, 1, 2);
        int flags = argc == 2 ? RubyNumeric.num2int(args[1]) : 0;
        IRubyObject arg0 = args[0];
        if (arg0 instanceof RubyArray) {
            List list = ((RubyArray)arg0).getList();
            int len = list.size();
            if (len < 3 || len > 4) {
                throw runtime.newArgumentError("array size should be 3 or 4, " + len + " given");
            }
            host = list.get(2).toString();
            port = list.get(1).toString();
        } else if (arg0 instanceof RubyString) {
            String arg = ((RubyString)arg0).toString();
            Matcher m = STRING_ADDRESS_PATTERN.matcher(arg);
            if (!m.matches()) {
                throw runtime.newArgumentError("invalid address string");
            }
            host = m.group(3);
            if (host == null || host.length() == 0 || (port = m.group(5)) == null || port.length() == 0) {
                throw runtime.newArgumentError("invalid address string");
            }
        } else {
            throw runtime.newArgumentError("invalid args");
        }
        try {
            addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw RubySocket.sockerr(recv, "unknown host: " + host);
        }
        host = (flags & 2) == 0 ? addr.getCanonicalHostName() : addr.getHostAddress();
        return runtime.newArray(runtime.newString(host), runtime.newString(port));
    }

    public static class Service
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            runtime.defineClass("SocketError", runtime.fastGetClass("StandardError"), runtime.fastGetClass("StandardError").getAllocator());
            RubyBasicSocket.createBasicSocket(runtime);
            RubySocket.createSocket(runtime);
            runtime.getInstanceConfig();
            if (RubyInstanceConfig.nativeEnabled && RubyUNIXSocket.tryUnixDomainSocket()) {
                RubyUNIXSocket.createUNIXSocket(runtime);
                RubyUNIXServer.createUNIXServer(runtime);
            }
            RubyIPSocket.createIPSocket(runtime);
            RubyTCPSocket.createTCPSocket(runtime);
            RubyTCPServer.createTCPServer(runtime);
            RubyUDPSocket.createUDPSocket(runtime);
        }
    }
}

