/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;

public class JavaPOSIX
implements POSIX {
    POSIXHandler handler;
    JavaLibCHelper helper;

    public JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    @Override
    public int chmod(String filename, int mode) {
        return this.helper.chmod(filename, mode);
    }

    @Override
    public int chown(String filename, int user, int group) {
        return this.helper.chown(filename, user, group);
    }

    @Override
    public FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    @Override
    public int getegid() {
        return this.unimplementedInt("getegid");
    }

    @Override
    public int geteuid() {
        return this.unimplementedInt("geteuid");
    }

    @Override
    public int getgid() {
        return this.unimplementedInt("getgid");
    }

    @Override
    public String getlogin() {
        return this.helper.getlogin();
    }

    @Override
    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    @Override
    public int getpid() {
        return this.helper.getpid();
    }

    @Override
    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    @Override
    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    @Override
    public Passwd getpwuid(int which) {
        this.handler.unimplementedError("getpwuid unimplemented");
        return null;
    }

    @Override
    public Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    @Override
    public Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    @Override
    public Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    @Override
    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    @Override
    public int setpwent() {
        return this.helper.setpwent();
    }

    @Override
    public int endpwent() {
        return this.helper.endpwent();
    }

    @Override
    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    @Override
    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    @Override
    public int getuid() {
        return this.unimplementedInt("getuid");
    }

    @Override
    public int fork() {
        return -1;
    }

    @Override
    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    @Override
    public int kill(int pid, int signal) {
        return this.unimplementedInt("kill");
    }

    @Override
    public int lchmod(String filename, int mode) {
        return this.unimplementedInt("lchmod");
    }

    @Override
    public int lchown(String filename, int user, int group) {
        return this.unimplementedInt("lchown");
    }

    @Override
    public int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    @Override
    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.helper.lstat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int mkdir(String path, int mode) {
        return this.helper.mkdir(path, mode);
    }

    @Override
    public String readlink(String path) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.helper.readlink(path, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    @Override
    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.helper.stat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    @Override
    public int setegid(int egid) {
        return this.unimplementedInt("setegid");
    }

    @Override
    public int seteuid(int euid) {
        return this.unimplementedInt("seteuid");
    }

    @Override
    public int setgid(int gid) {
        return this.unimplementedInt("setgid");
    }

    @Override
    public int getpgid(int pid) {
        return this.unimplementedInt("getpgid");
    }

    @Override
    public int setpgid(int pid, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    @Override
    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    @Override
    public int setuid(int uid) {
        return this.unimplementedInt("setuid");
    }

    @Override
    public int umask(int mask) {
        return 0;
    }

    @Override
    public int wait(int[] status) {
        return this.unimplementedInt("wait");
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        return this.unimplementedInt("waitpid");
    }

    @Override
    public int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    private int unimplementedInt(String message) {
        this.handler.unimplementedError(message);
        return -1;
    }
}

