/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class SplitChannel
implements ReadableByteChannel,
WritableByteChannel {
    private ReadableByteChannel inChannel;
    private WritableByteChannel outChannel;
    private boolean isOpen;
    private boolean writable;
    private boolean readable;

    public SplitChannel(ReadableByteChannel inChannel, WritableByteChannel outChannel) {
        this.inChannel = inChannel;
        this.outChannel = outChannel;
        this.isOpen = true;
        if (inChannel != null) {
            this.readable = true;
        }
        if (outChannel != null) {
            this.writable = true;
        }
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        if (this.isOpen && this.readable) {
            return this.inChannel.read(buffer);
        }
        throw new EOFException();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.inChannel.close();
        this.outChannel.close();
        this.isOpen = false;
    }

    public void closeRead() throws IOException {
        this.inChannel.close();
        this.readable = false;
    }

    public void closeWrite() throws IOException {
        this.outChannel.close();
        this.writable = false;
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        if (this.isOpen && this.writable) {
            return this.outChannel.write(buffer);
        }
        throw new EOFException();
    }
}

