/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.builtin.IRubyObject;

public class ShellLauncher {
    private Ruby runtime;

    public ShellLauncher(Ruby runtime) {
        this.runtime = runtime;
    }

    private String[] getCurrentEnv() {
        RubyHash hash = (RubyHash)this.runtime.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash.size()];
        int i = 0;
        for (Map.Entry e : hash.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public int runAndWait(IRubyObject[] rawArgs) {
        return this.runAndWait(rawArgs, this.runtime.getOutputStream());
    }

    public int runAndWait(IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = this.runtime.getErrorStream();
        InputStream input = this.runtime.getInputStream();
        try {
            Process aProcess = this.run(rawArgs);
            this.handleStreams(aProcess, input, output, error);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw this.runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw this.runtime.newThreadError("unexpected interrupt");
        }
    }

    public Process run(IRubyObject string) throws IOException {
        return this.run(new IRubyObject[]{string});
    }

    public Process run(IRubyObject[] rawArgs) throws IOException {
        String shell = this.getShell(this.runtime);
        Process aProcess = null;
        File pwd = new File(this.runtime.getCurrentDirectory());
        String[] args = this.parseCommandLine(this.runtime, rawArgs);
        if (this.shouldRunInProcess(this.runtime, args[0])) {
            int startIndex;
            String command = args[0];
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args[0] = this.runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] newargs = new String[args.length - startIndex];
            System.arraycopy(args, startIndex, newargs, 0, newargs.length);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, this.getCurrentEnv(), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (rawArgs.length == 1 && this.shouldRunInShell(shell, args)) {
            String[] argArray = new String[3];
            String cmdline = rawArgs[0].toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, this.getCurrentEnv(), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args, this.getCurrentEnv(), pwd);
        }
        return aProcess;
    }

    private void handleStreams(Process p, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p.getInputStream();
        InputStream pErr = p.getErrorStream();
        OutputStream pIn = p.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false);
        StreamPumper t2 = new StreamPumper(pErr, err, false);
        StreamPumper t3 = new StreamPumper(in, pIn, true);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private String[] parseCommandLine(Ruby runtime, IRubyObject[] rawArgs) {
        String[] args;
        if (rawArgs.length == 1) {
            RubyArray parts = (RubyArray)runtime.evalScriptlet("require 'jruby/path_helper'; JRuby::PathHelper").callMethod(runtime.getCurrentContext(), "smart_split_command", rawArgs);
            args = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args[i] = parts.entry(i).toString();
            }
        } else {
            args = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args[i] = rawArgs[i].toString();
            }
        }
        return args;
    }

    private boolean shouldRunInProcess(Ruby runtime, String command) {
        if (!runtime.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        String[] slashDelimitedTokens = command.split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        int indexOfRuby = finalToken.indexOf("ruby");
        return indexOfRuby != -1 && indexOfRuby == finalToken.length() - 4 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private boolean shouldRunInShell(String shell, String[] args) {
        return shell != null && args.length > 1 && !new File(args[0]).exists();
    }

    private String getShell(Ruby runtime) {
        return runtime.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    private static class StreamPumper
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private volatile boolean quit;
        private final Object waitLock = new Object();

        StreamPumper(InputStream in, OutputStream out, boolean avail) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf = new byte[1024];
            boolean hasReadSomething = false;
            try {
                while (!this.quit) {
                    int numRead;
                    if (this.onlyIfAvailable && !hasReadSomething) {
                        if (this.in.available() == 0) {
                            Object object = this.waitLock;
                            synchronized (object) {
                                this.waitLock.wait(10L);
                                continue;
                            }
                        }
                        hasReadSomething = true;
                    }
                    if ((numRead = this.in.read(buf)) == -1) {
                        break;
                    }
                    this.out.write(buf, 0, numRead);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.onlyIfAvailable) {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private String[] argArray;
        private int result;
        private RubyInstanceConfig config;
        private Thread processThread;
        private PipedInputStream processOutput = new PipedInputStream();
        private PipedInputStream processError = new PipedInputStream();
        private PipedOutputStream processInput = new PipedOutputStream();
        private final String[] env;
        private final File pwd;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
        }

        @Override
        public void run() {
            try {
                this.result = new Main(this.config).run(this.argArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(this.config.getError());
                this.result = -1;
            }
            finally {
                this.config.getOutput().close();
                this.config.getError().close();
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setInput(new PipedInputStream(processInput));
                    this.setOutput(new PrintStream(new PipedOutputStream(processOutput)));
                    this.setError(new PrintStream(new PipedOutputStream(processError)));
                    this.setEnvironment(this.environmentMap(env));
                    this.setCurrentDirectory(pwd.toString());
                }
            };
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.closeStreams();
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            this.closeStreams();
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

