/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.RubyArray;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class OneVarDynamicScope
extends DynamicScope {
    private IRubyObject variableValue;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        if (this.staticScope.getNumberOfVariables() != 1) {
            throw new RuntimeException("OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope");
        }
    }

    @Override
    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValue};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        return this.variableValue;
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        assert (offset == 0) : "SingleVarDynamicScope only supports scopes with one variable";
        if (this.variableValue == null) {
            this.variableValue = nil;
            return this.variableValue;
        }
        return this.variableValue;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValue == null) {
            this.variableValue = nil;
            return this.variableValue;
        }
        return this.variableValue;
    }

    @Override
    public IRubyObject getValueOneDepthZeroOrNil(IRubyObject nil) {
        throw new RuntimeException("SingleVarDynamicScope only supports scopes with one variable");
    }

    @Override
    public void setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            this.parent.setValue(offset, value, depth - 1);
        } else {
            assert (offset == 0) : "SingleVarDynamicScope only supports one variable";
            this.variableValue = value;
        }
    }

    @Override
    public void setValueDepthZero(IRubyObject value, int offset) {
        assert (offset == 0) : "SingleVarDynamicScope only supports one variable";
        this.variableValue = value;
    }

    @Override
    public void setValueZeroDepthZero(IRubyObject value) {
        this.variableValue = value;
    }

    @Override
    public void setValueOneDepthZero(IRubyObject value) {
        throw new RuntimeException("SingleVarDynamicScope only supports scopes with one variable");
    }

    @Override
    public void setArgValues(IRubyObject[] values, int size) {
        assert (values.length == 1) : "SingleVarDynamicScope only supports one variable";
        this.variableValue = values[0];
    }

    @Override
    public IRubyObject[] getArgValues() {
        if (!this.staticScope.isArgumentScope()) {
            return this.parent.getArgValues();
        }
        int totalArgs = this.staticScope.getRequiredArgs() + this.staticScope.getOptionalArgs();
        assert (totalArgs <= 1) : "OneVarDynamicScope only supports one variable";
        if (this.staticScope.getRestArg() < 0) {
            if (totalArgs == 1) {
                return new IRubyObject[]{this.variableValue};
            }
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject restArg = this.getValue(this.staticScope.getRestArg(), 0);
        assert (restArg != null);
        RubyArray splattedArgs = ASTInterpreter.splatValue(restArg.getRuntime(), restArg);
        IRubyObject[] argValues = new IRubyObject[totalArgs + splattedArgs.size()];
        System.arraycopy(splattedArgs.toJavaArray(), 0, argValues, totalArgs, splattedArgs.size());
        return argValues;
    }

    @Override
    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope instanceof BlockStaticScope ? "block" : "local") + " [");
        String[] names = this.staticScope.getVariables();
        buf.append(names[0]).append("=");
        if (this.variableValue == null) {
            buf.append("null");
        } else {
            buf.append(this.variableValue);
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }
}

