/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.jruby.IncludedModuleWrapper;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.runtime.marshal.MarshalCache;
import org.jruby.util.ByteList;

public class MarshalStream
extends FilterOutputStream {
    private final Ruby runtime;
    private final int depthLimit;
    private int depth = 0;
    private MarshalCache cache;
    private static final char TYPE_IVAR = 'I';
    private static final char TYPE_USRMARSHAL = 'U';
    private static final char TYPE_USERDEF = 'u';
    private static final char TYPE_UCLASS = 'C';

    public MarshalStream(Ruby runtime, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.runtime = runtime;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        out.write(4);
        out.write(8);
    }

    public void dumpObject(IRubyObject value) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        this.writeAndRegister(value);
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    public void registerLinkTarget(IRubyObject newObject) {
        if (MarshalStream.shouldBeRegistered(newObject)) {
            this.cache.register(newObject);
        }
    }

    static boolean shouldBeRegistered(IRubyObject value) {
        if (value.isNil()) {
            return false;
        }
        if (value instanceof RubyBoolean) {
            return false;
        }
        return !(value instanceof RubyFixnum);
    }

    private void writeAndRegister(IRubyObject value) throws IOException {
        if (this.cache.isRegistered(value)) {
            this.cache.writeLink(this, value);
        } else if (this.hasNewUserDefinedMarshaling(value)) {
            this.userNewMarshal(value);
        } else if (this.hasUserDefinedMarshaling(value)) {
            this.userMarshal(value);
        } else {
            this.writeDirectly(value);
        }
    }

    private List<Variable<IRubyObject>> getVariables(IRubyObject value) throws IOException {
        int nativeTypeIndex;
        List<Variable<IRubyObject>> variables = null;
        if (value instanceof CoreObjectType && (nativeTypeIndex = ((CoreObjectType)((Object)value)).getNativeTypeIndex()) != 14) {
            if (!value.isImmediate() && value.hasVariables() && nativeTypeIndex != 13) {
                variables = value.getVariableList();
                this.write(73);
            }
            RubyClass type = value.getMetaClass();
            switch (nativeTypeIndex) {
                case 3: 
                case 4: 
                case 9: 
                case 10: {
                    type = this.dumpExtended(type);
                }
            }
            if (nativeTypeIndex != value.getMetaClass().index && nativeTypeIndex != 15) {
                this.writeUserClass(value, type);
            }
        }
        return variables;
    }

    private void writeDirectly(IRubyObject value) throws IOException {
        List<Variable<IRubyObject>> variables = this.getVariables(value);
        this.writeObjectData(value);
        if (variables != null) {
            this.dumpVariables(variables);
        }
    }

    public static String getPathFromClass(RubyModule clazz) {
        RubyModule real;
        String path = clazz.getName();
        if (path.charAt(0) == '#') {
            String classOrModule = clazz.isClass() ? "class" : "module";
            throw clazz.getRuntime().newTypeError("can't dump anonymous " + classOrModule + " " + path);
        }
        RubyModule rubyModule = real = clazz.isModule() ? clazz : ((RubyClass)clazz).getRealClass();
        if (clazz.getRuntime().getClassFromPath(path) != real) {
            throw clazz.getRuntime().newTypeError(path + " can't be referred");
        }
        return path;
    }

    private void writeObjectData(IRubyObject value) throws IOException {
        if (value instanceof CoreObjectType) {
            int nativeTypeIndex = ((CoreObjectType)((Object)value)).getNativeTypeIndex();
            switch (nativeTypeIndex) {
                case 3: {
                    this.write(91);
                    RubyArray.marshalTo((RubyArray)value, this);
                    return;
                }
                case 7: {
                    this.write(70);
                    return;
                }
                case 1: {
                    RubyFixnum fixnum = (RubyFixnum)value;
                    if (fixnum.getLongValue() <= 0x3FFFFFFFL && fixnum.getLongValue() >= -1073741824L) {
                        this.write(105);
                        this.writeInt((int)fixnum.getLongValue());
                        return;
                    }
                    value = RubyBignum.newBignum(value.getRuntime(), fixnum.getLongValue());
                }
                case 2: {
                    this.write(108);
                    RubyBignum.marshalTo((RubyBignum)value, this);
                    return;
                }
                case 13: {
                    if (((RubyClass)value).isSingleton()) {
                        throw this.runtime.newTypeError("singleton class can't be dumped");
                    }
                    this.write(99);
                    RubyClass.marshalTo((RubyClass)value, this);
                    return;
                }
                case 11: {
                    this.write(102);
                    RubyFloat.marshalTo((RubyFloat)value, this);
                    return;
                }
                case 10: {
                    RubyHash hash = (RubyHash)value;
                    if (hash.getIfNone().isNil()) {
                        this.write(123);
                    } else {
                        if (hash.hasDefaultProc()) {
                            throw hash.getRuntime().newTypeError("can't dump hash with default proc");
                        }
                        this.write(125);
                    }
                    RubyHash.marshalTo(hash, this);
                    return;
                }
                case 12: {
                    this.write(109);
                    RubyModule.marshalTo((RubyModule)value, this);
                    return;
                }
                case 5: {
                    this.write(48);
                    return;
                }
                case 14: {
                    this.dumpDefaultObjectHeader(value.getMetaClass());
                    value.getMetaClass().getRealClass().marshal(value, this);
                    return;
                }
                case 9: {
                    this.write(47);
                    RubyRegexp.marshalTo((RubyRegexp)value, this);
                    return;
                }
                case 4: {
                    this.registerLinkTarget(value);
                    this.write(34);
                    this.writeString(value.convertToString().getByteList());
                    return;
                }
                case 15: {
                    RubyStruct.marshalTo((RubyStruct)value, this);
                    return;
                }
                case 8: {
                    this.registerLinkTarget(value);
                    this.write(58);
                    this.writeString(value.toString());
                    return;
                }
                case 6: {
                    this.write(84);
                    return;
                }
            }
        } else {
            this.dumpDefaultObjectHeader(value.getMetaClass());
            value.getMetaClass().getRealClass().marshal(value, this);
        }
    }

    private boolean hasNewUserDefinedMarshaling(IRubyObject value) {
        return value.respondsTo("marshal_dump");
    }

    private void userNewMarshal(IRubyObject value) throws IOException {
        this.registerLinkTarget(value);
        this.write(85);
        RubyClass metaclass = value.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, metaclass.getName()));
        IRubyObject marshaled = value.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        this.dumpObject(marshaled);
    }

    private boolean hasUserDefinedMarshaling(IRubyObject value) {
        return value.respondsTo("_dump");
    }

    private void userMarshal(IRubyObject value) throws IOException {
        this.registerLinkTarget(value);
        IRubyObject dumpResult = value.callMethod(this.runtime.getCurrentContext(), "_dump", this.runtime.newFixnum(this.depthLimit));
        if (!(dumpResult instanceof RubyString)) {
            throw this.runtime.newTypeError(dumpResult, this.runtime.getString());
        }
        RubyString marshaled = (RubyString)dumpResult;
        boolean hasVars = marshaled.hasVariables();
        if (hasVars) {
            this.write(73);
        }
        this.write(117);
        RubyClass metaclass = value.getMetaClass().getRealClass();
        this.dumpObject(RubySymbol.newSymbol(this.runtime, metaclass.getName()));
        this.writeString(marshaled.getByteList());
        if (hasVars) {
            this.dumpVariables(marshaled.getVariableList());
        }
    }

    public void writeUserClass(IRubyObject obj, RubyClass type) throws IOException {
        this.write(67);
        if (type.getName().charAt(0) == '#') {
            throw obj.getRuntime().newTypeError("can't dump anonymous class " + type.getName());
        }
        this.dumpObject(this.runtime.newSymbol(type.getName()));
    }

    public void dumpInstanceVars(Map instanceVars) throws IOException {
        this.runtime.getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "internal: deprecated dumpInstanceVars() called", "dumpInstanceVars");
        this.writeInt(instanceVars.size());
        for (String name : instanceVars.keySet()) {
            IRubyObject value = (IRubyObject)instanceVars.get(name);
            this.writeAndRegister(this.runtime.newSymbol(name));
            this.dumpObject(value);
        }
    }

    public void dumpVariables(List<Variable<IRubyObject>> vars) throws IOException {
        this.writeInt(vars.size());
        for (Variable<IRubyObject> var : vars) {
            this.writeAndRegister(this.runtime.newSymbol(var.getName()));
            this.dumpObject(var.getValue());
        }
    }

    private boolean hasSingletonMethods(RubyClass type) {
        for (Map.Entry entry : type.getMethods().entrySet()) {
            DynamicMethod method = (DynamicMethod)entry.getValue();
            if (method.getImplementationClass() != type) continue;
            return true;
        }
        return false;
    }

    private RubyClass dumpExtended(RubyClass type) throws IOException {
        if (type.isSingleton()) {
            if (this.hasSingletonMethods(type) || type.hasVariables()) {
                throw type.getRuntime().newTypeError("singleton can't be dumped");
            }
            type = type.getSuperClass();
        }
        while (type.isIncluded()) {
            this.write(101);
            this.dumpObject(RubySymbol.newSymbol(this.runtime, ((IncludedModuleWrapper)type).getNonIncludedClass().getName()));
            type = type.getSuperClass();
        }
        return type;
    }

    public void dumpDefaultObjectHeader(RubyClass type) throws IOException {
        this.dumpDefaultObjectHeader('o', type);
    }

    public void dumpDefaultObjectHeader(char tp, RubyClass type) throws IOException {
        this.dumpExtended(type);
        this.write(tp);
        RubySymbol classname = RubySymbol.newSymbol(this.runtime, MarshalStream.getPathFromClass(type.getRealClass()));
        this.dumpObject(classname);
    }

    public void writeString(String value) throws IOException {
        this.writeInt(value.length());
        this.out.write(RubyString.stringToBytes(value));
    }

    public void writeString(ByteList value) throws IOException {
        int len = value.length();
        this.writeInt(len);
        this.out.write(value.unsafeBytes(), value.begin(), len);
    }

    public void dumpSymbol(String value) throws IOException {
        this.write(58);
        this.writeInt(value.length());
        this.out.write(RubyString.stringToBytes(value));
    }

    public void writeInt(int value) throws IOException {
        if (value == 0) {
            this.out.write(0);
        } else if (0 < value && value < 123) {
            this.out.write(value + 5);
        } else if (-124 < value && value < 0) {
            this.out.write(value - 5 & 0xFF);
        } else {
            int i;
            byte[] buf = new byte[4];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(value & 0xFF);
                if ((value >>= 8) == 0 || value == -1) break;
            }
            int len = i + 1;
            this.out.write(value < 0 ? -len : len);
            this.out.write(buf, 0, i + 1);
        }
    }
}

