/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlock
extends BlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected final StaticScope scope;

    public static Block newCompiledClosure(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Arity arity, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding = new Binding(self, frame, visibility, klass, dynamicScope);
        CompiledBlock body = new CompiledBlock(arity, scope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding);
    }

    public static Block newCompiledClosure(ThreadContext context, IRubyObject self, Arity arity, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Frame f = context.getCurrentFrame();
        f.setFile(context.getFile());
        f.setLine(context.getLine());
        return CompiledBlock.newCompiledClosure(self, f, Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope(), arity, scope, callback, hasMultipleArgsHead, argumentType);
    }

    protected CompiledBlock(Arity arity, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(argumentType);
        this.arity = arity;
        this.scope = scope;
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        args = this.prepareArgumentsForCall(context, args, type);
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true, binding, type);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        Visibility oldVis = binding.getFrame().getVisibility();
        IRubyObject[] realArgs = aValue ? this.setupBlockArgs(context, args, self) : this.setupBlockArg(context, args, self);
        this.pre(context, klass, binding);
        try {
            IRubyObject iRubyObject = this.callback.call(context, self, realArgs);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            if (bj.getTarget() == null) {
                bj.setTarget(this);
            }
            throw bj;
        }
        catch (JumpException.NextJump nj) {
            IRubyObject iRubyObject = type == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
            return iRubyObject;
        }
        finally {
            binding.getFrame().setVisibility(oldVis);
            this.post(context, binding);
        }
    }

    protected void pre(ThreadContext context, RubyModule klass, Binding binding) {
        context.preYieldSpecificBlock(binding, this.scope, klass);
    }

    protected void post(ThreadContext context, Binding binding) {
        context.postYield(binding);
    }

    private IRubyObject[] setupBlockArgs(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{value};
            }
        }
        int length = this.arrayLength(value);
        switch (length) {
            case 0: {
                value = context.getRuntime().getNil();
                break;
            }
            case 1: {
                value = ((RubyArray)value).eltInternal(0);
                break;
            }
            default: {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length + " for 1)", new Object[0]);
            }
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject[] setupBlockArg(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{ArgsUtil.convertToRubyArray(context.getRuntime(), value, this.hasMultipleArgsHead)};
            }
        }
        if (value == null) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return new IRubyObject[]{context.getRuntime().getNil()};
        }
        return new IRubyObject[]{value};
    }

    @Override
    public StaticScope getStaticScope() {
        return this.scope;
    }

    @Override
    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    @Override
    public Arity arity() {
        return this.arity;
    }
}

