/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CacheMap;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class CallSite {
    public final int methodID;
    public final String methodName;
    protected final CallType callType;

    public CallSite(int methodID, String methodName, CallType callType) {
        this.methodID = methodID;
        this.methodName = methodName;
        this.callType = callType;
    }

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, Block var3);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, Block var4);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, Block var5);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject var3, IRubyObject var4, IRubyObject var5, Block var6);

    public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);

    public static class InlineCachingCallSite
    extends CallSite
    implements CacheMap.CacheSite {
        DynamicMethod cachedMethod;
        RubyClass cachedType;

        public InlineCachingCallSite(String methodName, CallType callType) {
            super(MethodIndex.getIndex(methodName), methodName, callType);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, IRubyObject[] args, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, args, context.getFrameSelf(), this.callType, block);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, args, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, IRubyObject[] args, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, args, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, args);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, IRubyObject.NULL_ARRAY, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, selfType, this.methodName);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, IRubyObject.NULL_ARRAY, context.getFrameSelf(), this.callType, block);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg}, context.getFrameSelf(), this.callType, block);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2}, context.getFrameSelf(), this.callType, block);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2, arg3}, context.getFrameSelf(), this.callType, Block.NULL_BLOCK);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
        }

        protected IRubyObject cacheAndCall(RubyClass selfType, Block block, ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            DynamicMethod method = selfType.searchMethod(this.methodName);
            if (method.isUndefined() || !this.methodName.equals("method_missing") && !method.isCallableFrom(context.getFrameSelf(), this.callType)) {
                return RuntimeHelpers.callMethodMissing(context, self, method, this.methodName, new IRubyObject[]{arg1, arg2, arg3}, context.getFrameSelf(), this.callType, block);
            }
            this.cachedMethod = method;
            this.cachedType = selfType;
            selfType.getRuntime().getCacheMap().add(method, this);
            return method.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
        }

        @Override
        public void removeCachedMethod() {
            this.cachedType = null;
            this.cachedMethod = null;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            RubyClass selfType = self.getMetaClass();
            if (this.cachedType == selfType && this.cachedMethod != null) {
                return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args);
            }
            return this.cacheAndCall(selfType, args, context, self);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args, Block block) {
            try {
                RubyClass selfType = self.getMetaClass();
                if (this.cachedType == selfType && this.cachedMethod != null) {
                    return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, args, block);
                }
                return this.cacheAndCall(selfType, block, args, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self) {
            RubyClass selfType = self.getMetaClass();
            if (this.cachedType == selfType && this.cachedMethod != null) {
                return this.cachedMethod.call(context, self, selfType, this.methodName);
            }
            return this.cacheAndCall(selfType, context, self);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, Block block) {
            try {
                RubyClass selfType = self.getMetaClass();
                if (this.cachedType == selfType && this.cachedMethod != null) {
                    return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, block);
                }
                return this.cacheAndCall(selfType, block, context, self);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1) {
            RubyClass selfType = self.getMetaClass();
            if (this.cachedType == selfType && this.cachedMethod != null) {
                return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1);
            }
            return this.cacheAndCall(selfType, context, self, arg1);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            try {
                RubyClass selfType = self.getMetaClass();
                if (this.cachedType == selfType && this.cachedMethod != null) {
                    return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            RubyClass selfType = self.getMetaClass();
            if (this.cachedType == selfType && this.cachedMethod != null) {
                return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            try {
                RubyClass selfType = self.getMetaClass();
                if (this.cachedType == selfType && this.cachedMethod != null) {
                    return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            RubyClass selfType = self.getMetaClass();
            if (this.cachedType == selfType && this.cachedMethod != null) {
                return this.cachedMethod.call(context, self, (RubyModule)selfType, this.methodName, arg1, arg2, arg3);
            }
            return this.cacheAndCall(selfType, context, self, arg1, arg2, arg3);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            try {
                RubyClass selfType = self.getMetaClass();
                if (this.cachedType == selfType && this.cachedMethod != null) {
                    return this.cachedMethod.call(context, self, selfType, this.methodName, arg1, arg2, arg3, block);
                }
                return this.cacheAndCall(selfType, block, context, self, arg1, arg2, arg3);
            }
            catch (JumpException.BreakJump bj) {
                return this.handleBreakJump(bj, block);
            }
            catch (JumpException.RetryJump rj) {
                throw context.getRuntime().newLocalJumpError("retry", context.getRuntime().getNil(), "retry outside of rescue not yet supported");
            }
            catch (StackOverflowError soe) {
                throw context.getRuntime().newSystemStackError("stack level too deep");
            }
        }

        private IRubyObject handleBreakJump(JumpException.BreakJump bj, Block block) throws JumpException.BreakJump {
            if (bj.isBreakInKernelLoop()) {
                if (block.getBody() == bj.getTarget()) {
                    bj.setBreakInKernelLoop(false);
                }
                throw bj;
            }
            return (IRubyObject)bj.getValue();
        }
    }

    public static abstract class ArgumentBoxingCallSite
    extends CallSite {
        public ArgumentBoxingCallSite(String methodName, CallType callType) {
            super(MethodIndex.getIndex(methodName), methodName, callType);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self) {
            IRubyObject[] args = IRubyObject.NULL_ARRAY;
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1) {
            IRubyObject[] args = new IRubyObject[]{arg1};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2, arg3};
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject[] args) {
            Block block = Block.NULL_BLOCK;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, Block block) {
            IRubyObject[] args = IRubyObject.NULL_ARRAY;
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1};
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2};
            return this.call(context, self, args, block);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3, Block block) {
            IRubyObject[] args = new IRubyObject[]{arg1, arg2, arg3};
            return this.call(context, self, args, block);
        }

        @Override
        public abstract IRubyObject call(ThreadContext var1, IRubyObject var2, IRubyObject[] var3, Block var4);
    }
}

