/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConstructor
extends JavaCallable {
    private final Constructor constructor;
    private final Class[] parameterTypes;

    public static RubyClass createJavaConstructorClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaConstructor.class);
        JavaCallable.registerRubyMethods(runtime, result, JavaConstructor.class);
        result.defineFastMethod("arity", callbackFactory.getFastMethod("arity"));
        result.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        result.defineFastMethod("argument_types", callbackFactory.getFastMethod("argument_types"));
        result.defineFastMethod("new_instance", callbackFactory.getFastOptMethod("new_instance"));
        return result;
    }

    public JavaConstructor(Ruby runtime, Constructor constructor) {
        super(runtime, runtime.getJavaSupport().getJavaModule().fastGetClass("JavaConstructor"));
        this.constructor = constructor;
        this.parameterTypes = constructor.getParameterTypes();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaConstructor && this.constructor == ((JavaConstructor)other).constructor;
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    public IRubyObject new_instance(IRubyObject[] args) {
        if (args.length != this.getArity()) {
            throw this.getRuntime().newArgumentError(args.length, this.getArity());
        }
        Object[] constructorArguments = new Object[args.length];
        Class[] types = this.parameterTypes;
        for (int i = 0; i < args.length; ++i) {
            constructorArguments[i] = JavaUtil.convertArgument(args[i], types[i]);
        }
        try {
            Object result = this.constructor.newInstance(constructorArguments);
            return JavaObject.wrap(this.getRuntime(), result);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + constructorArguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException());
            assert (false);
            return null;
        }
        catch (InstantiationException ie) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    @Override
    protected String nameOnInspection() {
        return this.getType().toString();
    }

    @Override
    protected Class[] parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    protected int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.constructor;
    }
}

