/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject
extends RubyObject {
    protected JavaAccessibleObject(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static void registerRubyMethods(Ruby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaAccessibleObject.class);
        result.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("equal?", callbackFactory.getFastMethod("same", IRubyObject.class));
        result.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        result.defineFastMethod("accessible?", callbackFactory.getFastMethod("isAccessible"));
        result.defineFastMethod("accessible=", callbackFactory.getFastMethod("setAccessible", IRubyObject.class));
    }

    protected abstract AccessibleObject accessibleObject();

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject() == ((JavaAccessibleObject)other).accessibleObject();
    }

    @Override
    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    public IRubyObject op_equal(IRubyObject other) {
        return other instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)other).accessibleObject()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject same(IRubyObject other) {
        return this.getRuntime().newBoolean(this.equals(other));
    }

    public RubyBoolean isAccessible() {
        return new RubyBoolean(this.getRuntime(), this.accessibleObject().isAccessible());
    }

    public IRubyObject setAccessible(IRubyObject object) {
        this.accessibleObject().setAccessible(object.isTrue());
        return object;
    }
}

