/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPServer(runtime, klass);
        }
    };
    private ServerSocketChannel ssc;
    private InetSocketAddress socket_address;

    static void createTCPServer(Ruby runtime) {
        RubyClass rb_cTCPServer = runtime.defineClass("TCPServer", runtime.fastGetClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime.getObject().fastSetConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @Override
    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args) {
        IRubyObject port;
        IRubyObject hostname = args[0];
        IRubyObject iRubyObject = port = args.length > 1 ? args[1] : this.getRuntime().getNil();
        if (hostname.isNil()) {
            hostname = this.getRuntime().newString("0.0.0.0");
        } else if (hostname instanceof RubyFixnum) {
            port = hostname;
            hostname = this.getRuntime().newString("0.0.0.0");
        }
        String shost = hostname.convertToString().toString();
        try {
            InetAddress addr = InetAddress.getByName(shost);
            this.ssc = ServerSocketChannel.open();
            this.socket_address = new InetSocketAddress(addr, RubyNumeric.fix2int(port));
            this.ssc.socket().bind(this.socket_address);
            this.initSocket(new ChannelDescriptor(this.ssc, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (UnknownHostException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw this.getRuntime().newErrnoEADDRINUSEError();
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    /*
     * Loose catch block
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept() {
        RubyTCPSocket socket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        ThreadContext context = this.getRuntime().getCurrentContext();
        Selector selector = null;
        try {
            this.ssc.configureBlocking(false);
            selector = Selector.open();
            SelectionKey key = this.ssc.register(selector, 16);
            context.getThread().beforeBlockingCall();
            while (true) {
                int selected;
                if ((selected = selector.select()) != 0) {
                    try {
                        socket.initSocket(new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
                    }
                    catch (InvalidValueException ex) {
                        throw this.getRuntime().newErrnoEINVALError();
                    }
                    RubyTCPSocket rubyTCPSocket = socket;
                    return rubyTCPSocket;
                }
                this.getRuntime().getCurrentContext().pollThreadEvents();
                continue;
                break;
            }
            catch (IOException e) {
                throw RubyTCPServer.sockerr(this, "problem when accepting");
            }
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException iOException) {}
            context.getThread().afterBlockingCall();
        }
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock() {
        RubyTCPSocket socket = new RubyTCPSocket(this.getRuntime(), this.getRuntime().fastGetClass("TCPSocket"));
        Selector selector = null;
        try {
            this.ssc.configureBlocking(false);
            selector = Selector.open();
            SelectionKey key = this.ssc.register(selector, 16);
            int selected = selector.selectNow();
            if (selected == 0) {
                throw this.getRuntime().newErrnoEAGAINError("Resource temporarily unavailable");
            }
            try {
                socket.initSocket(new ChannelDescriptor(this.ssc.accept(), RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
            }
            catch (InvalidValueException ex) {
                throw this.getRuntime().newErrnoEINVALError();
            }
            RubyTCPSocket rubyTCPSocket = socket;
            return rubyTCPSocket;
        }
        catch (IOException e) {
            throw RubyTCPServer.sockerr(this, "problem when accepting");
        }
        finally {
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(IRubyObject backlog) {
        return RubyFixnum.zero(this.getRuntime());
    }

    @JRubyMethod(name={"peeraddt"}, rest=true)
    public IRubyObject peeraddr(IRubyObject[] args) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(IRubyObject[] args) {
        throw this.getRuntime().newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"open"}, rest=true, frame=true, meta=true)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        IRubyObject tcpServer = recv.callMethod(context, "new", args);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, tcpServer);
            return iRubyObject;
        }
        finally {
            tcpServer.callMethod(context, "close");
        }
    }
}

