/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.demo;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.ext.Readline;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class TextAreaReadline
extends OutputStream
implements KeyListener {
    JTextComponent area;
    private int startPos;
    private String currentLine;
    private Object amEditing = new Object();
    public MutableAttributeSet promptStyle;
    public MutableAttributeSet inputStyle;
    public MutableAttributeSet outputStyle;
    public MutableAttributeSet resultStyle;
    private JComboBox completeCombo;
    private BasicComboPopup completePopup;
    private int start;
    private int end;
    private volatile boolean finished = false;

    public TextAreaReadline(JTextComponent area) {
        this(area, null);
    }

    public TextAreaReadline(JTextComponent area, String message) {
        this.area = area;
        area.addKeyListener(this);
        if (area.getDocument() instanceof AbstractDocument) {
            ((AbstractDocument)area.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos) {
                        super.insertString(fb, offset, string, attr);
                    }
                }

                @Override
                public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos) {
                        super.remove(fb, offset, length);
                    }
                }

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (offset >= TextAreaReadline.this.startPos) {
                        super.replace(fb, offset, length, text, attrs);
                    }
                }
            });
        }
        this.promptStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptStyle, new Color(164, 0, 0));
        this.inputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputStyle, new Color(32, 74, 135));
        this.outputStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.outputStyle, Color.darkGray);
        this.resultStyle = new SimpleAttributeSet();
        StyleConstants.setItalic(this.resultStyle, true);
        StyleConstants.setForeground(this.resultStyle, new Color(32, 74, 135));
        this.completeCombo = new JComboBox();
        this.completeCombo.setRenderer(new DefaultListCellRenderer());
        this.completePopup = new BasicComboPopup(this.completeCombo);
        if (message != null) {
            SimpleAttributeSet messageStyle = new SimpleAttributeSet();
            StyleConstants.setBackground(messageStyle, area.getForeground());
            StyleConstants.setForeground(messageStyle, area.getBackground());
            this.append(message, messageStyle);
        }
    }

    public void hookIntoRuntime(final Ruby runtime) {
        runtime.getLoadService().require("readline");
        RubyModule readlineM = runtime.fastGetModule("Readline");
        RubyIO out = new RubyIO(runtime, this);
        runtime.getGlobalVariables().set("$stdout", out);
        runtime.getGlobalVariables().set("$stderr", out);
        readlineM.defineModuleFunction("readline", new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block block) {
                return runtime.newString(TextAreaReadline.this.readLine(args[0].toString()));
            }

            @Override
            public Arity getArity() {
                return Arity.twoArguments();
            }
        });
    }

    protected void completeAction(KeyEvent event) {
        if (Readline.getCompletor() == null) {
            return;
        }
        event.consume();
        if (this.completePopup.isVisible()) {
            return;
        }
        LinkedList candidates = new LinkedList();
        String bufstr = null;
        try {
            bufstr = this.area.getText(this.startPos, this.area.getCaretPosition() - this.startPos);
        }
        catch (BadLocationException e) {
            return;
        }
        int cursor = this.area.getCaretPosition() - this.startPos;
        int position = Readline.getCompletor().complete(bufstr, cursor, candidates);
        if (candidates.isEmpty()) {
            return;
        }
        if (candidates.size() == 1) {
            this.replaceText(this.startPos + position, this.area.getCaretPosition(), (String)candidates.get(0));
            return;
        }
        this.start = this.startPos + position;
        this.end = this.area.getCaretPosition();
        Point pos = this.area.getCaret().getMagicCaretPosition();
        int cutoff = bufstr.substring(position).lastIndexOf(46) + 1;
        this.start += cutoff;
        if (candidates.size() < 10) {
            this.completePopup.getList().setVisibleRowCount(candidates.size());
        } else {
            this.completePopup.getList().setVisibleRowCount(10);
        }
        this.completeCombo.removeAllItems();
        for (String item : candidates) {
            if (cutoff != 0) {
                item = item.substring(cutoff);
            }
            this.completeCombo.addItem(item);
        }
        this.completePopup.show(this.area, pos.x, pos.y + this.area.getFontMetrics(this.area.getFont()).getHeight());
    }

    protected void backAction(KeyEvent event) {
        if (this.area.getCaretPosition() <= this.startPos) {
            event.consume();
        }
    }

    protected void upAction(KeyEvent event) {
        event.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() - 1;
            if (selected < 0) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory().next()) {
            this.currentLine = this.getLine();
        } else {
            Readline.getHistory().previous();
        }
        if (!Readline.getHistory().previous()) {
            return;
        }
        String oldLine = Readline.getHistory().current().trim();
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void downAction(KeyEvent event) {
        String oldLine;
        event.consume();
        if (this.completePopup.isVisible()) {
            int selected = this.completeCombo.getSelectedIndex() + 1;
            if (selected == this.completeCombo.getItemCount()) {
                return;
            }
            this.completeCombo.setSelectedIndex(selected);
            return;
        }
        if (!Readline.getHistory().next()) {
            return;
        }
        if (!Readline.getHistory().next()) {
            oldLine = this.currentLine;
        } else {
            Readline.getHistory().previous();
            oldLine = Readline.getHistory().current().trim();
        }
        this.replaceText(this.startPos, this.area.getDocument().getLength(), oldLine);
    }

    protected void replaceText(int start, int end, String replacement) {
        try {
            this.area.getDocument().remove(start, end - start);
            this.area.getDocument().insertString(start, replacement, this.inputStyle);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected String getLine() {
        try {
            return this.area.getText(this.startPos, this.area.getDocument().getLength() - this.startPos);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enterAction(KeyEvent event) {
        event.consume();
        if (this.completePopup.isVisible()) {
            if (this.completeCombo.getSelectedItem() != null) {
                this.replaceText(this.start, this.end, (String)this.completeCombo.getSelectedItem());
            }
            this.completePopup.setVisible(false);
            return;
        }
        this.append("\n", null);
        Object object = this.amEditing;
        synchronized (object) {
            this.amEditing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyFinished() {
        Object object = this.amEditing;
        synchronized (object) {
            this.finished = true;
            this.amEditing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String prompt) {
        this.append(prompt.trim(), this.promptStyle);
        this.append(" ", this.inputStyle);
        this.area.setCaretPosition(this.area.getDocument().getLength());
        this.startPos = this.area.getDocument().getLength();
        Readline.getHistory().moveToEnd();
        Object object = this.amEditing;
        synchronized (object) {
            if (this.finished) {
                return "exit";
            }
            try {
                this.amEditing.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        String result = this.finished ? "exit" : this.getLine().trim();
        return result;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        switch (code) {
            case 9: {
                this.completeAction(event);
                break;
            }
            case 8: 
            case 37: {
                this.backAction(event);
                break;
            }
            case 38: {
                this.upAction(event);
                break;
            }
            case 40: {
                this.downAction(event);
                break;
            }
            case 10: {
                this.enterAction(event);
                break;
            }
            case 36: {
                event.consume();
                this.area.setCaretPosition(this.startPos);
            }
        }
        if (this.completePopup.isVisible() && code != 9 && code != 38 && code != 40) {
            this.completePopup.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    protected void append(String toAppend, AttributeSet style) {
        try {
            this.area.getDocument().insertString(this.area.getDocument().getLength(), toAppend, style);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void writeLine(String line) {
        if (line.startsWith("=>")) {
            this.append(line, this.resultStyle);
        } else {
            this.append(line, this.outputStyle);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeLine("" + b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.writeLine(new String(b, off, len));
    }

    @Override
    public void write(byte[] b) {
        this.writeLine(new String(b));
    }
}

