/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.AbstractVariableCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StackBasedVariableCompiler
extends AbstractVariableCompiler {
    private int scopeIndex;
    private int baseVariableIndex;

    public StackBasedVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, int scopeIndex, int argsIndex, int closureIndex, int firstTempIndex) {
        super(methodCompiler, method, argsIndex, closureIndex, firstTempIndex);
        this.baseVariableIndex = firstTempIndex;
        this.scopeIndex = scopeIndex;
    }

    @Override
    public void beginMethod(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadNil();
        for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
            this.assignLocalVariable(i);
        }
        this.method.pop();
        this.tempVariableIndex += scope.getNumberOfVariables();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        }
    }

    @Override
    public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
        throw new NotCompilableException("ERROR: stack-based variables should not be compiling class bodies");
    }

    @Override
    public void beginClosure(CompilerCallback argsCallback, StaticScope scope) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
        this.method.astore(this.scopeIndex);
        if (scope != null) {
            this.methodCompiler.loadNil();
            for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
                this.assignLocalVariable(i);
            }
            this.method.pop();
            this.tempVariableIndex += scope.getNumberOfVariables();
        }
        if (argsCallback != null) {
            this.method.aload(this.argsIndex);
            this.method.ldc(new Integer(0));
            this.method.arrayload();
            argsCallback.call(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public void assignLocalVariable(int index) {
        this.method.dup();
        this.method.astore(this.baseVariableIndex + index);
    }

    @Override
    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
        } else {
            this.method.dup();
            this.method.aload(this.scopeIndex);
            this.method.swap();
            this.method.ldc(new Integer(index));
            this.method.swap();
            this.method.ldc(new Integer(depth));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
        }
    }

    @Override
    public void retrieveLocalVariable(int index) {
        this.method.aload(this.baseVariableIndex + index);
    }

    @Override
    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
        } else {
            this.method.aload(this.scopeIndex);
            this.method.ldc(new Integer(index));
            this.method.ldc(new Integer(depth));
            this.methodCompiler.loadNil();
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
        }
    }
}

