/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBinding;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyProcess;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubySystemExit;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.LoadService;
import org.jruby.util.IdUtil;
import org.jruby.util.ShellLauncher;
import org.jruby.util.Sprintf;
import org.jruby.util.TypeConverter;

public class RubyKernel {
    public static final Class<?> IRUBY_OBJECT = IRubyObject.class;

    public static RubyModule createKernelModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Kernel");
        runtime.setKernel(module);
        CallbackFactory objectCallbackFactory = runtime.callbackFactory(RubyObject.class);
        module.defineAnnotatedMethods(RubyKernel.class);
        module.defineAnnotatedMethods(RubyObject.class);
        runtime.setRespondToMethod(module.searchMethod("respond_to?"));
        runtime.getObject().dispatcher = objectCallbackFactory.createDispatcher(runtime.getObject());
        module.setFlag(2048, false);
        return module;
    }

    @JRubyMethod(name={"at_exit"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject at_exit(IRubyObject recv, Block block) {
        return recv.getRuntime().pushExitBlock(recv.getRuntime().newProc(Block.Type.PROC, block));
    }

    @JRubyMethod(name={"autoload?"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload_p(IRubyObject recv, IRubyObject symbol) {
        RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : recv.getRuntime().getObject();
        String name = module.getName() + "::" + symbol.asJavaString();
        IAutoloadMethod autoloadMethod = recv.getRuntime().getLoadService().autoloadFor(name);
        if (autoloadMethod == null) {
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newString(autoloadMethod.file());
    }

    @JRubyMethod(name={"autoload"}, required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject autoload(IRubyObject recv, IRubyObject symbol, final IRubyObject file) {
        Ruby runtime = recv.getRuntime();
        final LoadService loadService = runtime.getLoadService();
        String nonInternedName = symbol.asJavaString();
        if (!IdUtil.isValidConstantName(nonInternedName)) {
            throw runtime.newNameError("autoload must be constant name", nonInternedName);
        }
        RubyString fileString = file.convertToString();
        if (fileString.isEmpty()) {
            throw runtime.newArgumentError("empty file name");
        }
        final String baseName = symbol.asJavaString().intern();
        final RubyModule module = recv instanceof RubyModule ? (RubyModule)recv : runtime.getObject();
        String nm = module.getName() + "::" + baseName;
        IRubyObject undef = runtime.getUndef();
        IRubyObject existingValue = module.fastFetchConstant(baseName);
        if (existingValue != null && existingValue != undef) {
            return runtime.getNil();
        }
        module.fastStoreConstant(baseName, undef);
        loadService.addAutoload(nm, new IAutoloadMethod(){

            @Override
            public String file() {
                return file.toString();
            }

            @Override
            public IRubyObject load(Ruby runtime, String name) {
                boolean required = loadService.require(this.file());
                if (!required) {
                    return null;
                }
                return module.fastGetConstant(baseName);
            }
        });
        return runtime.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyClass exc;
        Ruby runtime = recv.getRuntime();
        if (args.length == 0 || !(args[0] instanceof RubySymbol)) {
            throw runtime.newArgumentError("no id given");
        }
        String name = args[0].asJavaString();
        ThreadContext context = runtime.getCurrentContext();
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        String format = null;
        boolean noMethod = true;
        if (lastVis == Visibility.PRIVATE) {
            format = "private method `%s' called for %s";
        } else if (lastVis == Visibility.PROTECTED) {
            format = "protected method `%s' called for %s";
        } else if (lastCallType == CallType.VARIABLE) {
            format = "undefined local variable or method `%s' for %s";
            noMethod = false;
        } else if (lastCallType == CallType.SUPER) {
            format = "super: no superclass method `%s'";
        }
        if (format == null) {
            format = "undefined method `%s' for %s";
        }
        String description = null;
        if (recv.isNil()) {
            description = "nil";
        } else if (recv instanceof RubyBoolean && recv.isTrue()) {
            description = "true";
        } else if (recv instanceof RubyBoolean && !recv.isTrue()) {
            description = "false";
        } else if (name.equals("inspect") || name.equals("to_s")) {
            description = recv.anyToString().toString();
        } else {
            IRubyObject d;
            try {
                d = recv.callMethod(context, "inspect");
                if (d.getMetaClass() == recv.getMetaClass() || d instanceof RubyString && ((RubyString)d).length().getLongValue() > 65L) {
                    d = recv.anyToString();
                }
            }
            catch (JumpException je) {
                d = recv.anyToString();
            }
            description = d.toString();
        }
        if (description.length() == 0 || description.length() > 0 && description.charAt(0) != '#') {
            description = description + ":" + recv.getMetaClass().getRealClass().getName();
        }
        IRubyObject[] exArgs = new IRubyObject[noMethod ? 3 : 2];
        RubyArray arr = runtime.newArray(args[0], runtime.newString(description));
        RubyString msg = runtime.newString(Sprintf.sprintf(runtime.newString(format), (IRubyObject)arr).toString());
        if (recv.isTaint()) {
            msg.setTaint(true);
        }
        exArgs[0] = msg;
        exArgs[1] = args[0];
        if (noMethod) {
            IRubyObject[] NMEArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 1, NMEArgs, 0, NMEArgs.length);
            exArgs[2] = runtime.newArrayNoCopy(NMEArgs);
            exc = runtime.fastGetClass("NoMethodError");
        } else {
            exc = runtime.fastGetClass("NameError");
        }
        throw new RaiseException((RubyException)exc.newInstance(exArgs, Block.NULL_BLOCK));
    }

    @JRubyMethod(name={"open"}, required=1, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        String arg = args[0].convertToString().toString();
        Ruby runtime = recv.getRuntime();
        if (arg.startsWith("|")) {
            String command = arg.substring(1);
            return RubyIO.popen(runtime.getIO(), new IRubyObject[]{runtime.newString(command)}, block);
        }
        return RubyFile.open(runtime.getFile(), args, block);
    }

    @JRubyMethod(name={"getc"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject getc(IRubyObject recv) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "getc is obsolete; use STDIN.getc instead", "getc", "STDIN.getc");
        IRubyObject defin = recv.getRuntime().getGlobalVariables().get("$stdin");
        return defin.callMethod(recv.getRuntime().getCurrentContext(), "getc");
    }

    @JRubyMethod(name={"gets"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gets(IRubyObject recv, IRubyObject[] args) {
        return RubyArgsFile.gets(recv.getRuntime().getGlobalVariables().get("$<"), args);
    }

    @JRubyMethod(name={"abort"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject abort(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 1) {
            recv.getRuntime().getGlobalVariables().get("$stderr").callMethod(recv.getRuntime().getCurrentContext(), "puts", args[0]);
        }
        throw new MainExitException(1, true);
    }

    @JRubyMethod(name={"Array"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_array(IRubyObject recv, IRubyObject object) {
        IRubyObject value = object.checkArrayType();
        if (value.isNil()) {
            if (object.getMetaClass().searchMethod("to_a").getImplementationClass() != recv.getRuntime().getKernel()) {
                value = object.callMethod(recv.getRuntime().getCurrentContext(), MethodIndex.TO_A, "to_a");
                if (!(value instanceof RubyArray)) {
                    throw recv.getRuntime().newTypeError("`to_a' did not return Array");
                }
                return value;
            }
            return recv.getRuntime().newArray(object);
        }
        return value;
    }

    @JRubyMethod(name={"Float"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_float(IRubyObject recv, IRubyObject object) {
        if (object instanceof RubyFixnum) {
            return RubyFloat.newFloat(object.getRuntime(), ((RubyFixnum)object).getDoubleValue());
        }
        if (object instanceof RubyFloat) {
            return object;
        }
        if (object instanceof RubyBignum) {
            return RubyFloat.newFloat(object.getRuntime(), RubyBignum.big2dbl((RubyBignum)object));
        }
        if (object instanceof RubyString) {
            if (((RubyString)object).getByteList().realSize == 0) {
                throw recv.getRuntime().newArgumentError("invalid value for Float(): " + object.inspect());
            }
            return RubyNumeric.str2fnum(recv.getRuntime(), (RubyString)object, true);
        }
        if (object.isNil()) {
            throw recv.getRuntime().newTypeError("can't convert nil into Float");
        }
        RubyFloat rFloat = (RubyFloat)TypeConverter.convertToType(object, recv.getRuntime().getFloat(), MethodIndex.TO_F, "to_f");
        if (Double.isNaN(rFloat.getDoubleValue())) {
            throw recv.getRuntime().newArgumentError("invalid value for Float()");
        }
        return rFloat;
    }

    @JRubyMethod(name={"Integer"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_integer(IRubyObject recv, IRubyObject object) {
        IRubyObject tmp;
        if (object instanceof RubyFloat) {
            double val = ((RubyFloat)object).getDoubleValue();
            if (val > 9.223372036854776E18 && val < -9.223372036854776E18) {
                return RubyNumeric.dbl2num(recv.getRuntime(), ((RubyFloat)object).getDoubleValue());
            }
        } else {
            if (object instanceof RubyFixnum || object instanceof RubyBignum) {
                return object;
            }
            if (object instanceof RubyString) {
                return RubyNumeric.str2inum(recv.getRuntime(), (RubyString)object, 0, true);
            }
        }
        if ((tmp = TypeConverter.convertToType(object, recv.getRuntime().getInteger(), MethodIndex.TO_INT, "to_int", false)).isNil()) {
            return object.convertToInteger(MethodIndex.TO_I, "to_i");
        }
        return tmp;
    }

    @JRubyMethod(name={"String"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_string(IRubyObject recv, IRubyObject object) {
        return TypeConverter.convertToType(object, recv.getRuntime().getString(), MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod(name={"p"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject p(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            defout.callMethod(context, "write", args[i].callMethod(context, "inspect"));
            defout.callMethod(context, "write", recv.getRuntime().newString("\n"));
        }
        if (defout instanceof RubyFile) {
            ((RubyFile)defout).flush();
        }
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"putc"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject putc(IRubyObject recv, IRubyObject ch) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        return defout.callMethod(recv.getRuntime().getCurrentContext(), "putc", ch);
    }

    @JRubyMethod(name={"puts"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject puts(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "puts", args);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"print"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject print(IRubyObject recv, IRubyObject[] args) {
        IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
        ThreadContext context = recv.getRuntime().getCurrentContext();
        defout.callMethod(context, "print", args);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"printf"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject printf(IRubyObject recv, IRubyObject[] args) {
        if (args.length != 0) {
            IRubyObject defout = recv.getRuntime().getGlobalVariables().get("$>");
            if (!(args[0] instanceof RubyString)) {
                defout = args[0];
                args = ArgsUtil.popArray(args);
            }
            ThreadContext context = recv.getRuntime().getCurrentContext();
            defout.callMethod(context, "write", RubyKernel.sprintf(recv, args));
        }
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"readline"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject readline(IRubyObject recv, IRubyObject[] args) {
        IRubyObject line = RubyKernel.gets(recv, args);
        if (line.isNil()) {
            throw recv.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray readlines(IRubyObject recv, IRubyObject[] args) {
        return RubyArgsFile.readlines(recv.getRuntime().getGlobalVariables().get("$<"), args);
    }

    private static RubyString getLastlineString(Ruby runtime) {
        IRubyObject line = runtime.getCurrentContext().getPreviousFrame().getLastLine();
        if (line.isNil()) {
            throw runtime.newTypeError("$_ value need to be String (nil given).");
        }
        if (!(line instanceof RubyString)) {
            throw runtime.newTypeError("$_ value need to be String (" + line.getMetaClass().getName() + " given).");
        }
        return (RubyString)line;
    }

    @JRubyMethod(name={"sub!"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sub_bang(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).sub_bang(args, block);
    }

    @JRubyMethod(name={"sub"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sub(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.sub_bang(args, block).isNil()) {
            recv.getRuntime().getCurrentContext().getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"gsub!"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gsub_bang(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).gsub_bang(args, block);
    }

    @JRubyMethod(name={"gsub"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject gsub(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = (RubyString)RubyKernel.getLastlineString(recv.getRuntime()).dup();
        if (!str.gsub_bang(args, block).isNil()) {
            recv.getRuntime().getCurrentContext().getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"chop!"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chop_bang(IRubyObject recv, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chop_bang();
    }

    @JRubyMethod(name={"chop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chop(IRubyObject recv, Block block) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        if (str.getByteList().realSize > 0) {
            str = (RubyString)str.dup();
            str.chop_bang();
            recv.getRuntime().getCurrentContext().getPreviousFrame().setLastLine(str);
        }
        return str;
    }

    @JRubyMethod(name={"chomp!"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chomp_bang(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).chomp_bang(args);
    }

    @JRubyMethod(name={"chomp"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject chomp(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString str = RubyKernel.getLastlineString(recv.getRuntime());
        RubyString dup = (RubyString)str.dup();
        if (dup.chomp_bang(args).isNil()) {
            return str;
        }
        recv.getRuntime().getCurrentContext().getPreviousFrame().setLastLine(dup);
        return dup;
    }

    @JRubyMethod(name={"split"}, optional=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject split(IRubyObject recv, IRubyObject[] args, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).split(args);
    }

    @JRubyMethod(name={"scan"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject scan(IRubyObject recv, IRubyObject pattern, Block block) {
        return RubyKernel.getLastlineString(recv.getRuntime()).scan(pattern, block);
    }

    @JRubyMethod(name={"select"}, required=1, optional=3, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject select(IRubyObject recv, IRubyObject[] args) {
        return RubyIO.select_static(recv.getRuntime(), args);
    }

    @JRubyMethod(name={"sleep"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sleep(IRubyObject recv, IRubyObject[] args) {
        long loopStartTime;
        long milliseconds;
        if (args.length == 0) {
            milliseconds = 0L;
        } else {
            if (!(args[0] instanceof RubyNumeric)) {
                throw recv.getRuntime().newTypeError("can't convert " + args[0].getMetaClass().getName() + "into time interval");
            }
            milliseconds = (long)(args[0].convertToFloat().getDoubleValue() * 1000.0);
            if (milliseconds < 0L) {
                throw recv.getRuntime().newArgumentError("time interval must be positive");
            }
            if (milliseconds == 0L) {
                return recv.getRuntime().newFixnum(0L);
            }
        }
        long startTime = System.currentTimeMillis();
        RubyThread rubyThread = recv.getRuntime().getThreadService().getCurrentContext().getThread();
        do {
            loopStartTime = System.currentTimeMillis();
            try {
                rubyThread.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((milliseconds -= System.currentTimeMillis() - loopStartTime) > 0L);
        return recv.getRuntime().newFixnum(Math.round((double)(System.currentTimeMillis() - startTime) / 1000.0));
    }

    @JRubyMethod(name={"exit"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().secure(4);
        int status = 1;
        if (args.length > 0) {
            RubyObject argument = (RubyObject)args[0];
            status = argument instanceof RubyFixnum ? RubyNumeric.fix2int(argument) : (argument.isFalse() ? 1 : 0);
        }
        throw recv.getRuntime().newSystemExit(status);
    }

    @JRubyMethod(name={"exit!"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exit_bang(IRubyObject recv, IRubyObject[] args) {
        return RubyKernel.exit(recv, args);
    }

    @JRubyMethod(name={"global_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray global_variables(IRubyObject recv) {
        RubyArray globalVariables = recv.getRuntime().newArray();
        for (String globalVariableName : recv.getRuntime().getGlobalVariables().getNames()) {
            globalVariables.append(recv.getRuntime().newString(globalVariableName));
        }
        return globalVariables;
    }

    @JRubyMethod(name={"local_variables"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray local_variables(IRubyObject recv) {
        Ruby runtime = recv.getRuntime();
        RubyArray localVariables = runtime.newArray();
        for (String name : runtime.getCurrentContext().getCurrentScope().getAllNamesInScope()) {
            if (!IdUtil.isLocal(name)) continue;
            localVariables.append(runtime.newString(name));
        }
        return localVariables;
    }

    @JRubyMethod(name={"binding"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBinding binding(IRubyObject recv, Block block) {
        return recv.getRuntime().newBinding();
    }

    @JRubyMethod(name={"block_given?", "iterator?"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean block_given_p(IRubyObject recv, Block block) {
        return recv.getRuntime().newBoolean(recv.getRuntime().getCurrentContext().getPreviousFrame().getBlock().isGiven());
    }

    @JRubyMethod(name={"sprintf", "format"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject sprintf(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError("sprintf must have at least one argument");
        }
        RubyString str = RubyString.stringValue(args[0]);
        RubyArray newArgs = recv.getRuntime().newArrayNoCopy(args);
        newArgs.shift();
        return str.op_format(newArgs);
    }

    @JRubyMethod(name={"raise", "fail"}, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject raise(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject exception;
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            IRubyObject lastException = runtime.getGlobalVariables().get("$!");
            if (lastException.isNil()) {
                throw new RaiseException(runtime, runtime.fastGetClass("RuntimeError"), "", false);
            }
            throw new RaiseException((RubyException)lastException);
        }
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (args.length == 1) {
            if (args[0] instanceof RubyString) {
                throw new RaiseException((RubyException)runtime.fastGetClass("RuntimeError").newInstance(args, block));
            }
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception");
        } else {
            if (!args[0].respondsTo("exception")) {
                throw runtime.newTypeError("exception class/object expected");
            }
            exception = args[0].callMethod(context, "exception", args[1]);
        }
        if (!runtime.fastGetClass("Exception").isInstance(exception)) {
            throw runtime.newTypeError("exception object expected");
        }
        if (args.length == 3) {
            ((RubyException)exception).set_backtrace(args[2]);
        }
        throw new RaiseException((RubyException)exception);
    }

    @JRubyMethod(name={"require"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject require(IRubyObject recv, IRubyObject name, Block block) {
        if (recv.getRuntime().getLoadService().require(name.convertToString().toString())) {
            return recv.getRuntime().getTrue();
        }
        return recv.getRuntime().getFalse();
    }

    @JRubyMethod(name={"load"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject load(IRubyObject recv, IRubyObject[] args, Block block) {
        RubyString file = args[0].convertToString();
        boolean wrap = false;
        if (args.length == 2) {
            wrap = args[1].isTrue();
        }
        recv.getRuntime().getLoadService().load(file.getByteList().toString(), wrap);
        return recv.getRuntime().getTrue();
    }

    @JRubyMethod(name={"eval"}, required=1, optional=3, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject eval(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject scope;
        Ruby runtime = recv.getRuntime();
        RubyString src = args[0].convertToString();
        runtime.checkSafeString(src);
        IRubyObject iRubyObject = scope = args.length > 1 && !args[1].isNil() ? args[1] : null;
        String file = args.length > 2 ? args[2].convertToString().toString() : (scope == null ? "(eval)" : null);
        int line = args.length > 3 ? (int)args[3].convertToInteger().getLongValue() : (scope == null ? 0 : -1);
        if (scope == null) {
            scope = RubyBinding.newBindingForEval(runtime);
        }
        return ASTInterpreter.evalWithBinding(runtime.getCurrentContext(), src, scope, file, line);
    }

    @JRubyMethod(name={"callcc"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject callcc(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        runtime.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, "Kernel#callcc: Continuations are not implemented in JRuby and will not work", "Kernel#callcc");
        IRubyObject cc = runtime.getContinuation().callMethod(runtime.getCurrentContext(), "new");
        cc.dataWrapStruct(block);
        return block.yield(runtime.getCurrentContext(), cc);
    }

    @JRubyMethod(name={"caller"}, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject caller(IRubyObject recv, IRubyObject[] args, Block block) {
        int level;
        int n = level = args.length > 0 ? RubyNumeric.fix2int(args[0]) : 1;
        if (level < 0) {
            throw recv.getRuntime().newArgumentError("negative level(" + level + ')');
        }
        return ThreadContext.createBacktraceFromFrames(recv.getRuntime(), recv.getRuntime().getCurrentContext().createBacktrace(level, false));
    }

    @JRubyMethod(name={"catch"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbCatch(IRubyObject recv, IRubyObject tag, Block block) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        CatchTarget target = new CatchTarget(tag.asJavaString());
        try {
            context.pushCatch(target);
            IRubyObject iRubyObject = block.yield(context, tag);
            return iRubyObject;
        }
        catch (JumpException.ThrowJump tj) {
            if (tj.getTarget() == target) {
                IRubyObject iRubyObject = (IRubyObject)tj.getValue();
                return iRubyObject;
            }
            throw tj;
        }
        finally {
            context.popCatch();
        }
    }

    @JRubyMethod(name={"throw"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject rbThrow(IRubyObject recv, IRubyObject[] args, Block block) {
        Ruby runtime = recv.getRuntime();
        String tag = args[0].asJavaString();
        ThreadContext context = runtime.getCurrentContext();
        CatchTarget[] catches = context.getActiveCatches();
        String message = "uncaught throw `" + tag + "'";
        for (int i = catches.length - 1; i >= 0; --i) {
            if (!tag.equals(catches[i].getTag())) continue;
            throw new JumpException.ThrowJump(catches[i], args.length > 1 ? args[1] : runtime.getNil());
        }
        RubyThread currentThread = context.getThread();
        if (currentThread == runtime.getThreadService().getMainThread()) {
            throw runtime.newNameError(message, tag);
        }
        throw runtime.newThreadError(message + " in thread 0x" + Integer.toHexString(RubyInteger.fix2int(currentThread.id())));
    }

    @JRubyMethod(name={"trap"}, required=1, frame=true, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trap(IRubyObject recv, IRubyObject[] args, Block block) {
        recv.getRuntime().getLoadService().require("jsignal");
        return RuntimeHelpers.invoke(recv.getRuntime().getCurrentContext(), recv, "__jtrap", args, CallType.FUNCTIONAL, block);
    }

    @JRubyMethod(name={"warn"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject warn(IRubyObject recv, IRubyObject message) {
        Ruby runtime = recv.getRuntime();
        if (!runtime.getVerbose().isNil()) {
            IRubyObject out = runtime.getGlobalVariables().get("$stderr");
            out.callMethod(runtime.getCurrentContext(), "puts", new IRubyObject[]{message});
        }
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"set_trace_func"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject set_trace_func(IRubyObject recv, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            recv.getRuntime().setTraceFunction(null);
        } else {
            if (!(trace_func instanceof RubyProc)) {
                throw recv.getRuntime().newTypeError("trace_func needs to be Proc.");
            }
            recv.getRuntime().setTraceFunction((RubyProc)trace_func);
        }
        return trace_func;
    }

    @JRubyMethod(name={"trace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject trace_var(IRubyObject recv, IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError(0, 1);
        }
        RubyProc proc = null;
        String var = null;
        if (args.length > 1) {
            var = args[0].toString();
        }
        if (var.charAt(0) != '$') {
            return recv.getRuntime().getNil();
        }
        if (args.length == 1) {
            proc = RubyProc.newProc(recv.getRuntime(), block, Block.Type.PROC);
        }
        if (args.length == 2) {
            proc = (RubyProc)TypeConverter.convertToType(args[1], recv.getRuntime().getProc(), 0, "to_proc", true);
        }
        recv.getRuntime().getGlobalVariables().setTraceVar(var, proc);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"untrace_var"}, required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject untrace_var(IRubyObject recv, IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError(0, 1);
        }
        String var = null;
        if (args.length >= 1) {
            var = args[0].toString();
        }
        if (var.charAt(0) != '$') {
            return recv.getRuntime().getNil();
        }
        if (args.length > 1) {
            ArrayList<IRubyObject> success = new ArrayList<IRubyObject>();
            for (int i = 1; i < args.length; ++i) {
                if (!recv.getRuntime().getGlobalVariables().untraceVar(var, args[i])) continue;
                success.add(args[i]);
            }
            return RubyArray.newArray(recv.getRuntime(), success);
        }
        recv.getRuntime().getGlobalVariables().untraceVar(var);
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_added"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, required=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined(IRubyObject recv, IRubyObject symbolId, Block block) {
        return recv.getRuntime().getNil();
    }

    @JRubyMethod(name={"proc", "lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public static RubyProc proc(IRubyObject recv, Block block) {
        return recv.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"lambda"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc lambda(IRubyObject recv, Block block) {
        return recv.getRuntime().newProc(Block.Type.LAMBDA, block);
    }

    @JRubyMethod(name={"proc"}, frame=true, module=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public static RubyProc proc_1_9(IRubyObject recv, Block block) {
        return recv.getRuntime().newProc(Block.Type.PROC, block);
    }

    @JRubyMethod(name={"loop"}, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject loop(IRubyObject recv, Block block) {
        ThreadContext context = recv.getRuntime().getCurrentContext();
        try {
            while (true) {
                block.yield(context, recv.getRuntime().getNil());
                context.pollThreadEvents();
            }
        }
        catch (JumpException.BreakJump bj) {
            if (bj.getTarget() != null && bj.getTarget() != block.getBody()) {
                bj.setBreakInKernelLoop(true);
            }
            throw bj;
        }
    }

    @JRubyMethod(name={"test"}, required=2, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject test(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            throw recv.getRuntime().newArgumentError("wrong number of arguments");
        }
        int cmd = args[0] instanceof RubyFixnum ? (int)((RubyFixnum)args[0]).getLongValue() : (args[0] instanceof RubyString && ((RubyString)args[0]).getByteList().length() > 0 ? (int)((RubyString)args[0]).getByteList().charAt(0) : (int)args[0].convertToInteger().getLongValue());
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 71: 
            case 77: 
            case 79: 
            case 82: 
            case 83: 
            case 87: 
            case 88: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 107: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 119: 
            case 120: 
            case 122: {
                break;
            }
            default: {
                throw recv.getRuntime().newArgumentError("unknown command ?" + (char)cmd);
            }
        }
        switch (cmd) {
            case 45: 
            case 60: 
            case 61: 
            case 62: {
                if (args.length == 3) break;
                throw recv.getRuntime().newArgumentError(args.length, 3);
            }
            default: {
                if (args.length == 2) break;
                throw recv.getRuntime().newArgumentError(args.length, 2);
            }
        }
        switch (cmd) {
            case 65: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).atime();
            }
            case 98: {
                return RubyFileTest.blockdev_p(recv, args[1]);
            }
            case 99: {
                return RubyFileTest.chardev_p(recv, args[1]);
            }
            case 67: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).ctime();
            }
            case 100: {
                return RubyFileTest.directory_p(recv, args[1]);
            }
            case 101: {
                return RubyFileTest.exist_p(recv, args[1]);
            }
            case 102: {
                return RubyFileTest.file_p(recv, args[1]);
            }
            case 103: {
                return RubyFileTest.setgid_p(recv, args[1]);
            }
            case 71: {
                return RubyFileTest.grpowned_p(recv, args[1]);
            }
            case 107: {
                return RubyFileTest.sticky_p(recv, args[1]);
            }
            case 77: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtime();
            }
            case 108: {
                return RubyFileTest.symlink_p(recv, args[1]);
            }
            case 111: {
                return RubyFileTest.owned_p(recv, args[1]);
            }
            case 79: {
                return RubyFileTest.rowned_p(recv, args[1]);
            }
            case 112: {
                return RubyFileTest.pipe_p(recv, args[1]);
            }
            case 114: {
                return RubyFileTest.readable_p(recv, args[1]);
            }
            case 82: {
                return RubyFileTest.readable_p(recv, args[1]);
            }
            case 115: {
                return RubyFileTest.size_p(recv, args[1]);
            }
            case 83: {
                return RubyFileTest.socket_p(recv, args[1]);
            }
            case 117: {
                return RubyFileTest.setuid_p(recv, args[1]);
            }
            case 119: {
                return RubyFileTest.writable_p(recv, args[1]);
            }
            case 87: {
                return RubyFileTest.writable_p(recv, args[1]);
            }
            case 120: {
                return RubyFileTest.executable_p(recv, args[1]);
            }
            case 88: {
                return RubyFileTest.executable_real_p(recv, args[1]);
            }
            case 122: {
                return RubyFileTest.zero_p(recv, args[1]);
            }
            case 61: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeEquals(args[2]);
            }
            case 60: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeLessThan(args[2]);
            }
            case 62: {
                return recv.getRuntime().newFileStat(args[1].convertToString().toString(), false).mtimeGreaterThan(args[2]);
            }
            case 45: {
                return RubyFileTest.identical_p(recv, args[1], args[2]);
            }
        }
        throw new InternalError("unreachable code reached!");
    }

    @JRubyMethod(name={"`"}, required=1, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject backquote(IRubyObject recv, IRubyObject aString) {
        Ruby runtime = recv.getRuntime();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        RubyString string = aString.convertToString();
        int resultCode = new ShellLauncher(runtime).runAndWait(new IRubyObject[]{string}, output);
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return RubyString.newString(recv.getRuntime(), output.toByteArray());
    }

    @JRubyMethod(name={"srand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyInteger srand(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        long oldRandomSeed = runtime.getRandomSeed();
        if (args.length > 0) {
            RubyInteger integerSeed = args[0].convertToInteger(MethodIndex.TO_INT, "to_int");
            runtime.setRandomSeed(integerSeed.getLongValue());
        } else {
            runtime.setRandomSeed(System.currentTimeMillis() ^ (long)recv.hashCode() ^ runtime.incrementRandomSeedSequence() ^ (long)runtime.getRandom().nextInt(Math.max(1, Math.abs((int)runtime.getRandomSeed()))));
        }
        runtime.getRandom().setSeed(runtime.getRandomSeed());
        return runtime.newFixnum(oldRandomSeed);
    }

    @JRubyMethod(name={"rand"}, optional=1, module=true, visibility=Visibility.PRIVATE)
    public static RubyNumeric rand(IRubyObject recv, IRubyObject[] args) {
        long ceil;
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            ceil = 0L;
        } else if (args.length == 1) {
            if (args[0] instanceof RubyBignum) {
                byte[] bigCeilBytes = ((RubyBignum)args[0]).getValue().toByteArray();
                BigInteger bigCeil = new BigInteger(bigCeilBytes).abs();
                byte[] randBytes = new byte[bigCeilBytes.length];
                runtime.getRandom().nextBytes(randBytes);
                BigInteger result = new BigInteger(randBytes).abs().mod(bigCeil);
                return new RubyBignum(runtime, result);
            }
            RubyInteger integerCeil = (RubyInteger)RubyKernel.new_integer(recv, args[0]);
            ceil = Math.abs(integerCeil.getLongValue());
        } else {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for 1)");
        }
        if (ceil == 0L) {
            return RubyFloat.newFloat(runtime, runtime.getRandom().nextDouble());
        }
        if (ceil > Integer.MAX_VALUE) {
            return runtime.newFixnum(Math.abs(runtime.getRandom().nextLong()) % ceil);
        }
        return runtime.newFixnum(runtime.getRandom().nextInt((int)ceil));
    }

    @JRubyMethod(name={"syscall"}, required=1, optional=9, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject syscall(IRubyObject recv, IRubyObject[] args) {
        throw recv.getRuntime().newNotImplementedError("Kernel#syscall is not implemented in JRuby");
    }

    @JRubyMethod(name={"system"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static RubyBoolean system(IRubyObject recv, IRubyObject[] args) {
        int resultCode;
        Ruby runtime = recv.getRuntime();
        try {
            resultCode = new ShellLauncher(runtime).runAndWait(args);
        }
        catch (Exception e) {
            resultCode = 127;
        }
        recv.getRuntime().getGlobalVariables().set("$?", RubyProcess.RubyStatus.newProcessStatus(runtime, resultCode));
        return runtime.newBoolean(resultCode == 0);
    }

    @JRubyMethod(name={"exec"}, required=1, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject exec(IRubyObject recv, IRubyObject[] args) {
        int resultCode;
        Ruby runtime = recv.getRuntime();
        try {
            resultCode = new ShellLauncher(runtime).runAndWait(args);
        }
        catch (Exception e) {
            throw runtime.newErrnoENOENTError("cannot execute");
        }
        return RubyKernel.exit(recv, new IRubyObject[]{runtime.newFixnum(resultCode)});
    }

    @JRubyMethod(name={"fork"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject fork(IRubyObject recv, Block block) {
        Ruby runtime = recv.getRuntime();
        if (!RubyInstanceConfig.FORK_ENABLED) {
            throw runtime.newNotImplementedError("fork is unsafe and disabled by default on JRuby");
        }
        if (block.isGiven()) {
            int pid = runtime.getPosix().fork();
            if (pid == 0) {
                try {
                    block.yield(runtime.getCurrentContext(), runtime.getNil());
                }
                catch (RaiseException re) {
                    if (re.getException() instanceof RubySystemExit) {
                        throw re;
                    }
                    return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.minus_one(runtime)});
                }
                catch (Throwable t) {
                    return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.minus_one(runtime)});
                }
                return RubyKernel.exit_bang(recv, new IRubyObject[]{RubyFixnum.zero(runtime)});
            }
            return runtime.newFixnum(pid);
        }
        int result = runtime.getPosix().fork();
        if (result == -1) {
            return runtime.getNil();
        }
        return runtime.newFixnum(result);
    }

    public static class CatchTarget
    implements JumpTarget {
        private final String tag;

        public CatchTarget(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

