/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyInteger
extends RubyNumeric {
    public static RubyClass createIntegerClass(Ruby runtime) {
        RubyClass integer = runtime.defineClass("Integer", runtime.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setInteger(integer);
        integer.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyInteger;
            }
        };
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyInteger.class);
        integer.getSingletonClass().undefineMethod("new");
        integer.includeModule(runtime.getPrecision());
        integer.defineAnnotatedMethods(RubyInteger.class);
        integer.dispatcher = callbackFactory.createDispatcher(integer);
        return integer;
    }

    public RubyInteger(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public RubyInteger(Ruby runtime, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime, rubyClass, useObjectSpace);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @Override
    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"upto"}, required=1, frame=true)
    public IRubyObject upto(IRubyObject to, Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            long fromValue;
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            for (long i = fromValue = this.getLongValue(); i <= toValue; ++i) {
                block.yield(context, RubyFixnum.newFixnum(runtime, i));
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, MethodIndex.OP_GT, ">", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(runtime));
            }
        }
        return this;
    }

    @JRubyMethod(name={"downto"}, required=1, frame=true)
    public IRubyObject downto(IRubyObject to, Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyFixnum toFixnum = (RubyFixnum)to;
            long toValue = toFixnum.getLongValue();
            for (long i = this.getLongValue(); i >= toValue; --i) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric i = this;
            while (!i.callMethod(context, MethodIndex.OP_LT, "<", to).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_MINUS, "-", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"times"}, frame=true)
    public IRubyObject times(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this instanceof RubyFixnum) {
            long value = this.getLongValue();
            for (long i = 0L; i < value; ++i) {
                block.yield(context, RubyFixnum.newFixnum(this.getRuntime(), i));
            }
        } else {
            RubyNumeric i = RubyFixnum.zero(this.getRuntime());
            while (i.callMethod(context, MethodIndex.OP_LT, "<", this).isTrue()) {
                block.yield(context, i);
                i = (RubyNumeric)i.callMethod(context, MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
            }
        }
        return this;
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ() {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.OP_PLUS, "+", RubyFixnum.one(this.getRuntime()));
    }

    @JRubyMethod(name={"chr"})
    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return this.getRuntime().newString(new String(new char[]{(char)this.getLongValue()}));
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "round", "truncate"})
    public RubyInteger to_i() {
        return this;
    }

    @JRubyMethod(name={"induced_from"}, meta=true, required=1)
    public static IRubyObject induced_from(IRubyObject recv, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat) {
            return other.callMethod(recv.getRuntime().getCurrentContext(), MethodIndex.TO_I, "to_i");
        }
        throw recv.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }
}

