/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.FileStat;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private JRubyFile file;
    private FileStat stat;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyFileStat(runtime, klass);
        }
    };

    public static RubyClass createFileStatClass(Ruby runtime) {
        RubyClass fileStatClass = runtime.getFile().defineClassUnder("Stat", runtime.getObject(), ALLOCATOR);
        runtime.setFileStat(fileStatClass);
        fileStatClass.includeModule(runtime.fastGetModule("Comparable"));
        fileStatClass.defineAnnotatedMethods(RubyFileStat.class);
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    public static RubyFileStat newFileStat(Ruby runtime, String filename, boolean lstat) {
        RubyFileStat stat = new RubyFileStat(runtime, runtime.getFileStat());
        stat.setup(filename, lstat);
        return stat;
    }

    public static RubyFileStat newFileStat(Ruby runtime, FileDescriptor descriptor) {
        RubyFileStat stat = new RubyFileStat(runtime, runtime.getFileStat());
        stat.setup(descriptor);
        return stat;
    }

    private void setup(FileDescriptor descriptor) {
        this.stat = this.getRuntime().getPosix().fstat(descriptor);
    }

    private void setup(String filename, boolean lstat) {
        if (RubyFile.IS_WINDOWS && filename.length() == 2 && filename.charAt(1) == ':' && Character.isLetter(filename.charAt(0))) {
            filename = filename + "/";
        }
        this.file = JRubyFile.create(this.getRuntime().getCurrentDirectory(), filename);
        this.stat = lstat ? this.getRuntime().getPosix().lstat(this.file.getAbsolutePath()) : this.getRuntime().getPosix().stat(this.file.getAbsolutePath());
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        this.setup(fname.convertToString().toString(), false);
        return this;
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime() {
        return this.getRuntime().newTime(this.stat.atime() * 1000L);
    }

    @JRubyMethod(name={"blksize"})
    public RubyFixnum blksize() {
        return this.getRuntime().newFixnum(this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p() {
        return this.getRuntime().newBoolean(this.stat.isBlockDev());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks() {
        return this.getRuntime().newFixnum(this.stat.blocks());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p() {
        return this.getRuntime().newBoolean(this.stat.isCharDev());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject cmp(IRubyObject other) {
        long time2;
        long time1;
        if (!(other instanceof RubyFileStat)) {
            this.getRuntime().getNil();
        }
        if ((time1 = this.stat.mtime()) == (time2 = ((RubyFileStat)other).stat.mtime())) {
            return this.getRuntime().newFixnum(0L);
        }
        if (time1 < time2) {
            return this.getRuntime().newFixnum(-1L);
        }
        return this.getRuntime().newFixnum(1L);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        return this.getRuntime().newTime(this.stat.ctime() * 1000L);
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev() {
        return this.getRuntime().newFixnum(this.stat.dev());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.dev()));
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.dev()));
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        return this.getRuntime().newBoolean(this.stat.isDirectory());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutable());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutableReal());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        return this.getRuntime().newBoolean(this.stat.isFile());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        return this.getRuntime().newString(this.stat.ftype());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid() {
        return this.getRuntime().newFixnum(this.stat.gid());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p() {
        return this.getRuntime().newBoolean(this.stat.isGroupOwned());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyFileStat)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyFileStat originalFileStat = (RubyFileStat)original;
        this.file = originalFileStat.file;
        this.stat = originalFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        return this.getRuntime().newFixnum(this.stat.ino());
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        buf.append(this.getMetaClass().getRealClass().getName());
        buf.append(" ");
        try {
            buf.append("dev=0").append(Long.toHexString(this.stat.dev())).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            buf.append("ino=").append(this.stat.ino()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
        try {
            buf.append("nlink=").append(this.stat.nlink()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            buf.append("uid=").append(this.stat.uid()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            buf.append("gid=").append(this.stat.gid()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            buf.append("rdev=0").append(Long.toHexString(this.stat.rdev())).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("size=").append(this.stat.st_size()).append(", ");
        try {
            buf.append("blksize=").append(this.stat.blockSize()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            buf.append("blocks=").append(this.stat.blocks()).append(", ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        buf.append("atime=").append(this.atime()).append(", ");
        buf.append("mtime=").append(this.mtime()).append(", ");
        buf.append("ctime=").append(this.ctime()).append(", ");
        buf.append(">");
        return this.getRuntime().newString(buf.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        return this.getRuntime().newFixnum(this.stat.uid());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        return this.getRuntime().newFixnum(this.stat.mode());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.getRuntime().newTime(this.stat.mtime() * 1000L);
    }

    public IRubyObject mtimeEquals(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() == RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeGreaterThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() > RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeLessThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() < RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink() {
        return this.getRuntime().newFixnum(this.stat.nlink());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p() {
        return this.getRuntime().newBoolean(this.stat.isOwned());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p() {
        return this.getRuntime().newBoolean(this.stat.isNamedPipe());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev() {
        return this.getRuntime().newFixnum(this.stat.rdev());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.rdev()));
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.rdev()));
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        return this.getRuntime().newBoolean(this.stat.isReadable());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isReadableReal());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetgid());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetuid());
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.stat.st_size());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p() {
        long size = this.stat.st_size();
        if (size == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(size);
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p() {
        return this.getRuntime().newBoolean(this.stat.isSocket());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p() {
        return this.getRuntime().newBoolean(this.stat.isSticky());
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        return this.getRuntime().newBoolean(this.getRuntime().getPosix().lstat(this.file.getAbsolutePath()).isSymlink());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        return this.getRuntime().newBoolean(this.stat.isWritable());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isWritableReal());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.stat.isEmpty());
    }
}

