/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.JRubyFile;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.Stream;

public class RubyFile
extends RubyIO {
    private static final long serialVersionUID = 1L;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    static final boolean IS_WINDOWS;
    protected String path;
    private FileLock currentLock;
    private static ObjectAllocator FILE_ALLOCATOR;

    public RubyFile(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public RubyFile(Ruby runtime, String path, final Reader reader) {
        this(runtime, path, new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby runtime, String path, InputStream in) {
        super(runtime, runtime.getFile());
        this.path = path;
        try {
            this.openFile.setMainStream(new ChannelStream(runtime, new ChannelDescriptor(Channels.newChannel(in), RubyFile.getNewFileno(), new FileDescriptor())));
        }
        catch (InvalidValueException ex) {
            throw runtime.newErrnoEINVALError();
        }
        this.openFile.setMode(this.openFile.getMainStream().getModes().getOpenFileFlags());
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    public static RubyClass createFileClass(Ruby runtime) {
        RubyClass fileClass = runtime.defineClass("File", runtime.getIO(), FILE_ALLOCATOR);
        runtime.setFile(fileClass);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFile.class);
        RubyString separator = runtime.newString("/");
        fileClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyFile;
            }
        };
        separator.freeze();
        fileClass.defineConstant("SEPARATOR", separator);
        fileClass.defineConstant("Separator", separator);
        if (File.separatorChar == '\\') {
            RubyString altSeparator = runtime.newString("\\");
            altSeparator.freeze();
            fileClass.defineConstant("ALT_SEPARATOR", altSeparator);
        } else {
            fileClass.defineConstant("ALT_SEPARATOR", runtime.getNil());
        }
        RubyString pathSeparator = runtime.newString(File.pathSeparator);
        pathSeparator.freeze();
        fileClass.defineConstant("PATH_SEPARATOR", pathSeparator);
        fileClass.fastSetConstant("BINARY", runtime.newFixnum(32768L));
        fileClass.fastSetConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
        fileClass.fastSetConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
        fileClass.fastSetConstant("FNM_SYSCASE", runtime.newFixnum(8L));
        fileClass.fastSetConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
        fileClass.fastSetConstant("FNM_PATHNAME", runtime.newFixnum(2L));
        fileClass.fastSetConstant("RDONLY", runtime.newFixnum(0L));
        fileClass.fastSetConstant("WRONLY", runtime.newFixnum(1L));
        fileClass.fastSetConstant("RDWR", runtime.newFixnum(2L));
        fileClass.fastSetConstant("CREAT", runtime.newFixnum(256L));
        fileClass.fastSetConstant("EXCL", runtime.newFixnum(1024L));
        fileClass.fastSetConstant("NOCTTY", runtime.newFixnum(256L));
        fileClass.fastSetConstant("TRUNC", runtime.newFixnum(512L));
        fileClass.fastSetConstant("APPEND", runtime.newFixnum(8L));
        fileClass.fastSetConstant("NONBLOCK", runtime.newFixnum(4L));
        fileClass.fastSetConstant("LOCK_SH", runtime.newFixnum(1L));
        fileClass.fastSetConstant("LOCK_EX", runtime.newFixnum(2L));
        fileClass.fastSetConstant("LOCK_NB", runtime.newFixnum(4L));
        fileClass.fastSetConstant("LOCK_UN", runtime.newFixnum(8L));
        RubyModule constants = fileClass.defineModuleUnder("Constants");
        constants.fastSetConstant("BINARY", runtime.newFixnum(32768L));
        constants.fastSetConstant("FNM_NOESCAPE", runtime.newFixnum(1L));
        constants.fastSetConstant("FNM_CASEFOLD", runtime.newFixnum(8L));
        constants.fastSetConstant("FNM_DOTMATCH", runtime.newFixnum(4L));
        constants.fastSetConstant("FNM_PATHNAME", runtime.newFixnum(2L));
        constants.fastSetConstant("RDONLY", runtime.newFixnum(0L));
        constants.fastSetConstant("WRONLY", runtime.newFixnum(1L));
        constants.fastSetConstant("RDWR", runtime.newFixnum(2L));
        constants.fastSetConstant("CREAT", runtime.newFixnum(256L));
        constants.fastSetConstant("EXCL", runtime.newFixnum(1024L));
        constants.fastSetConstant("NOCTTY", runtime.newFixnum(256L));
        constants.fastSetConstant("TRUNC", runtime.newFixnum(512L));
        constants.fastSetConstant("APPEND", runtime.newFixnum(8L));
        constants.fastSetConstant("NONBLOCK", runtime.newFixnum(4L));
        constants.fastSetConstant("LOCK_SH", runtime.newFixnum(1L));
        constants.fastSetConstant("LOCK_EX", runtime.newFixnum(2L));
        constants.fastSetConstant("LOCK_NB", runtime.newFixnum(4L));
        constants.fastSetConstant("LOCK_UN", runtime.newFixnum(8L));
        runtime.getFileTest().extend_object(fileClass);
        fileClass.defineAnnotatedMethods(RubyFile.class);
        fileClass.dispatcher = callbackFactory.createDispatcher(fileClass);
        return fileClass;
    }

    public void openInternal(String newPath, ModeFlags newModes) {
        this.path = newPath;
        this.openFile.setMode(newModes.getOpenFileFlags());
        if ("/dev/null".equals(this.path) && SafePropertyAccessor.getProperty("os.name").contains("Windows")) {
            this.path = "NUL:";
        }
        try {
            if (newPath.startsWith("file:")) {
                JarFile jf;
                String filePath = this.path.substring(5, this.path.indexOf("!"));
                String internalPath = this.path.substring(this.path.indexOf("!") + 2);
                try {
                    jf = new JarFile(filePath);
                }
                catch (IOException e) {
                    throw this.getRuntime().newErrnoENOENTError("File not found - " + newPath);
                }
                ZipEntry zf = jf.getEntry(internalPath);
                if (zf == null) {
                    throw this.getRuntime().newErrnoENOENTError("File not found - " + newPath);
                }
                InputStream is = jf.getInputStream(zf);
                this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(Channels.newChannel(is), RubyFile.getNewFileno(), new FileDescriptor())));
            } else {
                try {
                    this.openFile.setMainStream(ChannelStream.fopen(this.getRuntime(), newPath, newModes));
                }
                catch (BadDescriptorException e) {
                    throw this.getRuntime().newErrnoEBADFError();
                }
                catch (FileExistsException fee) {
                    throw this.getRuntime().newErrnoEEXISTError(fee.getMessage());
                }
            }
            this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
        catch (InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (DirectoryAsFileException e) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileNotFoundException e) {
            if (Ruby.isSecurityRestricted() || new File(newPath).exists()) {
                throw this.getRuntime().newErrnoEACCESError("Permission denied - " + newPath);
            }
            throw this.getRuntime().newErrnoENOENTError("File not found - " + newPath);
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
        catch (SecurityException se) {
            throw this.getRuntime().newIOError(se.getMessage());
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject close() {
        if (this.currentLock != null) {
            try {
                this.currentLock.release();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return super.close();
    }

    @JRubyMethod(required=1)
    public IRubyObject flock(IRubyObject lockingConstant) {
        block17: {
            assert (this.openFile.getMainStream().getDescriptor().isSeekable());
            FileChannel fileChannel = (FileChannel)this.openFile.getMainStream().getDescriptor().getChannel();
            int lockMode = RubyNumeric.num2int(lockingConstant);
            if (!this.openFile.isWritable() && (lockMode & 2) > 0) {
                lockMode = lockMode ^ 2 | 1;
            }
            try {
                switch (lockMode) {
                    case 8: 
                    case 12: {
                        if (this.currentLock == null) break;
                        this.currentLock.release();
                        this.currentLock = null;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 2: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock();
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 6: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock();
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 1: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.lock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                    case 5: {
                        if (this.currentLock != null) {
                            this.currentLock.release();
                            this.currentLock = null;
                        }
                        this.currentLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
                        if (this.currentLock == null) break;
                        return this.getRuntime().newFixnum(0L);
                    }
                }
            }
            catch (IOException ioe) {
                if (this.getRuntime().getDebug().isTrue()) {
                    ioe.printStackTrace(System.err);
                }
            }
            catch (OverlappingFileLockException ioe) {
                if (!this.getRuntime().getDebug().isTrue()) break block17;
                ioe.printStackTrace(System.err);
            }
        }
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(required=1, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject fd;
        if (this.openFile == null) {
            throw this.getRuntime().newRuntimeError("reinitializing File");
        }
        if (args.length > 0 && args.length < 3 && !(fd = TypeConverter.convertToTypeWithCheck(args[0], this.getRuntime().getFixnum(), MethodIndex.TO_INT, "to_int")).isNil()) {
            args[0] = fd;
            return super.initialize(args, block);
        }
        return this.openFile(args);
    }

    private IRubyObject openFile(IRubyObject[] args) {
        RubyString filename = args[0].convertToString();
        this.getRuntime().checkSafeString(filename);
        this.path = ((Object)filename).toString();
        try {
            if (args.length > 1 && args[1] instanceof RubyFixnum || args.length > 2 && !args[2].isNil()) {
                ModeFlags modes;
                if (args[1] instanceof RubyFixnum) {
                    modes = new ModeFlags(RubyNumeric.num2int(args[1]));
                } else {
                    String modeString = args[1].convertToString().toString();
                    modes = RubyFile.getIOModes(this.getRuntime(), modeString);
                }
                int perm = args.length > 2 && !args[2].isNil() ? RubyNumeric.num2int(args[2]) : 438;
                this.sysopenInternal(this.path, modes, perm);
            } else {
                String modeString = "r";
                if (args.length > 1 && !args[1].isNil()) {
                    modeString = args[1].convertToString().toString();
                }
                this.openInternal(this.path, modeString);
            }
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return this;
    }

    private void sysopenInternal(String path, ModeFlags modes, int perm) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setPath(path);
        this.openFile.setMode(modes.getOpenFileFlags());
        ChannelDescriptor descriptor = this.sysopen(path, modes, perm);
        this.openFile.setMainStream(this.fdopen(descriptor, modes));
        this.registerDescriptor(descriptor);
    }

    private void openInternal(String path, String modeString) throws InvalidValueException {
        this.openFile = new OpenFile();
        this.openFile.setMode(RubyFile.getIOModes(this.getRuntime(), modeString).getOpenFileFlags());
        this.openFile.setPath(path);
        this.openFile.setMainStream(this.fopen(path, modeString));
        this.registerDescriptor(this.openFile.getMainStream().getDescriptor());
    }

    private ChannelDescriptor sysopen(String path, ModeFlags modes, int perm) throws InvalidValueException {
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(this.getRuntime().getCurrentDirectory(), path, modes, perm, this.getRuntime().getPosix());
            return descriptor;
        }
        catch (FileNotFoundException fnfe) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (DirectoryAsFileException dafe) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException fee) {
            throw this.getRuntime().newErrnoEEXISTError("file exists: " + path);
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private Stream fopen(String path, String modeString) {
        try {
            Stream stream = ChannelStream.fopen(this.getRuntime(), path, RubyFile.getIOModes(this.getRuntime(), modeString));
            if (stream == null) {
                // empty if block
            }
            return stream;
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (FileNotFoundException ex) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (DirectoryAsFileException ex) {
            throw this.getRuntime().newErrnoEISDirError();
        }
        catch (FileExistsException ex) {
            throw this.getRuntime().newErrnoEEXISTError(path);
        }
        catch (IOException ex) {
            throw this.getRuntime().newIOErrorFromException(ex);
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (PipeException ex) {
            throw this.getRuntime().newErrnoEPIPEError();
        }
    }

    @JRubyMethod(required=1)
    public IRubyObject chmod(IRubyObject arg) {
        int mode = (int)arg.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().chmod(this.path, mode));
    }

    @JRubyMethod(required=2)
    public IRubyObject chown(IRubyObject arg1, IRubyObject arg2) {
        int owner = (int)arg1.convertToInteger().getLongValue();
        int group = (int)arg2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().chown(this.path, owner, group));
    }

    @JRubyMethod
    public IRubyObject atime() {
        return this.getRuntime().newFileStat(this.path, false).atime();
    }

    @JRubyMethod
    public IRubyObject ctime() {
        return this.getRuntime().newFileStat(this.path, false).ctime();
    }

    @JRubyMethod(required=1)
    public IRubyObject lchmod(IRubyObject arg) {
        int mode = (int)arg.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().lchmod(this.path, mode));
    }

    @JRubyMethod(required=2)
    public IRubyObject lchown(IRubyObject arg1, IRubyObject arg2) {
        int owner = (int)arg1.convertToInteger().getLongValue();
        int group = (int)arg2.convertToInteger().getLongValue();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        return this.getRuntime().newFixnum(this.getRuntime().getPosix().lchown(this.path, owner, group));
    }

    @JRubyMethod
    public IRubyObject lstat() {
        return this.getRuntime().newFileStat(this.path, true);
    }

    @JRubyMethod
    public IRubyObject mtime() {
        return RubyFile.getLastModified(this.getRuntime(), this.path);
    }

    @JRubyMethod
    public RubyString path() {
        return this.getRuntime().newString(this.path);
    }

    @Override
    @JRubyMethod
    public IRubyObject stat() {
        this.openFile.checkClosed(this.getRuntime());
        return this.getRuntime().newFileStat(this.path, false);
    }

    @JRubyMethod(required=1)
    public IRubyObject truncate(IRubyObject arg) {
        RubyInteger newLength = arg.convertToInteger();
        if (newLength.getLongValue() < 0L) {
            throw this.getRuntime().newErrnoEINVALError("invalid argument: " + this.path);
        }
        try {
            this.openFile.checkWritable(this.getRuntime());
            this.openFile.getMainStream().ftruncate(newLength.getLongValue());
        }
        catch (BadDescriptorException e) {
            throw this.getRuntime().newErrnoEBADFError();
        }
        catch (PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public String toString() {
        return "RubyFile(" + this.path + ", " + this.openFile.getMode() + ", " + this.openFile.getMainStream().getDescriptor().getFileno() + ")";
    }

    private static ModeFlags getModes(Ruby runtime, IRubyObject object) throws InvalidValueException {
        if (object instanceof RubyString) {
            return RubyFile.getIOModes(runtime, ((RubyString)object).toString());
        }
        if (object instanceof RubyFixnum) {
            return new ModeFlags(((RubyFixnum)object).getLongValue());
        }
        throw runtime.newTypeError("Invalid type for modes");
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer();
        val.append("#<File:").append(this.path);
        if (!this.openFile.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject basename(IRubyObject recv, IRubyObject[] args) {
        int index;
        char c;
        String name = RubyString.stringValue(args[0]).toString();
        if (IS_WINDOWS && name.length() > 1 && name.charAt(1) == ':' && Character.isLetter(name.charAt(0))) {
            switch (name.length()) {
                case 2: {
                    return recv.getRuntime().newString("").infectBy(args[0]);
                }
                case 3: {
                    return recv.getRuntime().newString(name.substring(2)).infectBy(args[0]);
                }
            }
            switch (name.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    name = name.substring(2);
                }
            }
        }
        while (name.length() > 1 && name.charAt(name.length() - 1) == '/') {
            name = name.substring(0, name.length() - 1);
        }
        int slashCount = 0;
        int length = name.length();
        for (int i = length - 1; i >= 0 && ((c = name.charAt(i)) == '/' || c == '\\'); --i) {
            ++slashCount;
        }
        if (slashCount > 0 && length > 1) {
            name = name.substring(0, name.length() - slashCount);
        }
        if ((index = name.lastIndexOf(47)) == -1) {
            index = name.lastIndexOf(92);
        }
        if (!name.equals("/") && index != -1) {
            name = name.substring(index + 1);
        }
        if (args.length == 2) {
            String ext = RubyString.stringValue(args[1]).toString();
            if (".*".equals(ext)) {
                index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else if (name.endsWith(ext)) {
                name = name.substring(0, name.length() - ext.length());
            }
        }
        return recv.getRuntime().newString(name).infectBy(args[0]);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject chmod(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int count = 0;
        RubyInteger mode = args[0].convertToInteger();
        for (int i = 1; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == runtime.getPosix().chmod(filename.toString(), (int)mode.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject chown(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int count = 0;
        RubyInteger owner = args[0].convertToInteger();
        RubyInteger group = args[1].convertToInteger();
        for (int i = 2; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == runtime.getPosix().chown(filename.toString(), (int)owner.getLongValue(), (int)group.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject dirname(IRubyObject recv, IRubyObject arg) {
        char endChar;
        String result;
        boolean startsWithDriveLetterOnWindows;
        RubyString filename = RubyString.stringValue(arg);
        String jfilename = filename.toString();
        String name = jfilename.replace('\\', '/');
        int minPathLength = 1;
        boolean trimmedSlashes = false;
        boolean bl = startsWithDriveLetterOnWindows = IS_WINDOWS && name.length() > 1 && RubyFile.isWindowsDriveLetter(name.charAt(0)) && name.charAt(1) == ':';
        if (startsWithDriveLetterOnWindows) {
            minPathLength = 3;
        }
        while (name.length() > minPathLength && name.charAt(name.length() - 1) == '/') {
            trimmedSlashes = true;
            name = name.substring(0, name.length() - 1);
        }
        if (startsWithDriveLetterOnWindows && name.length() == 2) {
            result = trimmedSlashes ? jfilename.substring(0, 3) : jfilename.substring(0, 2) + '.';
        } else {
            int index = name.lastIndexOf(47);
            if (index == -1) {
                if (startsWithDriveLetterOnWindows) {
                    return recv.getRuntime().newString(jfilename.substring(0, 2) + ".");
                }
                return recv.getRuntime().newString(".");
            }
            if (index == 0) {
                return recv.getRuntime().newString("/");
            }
            if (startsWithDriveLetterOnWindows && index == 2) {
                ++index;
            }
            result = jfilename.substring(0, index);
        }
        while (result.length() > minPathLength && ((endChar = result.charAt(result.length() - 1)) == '/' || endChar == '\\')) {
            result = result.substring(0, result.length() - 1);
        }
        return recv.getRuntime().newString(result).infectBy(filename);
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject extname(IRubyObject recv, IRubyObject arg) {
        IRubyObject baseFilename = RubyFile.basename(recv, new IRubyObject[]{arg});
        String filename = RubyString.stringValue(baseFilename).toString();
        String result = "";
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex > 0 && dotIndex != filename.length() - 1) {
            result = filename.substring(dotIndex);
        }
        return recv.getRuntime().newString(result);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject expand_path(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        String relativePath = RubyString.stringValue(args[0]).toString();
        boolean isAbsoluteWithFilePrefix = relativePath.startsWith("file:");
        String cwd = null;
        relativePath = RubyFile.expandUserPath(recv, relativePath);
        if (args.length == 2 && !args[1].isNil()) {
            String cwdArg = RubyString.stringValue(args[1]).toString();
            cwd = RubyFile.expandUserPath(recv, cwdArg);
            if (cwd.charAt(0) != '/') {
                cwd = JRubyFile.create(runtime.getCurrentDirectory(), cwd).getAbsolutePath();
            }
        } else {
            cwd = runtime.getCurrentDirectory();
        }
        if (cwd == null) {
            return runtime.getNil();
        }
        String padSlashes = "";
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            padSlashes = RubyFile.countSlashes(relativePath);
        } else if (cwd.length() > 0 && cwd.charAt(0) == '/') {
            padSlashes = RubyFile.countSlashes(cwd);
        }
        JRubyFile path = relativePath.length() == 0 ? JRubyFile.create(relativePath, cwd) : JRubyFile.create(cwd, relativePath);
        String tempResult = padSlashes + RubyFile.canonicalize(path.getAbsolutePath());
        if (isAbsoluteWithFilePrefix) {
            tempResult = tempResult.substring(tempResult.indexOf("file:"));
        }
        return runtime.newString(tempResult);
    }

    private static String expandUserPath(IRubyObject recv, String path) {
        int pathLength = path.length();
        if (pathLength >= 1 && path.charAt(0) == '~') {
            int userEnd = path.indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    path = RubyDir.getHomeDirectoryPath(recv).toString();
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                path = RubyDir.getHomeDirectoryPath(recv).toString() + path.substring(1);
            } else if (userEnd > 1) {
                String user = path.substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(recv, user);
                if (dir.isNil()) {
                    Ruby runtime = recv.getRuntime();
                    throw runtime.newArgumentError("user " + user + " does not exist");
                }
                path = "" + dir + (pathLength == userEnd ? "" : path.substring(userEnd));
            }
        }
        return path;
    }

    private static String countSlashes(String stringToCheck) {
        int slashCount = 0;
        for (int i = 0; i < stringToCheck.length() && stringToCheck.charAt(i) == '/'; ++i) {
            ++slashCount;
        }
        if (slashCount > 0) {
            --slashCount;
        }
        byte[] slashes = new byte[slashCount];
        for (int i = 0; i < slashCount; ++i) {
            slashes[i] = 47;
        }
        return new String(slashes);
    }

    private static String canonicalize(String path) {
        return RubyFile.canonicalize(null, path);
    }

    private static String canonicalize(String canonicalPath, String remaining) {
        String child;
        if (remaining == null) {
            return canonicalPath;
        }
        int slash = remaining.indexOf(47);
        if (slash == -1) {
            child = remaining;
            remaining = null;
        } else {
            child = remaining.substring(0, slash);
            remaining = remaining.substring(slash + 1);
        }
        if (child.equals(".")) {
            if (canonicalPath != null && canonicalPath.length() == 0) {
                canonicalPath = canonicalPath + "/";
            }
        } else if (child.equals("..")) {
            if (canonicalPath == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            int lastDir = canonicalPath.lastIndexOf(47);
            canonicalPath = lastDir == -1 ? "" : canonicalPath.substring(0, lastDir);
        } else {
            canonicalPath = canonicalPath == null ? child : canonicalPath + "/" + child;
        }
        return RubyFile.canonicalize(canonicalPath, remaining);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, required=2, optional=1, meta=true)
    public static IRubyObject fnmatch(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int flags = args.length == 3 ? RubyNumeric.num2int(args[2]) : 0;
        ByteList pattern = args[0].convertToString().getByteList();
        ByteList path = args[1].convertToString().getByteList();
        if (Dir.fnmatch(pattern.bytes, pattern.begin, pattern.begin + pattern.realSize, path.bytes, path.begin, path.begin + path.realSize, flags) == 0) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"ftype"}, required=1, meta=true)
    public static IRubyObject ftype(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newFileStat(filename.convertToString().toString(), true).ftype();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String inspectJoin(IRubyObject recv, RubyArray parent, RubyArray array) {
        Ruby runtime = recv.getRuntime();
        if (runtime.isInspecting(parent)) {
            return RubyFile.join(recv, array).toString();
        }
        try {
            runtime.registerInspecting(parent);
            String string = RubyFile.join(recv, array).toString();
            return string;
        }
        finally {
            runtime.unregisterInspecting(parent);
        }
    }

    private static RubyString join(IRubyObject recv, RubyArray ary) {
        IRubyObject[] args = ary.toJavaArray();
        boolean isTainted = false;
        StringBuffer buffer = new StringBuffer();
        Ruby runtime = recv.getRuntime();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].isTaint()) {
                isTainted = true;
            }
            String element = args[i] instanceof RubyString ? args[i].toString() : (args[i] instanceof RubyArray ? (runtime.isInspecting(args[i]) ? "[...]" : RubyFile.inspectJoin(recv, ary, (RubyArray)args[i])) : args[i].convertToString().toString());
            RubyFile.chomp(buffer);
            if (i > 0 && !element.startsWith("/") && !element.startsWith("\\")) {
                buffer.append("/");
            }
            buffer.append(element);
        }
        RubyString fixedStr = RubyString.newString(recv.getRuntime(), buffer.toString());
        fixedStr.setTaint(isTainted);
        return fixedStr;
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(IRubyObject recv, IRubyObject[] args) {
        return RubyFile.join(recv, RubyArray.newArrayNoCopyLight(recv.getRuntime(), args));
    }

    private static void chomp(StringBuffer buffer) {
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0 && (buffer.lastIndexOf("/") == lastIndex || buffer.lastIndexOf("\\") == lastIndex); --lastIndex) {
            buffer.setLength(lastIndex);
        }
    }

    @JRubyMethod(name={"lstat"}, required=1, meta=true)
    public static IRubyObject lstat(IRubyObject recv, IRubyObject filename) {
        String f = filename.convertToString().toString();
        if (f.startsWith("file:")) {
            f = f.substring(5, f.indexOf("!"));
        }
        return recv.getRuntime().newFileStat(f, true);
    }

    @JRubyMethod(name={"stat"}, required=1, meta=true)
    public static IRubyObject stat(IRubyObject recv, IRubyObject filename) {
        String f = filename.convertToString().toString();
        if (f.startsWith("file:")) {
            f = f.substring(5, f.indexOf("!"));
        }
        return recv.getRuntime().newFileStat(f, false);
    }

    @JRubyMethod(name={"atime"}, required=1, meta=true)
    public static IRubyObject atime(IRubyObject recv, IRubyObject filename) {
        String f = filename.convertToString().toString();
        if (f.startsWith("file:")) {
            f = f.substring(5, f.indexOf("!"));
        }
        return recv.getRuntime().newFileStat(f, false).atime();
    }

    @JRubyMethod(name={"ctime"}, required=1, meta=true)
    public static IRubyObject ctime(IRubyObject recv, IRubyObject filename) {
        String f = filename.convertToString().toString();
        if (f.startsWith("file:")) {
            f = f.substring(5, f.indexOf("!"));
        }
        return recv.getRuntime().newFileStat(f, false).ctime();
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject lchmod(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int count = 0;
        RubyInteger mode = args[0].convertToInteger();
        for (int i = 1; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == runtime.getPosix().lchmod(filename.toString(), (int)mode.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=3, rest=true, meta=true)
    public static IRubyObject lchown(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        int count = 0;
        RubyInteger owner = args[0].convertToInteger();
        RubyInteger group = args[1].convertToInteger();
        for (int i = 2; i < args.length; ++i) {
            boolean result;
            IRubyObject filename = args[i];
            if (!RubyFileTest.exist_p(filename, filename.convertToString()).isTrue()) {
                throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
            }
            boolean bl = result = 0 == runtime.getPosix().lchown(filename.toString(), (int)owner.getLongValue(), (int)group.getLongValue());
            if (!result) continue;
            ++count;
        }
        return runtime.newFixnum(count);
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject link(IRubyObject recv, IRubyObject from, IRubyObject to) {
        RubyString fromStr = RubyString.stringValue(from);
        RubyString toStr = RubyString.stringValue(to);
        try {
            if (recv.getRuntime().getPosix().link(fromStr.toString(), toStr.toString()) == -1) {
                throw recv.getRuntime().newErrnoEEXISTError("File exists - " + fromStr + " or " + toStr);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw recv.getRuntime().newNotImplementedError("link() function is unimplemented on this machine");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(name={"mtime"}, required=1, meta=true)
    public static IRubyObject mtime(IRubyObject recv, IRubyObject filename) {
        return RubyFile.getLastModified(recv.getRuntime(), filename.convertToString().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, boolean tryToYield, Block block) {
        RubyFile file;
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        if (args[0] instanceof RubyInteger) {
            file = new RubyFile(runtime, (RubyClass)recv);
            file.initialize(args, Block.NULL_BLOCK);
        } else {
            ModeFlags modes;
            RubyString pathString = RubyString.stringValue(args[0]);
            runtime.checkSafeString(pathString);
            String path = pathString.toString();
            try {
                modes = args.length >= 2 ? RubyFile.getModes(runtime, args[1]) : new ModeFlags(0L);
            }
            catch (InvalidValueException ex) {
                throw runtime.newErrnoEINVALError();
            }
            file = new RubyFile(runtime, (RubyClass)recv);
            RubyInteger fileMode = args.length >= 3 ? args[2].convertToInteger() : null;
            file.openInternal(path, modes);
            if (fileMode != null) {
                RubyFile.chmod(recv, new IRubyObject[]{fileMode, pathString});
            }
        }
        if (tryToYield && block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(tc, file);
                return iRubyObject;
            }
            finally {
                if (file.openFile.isOpen()) {
                    file.close();
                }
            }
        }
        return file;
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject rename(IRubyObject recv, IRubyObject oldName, IRubyObject newName) {
        Ruby runtime = recv.getRuntime();
        RubyString oldNameString = RubyString.stringValue(oldName);
        RubyString newNameString = RubyString.stringValue(newName);
        runtime.checkSafeString(oldNameString);
        runtime.checkSafeString(newNameString);
        JRubyFile oldFile = JRubyFile.create(runtime.getCurrentDirectory(), oldNameString.toString());
        JRubyFile newFile = JRubyFile.create(runtime.getCurrentDirectory(), newNameString.toString());
        if (!oldFile.exists() || !newFile.getParentFile().exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + oldNameString + " or " + newNameString);
        }
        JRubyFile dest = JRubyFile.create(runtime.getCurrentDirectory(), newNameString.toString());
        if (oldFile.renameTo(dest)) {
            return RubyFixnum.zero(runtime);
        }
        if (newFile.exists()) {
            recv.getRuntime().getPosix().chmod(newNameString.toString(), 438);
            newFile.delete();
        }
        if (oldFile.renameTo(dest)) {
            return RubyFixnum.zero(runtime);
        }
        throw runtime.newErrnoEACCESError("Permission denied - " + oldNameString + " or " + newNameString);
    }

    @JRubyMethod(required=1, meta=true)
    public static RubyArray split(IRubyObject recv, IRubyObject arg) {
        RubyString filename = RubyString.stringValue(arg);
        return filename.getRuntime().newArray(RubyFile.dirname(recv, filename), RubyFile.basename(recv, new IRubyObject[]{filename}));
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject symlink(IRubyObject recv, IRubyObject from, IRubyObject to) {
        RubyString fromStr = RubyString.stringValue(from);
        RubyString toStr = RubyString.stringValue(to);
        try {
            if (recv.getRuntime().getPosix().symlink(fromStr.toString(), toStr.toString()) == -1) {
                throw recv.getRuntime().newErrnoEEXISTError("File exists - " + fromStr + " or " + toStr);
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw recv.getRuntime().newNotImplementedError("symlink() function is unimplemented on this machine");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject readlink(IRubyObject recv, IRubyObject path) {
        String realPath = recv.getRuntime().getPosix().readlink(path.toString());
        if (!RubyFileTest.exist_p(recv, path).isTrue()) {
            throw recv.getRuntime().newErrnoENOENTError("No such file or directory - " + path);
        }
        if (!RubyFileTest.symlink_p(recv, path).isTrue()) {
            throw recv.getRuntime().newErrnoEINVALError("invalid argument - " + path);
        }
        if (realPath == null) {
            // empty if block
        }
        return recv.getRuntime().newString(realPath);
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject truncate(IRubyObject recv, IRubyObject arg1, IRubyObject arg2) {
        Ruby runtime = recv.getRuntime();
        RubyString filename = arg1.convertToString();
        RubyInteger newLength = arg2.convertToInteger();
        if (!new File(filename.getByteList().toString()).exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + filename.getByteList().toString());
        }
        if (newLength.getLongValue() < 0L) {
            throw runtime.newErrnoEINVALError("invalid argument: " + filename);
        }
        IRubyObject[] args = new IRubyObject[]{filename, runtime.newString("r+")};
        RubyFile file = (RubyFile)RubyFile.open(recv, args, false, null);
        file.truncate(newLength);
        file.close();
        return RubyFixnum.zero(runtime);
    }

    @JRubyMethod(meta=true, optional=1)
    public static IRubyObject umask(IRubyObject recv, IRubyObject[] args) {
        int oldMask = 0;
        if (args.length == 0) {
            oldMask = recv.getRuntime().getPosix().umask(0);
        } else if (args.length == 1) {
            oldMask = recv.getRuntime().getPosix().umask((int)args[0].convertToInteger().getLongValue());
        } else {
            recv.getRuntime().newArgumentError("wrong number of arguments");
        }
        return recv.getRuntime().newFixnum(oldMask);
    }

    @JRubyMethod(required=2, rest=true, meta=true)
    public static IRubyObject utime(IRubyObject recv, IRubyObject[] args) {
        long mtime;
        Ruby runtime = recv.getRuntime();
        if (args[1] instanceof RubyTime) {
            mtime = ((RubyTime)args[1]).getJavaDate().getTime();
        } else if (args[1] instanceof RubyNumeric) {
            mtime = RubyNumeric.num2long(args[1]);
        } else if (args[1] == runtime.getNil()) {
            mtime = System.currentTimeMillis();
        } else {
            RubyTime time = (RubyTime)TypeConverter.convertToType(args[1], runtime.getTime(), MethodIndex.NO_INDEX, "to_time", true);
            mtime = time.getJavaDate().getTime();
        }
        int j = args.length;
        for (int i = 2; i < j; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            runtime.checkSafeString(filename);
            JRubyFile fileToTouch = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
            if (!fileToTouch.exists()) {
                throw runtime.newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            fileToTouch.setLastModified(mtime);
        }
        return runtime.newFixnum(args.length - 2);
    }

    @JRubyMethod(name={"unlink", "delete"}, rest=true, meta=true)
    public static IRubyObject unlink(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        for (int i = 0; i < args.length; ++i) {
            RubyString filename = RubyString.stringValue(args[i]);
            runtime.checkSafeString(filename);
            JRubyFile lToDelete = JRubyFile.create(runtime.getCurrentDirectory(), filename.toString());
            boolean isSymlink = RubyFileTest.symlink_p(recv, filename).isTrue();
            if (!lToDelete.exists() && !isSymlink) {
                throw runtime.newErrnoENOENTError(" No such file or directory - \"" + filename + "\"");
            }
            if (lToDelete.delete()) continue;
            return runtime.getFalse();
        }
        return runtime.newFixnum(args.length);
    }

    private static IRubyObject getLastModified(Ruby runtime, String path) {
        JRubyFile file = JRubyFile.create(runtime.getCurrentDirectory(), path);
        if (!file.exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + path);
        }
        return runtime.newTime(file.lastModified());
    }

    static {
        String osname = System.getProperty("os.name");
        IS_WINDOWS = osname != null && osname.toLowerCase().indexOf("windows") != -1;
        FILE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyFile instance = new RubyFile(runtime, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
    }
}

