/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyException
extends RubyObject {
    private Frame[] backtraceFrames;
    private IRubyObject backtrace;
    public IRubyObject message;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    private static ObjectAllocator EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyException instance = new RubyException(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    private static final ObjectMarshal EXCEPTION_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            RubyException exc = (RubyException)obj;
            marshalStream.registerLinkTarget(exc);
            List<Variable<IRubyObject>> attrs = exc.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.message == null ? runtime.getNil() : exc.message));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            RubyException exc = (RubyException)type.allocate();
            unmarshalStream.registerLinkTarget(exc);
            unmarshalStream.defaultVariablesUnmarshal(exc);
            exc.message = exc.removeInternalVariable("mesg");
            exc.set_backtrace(exc.removeInternalVariable("bt"));
            return exc;
        }
    };

    protected RubyException(Ruby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, null);
    }

    public RubyException(Ruby runtime, RubyClass rubyClass, String message) {
        super(runtime, rubyClass);
        this.message = message == null ? runtime.getNil() : runtime.newString(message);
    }

    public static RubyClass createExceptionClass(Ruby runtime) {
        RubyClass exceptionClass = runtime.defineClass("Exception", runtime.getObject(), EXCEPTION_ALLOCATOR);
        runtime.setException(exceptionClass);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        CallbackFactory classCB = runtime.callbackFactory(RubyClass.class);
        exceptionClass.getMetaClass().defineMethod("exception", classCB.getOptMethod("newInstance"));
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime, RubyClass excptnClass, String msg) {
        return new RubyException(runtime, excptnClass, msg);
    }

    public void setBacktraceFrames(Frame[] backtraceFrames) {
        this.backtraceFrames = backtraceFrames;
    }

    public IRubyObject getBacktrace() {
        if (this.backtrace == null) {
            this.backtrace = this.backtraceFrames == null ? this.getRuntime().getNil() : ThreadContext.createBacktraceFromFrames(this.getRuntime(), this.backtraceFrames);
        }
        return this.backtrace;
    }

    @JRubyMethod(optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length == 1) {
            this.message = args[0];
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        if (obj.isNil()) {
            this.backtrace = null;
        } else {
            if (!this.isArrayOfStrings(obj)) {
                throw this.getRuntime().newTypeError("backtrace must be Array of String");
            }
            this.backtrace = (RubyArray)obj;
        }
        return this.backtrace();
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.getMetaClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return this.message;
    }

    @JRubyMethod(name={"to_str", "message"})
    public IRubyObject to_str() {
        return this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s");
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect() {
        RubyClass rubyClass = this.getMetaClass();
        RubyString exception = RubyString.objAsString(this);
        if (exception.getByteList().realSize == 0) {
            return this.getRuntime().newString(rubyClass.getName());
        }
        StringBuffer sb = new StringBuffer("#<");
        sb.append(rubyClass.getName()).append(": ").append(exception.getByteList()).append(">");
        return this.getRuntime().newString(sb.toString());
    }

    public void printBacktrace(PrintStream errorStream) {
        IRubyObject backtrace = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        if (!backtrace.isNil() && backtrace instanceof RubyArray) {
            IRubyObject[] elements = backtrace.convertToArray().toJavaArray();
            for (int i = 1; i < elements.length; ++i) {
                IRubyObject stackTraceLine = elements[i];
                if (stackTraceLine instanceof RubyString) {
                    this.printStackTraceLine(errorStream, stackTraceLine);
                }
                if (i != 8 || elements.length <= 18) continue;
                int hiddenLevels = elements.length - 8 - 4;
                errorStream.print("\t ... " + hiddenLevels + " levels...\n");
                i = elements.length - 4;
            }
        }
    }

    private void printStackTraceLine(PrintStream errorStream, IRubyObject stackTraceLine) {
        errorStream.print("\tfrom " + stackTraceLine + '\n');
    }

    private boolean isArrayOfStrings(IRubyObject backtrace) {
        if (!(backtrace instanceof RubyArray)) {
            return false;
        }
        IRubyObject[] elements = ((RubyArray)backtrace).toJavaArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof RubyString) continue;
            return false;
        }
        return true;
    }
}

