/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Comparator;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby runtime) {
        RubyModule enumModule = runtime.defineModule("Enumerable");
        runtime.setEnumerable(enumModule);
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self, BlockCallback callback) {
        return self.callMethod(context, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(self, runtime.getEnumerable(), Arity.noArguments(), callback, context));
    }

    @JRubyMethod(name={"to_a", "entries"})
    public static IRubyObject to_a(IRubyObject self) {
        Ruby runtime = self.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyArray result = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new AppendBlockCallback(runtime, result));
        return result;
    }

    @JRubyMethod(name={"sort"}, frame=true)
    public static IRubyObject sort(IRubyObject self, Block block) {
        Ruby runtime = self.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyArray result = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new AppendBlockCallback(runtime, result));
        result.sort_bang(block);
        return result;
    }

    @JRubyMethod(name={"sort_by"}, frame=true)
    public static IRubyObject sort_by(IRubyObject self, final Block block) {
        int i;
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        if (self instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self;
            final IRubyObject[][] valuesAndCriteria = new IRubyObject[selfArray.size()][2];
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){
                int i = 0;

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    valuesAndCriteria[this.i][0] = largs[0];
                    valuesAndCriteria[this.i++][1] = block.yield(context, largs[0]);
                    return runtime.getNil();
                }
            });
            Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

                @Override
                public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                    return RubyFixnum.fix2int(o1[1].callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", o2[1]));
                }
            });
            IRubyObject[] dstArray = new IRubyObject[selfArray.size()];
            for (int i2 = 0; i2 < dstArray.length; ++i2) {
                dstArray[i2] = valuesAndCriteria[i2][0];
            }
            return runtime.newArrayNoCopy(dstArray);
        }
        RubyArray result = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new AppendBlockCallback(runtime, result));
        IRubyObject[][] valuesAndCriteria = new IRubyObject[result.size()][2];
        for (i = 0; i < valuesAndCriteria.length; ++i) {
            IRubyObject val;
            valuesAndCriteria[i][0] = val = result.eltInternal(i);
            valuesAndCriteria[i][1] = block.yield(context, val);
        }
        Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                return RubyFixnum.fix2int(o1[1].callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", o2[1]));
            }
        });
        for (i = 0; i < valuesAndCriteria.length; ++i) {
            result.eltInternalSet(i, valuesAndCriteria[i][0]);
        }
        return result;
    }

    @JRubyMethod(name={"grep"}, required=1, frame=true)
    public static IRubyObject grep(IRubyObject self, final IRubyObject pattern, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyArray result = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (pattern.callMethod(context, MethodIndex.OP_EQQ, "===", largs[0]).isTrue()) {
                        result.append(block.yield(context, largs[0]));
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (pattern.callMethod(context, MethodIndex.OP_EQQ, "===", largs[0]).isTrue()) {
                        result.append(largs[0]);
                    }
                    return runtime.getNil();
                }
            });
        }
        return result;
    }

    @JRubyMethod(name={"detect", "find"}, optional=1, frame=true)
    public static IRubyObject detect(IRubyObject self, IRubyObject[] args, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final IRubyObject[] result = new IRubyObject[]{null};
        IRubyObject ifnone = null;
        if (args.length == 1) {
            ifnone = args[0];
        }
        try {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (block.yield(context, largs[0]).isTrue()) {
                        result[0] = largs[0];
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return result[0];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : runtime.getNil();
    }

    @JRubyMethod(name={"select", "find_all"}, frame=true)
    public static IRubyObject select(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyArray result = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (block.yield(context, largs[0]).isTrue()) {
                    result.append(largs[0]);
                }
                return runtime.getNil();
            }
        });
        return result;
    }

    @JRubyMethod(name={"reject"}, frame=true)
    public static IRubyObject reject(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyArray result = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (!block.yield(context, largs[0]).isTrue()) {
                    result.append(largs[0]);
                }
                return runtime.getNil();
            }
        });
        return result;
    }

    @JRubyMethod(name={"collect", "map"}, frame=true)
    public static IRubyObject collect(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyArray result = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    result.append(block.yield(context, largs[0]));
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, new AppendBlockCallback(runtime, result));
        }
        return result;
    }

    @JRubyMethod(name={"inject"}, optional=1, frame=true)
    public static IRubyObject inject(IRubyObject self, IRubyObject[] args, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final IRubyObject[] result = new IRubyObject[]{null};
        if (args.length == 1) {
            result[0] = args[0];
        }
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                result[0] = result[0] == null ? largs[0] : block.yield(context, runtime.newArray(result[0], largs[0]));
                return runtime.getNil();
            }
        });
        return result[0] == null ? runtime.getNil() : result[0];
    }

    @JRubyMethod(name={"partition"}, frame=true)
    public static IRubyObject partition(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyArray arr_true = runtime.newArray();
        final RubyArray arr_false = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (block.yield(context, largs[0]).isTrue()) {
                    arr_true.append(largs[0]);
                } else {
                    arr_false.append(largs[0]);
                }
                return runtime.getNil();
            }
        });
        return runtime.newArray(arr_true, arr_false);
    }

    @JRubyMethod(name={"each_with_index"}, frame=true)
    public static IRubyObject each_with_index(IRubyObject self, Block block) {
        ThreadContext context = self.getRuntime().getCurrentContext();
        self.callMethod(context, "each", IRubyObject.NULL_ARRAY, CallBlock.newCallClosure(self, self.getRuntime().getEnumerable(), Arity.noArguments(), new EachWithIndex(context, block), context));
        return self;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1, frame=true)
    public static IRubyObject include_p(IRubyObject self, final IRubyObject arg) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        try {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (RubyObject.equalInternal(context, arg, largs[0]).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"max"}, frame=true)
    public static IRubyObject max(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final IRubyObject[] result = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result[0] == null || RubyComparable.cmpint(block.yield(context, runtime.newArray(largs[0], result[0])), largs[0], result[0]) > 0) {
                        result[0] = largs[0];
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result[0] == null || RubyComparable.cmpint(largs[0].callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", result[0]), largs[0], result[0]) > 0) {
                        result[0] = largs[0];
                    }
                    return runtime.getNil();
                }
            });
        }
        return result[0] == null ? runtime.getNil() : result[0];
    }

    @JRubyMethod(name={"min"}, frame=true)
    public static IRubyObject min(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final IRubyObject[] result = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result[0] == null || RubyComparable.cmpint(block.yield(context, runtime.newArray(largs[0], result[0])), largs[0], result[0]) < 0) {
                        result[0] = largs[0];
                    }
                    return runtime.getNil();
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    if (result[0] == null || RubyComparable.cmpint(largs[0].callMethod(context, MethodIndex.OP_SPACESHIP, "<=>", result[0]), largs[0], result[0]) < 0) {
                        result[0] = largs[0];
                    }
                    return runtime.getNil();
                }
            });
        }
        return result[0] == null ? runtime.getNil() : result[0];
    }

    @JRubyMethod(name={"all?"}, frame=true)
    public static IRubyObject all_p(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        if (!block.yield(context, largs[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        if (!largs[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"any?"}, frame=true)
    public static IRubyObject any_p(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        if (block.yield(context, largs[0]).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        if (largs[0].isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(name={"zip"}, rest=true, frame=true)
    public static IRubyObject zip(IRubyObject self, final IRubyObject[] args, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < args.length; ++i) {
            args[i] = TypeConverter.convertToType(args[i], runtime.getArray(), MethodIndex.TO_A, "to_a");
        }
        final int aLen = args.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){
                int ix = 0;

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyArray array = runtime.newArray(aLen);
                    array.append(largs[0]);
                    int j = args.length;
                    for (int i = 0; i < j; ++i) {
                        array.append(((RubyArray)args[i]).entry(this.ix));
                    }
                    block.yield(context, array);
                    ++this.ix;
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){
            int ix = 0;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyArray array = runtime.newArray(aLen);
                array.append(largs[0]);
                int j = args.length;
                for (int i = 0; i < j; ++i) {
                    array.append(((RubyArray)args[i]).entry(this.ix));
                }
                zip.append(array);
                ++this.ix;
                return runtime.getNil();
            }
        });
        return zip;
    }

    @JRubyMethod(name={"group_by"}, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject group_by(IRubyObject self, final Block block) {
        final Ruby runtime = self.getRuntime();
        final ThreadContext context = runtime.getCurrentContext();
        final RubyHash result = new RubyHash(runtime);
        RubyEnumerable.callEach(runtime, context, self, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject key = block.yield(context, largs[0]);
                IRubyObject curr = result.fastARef(key);
                if (curr == null) {
                    curr = runtime.newArray();
                    result.fastASet(key, curr);
                }
                curr.callMethod(context, MethodIndex.OP_LSHIFT, "<<", largs[0]);
                return runtime.getNil();
            }
        });
        return result;
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private Ruby runtime;
        private RubyArray result;

        public AppendBlockCallback(Ruby runtime, RubyArray result) {
            this.runtime = runtime;
            this.result = result;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            this.result.append(largs[0]);
            return this.runtime.getNil();
        }
    }

    private static class EachWithIndex
    implements BlockCallback {
        private int index = 0;
        private final Block block;
        private final Ruby runtime;

        public EachWithIndex(ThreadContext ctx, Block block) {
            this.block = block;
            this.runtime = ctx.getRuntime();
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            this.block.yield(context, this.runtime.newArray(iargs[0], this.runtime.newFixnum(this.index++)));
            return this.runtime.getNil();
        }
    }
}

