/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class RubyBoolean
extends RubyObject {
    private final Ruby runtime;

    public RubyBoolean(Ruby runtime, boolean value) {
        super(runtime, value ? runtime.getTrueClass() : runtime.getFalseClass(), false);
        if (!value) {
            this.flags = 1;
        }
        this.runtime = runtime;
    }

    @Override
    public int getNativeTypeIndex() {
        return (this.flags & 1) == 0 ? 6 : 7;
    }

    @Override
    public Ruby getRuntime() {
        if (Ruby.RUNTIME_THREADLOCAL) {
            return Ruby.getCurrentInstance();
        }
        return this.runtime;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @Override
    public Class<?> getJavaClass() {
        return Boolean.TYPE;
    }

    public static RubyClass createFalseClass(Ruby runtime) {
        RubyClass falseClass = runtime.defineClass("FalseClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFalseClass(falseClass);
        falseClass.index = 7;
        CallbackFactory fact = runtime.callbackFactory(RubyBoolean.class);
        falseClass.defineFastMethod("&", fact.getFastMethod("false_and", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("|", fact.getFastMethod("false_or", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("^", fact.getFastMethod("false_xor", RubyKernel.IRUBY_OBJECT));
        falseClass.defineFastMethod("to_s", fact.getFastMethod("false_to_s"));
        falseClass.getMetaClass().undefineMethod("new");
        falseClass.dispatcher = fact.createDispatcher(falseClass);
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby runtime) {
        RubyClass trueClass = runtime.defineClass("TrueClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setTrueClass(trueClass);
        trueClass.index = 6;
        CallbackFactory fact = runtime.callbackFactory(RubyBoolean.class);
        trueClass.defineFastMethod("&", fact.getFastMethod("true_and", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("|", fact.getFastMethod("true_or", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("^", fact.getFastMethod("true_xor", RubyKernel.IRUBY_OBJECT));
        trueClass.defineFastMethod("to_s", fact.getFastMethod("true_to_s"));
        trueClass.getMetaClass().undefineMethod("new");
        trueClass.dispatcher = fact.createDispatcher(trueClass);
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby runtime, boolean value) {
        return value ? runtime.getTrue() : runtime.getFalse();
    }

    public IRubyObject false_and(IRubyObject oth) {
        return this;
    }

    public IRubyObject false_or(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getTrue() : this;
    }

    public IRubyObject false_xor(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getTrue() : this;
    }

    @Override
    public RubyFixnum id() {
        if ((this.flags & 1) == 0) {
            return RubyFixnum.newFixnum(this.getRuntime(), 2L);
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    public IRubyObject false_to_s() {
        return this.getRuntime().newString("false");
    }

    public IRubyObject true_and(IRubyObject oth) {
        return oth.isTrue() ? this : this.getRuntime().getFalse();
    }

    public IRubyObject true_or(IRubyObject oth) {
        return this;
    }

    public IRubyObject true_xor(IRubyObject oth) {
        return oth.isTrue() ? this.getRuntime().getFalse() : this;
    }

    public IRubyObject true_to_s() {
        return this.getRuntime().newString("true");
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }
}

