/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBigDecimal(runtime, klass);
        }
    };
    private BigDecimal value;

    public static RubyClass createBigDecimal(Ruby runtime) {
        RubyClass result = runtime.defineClass("BigDecimal", runtime.getNumeric(), BIGDECIMAL_ALLOCATOR);
        result.fastSetConstant("ROUND_DOWN", RubyNumeric.int2fix(runtime, 1L));
        result.fastSetConstant("SIGN_POSITIVE_INFINITE", RubyNumeric.int2fix(runtime, 3L));
        result.fastSetConstant("EXCEPTION_OVERFLOW", RubyNumeric.int2fix(runtime, 1L));
        result.fastSetConstant("SIGN_POSITIVE_ZERO", RubyNumeric.int2fix(runtime, 1L));
        result.fastSetConstant("EXCEPTION_ALL", RubyNumeric.int2fix(runtime, 255L));
        result.fastSetConstant("ROUND_CEILING", RubyNumeric.int2fix(runtime, 2L));
        result.fastSetConstant("ROUND_UP", RubyNumeric.int2fix(runtime, 0L));
        result.fastSetConstant("SIGN_NEGATIVE_FINITE", RubyNumeric.int2fix(runtime, -2L));
        result.fastSetConstant("EXCEPTION_UNDERFLOW", RubyNumeric.int2fix(runtime, 4L));
        result.fastSetConstant("SIGN_NaN", RubyNumeric.int2fix(runtime, 0L));
        result.fastSetConstant("BASE", RubyNumeric.int2fix(runtime, 10000L));
        result.fastSetConstant("ROUND_HALF_DOWN", RubyNumeric.int2fix(runtime, 5L));
        result.fastSetConstant("ROUND_MODE", RubyNumeric.int2fix(runtime, 256L));
        result.fastSetConstant("SIGN_POSITIVE_FINITE", RubyNumeric.int2fix(runtime, 2L));
        result.fastSetConstant("EXCEPTION_INFINITY", RubyNumeric.int2fix(runtime, 1L));
        result.fastSetConstant("ROUND_HALF_EVEN", RubyNumeric.int2fix(runtime, 6L));
        result.fastSetConstant("ROUND_HALF_UP", RubyNumeric.int2fix(runtime, 4L));
        result.fastSetConstant("SIGN_NEGATIVE_INFINITE", RubyNumeric.int2fix(runtime, -3L));
        result.fastSetConstant("EXCEPTION_ZERODIVIDE", RubyNumeric.int2fix(runtime, 1L));
        result.fastSetConstant("SIGN_NEGATIVE_ZERO", RubyNumeric.int2fix(runtime, -1L));
        result.fastSetConstant("EXCEPTION_NaN", RubyNumeric.int2fix(runtime, 2L));
        result.fastSetConstant("ROUND_FLOOR", RubyNumeric.int2fix(runtime, 3L));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBigDecimal.class);
        runtime.getKernel().defineModuleFunction("BigDecimal", callbackFactory.getOptSingletonMethod("newBigDecimal"));
        result.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime));
        result.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime));
        result.setInternalModuleVariable("vpRoundingMode", RubyFixnum.zero(runtime));
        result.defineAnnotatedMethods(RubyBigDecimal.class);
        result.dispatcher = callbackFactory.createDispatcher(result);
        return result;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value) {
        super(runtime, runtime.fastGetClass("BigDecimal"));
        this.value = value;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        return RubyBigDecimal.newInstance(recv.getRuntime().fastGetClass("BigDecimal"), args);
    }

    public static RubyBigDecimal newBigDecimal(Ruby runtime, BigDecimal value) {
        return new RubyBigDecimal(runtime, value);
    }

    @Override
    public Class getJavaClass() {
        return BigDecimal.class;
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject recv) {
        return recv.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1, frame=true)
    public IRubyObject dump(IRubyObject[] args, Block unusedBlock) {
        RubyString precision = RubyString.newUnicodeString(args[0].getRuntime(), "0:");
        RubyString str = this.asString();
        return precision.append(str);
    }

    @JRubyMethod(name={"_load"}, required=1, frame=true, meta=true)
    public static RubyBigDecimal load(IRubyObject recv, IRubyObject from, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)recv).allocate();
        String precisionAndValue = from.convertToString().asJavaString();
        String value = precisionAndValue.substring(precisionAndValue.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(value);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject recv) {
        return recv.getRuntime().newFixnum(20L);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject recv, IRubyObject[] args) {
        IRubyObject arg;
        Ruby runtime = recv.getRuntime();
        RubyModule c = (RubyModule)recv;
        IRubyObject nCur = c.searchInternalModuleVariable("vpPrecLimit");
        if (args.length > 0 && !(arg = args[0]).isNil()) {
            if (!(arg instanceof RubyFixnum)) {
                throw runtime.newTypeError(arg, runtime.getFixnum());
            }
            if (0L > ((RubyFixnum)arg).getLongValue()) {
                throw runtime.newArgumentError("argument must be positive");
            }
            c.setInternalModuleVariable("vpPrecLimit", arg);
        }
        return nCur;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(IRubyObject recv, IRubyObject[] args) {
        long EXCEPTION_ALL;
        Ruby runtime = recv.getRuntime();
        RubyClass clazz = runtime.fastGetClass("BigDecimal");
        RubyModule c = (RubyModule)recv;
        args = Arity.scanArgs(runtime, args, 1, 1);
        IRubyObject mode = args[0];
        IRubyObject value = args[1];
        if (!(mode instanceof RubyFixnum)) {
            throw runtime.newTypeError("wrong argument type " + mode.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode).getLongValue();
        if ((longMode & (EXCEPTION_ALL = ((RubyFixnum)clazz.fastGetConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum EXCEPTION_NaN;
            if (value.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!value.isNil() && !(value instanceof RubyBoolean)) {
                throw runtime.newTypeError("second argument must be true or false");
            }
            RubyFixnum currentExceptionMode = (RubyFixnum)c.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum newExceptionMode = new RubyFixnum(runtime, currentExceptionMode.getLongValue());
            RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_INFINITY");
            if ((longMode & EXCEPTION_INFINITY.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced("|", EXCEPTION_INFINITY) : (RubyFixnum)currentExceptionMode.callCoerced("&", new RubyFixnum(runtime, EXCEPTION_INFINITY.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_NaN = (RubyFixnum)clazz.fastGetConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                newExceptionMode = value.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced("|", EXCEPTION_NaN) : (RubyFixnum)currentExceptionMode.callCoerced("&", new RubyFixnum(runtime, EXCEPTION_NaN.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            c.setInternalModuleVariable("vpExceptionMode", newExceptionMode);
            return newExceptionMode;
        }
        long ROUND_MODE = ((RubyFixnum)clazz.fastGetConstant("ROUND_MODE")).getLongValue();
        if (longMode == ROUND_MODE) {
            if (value.isNil()) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            if (!(value instanceof RubyFixnum)) {
                throw runtime.newTypeError("wrong argument type " + mode.getMetaClass() + " (expected Fixnum)");
            }
            RubyFixnum roundingMode = (RubyFixnum)value;
            if (roundingMode != clazz.fastGetConstant("ROUND_UP") && roundingMode != clazz.fastGetConstant("ROUND_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_FLOOR") && roundingMode != clazz.fastGetConstant("ROUND_CEILING") && roundingMode != clazz.fastGetConstant("ROUND_HALF_UP") && roundingMode != clazz.fastGetConstant("ROUND_HALF_DOWN") && roundingMode != clazz.fastGetConstant("ROUND_HALF_EVEN")) {
                throw runtime.newTypeError("invalid rounding mode");
            }
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return c.searchInternalModuleVariable("vpRoundingMode");
        }
        throw runtime.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private RubyBigDecimal getVpValue(IRubyObject v, boolean must) {
        if (v instanceof RubyBigDecimal) {
            return (RubyBigDecimal)v;
        }
        if (v instanceof RubyFixnum || v instanceof RubyBignum) {
            String s = v.toString();
            return RubyBigDecimal.newInstance(this.getRuntime().fastGetClass("BigDecimal"), new IRubyObject[]{this.getRuntime().newString(s)});
        }
        if (must) {
            String err = this.isImmediate() ? RubyString.objAsString(this.callMethod(this.getRuntime().getCurrentContext(), "inspect")).toString() : this.getMetaClass().getBaseName();
            throw this.getRuntime().newTypeError(err + " can't be coerced into BigDecimal");
        }
        return null;
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject recv, IRubyObject[] args) {
        BigDecimal decimal;
        if (args.length == 0) {
            decimal = new BigDecimal(0);
        } else {
            try {
                decimal = new BigDecimal(args[0].convertToString().toString());
            }
            catch (NumberFormatException e) {
                decimal = new BigDecimal(0);
            }
        }
        return new RubyBigDecimal(recv.getRuntime(), decimal);
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec = RubyFixnum.fix2int(this.getRuntime().fastGetClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int prec2 = Math.max(scale, prec);
        if (prec2 > 0 && this.value.scale() > prec2 - this.exp()) {
            this.value = this.value.setScale(prec2 - this.exp(), 4);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1)
    public IRubyObject op_mod(IRubyObject arg) {
        RubyBigDecimal val = this.getVpValue(arg, false);
        return new RubyBigDecimal(this.getRuntime(), this.value.divideAndRemainder(val.value)[1]).setResult();
    }

    @JRubyMethod(name={"*"}, required=1)
    public IRubyObject op_mul(IRubyObject arg) {
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced("*", arg);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(val.value)).setResult();
    }

    @JRubyMethod(name={"mult"}, required=2)
    public IRubyObject mult2(IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced("*", b);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(val.value)).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1)
    public IRubyObject op_pow(IRubyObject arg) {
        if (!(arg instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + arg.getMetaClass() + " (expected Fixnum)");
        }
        BigDecimal val = this.value;
        int times = RubyNumeric.fix2int(arg.convertToInteger());
        int sign = 0;
        if (times < 0) {
            sign = -1;
            times = -times;
        }
        BigDecimal result = BigDecimal.ONE;
        while (times > 0) {
            if (times % 2 != 0) {
                result = result.multiply(val);
                --times;
            }
            val = val.multiply(val);
            times /= 2;
        }
        if (sign == -1) {
            result = BigDecimal.ONE.divide(result);
        }
        return new RubyBigDecimal(this.getRuntime(), result).setResult();
    }

    @JRubyMethod(name={"+"}, required=1)
    public IRubyObject op_plus(IRubyObject arg) {
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced("+", arg);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.add(val.value)).setResult();
    }

    @JRubyMethod(name={"add"}, required=2)
    public IRubyObject add2(IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced("+", b);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.add(val.value)).setResult();
    }

    @Override
    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1)
    public IRubyObject op_minus(IRubyObject arg) {
        RubyBigDecimal val = this.getVpValue(arg, false);
        if (val == null) {
            return this.callCoerced("-", arg);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    @JRubyMethod(name={"sub"}, required=2)
    public IRubyObject sub2(IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = this.getVpValue(b, false);
        if (val == null) {
            return this.callCoerced("-", b);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    @Override
    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "div", "quo"}, required=1, optional=1)
    public IRubyObject op_div(IRubyObject[] args) {
        RubyBigDecimal val;
        int scale = 0;
        if (args.length == 2) {
            scale = RubyNumeric.fix2int(args[1]);
        }
        if ((val = this.getVpValue(args[0], false)) == null) {
            return this.callCoerced("/", args[0]);
        }
        if (scale == 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, 200, 4)).setResult();
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, 200, 4)).setResult(scale);
    }

    private IRubyObject cmp(IRubyObject r, char op) {
        int e = 0;
        RubyBigDecimal rb = this.getVpValue(r, false);
        if (rb == null) {
            IRubyObject ee = this.callCoerced("<=>", r);
            if (ee.isNil()) {
                return this.getRuntime().getNil();
            }
            e = RubyNumeric.fix2int(ee);
        } else {
            e = this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject arg) {
        return this.cmp(arg, '*');
    }

    @Override
    @JRubyMethod(name={"eql?"}, required=1)
    public IRubyObject eql_p(IRubyObject arg) {
        return this.cmp(arg, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject arg) {
        return this.cmp(arg, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject arg) {
        return this.cmp(arg, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject arg) {
        return this.cmp(arg, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject arg) {
        return this.cmp(arg, 'G');
    }

    @Override
    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] args) {
        throw new RuntimeException("BigDecimal#ceil is not implemented");
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray(this.getVpValue(other, true), this);
        return obj;
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    public RubyNumeric multiplyWith(RubyInteger value) {
        return (RubyNumeric)this.op_mul(value);
    }

    public RubyNumeric multiplyWith(RubyFloat value) {
        return (RubyNumeric)this.op_mul(value);
    }

    public RubyNumeric multiplyWith(RubyBignum value) {
        return (RubyNumeric)this.op_mul(value);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1)
    public IRubyObject divmod(IRubyObject arg) {
        System.err.println("unimplemented: divmod");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.exp());
    }

    private int exp() {
        return this.value.abs().unscaledValue().toString().length() - this.value.abs().scale();
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        System.err.println("unimplemented: finite?");
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"fix"})
    public IRubyObject fix() {
        System.err.println("unimplemented: fix");
        return this;
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] args) {
        throw new RuntimeException("BigDecimal#floor is not implemented");
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        System.err.println("unimplemented: frac");
        return this;
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        System.err.println("unimplemented: infinite?");
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(this.getRuntime().getCurrentContext(), MethodIndex.TO_S, "to_s")).append("'").append(",");
        int len = this.value.abs().unscaledValue().toString().length();
        int pow = len / 4;
        val.append(len).append("(").append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        System.err.println("unimplemented: nan?");
        return this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.value.signum() != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        System.err.println("unimplemented: precs");
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"remainder"}, required=1)
    public IRubyObject remainder(IRubyObject arg) {
        System.err.println("unimplemented: remainder");
        return this;
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(IRubyObject[] args) {
        int mode;
        int scale = args.length > 0 ? RubyBigDecimal.num2int(args[0]) : 0;
        int n = mode = args.length > 1 ? this.javaRoundingModeFromRubyRoundingMode(args[1]) : 4;
        if (scale < 0) {
            BigDecimal normalized = this.value.movePointRight(scale);
            BigDecimal rounded = normalized.setScale(0, mode);
            return new RubyBigDecimal(this.getRuntime(), rounded.movePointLeft(scale));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.setScale(scale, mode));
    }

    private int javaRoundingModeFromRubyRoundingMode(IRubyObject arg) {
        return RubyBigDecimal.num2int(arg);
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        System.err.println("unimplemented: sign");
        return this.getRuntime().newFixnum(this.value.signum());
    }

    @JRubyMethod(name={"split"})
    public IRubyObject split() {
        System.err.println("unimplemented: split");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject arg) {
        System.err.println("unimplemented: sqrt");
        return new RubyBigDecimal(this.getRuntime(), new BigDecimal(Math.sqrt(this.value.doubleValue()))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    @Override
    @JRubyMethod(name={"to_int"})
    public IRubyObject to_int() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String format) {
        int groups = 0;
        Pattern p = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher m = p.matcher(format);
        if (m.matches()) {
            groups = Integer.parseInt(m.group(2));
        }
        return groups;
    }

    private boolean hasArg(IRubyObject[] args) {
        return args.length != 0 && !args[0].isNil();
    }

    private String format(IRubyObject[] args) {
        return args[0].toString();
    }

    private String firstArgument(IRubyObject[] args) {
        if (this.hasArg(args)) {
            return this.format(args);
        }
        return null;
    }

    private boolean posSpace(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatHasLeadingSpace(arg);
        }
        return false;
    }

    private boolean posSign(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatHasLeadingPlus(arg) || this.posSpace(arg);
        }
        return false;
    }

    private boolean asEngineering(String arg) {
        if (null != arg) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(arg);
        }
        return true;
    }

    private int groups(String arg) {
        if (null != arg) {
            return RubyBigDecimal.formatFractionalDigitGroups(arg);
        }
        return 0;
    }

    private boolean isZero() {
        return this.value.abs().compareTo(BigDecimal.ZERO) == 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private IRubyObject engineeringValue(String arg) {
        int exponent = this.exp();
        int signum = this.value.signum();
        StringBuffer build = new StringBuffer();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg) ? (this.posSpace(arg) ? " " : "+") : "") : ""));
        build.append("0.");
        if (0 == this.groups(arg)) {
            String s = this.removeTrailingZeroes(this.unscaledValue());
            if ("".equals(s)) {
                build.append("0");
            } else {
                build.append(s);
            }
        } else {
            String sep = "";
            for (int index = 0; index < this.unscaledValue().length(); index += this.groups(arg)) {
                int next = index + this.groups(arg);
                if (next > this.unscaledValue().length()) {
                    next = this.unscaledValue().length();
                }
                build.append(sep).append(this.unscaledValue().substring(index, next));
                sep = " ";
            }
        }
        build.append("E").append(exponent);
        return this.getRuntime().newString(build.toString());
    }

    private IRubyObject floatingPointValue(String arg) {
        String[] values = this.value.abs().toString().split("\\.");
        String whole = "0";
        if (values.length > 0) {
            whole = values[0];
        }
        String after = "0";
        if (values.length > 1) {
            after = values[1];
        }
        int signum = this.value.signum();
        StringBuffer build = new StringBuffer();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg) ? (this.posSpace(arg) ? " " : "+") : "") : ""));
        if (this.groups(arg) == 0) {
            build.append(whole);
            if (null != after) {
                build.append(".").append(after);
            }
        } else {
            int next;
            int index;
            String sep = "";
            for (index = 0; index < whole.length(); index += this.groups(arg)) {
                next = index + this.groups(arg);
                if (next > whole.length()) {
                    next = whole.length();
                }
                build.append(sep).append(whole.substring(index, next));
                sep = " ";
            }
            if (null != after) {
                build.append(".");
                sep = "";
                for (index = 0; index < after.length(); index += this.groups(arg)) {
                    next = index + this.groups(arg);
                    if (next > after.length()) {
                        next = after.length();
                    }
                    build.append(sep).append(after.substring(index, next));
                    sep = " ";
                }
            }
        }
        return this.getRuntime().newString(build.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] args) {
        String arg = this.firstArgument(args);
        if (this.isZero()) {
            return this.getRuntime().newString("0.0");
        }
        if (this.asEngineering(arg)) {
            return this.engineeringValue(arg);
        }
        return this.floatingPointValue(arg);
    }

    @JRubyMethod(name={"truncate"}, optional=1)
    public IRubyObject truncate(IRubyObject[] args) {
        throw new RuntimeException("BigDecimal#truncate is not implemented");
    }

    @Override
    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.value.signum() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }
}

