/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.Composer;
import org.jvyamlb.ComposerImpl;
import org.jvyamlb.Constructor;
import org.jvyamlb.ConstructorException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.PrivateType;
import org.jvyamlb.ResolverImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.nodes.LinkNode;
import org.jvyamlb.nodes.MappingNode;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.ScalarNode;
import org.jvyamlb.nodes.SequenceNode;

public class BaseConstructorImpl
implements Constructor {
    private static final Map yamlConstructors = new HashMap();
    private static final Map yamlMultiConstructors = new HashMap();
    private static final Map yamlMultiRegexps = new HashMap();
    private Composer composer;
    private Map recursiveObjects = new HashMap();
    public static final Constructor.YamlConstructor CONSTRUCT_PRIMITIVE = new Constructor.YamlConstructor(){

        @Override
        public Object call(Constructor self, Node node) {
            return self.constructPrimitive(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SCALAR = new Constructor.YamlConstructor(){

        @Override
        public Object call(Constructor self, Node node) {
            return self.constructScalar(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_PRIVATE = new Constructor.YamlConstructor(){

        @Override
        public Object call(Constructor self, Node node) {
            return self.constructPrivateType(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_SEQUENCE = new Constructor.YamlConstructor(){

        @Override
        public Object call(Constructor self, Node node) {
            return self.constructSequence(node);
        }
    };
    public static final Constructor.YamlConstructor CONSTRUCT_MAPPING = new Constructor.YamlConstructor(){

        @Override
        public Object call(Constructor self, Node node) {
            return self.constructMapping(node);
        }
    };

    public Constructor.YamlConstructor getYamlConstructor(Object key) {
        return (Constructor.YamlConstructor)yamlConstructors.get(key);
    }

    public Constructor.YamlMultiConstructor getYamlMultiConstructor(Object key) {
        return (Constructor.YamlMultiConstructor)yamlMultiConstructors.get(key);
    }

    public Pattern getYamlMultiRegexp(Object key) {
        return (Pattern)yamlMultiRegexps.get(key);
    }

    public Set getYamlMultiRegexps() {
        return yamlMultiRegexps.keySet();
    }

    public static void addConstructor(String tag, Constructor.YamlConstructor ctor) {
        yamlConstructors.put(tag, ctor);
    }

    public static void addMultiConstructor(String tagPrefix, Constructor.YamlMultiConstructor ctor) {
        yamlMultiConstructors.put(tagPrefix, ctor);
        yamlMultiRegexps.put(tagPrefix, Pattern.compile("^" + tagPrefix));
    }

    public BaseConstructorImpl(Composer composer) {
        this.composer = composer;
    }

    @Override
    public boolean checkData() {
        return this.composer.checkNode();
    }

    @Override
    public Object getData() {
        Node node;
        if (this.composer.checkNode() && null != (node = this.composer.getNode())) {
            return this.constructDocument(node);
        }
        return null;
    }

    @Override
    public Iterator eachDocument() {
        return new DocumentIterator();
    }

    @Override
    public Iterator iterator() {
        return this.eachDocument();
    }

    @Override
    public Object constructDocument(Node node) {
        Object data = this.constructObject(node);
        this.recursiveObjects.clear();
        return data;
    }

    @Override
    public Object constructObject(Node node) {
        if (this.recursiveObjects.containsKey(node)) {
            LinkNode n = new LinkNode();
            n.setValue(node);
            return n;
        }
        this.recursiveObjects.put(node, new ArrayList());
        Constructor.YamlConstructor ctor = this.getYamlConstructor(node.getTag());
        if (ctor == null) {
            boolean through = true;
            for (String tagPrefix : this.getYamlMultiRegexps()) {
                Pattern reg = this.getYamlMultiRegexp(tagPrefix);
                if (!reg.matcher(node.getTag()).find()) continue;
                String tagSuffix = node.getTag().substring(tagPrefix.length());
                ctor = new YamlMultiAdapter(this.getYamlMultiConstructor(tagPrefix), tagSuffix);
                through = false;
                break;
            }
            if (through) {
                Constructor.YamlMultiConstructor xctor = this.getYamlMultiConstructor(null);
                if (null != xctor) {
                    ctor = new YamlMultiAdapter(xctor, node.getTag());
                } else {
                    ctor = this.getYamlConstructor(null);
                    if (ctor == null) {
                        ctor = CONSTRUCT_PRIMITIVE;
                    }
                }
            }
        }
        Object data = ctor.call(this, node);
        this.doRecursionFix(node, data);
        return data;
    }

    @Override
    public void doRecursionFix(Node node, Object obj) {
        List ll = (List)this.recursiveObjects.remove(node);
        if (null != ll) {
            Iterator iter = ll.iterator();
            while (iter.hasNext()) {
                ((Constructor.RecursiveFixer)iter.next()).replace(node, obj);
            }
        }
    }

    @Override
    public Object constructPrimitive(Node node) {
        if (node instanceof ScalarNode) {
            return this.constructScalar(node);
        }
        if (node instanceof SequenceNode) {
            return this.constructSequence(node);
        }
        if (node instanceof MappingNode) {
            return this.constructMapping(node);
        }
        System.err.println(node.getTag());
        return null;
    }

    @Override
    public Object constructScalar(Node node) {
        if (!(node instanceof ScalarNode)) {
            if (node instanceof MappingNode) {
                Map vals = (Map)node.getValue();
                for (Node key : vals.keySet()) {
                    if (!"tag:yaml.org,2002:value".equals(key.getTag())) continue;
                    return this.constructScalar((Node)vals.get(key));
                }
            }
            throw new ConstructorException(null, "expected a scalar node, but found " + node.getClass().getName(), null);
        }
        return node.getValue();
    }

    @Override
    public Object constructPrivateType(Node node) {
        Object val = null;
        val = node.getValue() instanceof Map ? this.constructMapping(node) : (node.getValue() instanceof List ? this.constructSequence(node) : node.getValue().toString());
        return new PrivateType(node.getTag(), val);
    }

    @Override
    public Object constructSequence(Node node) {
        if (!(node instanceof SequenceNode)) {
            throw new ConstructorException(null, "expected a sequence node, but found " + node.getClass().getName(), null);
        }
        List internal = (List)node.getValue();
        final ArrayList<Object> val = new ArrayList<Object>(internal.size());
        Iterator iter = internal.iterator();
        while (iter.hasNext()) {
            Object obj = this.constructObject((Node)iter.next());
            if (obj instanceof LinkNode) {
                final int ix = val.size();
                this.addFixer((Node)((LinkNode)obj).getValue(), new Constructor.RecursiveFixer(){

                    @Override
                    public void replace(Node node, Object real) {
                        val.set(ix, real);
                    }
                });
            }
            val.add(obj);
        }
        return val;
    }

    @Override
    public Object constructMapping(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        final Map[] mapping = new Map[]{new HashMap()};
        LinkedList<Map> merge = null;
        Map val = (Map)node.getValue();
        for (Node key_v : val.keySet()) {
            Node value_v = (Node)val.get(key_v);
            if (key_v.getTag().equals("tag:yaml.org,2002:merge")) {
                if (merge != null) {
                    throw new ConstructorException("while constructing a mapping", "found duplicate merge key", null);
                }
                if (value_v instanceof MappingNode) {
                    merge = new LinkedList<Map>();
                    merge.add((Map)this.constructMapping(value_v));
                    continue;
                }
                if (value_v instanceof SequenceNode) {
                    merge = new LinkedList();
                    List vals = (List)value_v.getValue();
                    for (Node subnode : vals) {
                        if (!(subnode instanceof MappingNode)) {
                            throw new ConstructorException("while constructing a mapping", "expected a mapping for merging, but found " + subnode.getClass().getName(), null);
                        }
                        merge.add(0, (Map)this.constructMapping(subnode));
                    }
                    continue;
                }
                throw new ConstructorException("while constructing a mapping", "expected a mapping or list of mappings for merging, but found " + value_v.getClass().getName(), null);
            }
            if (key_v.getTag().equals("tag:yaml.org,2002:value")) {
                if (mapping[0].containsKey("=")) {
                    throw new ConstructorException("while construction a mapping", "found duplicate value key", null);
                }
                mapping[0].put("=", this.constructObject(value_v));
                continue;
            }
            final Object kk = this.constructObject(key_v);
            Object vv = this.constructObject(value_v);
            if (vv instanceof LinkNode) {
                this.addFixer((Node)((LinkNode)vv).getValue(), new Constructor.RecursiveFixer(){

                    @Override
                    public void replace(Node node, Object real) {
                        mapping[0].put(kk, real);
                    }
                });
            }
            mapping[0].put(kk, vv);
        }
        if (null != merge) {
            merge.add(mapping[0]);
            mapping[0] = new HashMap();
            Iterator<Object> iter = merge.iterator();
            while (iter.hasNext()) {
                mapping[0].putAll((Map)iter.next());
            }
        }
        return mapping[0];
    }

    @Override
    public void addFixer(Node node, Constructor.RecursiveFixer fixer) {
        ArrayList<Constructor.RecursiveFixer> ll = (ArrayList<Constructor.RecursiveFixer>)this.recursiveObjects.get(node);
        if (ll == null) {
            ll = new ArrayList<Constructor.RecursiveFixer>();
            this.recursiveObjects.put(node, ll);
        }
        ll.add(fixer);
    }

    @Override
    public Object constructPairs(Node node) {
        if (!(node instanceof MappingNode)) {
            throw new ConstructorException(null, "expected a mapping node, but found " + node.getClass().getName(), null);
        }
        LinkedList<Object[]> value = new LinkedList<Object[]>();
        Map vals = (Map)node.getValue();
        for (Node key : vals.keySet()) {
            Node val = (Node)vals.get(key);
            value.add(new Object[]{this.constructObject(key), this.constructObject(val)});
        }
        return value;
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        ByteList input = new ByteList(1024);
        FileInputStream reader = new FileInputStream(filename);
        byte[] buff = new byte[1024];
        int read = 0;
        do {
            read = ((InputStream)reader).read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((InputStream)reader).close();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            BaseConstructorImpl ctor = new BaseConstructorImpl(new ComposerImpl(new ParserImpl(new ScannerImpl(input)), new ResolverImpl()));
            Iterator iter = ctor.eachDocument();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the nodes for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    public static class YamlMultiAdapter
    implements Constructor.YamlConstructor {
        private Constructor.YamlMultiConstructor ctor;
        private String prefix;

        public YamlMultiAdapter(Constructor.YamlMultiConstructor ctor, String prefix) {
            this.ctor = ctor;
            this.prefix = prefix;
        }

        @Override
        public Object call(Constructor self, Node node) {
            return this.ctor.call(self, this.prefix, node);
        }
    }

    private class DocumentIterator
    implements Iterator {
        private DocumentIterator() {
        }

        @Override
        public boolean hasNext() {
            return BaseConstructorImpl.this.checkData();
        }

        public Object next() {
            return BaseConstructorImpl.this.getData();
        }

        @Override
        public void remove() {
        }
    }
}

