/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.util.regex.Pattern;
import org.jruby.util.JRubyFile;

public class JavaNameMangler {
    public static final Pattern PATH_SPLIT = Pattern.compile("[/\\\\]");

    public static String mangleFilenameForClasspath(String filename) {
        try {
            String classPath = new JRubyFile(filename).getCanonicalPath().toString();
            String[] pathElements = PATH_SPLIT.split(classPath);
            StringBuffer newPath = new StringBuffer("ruby");
            for (String element : pathElements) {
                if (element.length() <= 0) continue;
                newPath.append("/");
                if (!Character.isJavaIdentifierStart(element.charAt(0))) {
                    newPath.append("$");
                }
                newPath.append(JavaNameMangler.mangleStringForCleanJavaIdentifier(element));
            }
            return newPath.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException(ioe);
        }
    }

    public static String mangledFilenameForStartupClasspath(String filename) {
        if (filename.equals("-e")) {
            return "__dash_e__";
        }
        return JavaNameMangler.mangleFilenameForClasspath(filename);
    }

    public static String mangleStringForCleanJavaIdentifier(String name) {
        char[] characters = name.toCharArray();
        StringBuffer cleanBuffer = new StringBuffer();
        boolean prevWasReplaced = false;
        block15: for (int i = 0; i < characters.length; ++i) {
            if (Character.isJavaIdentifierStart(characters[i])) {
                cleanBuffer.append(characters[i]);
                prevWasReplaced = false;
                continue;
            }
            if (!prevWasReplaced) {
                cleanBuffer.append("_");
            }
            prevWasReplaced = true;
            switch (characters[i]) {
                case '?': {
                    cleanBuffer.append("p_");
                    continue block15;
                }
                case '!': {
                    cleanBuffer.append("b_");
                    continue block15;
                }
                case '<': {
                    cleanBuffer.append("lt_");
                    continue block15;
                }
                case '>': {
                    cleanBuffer.append("gt_");
                    continue block15;
                }
                case '=': {
                    cleanBuffer.append("equal_");
                    continue block15;
                }
                case '[': {
                    if (i + 1 < characters.length && characters[i + 1] == ']') {
                        cleanBuffer.append("aref_");
                        ++i;
                        continue block15;
                    }
                    cleanBuffer.append("lbracket_");
                    continue block15;
                }
                case ']': {
                    cleanBuffer.append("rbracket_");
                    continue block15;
                }
                case '+': {
                    cleanBuffer.append("plus_");
                    continue block15;
                }
                case '-': {
                    cleanBuffer.append("minus_");
                    continue block15;
                }
                case '*': {
                    cleanBuffer.append("times_");
                    continue block15;
                }
                case '/': {
                    cleanBuffer.append("div_");
                    continue block15;
                }
                case '&': {
                    cleanBuffer.append("and_");
                    continue block15;
                }
                case '.': {
                    cleanBuffer.append("dot_");
                    continue block15;
                }
                default: {
                    cleanBuffer.append(Integer.toHexString(characters[i])).append("_");
                }
            }
        }
        return cleanBuffer.toString();
    }
}

