/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.util.SafePropertyAccessor;

public abstract class MethodFactory {
    private static boolean reflection = false;
    private static boolean dumping = false;
    private static String dumpingPath = null;

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, Method var2);

    public abstract void defineIndexedAnnotatedMethods(RubyModule var1, Class var2, MethodDefiningCallback var3);

    public static MethodFactory createFactory() {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath);
        }
        return new InvocationMethodFactory();
    }

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath);
        }
        return new InvocationMethodFactory(classLoader);
    }

    static {
        if (Ruby.isSecurityRestricted()) {
            reflection = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                reflection = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping = true;
                dumpingPath = SafePropertyAccessor.getProperty("jruby.dump_invocations").toString();
            }
        }
    }

    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, Method var2, DynamicMethod var3);
    }
}

