/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedBlock
extends BlockBody {
    private final IterNode iterNode;
    protected final Arity arity;

    public static Block newInterpretedClosure(ThreadContext context, IterNode iterNode, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        f.setPosition(context.getPosition());
        return InterpretedBlock.newInterpretedClosure(iterNode, self, Arity.procArityOf(iterNode.getVarNode()), f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
    }

    public static Block newInterpretedClosure(ThreadContext context, InterpretedBlock body, IRubyObject self) {
        Frame f = context.getCurrentFrame();
        f.setPosition(context.getPosition());
        Binding binding = new Binding(self, f, f.getVisibility(), context.getRubyClass(), context.getCurrentScope());
        return new Block(body, binding);
    }

    public static Block newInterpretedClosure(IterNode iterNode, IRubyObject self, Arity arity, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope) {
        NodeType argsNodeId = InterpretedBlock.getArgumentTypeWackyHack(iterNode);
        return new Block(new InterpretedBlock(iterNode, arity, InterpretedBlock.asArgumentType(argsNodeId)), new Binding(self, frame, visibility, klass, dynamicScope));
    }

    public InterpretedBlock(IterNode iterNode, int argumentType) {
        this(iterNode, Arity.procArityOf(iterNode == null ? null : iterNode.getVarNode()), argumentType);
    }

    public InterpretedBlock(IterNode iterNode, Arity arity, int argumentType) {
        super(argumentType);
        this.iterNode = iterNode;
        this.arity = arity;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        args = this.prepareArgumentsForCall(context, args, type);
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true, binding, type);
    }

    protected void pre(ThreadContext context, RubyModule klass, Binding binding) {
        context.preYieldSpecificBlockNEW(binding, this.iterNode.getScope(), klass);
    }

    protected void post(ThreadContext context, Binding binding) {
        context.postYield(binding);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    /*
     * Exception decompiling
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupBlockArgs(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                break;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, (RubyArray)value, false);
                break;
            }
            default: {
                int length = this.arrayLength(value);
                switch (length) {
                    case 0: {
                        value = runtime.getNil();
                        break;
                    }
                    case 1: {
                        value = ((RubyArray)value).eltInternal(0);
                        break;
                    }
                    default: {
                        runtime.getWarnings().warn("multiple values for a block parameter (" + length + " for 1)");
                    }
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, Block.NULL_BLOCK, false);
            }
        }
    }

    private void setupBlockArg(ThreadContext context, Node varNode, IRubyObject value, IRubyObject self) {
        Ruby runtime = self.getRuntime();
        switch (varNode.nodeId) {
            case ZEROARGNODE: {
                return;
            }
            case MULTIPLEASGNNODE: {
                value = AssignmentVisitor.multiAssign(runtime, context, self, (MultipleAsgnNode)varNode, ArgsUtil.convertToRubyArray(runtime, value, ((MultipleAsgnNode)varNode).getHeadNode() != null), false);
                break;
            }
            default: {
                if (value == null) {
                    runtime.getWarnings().warn("multiple values for a block parameter (0 for 1)");
                }
                AssignmentVisitor.assign(runtime, context, self, varNode, value, Block.NULL_BLOCK, false);
            }
        }
    }

    @Override
    protected int arrayLength(IRubyObject node) {
        return node instanceof RubyArray ? ((RubyArray)node).getLength() : 0;
    }

    @Override
    public StaticScope getStaticScope() {
        return this.iterNode.getScope();
    }

    @Override
    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public IterNode getIterNode() {
        return this.iterNode;
    }

    @Override
    public Arity arity() {
        return this.arity;
    }

    @Override
    public boolean isGiven() {
        return true;
    }
}

