/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class Frame
implements JumpTarget {
    private RubyModule klazz;
    private IRubyObject self;
    private String name;
    private Block block;
    private boolean isBindingFrame = false;
    private Visibility visibility = Visibility.PUBLIC;
    private JumpTarget jumpTarget;
    private IRubyObject backref;
    private IRubyObject lastline;
    private ISourcePosition position;

    public JumpTarget getJumpTarget() {
        return this.jumpTarget;
    }

    public void setJumpTarget(JumpTarget jumpTarget) {
        this.jumpTarget = jumpTarget;
    }

    public void updateFrame(ISourcePosition position) {
        this.updateFrame(null, null, null, Block.NULL_BLOCK, position, null);
    }

    public void updateFrame(Frame frame) {
        assert (frame.block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = frame.self;
        this.name = frame.name;
        this.klazz = frame.klazz;
        this.position = frame.position;
        this.block = frame.block;
        this.jumpTarget = frame.jumpTarget;
        this.visibility = frame.visibility;
        this.isBindingFrame = frame.isBindingFrame;
        this.backref = frame.backref;
        this.lastline = frame.lastline;
    }

    public void updateFrame(RubyModule klazz, IRubyObject self, String name, Block block, ISourcePosition position, JumpTarget jumpTarget) {
        assert (block != null) : "Block uses null object pattern.  It should NEVER be null";
        this.self = self;
        this.name = name;
        this.klazz = klazz;
        this.position = position;
        this.block = block;
        this.jumpTarget = jumpTarget;
        this.visibility = Visibility.PUBLIC;
        this.isBindingFrame = false;
        this.backref = null;
        this.lastline = null;
    }

    public Frame duplicate() {
        Frame newFrame = new Frame();
        newFrame.updateFrame(this);
        return newFrame;
    }

    public IRubyObject getBackRef() {
        return this.backref == null ? this.self.getRuntime().getNil() : this.backref;
    }

    public void setBackRef(IRubyObject backref) {
        this.backref = backref;
    }

    public IRubyObject getLastLine() {
        return this.lastline == null ? this.self.getRuntime().getNil() : this.lastline;
    }

    public void setLastLine(IRubyObject lastline) {
        this.lastline = lastline;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public void setPosition(ISourcePosition pos) {
        this.position = pos;
    }

    public RubyModule getKlazz() {
        return this.klazz;
    }

    public void setKlazz(RubyModule klazz) {
        this.klazz = klazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public boolean isBindingFrame() {
        return this.isBindingFrame;
    }

    public void setIsBindingFrame(boolean isBindingFrame) {
        this.isBindingFrame = isBindingFrame;
    }

    public Block getBlock() {
        return this.block;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.position != null ? this.position.toString() : "-1");
        sb.append(':');
        sb.append(this.klazz + " " + this.name);
        if (this.name != null) {
            sb.append("in ");
            sb.append(this.name);
        }
        return sb.toString();
    }
}

