/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.parser.BlockStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.runtime.scope.NoVarsDynamicScope;
import org.jruby.runtime.scope.OneVarDynamicScope;

public abstract class DynamicScope {
    protected StaticScope staticScope;
    protected DynamicScope parent;
    protected DynamicScope evalScope;

    protected DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this(staticScope);
        this.parent = parent;
    }

    protected DynamicScope(StaticScope staticScope) {
        this.staticScope = staticScope;
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope, DynamicScope parent) {
        switch (staticScope.getNumberOfVariables()) {
            case 0: {
                return new NoVarsDynamicScope(staticScope, parent);
            }
            case 1: {
                return new OneVarDynamicScope(staticScope, parent);
            }
        }
        return new ManyVarsDynamicScope(staticScope, parent);
    }

    public static DynamicScope newDynamicScope(StaticScope staticScope) {
        return DynamicScope.newDynamicScope(staticScope, null);
    }

    public final DynamicScope getEvalScope() {
        if (this.evalScope == null) {
            DynamicScope parent = this.getNextCapturedScope();
            this.evalScope = parent != null && parent.getEvalScope() == this ? this : new ManyVarsDynamicScope(new BlockStaticScope(this.getStaticScope()), this);
        }
        return this.evalScope;
    }

    public final DynamicScope getNextCapturedScope() {
        return this.parent;
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public final String[] getAllNamesInScope() {
        return this.staticScope.getAllNamesInScope();
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public abstract void growIfNeeded();

    public abstract String toString(StringBuffer var1, String var2);

    public abstract DynamicScope cloneScope();

    public abstract IRubyObject[] getValues();

    public abstract IRubyObject getValue(int var1, int var2);

    public abstract IRubyObject getValueOrNil(int var1, int var2, IRubyObject var3);

    public abstract IRubyObject getValueDepthZeroOrNil(int var1, IRubyObject var2);

    public abstract IRubyObject getValueZeroDepthZeroOrNil(IRubyObject var1);

    public abstract IRubyObject getValueOneDepthZeroOrNil(IRubyObject var1);

    public abstract void setValue(int var1, IRubyObject var2, int var3);

    public abstract void setValueDepthZero(IRubyObject var1, int var2);

    public abstract void setValueZeroDepthZero(IRubyObject var1);

    public abstract void setValueOneDepthZero(IRubyObject var1);

    public abstract void setArgValues(IRubyObject[] var1, int var2);

    public abstract IRubyObject[] getArgValues();
}

