/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaObject
extends RubyObject {
    private static Object NULL_LOCK = new Object();
    private final Object value;

    protected JavaObject(Ruby runtime, RubyClass rubyClass, Object value) {
        super(runtime, rubyClass);
        this.value = value;
    }

    protected JavaObject(Ruby runtime, Object value) {
        this(runtime, runtime.getJavaSupport().getJavaObjectClass(), value);
    }

    public static JavaObject wrap(Ruby runtime, Object value) {
        if (value != null) {
            if (value instanceof Class) {
                return JavaClass.get(runtime, (Class)value);
            }
            if (value.getClass().isArray()) {
                return new JavaArray(runtime, value);
            }
        }
        return new JavaObject(runtime, value);
    }

    @Override
    public Class getJavaClass() {
        return this.value != null ? this.value.getClass() : Void.TYPE;
    }

    public Object getValue() {
        return this.value;
    }

    public static RubyClass createJavaObjectClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaObject", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaObject.registerRubyMethods(runtime, result);
        result.getMetaClass().undefineMethod("new");
        result.getMetaClass().undefineMethod("allocate");
        result.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        return result;
    }

    protected static void registerRubyMethods(Ruby runtime, RubyClass result) {
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaObject.class);
        result.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        result.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("eql?", callbackFactory.getFastMethod("op_equal", IRubyObject.class));
        result.defineFastMethod("equal?", callbackFactory.getFastMethod("same", IRubyObject.class));
        result.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        result.defineFastMethod("java_type", callbackFactory.getFastMethod("java_type"));
        result.defineFastMethod("java_class", callbackFactory.getFastMethod("java_class"));
        result.defineFastMethod("java_proxy?", callbackFactory.getFastMethod("is_java_proxy"));
        result.defineMethod("synchronized", callbackFactory.getMethod("ruby_synchronized"));
        result.defineFastMethod("length", callbackFactory.getFastMethod("length"));
        result.defineFastMethod("[]", callbackFactory.getFastMethod("aref", IRubyObject.class));
        result.defineFastMethod("[]=", callbackFactory.getFastMethod("aset", IRubyObject.class, IRubyObject.class));
        result.defineFastMethod("fill", callbackFactory.getFastMethod("afill", IRubyObject.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value == null ? 0L : (long)this.value.hashCode());
    }

    @Override
    public IRubyObject to_s() {
        String s = this.value == null ? "" : this.value.toString();
        return s == null ? this.getRuntime().getNil() : RubyString.newUnicodeString(this.getRuntime(), s);
    }

    @Override
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isEqual = this.getValue().equals(((JavaObject)other).getValue());
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        if (this.getValue() == null && ((JavaObject)other).getValue() == null) {
            return this.getRuntime().getTrue();
        }
        boolean isSame = this.getValue() == ((JavaObject)other).getValue();
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aref(IRubyObject index) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject aset(IRubyObject index, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    public IRubyObject is_java_proxy() {
        return this.getRuntime().getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject ruby_synchronized(Block block) {
        Object lock = this.getValue();
        Object object = lock != null ? lock : NULL_LOCK;
        synchronized (object) {
            return block.yield(this.getRuntime().getCurrentContext(), null);
        }
    }
}

