/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ReflectedCompiledMethod;
import org.jruby.internal.runtime.methods.ReflectedJavaMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectionMethodFactory
extends MethodFactory {
    private static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String methodName, Arity arity, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig) {
        try {
            Method method = scriptObject.getClass().getMethod(methodName, COMPILED_METHOD_PARAMS);
            return new ReflectedCompiledMethod(implementationClass, arity, visibility, scope, scriptObject, method, callConfig);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("No method with name " + methodName + " found in " + scriptObject.getClass());
        }
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, Method method) {
        JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
        ReflectedJavaMethod ic = new ReflectedJavaMethod(implementationClass, method, jrubyMethod);
        boolean fast = !jrubyMethod.frame() && !jrubyMethod.scope();
        ic.setArity(Arity.fromAnnotation(jrubyMethod));
        ic.setJavaName(method.getName());
        ic.setArgumentTypes(method.getParameterTypes());
        ic.setSingleton(Modifier.isStatic(method.getModifiers()));
        if (fast) {
            ic.setCallConfig(CallConfiguration.NO_FRAME_NO_SCOPE);
        } else {
            ic.setCallConfig(CallConfiguration.FRAME_ONLY);
        }
        return ic;
    }

    @Override
    public void defineIndexedAnnotatedMethods(RubyModule implementationClass, Class type, MethodFactory.MethodDefiningCallback callback) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            JRubyMethod jrubyMethod = method.getAnnotation(JRubyMethod.class);
            if (jrubyMethod == null) continue;
            callback.define(implementationClass, method, this.getAnnotatedMethod(implementationClass, method));
        }
    }
}

