/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method, CallConfiguration callConfig) {
        super(implementationClass, arity, visibility, staticScope, scriptObject, callConfig);
        this.method = method;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), this.arity, name, args, block, this.staticScope, this);
        Ruby runtime = context.getRuntime();
        try {
            boolean isTrace = runtime.hasEventHooks();
            try {
                Object position;
                if (isTrace) {
                    position = context.getPosition();
                    runtime.callEventHooks(context, 3, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
                }
                position = (IRubyObject)this.method.invoke(this.$scriptObject, context, self, args, block);
                if (isTrace) {
                    ISourcePosition position2 = context.getPreviousFramePosition();
                    runtime.callEventHooks(context, 4, position2.getFile(), position2.getStartLine(), name, this.getImplementationClass());
                }
                return position;
            }
            catch (Throwable throwable) {
                try {
                    if (isTrace) {
                        ISourcePosition position = context.getPreviousFramePosition();
                        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (IllegalAccessException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof JumpException.ReturnJump) {
                        JumpException.FlowControlException f = (JumpException.FlowControlException)cause;
                        if (f.getTarget() == this) {
                            IRubyObject iRubyObject = (IRubyObject)f.getValue();
                            return iRubyObject;
                        }
                        throw f;
                    }
                    if (cause instanceof JumpException.RedoJump) {
                        throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw RaiseException.createNativeRaiseException(runtime, cause);
                }
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }
}

