/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.JITCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.JumpTarget;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public final class DefaultMethod
extends DynamicMethod
implements JumpTarget {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private int callCount = 0;
    private Script jitCompiledScript;
    private int requiredArgsCount;
    private int restArg;
    private boolean hasOptArgs;
    private CallConfiguration jitCallConfig;
    private ISourcePosition position;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, ISourcePosition position) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.requiredArgsCount = argsNode.getRequiredArgsCount();
        this.restArg = argsNode.getRestArg();
        this.hasOptArgs = argsNode.getOptArgs() != null;
        this.position = position;
        assert (argsNode != null);
    }

    public int getCallCount() {
        return this.callCount;
    }

    public void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public Script getJITCompilerScript() {
        return this.jitCompiledScript;
    }

    public void setJITCompiledScript(Script jitCompiledScript) {
        this.jitCompiledScript = jitCompiledScript;
    }

    public CallConfiguration getJITCallConfig() {
        return this.jitCallConfig;
    }

    public void setJITCallConfig(CallConfiguration jitCallConfig) {
        this.jitCallConfig = jitCallConfig;
    }

    public Node getBodyNode() {
        return this.body;
    }

    public ArgsNode getArgsNode() {
        return this.argsNode;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        RubyModule implementer = this.getImplementationClass();
        Ruby runtime = context.getRuntime();
        if (runtime.getInstanceConfig().getCompileMode().shouldJIT()) {
            JITCompiler.runJIT(this, runtime, context, name);
        }
        if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
            try {
                this.jitCallConfig.pre(context, self, implementer, this.getArity(), name, args, block, this.staticScope, this);
                IRubyObject iRubyObject = this.jitCompiledScript.run(context, self, args, block);
                return iRubyObject;
            }
            catch (JumpException.ReturnJump rj) {
                if (rj.getTarget() == this) {
                    IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                    return iRubyObject;
                }
                throw rj;
            }
            catch (JumpException.RedoJump rj) {
                throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
            }
            finally {
                if (runtime.hasEventHooks()) {
                    this.traceReturn(context, runtime, name);
                }
                this.jitCallConfig.post(context);
            }
        }
        try {
            this.callConfig.pre(context, self, implementer, this.getArity(), name, args, block, this.staticScope, this);
            if (this.argsNode.getBlockArgNode() != null) {
                context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), RuntimeHelpers.processBlockArgument(runtime, block), 0);
            }
            this.getArity().checkArity(runtime, args);
            this.prepareArguments(context, runtime, args);
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            IRubyObject rj = ASTInterpreter.eval(runtime, context, this.body, self, block);
            return rj;
        }
        catch (JumpException.ReturnJump rj) {
            if (rj.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                return iRubyObject;
            }
            throw rj;
        }
        catch (JumpException.RedoJump rj) {
            throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
            this.callConfig.post(context);
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        if (this.requiredArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + this.requiredArgsCount + ")");
        }
        if (this.requiredArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, this.requiredArgsCount);
        }
        if (this.hasOptArgs || this.restArg != -1) {
            this.prepareOptOrRestArgs(context, runtime, args);
        }
    }

    private void prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        int givenArgsCount = this.requiredArgsCount;
        int maximumArgs = this.requiredArgsCount;
        if (this.argsNode.getOptArgs() != null && this.restArg == -1 && (maximumArgs += this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + maximumArgs + ")");
        }
        if (this.hasOptArgs) {
            int i;
            ListNode optArgs = this.argsNode.getOptArgs();
            int j = 0;
            for (i = this.requiredArgsCount; i < args.length && j < optArgs.size(); ++i, ++j) {
                AssignmentVisitor.assign(runtime, context, context.getFrameSelf(), optArgs.get(j), args[i], Block.NULL_BLOCK, true);
                ++givenArgsCount;
            }
            i = 0;
            while (j < optArgs.size()) {
                ASTInterpreter.eval(runtime, context, optArgs.get(j), context.getFrameSelf(), Block.NULL_BLOCK);
                ++i;
                ++j;
            }
        }
        if (this.restArg != -1 && this.restArg >= 0) {
            RubyArray array = runtime.newArray(args.length - givenArgsCount);
            for (int i = givenArgsCount; i < args.length; ++i) {
                array.append(args[i]);
            }
            context.getCurrentScope().setValue(this.restArg, array, 0);
        }
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        runtime.callEventHooks(context, 3, this.position.getFile(), this.position.getStartLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.argsNode.getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.position);
    }
}

