/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.internal.runtime.UndefinedAccessor;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class GlobalVariable {
    private IAccessor accessor;
    private ArrayList<IRubyObject> traces = null;
    private boolean tracing;

    public GlobalVariable(IAccessor accessor) {
        this.accessor = accessor;
    }

    public static GlobalVariable newUndefined(Ruby runtime, String name) {
        GlobalVariable variable = new GlobalVariable(null);
        variable.setAccessor(new UndefinedAccessor(runtime, variable, name));
        return variable;
    }

    public IAccessor getAccessor() {
        return this.accessor;
    }

    public ArrayList getTraces() {
        return this.traces;
    }

    public void addTrace(RubyProc command) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        this.traces.add(command);
    }

    public boolean removeTrace(IRubyObject command) {
        if (this.traces == null || !this.traces.contains(command)) {
            return false;
        }
        this.traces.remove(command);
        return true;
    }

    public void removeTraces() {
        this.traces = null;
    }

    public void setAccessor(IAccessor accessor) {
        this.accessor = accessor;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(IRubyObject value) {
        if (this.traces == null) {
            return;
        }
        ThreadContext context = value.getRuntime().getCurrentContext();
        if (context.isWithinTrace()) {
            return;
        }
        try {
            context.setWithinTrace(true);
            for (int i = 0; i < this.traces.size(); ++i) {
                ((RubyProc)this.traces.get(i)).call(new IRubyObject[]{value});
            }
        }
        finally {
            context.setWithinTrace(false);
        }
    }
}

