/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jruby.Ruby;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.JRubyPOSIXHandler;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaPasswd;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.NativePasswd;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.util.Chmod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ShellLauncher;

public class JavaLibC
implements LibC {
    private POSIXHandler handler;
    private Ruby runtime;

    public JavaLibC(POSIXHandler handler) {
        this.handler = handler;
        this.runtime = ((JRubyPOSIXHandler)handler).runtime;
    }

    @Override
    public int chmod(String filename, int mode) {
        return Chmod.chmod(new File(filename), Integer.toOctalString(mode));
    }

    @Override
    public int chown(String filename, int user, int group) {
        int chownResult = -1;
        int chgrpResult = -1;
        try {
            if (user != -1) {
                Process chown = Runtime.getRuntime().exec("chown " + user + " " + filename);
                chownResult = chown.waitFor();
            }
            if (group != -1) {
                Process chgrp = Runtime.getRuntime().exec("chgrp " + user + " " + filename);
                chgrpResult = chgrp.waitFor();
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (chownResult != -1 && chgrpResult != -1) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getegid() {
        this.handler.unimplementedError("getegid");
        return -1;
    }

    @Override
    public int geteuid() {
        this.handler.unimplementedError("geteuid");
        return -1;
    }

    @Override
    public int getgid() {
        this.handler.unimplementedError("getgid");
        return -1;
    }

    @Override
    public String getlogin() {
        return System.getProperty("user.name");
    }

    @Override
    public int getpgid() {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    @Override
    public int getpgrp() {
        this.handler.unimplementedError("getpgrp");
        return -1;
    }

    @Override
    public int getpid() {
        return this.runtime.hashCode();
    }

    @Override
    public int getppid() {
        this.handler.unimplementedError("getppid");
        return -1;
    }

    @Override
    public NativePasswd getpwent() {
        return new JavaPasswd(this, this.handler);
    }

    @Override
    public int getuid() {
        this.handler.unimplementedError("getuid");
        return -1;
    }

    @Override
    public int kill(int pid, int signal) {
        this.handler.unimplementedError("kill");
        return -1;
    }

    @Override
    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("getuid");
        return -1;
    }

    @Override
    public int lchown(String filename, int user, int group) {
        this.handler.unimplementedError("lchown");
        return -1;
    }

    @Override
    public int link(String oldpath, String newpath) {
        try {
            return new ShellLauncher(this.runtime).runAndWait(new IRubyObject[]{this.runtime.newString("ln"), this.runtime.newString(oldpath), this.runtime.newString(newpath)});
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int lstat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        jstat.setup(path);
        return 0;
    }

    @Override
    public int mkdir(String path, int mode) {
        File dir = new File(path);
        if (!dir.mkdir()) {
            return -1;
        }
        this.chmod(path, mode);
        return 0;
    }

    @Override
    public int stat(String path, FileStat stat) {
        JavaFileStat jstat = (JavaFileStat)stat;
        try {
            File file = new File(path);
            if (!file.exists()) {
                this.handler.error(POSIX.ERRORS.ENOENT, path);
            }
            jstat.setup(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public int symlink(String oldpath, String newpath) {
        try {
            return new ShellLauncher(this.runtime).runAndWait(new IRubyObject[]{this.runtime.newString("ln"), this.runtime.newString("-s"), this.runtime.newString(oldpath), this.runtime.newString(newpath)});
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int readlink(String oldpath, ByteBuffer buffer, int length) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ShellLauncher launcher = new ShellLauncher(this.runtime);
            launcher.runAndWait(new IRubyObject[]{this.runtime.newString("readlink"), this.runtime.newString(oldpath)}, baos);
            byte[] bytes = baos.toByteArray();
            if (bytes.length > length) {
                return -1;
            }
            buffer.put(bytes, 0, bytes.length - 1);
            return buffer.position();
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int umask(int mask) {
        return 0;
    }

    @Override
    public int fork() {
        return -1;
    }

    @Override
    public int setegid(int egid) {
        this.handler.unimplementedError("setegid");
        return -1;
    }

    @Override
    public int seteuid(int euid) {
        this.handler.unimplementedError("seteuid");
        return -1;
    }

    @Override
    public int setgid(int gid) {
        this.handler.unimplementedError("setgid");
        return -1;
    }

    @Override
    public int getpgid(int pid) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    @Override
    public int setpgid(int pid, int pgid) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    @Override
    public int setpgrp(int pid, int pgrp) {
        this.handler.unimplementedError("setpgrp");
        return -1;
    }

    @Override
    public int setsid() {
        this.handler.unimplementedError("setsid");
        return -1;
    }

    @Override
    public int setuid(int uid) {
        this.handler.unimplementedError("setuid");
        return -1;
    }

    @Override
    public int waitpid(int pid, int[] status, int flags) {
        this.handler.unimplementedError("waitpid");
        return -1;
    }

    @Override
    public int wait(int[] status) {
        this.handler.unimplementedError("wait");
        return -1;
    }

    @Override
    public int getpriority(int which, int who) {
        this.handler.unimplementedError("getpriority");
        return -1;
    }

    @Override
    public int setpriority(int which, int who, int prio) {
        this.handler.unimplementedError("setpriority");
        return -1;
    }
}

